/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.AbstractDiscountedSolver;
import jmarkov.jmdp.solvers.MpsLpSolver;

public abstract class MpsLpDiscountedSolver<S extends State, A extends Action>
extends AbstractDiscountedSolver<S, A>
implements MpsLpSolver<S, A> {
    private Formatter output;
    private File mpsFile = null;
    private static String fs = File.separator;
    private boolean isAvg = false;
    private long processTime = -1L;
    private long buildTime = -1L;
    private long lpSolveTime = -1L;
    private long solBuildTime = -1L;

    public MpsLpDiscountedSolver(DTMDP<S, A> problem, double interestRate, String workingDir, String fileName) {
        super(problem, interestRate);
        this.mpsFile = new File(workingDir, fileName);
    }

    public MpsLpDiscountedSolver(DTMDP<S, A> problem, double interestRate) {
        super(problem, interestRate);
        try {
            File folder = new File(System.getProperty("user.dir"));
            this.mpsFile = null;
            this.mpsFile = folder.exists() && folder.isDirectory() ? File.createTempFile("MDP", ".mps", folder) : File.createTempFile("MDP", ".mps");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mpsFile.deleteOnExit();
    }

    protected MpsLpDiscountedSolver(DTMDP<S, A> problem, double interestRate, String workingDir, String fileName, boolean isAverage) {
        super(problem, interestRate);
        this.mpsFile = new File(workingDir, fileName);
        this.isAvg = isAverage;
    }

    protected MpsLpDiscountedSolver(DTMDP<S, A> problem, double interestRate, boolean isAverage) {
        super(problem, interestRate);
        this.isAvg = isAverage;
        try {
            File folder = new File(System.getProperty("user.dir"));
            this.mpsFile = null;
            this.mpsFile = folder.exists() && folder.isDirectory() ? File.createTempFile("MDP", ".mps", folder) : File.createTempFile("MDP", ".mps");
            this.mpsFile.deleteOnExit();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public final String getMpsFileName() {
        return this.mpsFile.getPath();
    }

    @Override
    public File getMpsFile() {
        return this.mpsFile;
    }

    @Override
    public final File getWorkingDir() {
        return this.mpsFile.getParentFile();
    }

    public final boolean isAvg() {
        return this.isAvg;
    }

    @Override
    public abstract void solveLP() throws SolverException;

    @Override
    public abstract Solution<S, A> buildSolution() throws SolverException;

    @Override
    public final Solution<S, A> solve() throws SolverException {
        long startTime = System.currentTimeMillis();
        this.build();
        long endBuild = System.currentTimeMillis();
        this.buildTime = endBuild - startTime;
        this.solveLP();
        long endLP = System.currentTimeMillis();
        this.lpSolveTime = endLP - endBuild;
        Solution<S, A> sol = this.buildSolution();
        this.valueFunction = sol.getValueFunction();
        this.policy = sol.getPolicy();
        this.solBuildTime = System.currentTimeMillis() - endLP;
        this.solved = true;
        this.processTime = System.currentTimeMillis() - startTime;
        return sol;
    }

    private void build() throws SolverException {
        DTMDP problem = this.getDiscreteProblem();
        int numStates = problem.getAllStates().size();
        double alpha = this.discountFactor == 1.0 ? 0.0 : 1.0 / (double)numStates;
        this.openFile();
        this.writeName();
        this.writeRows();
        this.writeColumns();
        this.writeRHS(alpha);
        this.writeEnData();
        this.closeFile();
    }

    @Override
    public final long getBuildTime() {
        return this.buildTime;
    }

    @Override
    public final long getLpSolveTime() {
        return this.lpSolveTime;
    }

    @Override
    public final long getSolBuildTime() {
        return this.solBuildTime;
    }

    @Override
    public final long getProcessTime() {
        return this.processTime;
    }

    private void openFile() throws SolverException {
        String fileName = this.mpsFile.getPath();
        try {
            File dir = this.mpsFile.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            fileName = this.mpsFile.getPath();
            this.output = new Formatter(this.mpsFile);
        }
        catch (SecurityException securityException) {
            throw new SolverException("You do not have write access to  file: " + fileName);
        }
        catch (IOException fileNotFoundException) {
            throw new SolverException("Error creating file: " + fileName);
        }
    }

    private void writeName() {
        this.output.format("NAME          " + this.mpsFile.getName() + "\n", new Object[0]);
    }

    private void writeRows() {
        this.output.format("ROWS\n", new Object[0]);
        this.output.format(" N  OBJ\n", new Object[0]);
        StatesSet states = this.getDiscreteProblem().getAllStates();
        for (State s : states) {
            boolean notFirstRow;
            String constraintLabel = "S" + s.getIndex();
            boolean bl = notFirstRow = !constraintLabel.equals("S0");
            if (this.isAvg && !notFirstRow) continue;
            this.output.format(" E  %-8.8s\n", constraintLabel);
        }
        if (this.isAvg) {
            this.output.format(" E  NORM\n", new Object[0]);
        }
    }

    private void writeColumns() {
        DTMDP<State, Action> problem = this.getDiscreteProblem();
        this.output.format("COLUMNS\n", new Object[0]);
        int indexVariables = 0;
        StatesSet<State> states = problem.getAllStates();
        for (State stateI : states) {
            Actions actions = problem.feasibleActions(stateI);
            for (Action action : actions) {
                double cost = problem.immediateCost(stateI, action);
                String variableName = "V" + String.valueOf(indexVariables);
                this.output.format("    %-8.8s  %-8.8s  %-10.8g\n", variableName, "OBJ", cost);
                States<State> statesJ = problem.reachable(stateI, action);
                for (State stateJ : statesJ) {
                    boolean notFirstRow;
                    double probability = problem.prob(stateI, stateJ, action);
                    double coefficient = (stateI.equals(stateJ) ? 1.0 : 0.0) - (this.isAvg ? probability : this.discountFactor * probability);
                    stateJ = states.get(stateJ);
                    String constraintLabel = "S" + stateJ.getIndex();
                    boolean bl = notFirstRow = !constraintLabel.equals("S0");
                    if (this.isAvg && !notFirstRow) continue;
                    this.output.format("    %-8.8s  %-8.8s  %-10.8g\n", variableName, constraintLabel, coefficient);
                }
                if (this.isAvg) {
                    this.output.format("    %-8.8s  %-8.8s  %-10.8g\n", variableName, "NORM", 1.0);
                }
                ++indexVariables;
            }
        }
    }

    private void writeRHS(double alpha) {
        this.output.format("RHS\n", new Object[0]);
        for (State state : this.getDiscreteProblem().getAllStates()) {
            boolean notFirstRow;
            String constraintLabel = "S" + state.getIndex();
            boolean bl = notFirstRow = !constraintLabel.equals("S0");
            if (this.isAvg && !notFirstRow) continue;
            this.output.format("    %-8.8s  %-8.8s  %-10.5g\n", "RHS", constraintLabel, alpha);
        }
        if (this.isAvg) {
            this.output.format("    %-8.8s  %-8.8s  %-10.5g\n", "RHS", "NORM", 1.0);
        }
    }

    private void writeEnData() {
        this.output.format("ENDATA", new Object[0]);
    }

    private void closeFile() {
        if (this.output != null) {
            this.output.close();
        }
    }
}

