/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import java.io.File;
import jmarkov.basic.Action;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.AbstractAverageSolver;
import jmarkov.jmdp.solvers.MpsLpDiscountedSolver;
import jmarkov.jmdp.solvers.MpsLpSolver;

public abstract class MpsLpAverageSolver<S extends State, A extends Action>
extends AbstractAverageSolver<S, A>
implements MpsLpSolver<S, A> {
    private static String fs = System.getProperty("file.separator");
    private MpsLpDiscountedSolver<S, A> discSolver = null;

    public MpsLpAverageSolver(DTMDP<S, A> problem, String workingDir, String fileName) {
        super(problem);
        this.discSolver = new MpsLpDiscountedSolver<S, A>(problem, 0.0, workingDir, fileName, true){

            @Override
            public void solveLP() throws SolverException {
                MpsLpAverageSolver.this.solveLPI();
            }

            @Override
            public long getIterations() {
                return MpsLpAverageSolver.this.getIterationsI();
            }

            @Override
            public String label() {
                return "MPS Xpress Solver (Avg)";
            }

            @Override
            public Solution<S, A> buildSolution() throws SolverException {
                return MpsLpAverageSolver.this.buildSolutionI();
            }
        };
    }

    public MpsLpAverageSolver(DTMDP<S, A> problem) {
        this(problem, System.getProperty("user.dir"), "MDP.mps");
    }

    @Override
    public final String getMpsFileName() {
        return this.discSolver.getMpsFileName();
    }

    @Override
    public final long getIterations() {
        return this.discSolver.getIterations();
    }

    @Override
    public final Solution<S, A> solve() throws SolverException {
        return this.discSolver.solve();
    }

    @Override
    public final File getWorkingDir() {
        return this.discSolver.getWorkingDir();
    }

    @Override
    public final File getMpsFile() {
        return this.discSolver.getMpsFile();
    }

    protected MpsLpDiscountedSolver<S, A> getDiscSolver() {
        return this.discSolver;
    }

    private void solveLPI() throws SolverException {
        this.solveLP();
    }

    private Solution<S, A> buildSolutionI() throws SolverException {
        return this.buildSolution();
    }

    private long getIterationsI() {
        return this.getIterations();
    }

    @Override
    public long getBuildTime() {
        return this.discSolver.getBuildTime();
    }

    @Override
    public long getLpSolveTime() {
        return this.discSolver.getLpSolveTime();
    }

    @Override
    public long getSolBuildTime() {
        return this.discSolver.getSolBuildTime();
    }

    @Override
    public final long getProcessTime() {
        return this.discSolver.getProcessTime();
    }
}

