/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp.solvers;

import java.io.IOException;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.DecisionRule;
import jmarkov.basic.Policy;
import jmarkov.basic.Solution;
import jmarkov.basic.State;
import jmarkov.basic.StatesSet;
import jmarkov.basic.ValueFunction;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.CT2DTConverter;
import jmarkov.jmdp.CTMDP;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.InfiniteMDP;
import jmarkov.jmdp.solvers.MpsLpDiscountedSolver;
import qs.Problem;
import qs.QSException;

public class MPSQsOptDiscountedSolver<S extends State, A extends Action>
extends MpsLpDiscountedSolver<S, A> {
    private Problem lpProb = null;

    public MPSQsOptDiscountedSolver(CTMDP<S, A> problem, double interestRate, String workingDir, String fileName) {
        this(problem, interestRate, workingDir, fileName, false);
    }

    public MPSQsOptDiscountedSolver(DTMDP<S, A> problem, double interestRate, String workingDir, String fileName) {
        super(problem, interestRate, workingDir, fileName);
    }

    public MPSQsOptDiscountedSolver(DTMDP<S, A> problem, double interestRate) {
        this(problem, interestRate, System.getProperty("user.dir"), "MDP.mps", false);
    }

    public MPSQsOptDiscountedSolver(CTMDP<S, A> problem, double interestRate) {
        this(problem, interestRate, System.getProperty("user.dir"), "MDP.mps", false);
    }

    public MPSQsOptDiscountedSolver(DTMDP<S, A> problem, double interestRate, String workingDir, String fileName, boolean isAvg) {
        super(problem, interestRate, workingDir, fileName, isAvg);
    }

    public MPSQsOptDiscountedSolver(CTMDP<S, A> problem, double interestRate, String workingDir, String fileName, boolean isAvg) {
        super(new CT2DTConverter<S, A>(problem), interestRate, workingDir, fileName, isAvg);
    }

    public MPSQsOptDiscountedSolver(DTMDP<S, A> problem, double interestRate, boolean isAvg) {
        super(problem, interestRate, isAvg);
    }

    public MPSQsOptDiscountedSolver(CTMDP<S, A> problem, double interestRate, boolean isAvg) {
        super(new CT2DTConverter<S, A>(problem), interestRate, isAvg);
    }

    void loadProblem() throws SolverException {
        String mpsFile = this.getMpsFileName();
        try {
            boolean isMpsFormat = true;
            this.lpProb = Problem.read((String)mpsFile, (boolean)isMpsFormat);
            if (this.lpProb == null) {
                throw new SolverException("Could not parse problem with file " + mpsFile);
            }
        }
        catch (IOException e) {
            throw new SolverException("Problems reading file " + mpsFile + ". Exception: " + e);
        }
    }

    @Override
    public long getIterations() {
        return 0L;
    }

    @Override
    public void solveLP() throws SolverException {
        this.loadProblem();
        try {
            this.lpProb.opt_primal();
        }
        catch (QSException e) {
            throw new SolverException("Error solving with QS:" + (Object)((Object)e));
        }
    }

    @Override
    public Solution<S, A> buildSolution() throws SolverException {
        DecisionRule<State, Action> dr = new DecisionRule<State, Action>();
        ValueFunction<State> vf = new ValueFunction<State>();
        try {
            int status = this.lpProb.get_status();
            switch (status) {
                case 3: {
                    int nrows = this.lpProb.get_rowcount();
                    double[] pi = new double[nrows];
                    double[] slack = new double[nrows];
                    int ncols = this.lpProb.get_colcount();
                    double[] x = new double[ncols];
                    double[] rc = new double[ncols];
                    double val = this.lpProb.get_solution(x, pi, slack, rc);
                    StatesSet states = ((InfiniteMDP)this.getProblem()).getAllStates();
                    int i = 0;
                    int var = 0;
                    for (State s : states) {
                        vf.set(s, this.isAvg() ? val : pi[i++]);
                        Actions acts = ((InfiniteMDP)this.getProblem()).feasibleActions(s);
                        for (Action a : acts) {
                            int n = var++;
                            if (!(x[n] > 0.0)) continue;
                            dr.set(s, a);
                        }
                    }
                    break;
                }
                case 6: {
                    throw new SolverException("QSopt found the problem to be unfeasible.");
                }
                case 7: {
                    throw new SolverException("QSopt found the problem to be unbounded.");
                }
                default: {
                    throw new SolverException("QSopt did not find an optimal solution. Return value: " + this.lpProb.get_status());
                }
            }
        }
        catch (QSException e) {
            throw new SolverException("Error reading the solution from QS.", e);
        }
        return new Solution(vf, new Policy(dr));
    }

    @Override
    public String label() {
        return "QSOpt Solver (disc)";
    }
}

