/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.MDP;
import jmarkov.jmdp.solvers.FiniteSolver;
import jmarkov.jmdp.solvers.Solver;

public abstract class FiniteMDP<S extends State, A extends Action>
extends MDP<S, A> {
    protected int horizon;
    private States<S>[] states;

    public FiniteMDP(States<S> initial, int horizon) {
        this.initial = initial;
        this.horizon = horizon;
        this.states = new States[horizon + 1];
        this.finite = true;
    }

    public FiniteMDP(S initial, int horizon) {
        this(new StatesSet<S>(initial), horizon);
    }

    @Override
    protected Solver<S, A> getDefaultSolver() {
        return new FiniteSolver(this);
    }

    public abstract double immediateCost(S var1, A var2, int var3);

    public abstract double prob(S var1, S var2, A var3, int var4);

    public abstract States<S> reachable(S var1, A var2, int var3);

    public States<S> getStates(int t) {
        if (this.states[t] == null) {
            int n = t;
            while (this.states[n] == null && n > 1) {
                --n;
            }
            if (n > 1) {
                this.states[n + 1] = this.oneStageReachable(this.states[n], n);
            } else if (n == 1) {
                this.states[1] = this.oneStageReachable(this.initial, n);
            } else {
                this.states[0] = this.initial;
            }
            while (n < t) {
                this.states[n + 1] = this.oneStageReachable(this.states[n], n);
                ++n;
            }
        }
        return this.states[t];
    }

    private States<S> oneStageReachable(States<S> initSet, int t) {
        StatesSet<State> stts = new StatesSet<State>();
        for (State s : initSet) {
            Actions<A> act = this.feasibleActions(s, t);
            for (Action a : act) {
                States<State> reached = this.reachable(s, a, t);
                for (State s1 : reached) {
                    stts.add(s1);
                }
            }
        }
        return stts;
    }

    public abstract double finalCost(S var1);

    public final double defaultFinalCost(S i) {
        double val = 0.0;
        Actions<A> availableActions = this.feasibleActions(i, this.horizon);
        double maxSoFar = -1.7976931348623157E308;
        for (Action a : availableActions) {
            val = this.immediateCost(i, a, this.horizon);
            if (!(val > maxSoFar)) continue;
            maxSoFar = val;
        }
        return val;
    }

    public abstract Actions<A> feasibleActions(S var1, int var2);

    protected void setHorizon(int T) {
        this.horizon = T;
    }

    public int getHorizon() {
        return this.horizon;
    }
}

