/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.Event;
import jmarkov.basic.Events;
import jmarkov.basic.State;
import jmarkov.basic.StateEvent;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.DTMDP;

public abstract class DTMDPEvA<S extends State, A extends Action, E extends Event>
extends DTMDP<StateEvent<S, E>, A> {
    public DTMDPEvA(States<S> initial) {
        super(new StatesSet());
        StatesSet<StateEvent<State, Event>> statesSet = new StatesSet<StateEvent<State, Event>>();
        for (State s : initial) {
            for (Action a : this.feasibleAct(s)) {
                for (Event e2 : this.activeEvents(s, a)) {
                    statesSet.add(new StateEvent<State, Event>(s, e2));
                }
            }
        }
        this.initial = statesSet;
    }

    @Override
    public final States<StateEvent<S, E>> reachable(StateEvent<S, E> i, A a) {
        StatesSet<StateEvent<StateEvent<State, Event>, E>> statesSet = new StatesSet<StateEvent<StateEvent<State, Event>, E>>();
        States<S> reached = this.reachable(i.getState(), a, i.getEvent());
        for (State j : reached) {
            for (Event e2 : this.activeEvents(j, a)) {
                statesSet.add(new StateEvent<State, Event>(j, e2));
            }
        }
        return statesSet;
    }

    @Override
    public final double immediateCost(StateEvent<S, E> i, A a) {
        return this.prob(i.getState(), i.getEvent()) * this.immediateCost(i.getState(), a, i.getEvent());
    }

    @Override
    public final double prob(StateEvent<S, E> i, StateEvent<S, E> j, A a) {
        return this.prob(i.getState(), j.getState(), a, i.getEvent()) * this.prob(i.getState(), i.getEvent());
    }

    @Override
    public final Actions<A> feasibleActions(StateEvent<S, E> i) {
        return this.feasibleAct(i.getState());
    }

    public abstract double immediateCost(S var1, A var2, E var3);

    public abstract double prob(S var1, S var2, A var3, E var4);

    public abstract double prob(S var1, E var2);

    public abstract States<S> reachable(S var1, A var2, E var3);

    public abstract Events<E> activeEvents(S var1, A var2);

    public abstract Actions<A> feasibleAct(S var1);
}

