/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.jmdp;

import java.util.Iterator;
import java.util.TreeMap;
import jmarkov.basic.Action;
import jmarkov.basic.Actions;
import jmarkov.basic.Event;
import jmarkov.basic.Events;
import jmarkov.basic.State;
import jmarkov.basic.StateEvent;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.CTMDP;

public abstract class CTMDPEvA<S extends State, A extends Action, E extends Event>
extends CTMDP<StateEvent<S, E>, A> {
    protected States<S> initSet;

    public CTMDPEvA(States<S> initial) {
        super(null);
        this.initSet = initial;
    }

    @Override
    protected StatesSet<StateEvent<S, E>> generate() {
        StatesSet unexplored = null;
        StatesSet<StateEvent<StateEvent, E>> explored = new StatesSet<StateEvent<StateEvent, E>>();
        if (this.initial == null) {
            StatesSet<StateEvent<State, Event>> statesSet = new StatesSet<StateEvent<State, Event>>();
            for (State s : this.initSet) {
                for (Event e2 : this.activeEvents(s)) {
                    statesSet.add(new StateEvent<State, Event>(s, e2));
                }
            }
            this.initial = statesSet;
            unexplored = new StatesSet(this.initial);
            Iterator<S> iterator = this.initial.iterator();
            if (iterator.hasNext()) {
                State s;
                this.activeState = s = (StateEvent)iterator.next();
            }
            long initialTime = System.currentTimeMillis();
            while (unexplored.size() > 0) {
                StatesSet<StateEvent> stts = this.oneStageReachable(unexplored);
                for (StateEvent stateEvent : unexplored) {
                    explored.add(stateEvent);
                }
                for (StateEvent stateEvent : explored) {
                    stts.remove(stateEvent);
                }
                unexplored = stts;
            }
            this.explorationTime = System.currentTimeMillis() - initialTime;
            this.maxRate *= 1.1;
            this.debug(1, String.valueOf(explored.size()) + " states found.\n");
        }
        return explored;
    }

    private double prob(StateEvent<S, E> i, A a) {
        States<S> st = this.reached(i.getState(), a, i.getEvent());
        double sum = 0.0;
        for (State s : st) {
            sum += this.rate(i.getState(), s, a, i.getEvent());
        }
        return sum / this.converter.exitRate(i, a);
    }

    @Override
    public double lumpCost(StateEvent<S, E> i, A a) {
        return this.prob(i, a) * this.lumpCost(i.getState(), a, i.getEvent());
    }

    @Override
    public double continuousCost(StateEvent<S, E> i, A a) {
        return this.prob(i, a) * this.continuousCost(i.getState(), a, i.getEvent());
    }

    @Override
    public double rate(StateEvent<S, E> i, StateEvent<S, E> j, A a) {
        return this.rate(i.getState(), j.getState(), a, i.getEvent()) * this.prob(i, a);
    }

    @Override
    public States<StateEvent<S, E>> reachable(StateEvent<S, E> i, A a) {
        StatesSet<StateEvent<StateEvent<State, Event>, E>> statesSet = new StatesSet<StateEvent<StateEvent<State, Event>, E>>();
        States<S> reached = this.reached(i.getState(), a, i.getEvent());
        for (State j : reached) {
            for (Event e2 : this.activeEvents(j)) {
                statesSet.add(new StateEvent<State, Event>(j, e2));
            }
        }
        this.converter.setExitRates(new TreeMap());
        return statesSet;
    }

    @Override
    public Actions<A> feasibleActions(StateEvent<S, E> s) {
        return this.feasibleAct(s.getState());
    }

    public abstract double rate(S var1, S var2, A var3, E var4);

    public abstract States<S> reached(S var1, A var2, E var3);

    public abstract Events<E> activeEvents(S var1);

    public abstract double lumpCost(S var1, A var2, E var3);

    public abstract double continuousCost(S var1, A var2, E var3);

    public abstract Actions<A> feasibleAct(S var1);
}

