/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesElement;
import jmarkov.basic.State;

public class PropertiesState
extends State
implements PropertiesElement {
    protected final int[] prop;

    public PropertiesState(int K) {
        this.prop = new int[K];
    }

    public PropertiesState(int[] properties) {
        this(properties, true);
    }

    public PropertiesState(int[] properties, boolean deepCopy) {
        if (deepCopy) {
            int N = properties.length;
            this.prop = new int[N];
            System.arraycopy(properties, 0, this.prop, 0, N);
        } else {
            this.prop = properties;
        }
    }

    public PropertiesState(PropertiesState s) {
        int n = s.prop.length;
        this.prop = new int[n];
        System.arraycopy(s.prop, 0, this.prop, 0, n);
    }

    public void computeMOPs(MarkovProcess mp) {
        int n = this.prop.length;
        int i = 0;
        while (i < n) {
            this.setMOP(mp, "Average for Property " + i, this.prop[i]);
            ++i;
        }
    }

    @Override
    public final int compareTo(State s) {
        if (!(s instanceof PropertiesState)) {
            return -1;
        }
        return this.compareTo((PropertiesState)s);
    }

    @Override
    public final int compareTo(PropertiesState ps) {
        int K = this.prop.length;
        int K2 = ps.prop.length;
        if (K != K2) {
            return K < K2 ? -1 : 1;
        }
        int i = 0;
        while (i < K) {
            if (this.prop[i] < ps.prop[i]) {
                return -1;
            }
            if (this.prop[i] > ps.prop[i]) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public String label() {
        String stg = "(";
        int n = this.prop.length;
        int i = 0;
        while (i < n - 1) {
            stg = String.valueOf(stg) + this.prop[i] + ",";
            ++i;
        }
        stg = String.valueOf(stg) + this.prop[n - 1] + ")";
        return stg;
    }

    @Override
    public int getNumProps() {
        return this.prop.length;
    }

    @Override
    public final int[] getProperties() {
        int[] newProp = new int[this.prop.length];
        System.arraycopy(this.prop, 0, newProp, 0, this.prop.length);
        return newProp;
    }

    @Override
    public int getProperty(int index) {
        return this.prop[index];
    }

    protected void setProperty(int index, int value) {
        this.prop[index] = value;
    }

    @Override
    public PropertiesElement clone() {
        return new PropertiesState(this.prop);
    }

    @Override
    public boolean isConsistent() {
        return true;
    }
}

