/*
 * Decompiled with CFR 0.152.
 */
package jmarkov.basic;

import jmarkov.basic.Action;
import jmarkov.basic.PropertiesElement;

public class PropertiesAction
extends Action
implements PropertiesElement {
    private final int[] prop;

    public PropertiesAction(int[] properties) {
        this.prop = properties;
    }

    @Override
    public String label() {
        String name = "(";
        int i = 0;
        while (i < this.prop.length - 1) {
            name = String.valueOf(name) + this.prop[i] + ",";
            ++i;
        }
        name = String.valueOf(name) + this.prop[this.prop.length - 1] + ")";
        return name;
    }

    public PropertiesAction(int size) {
        this.prop = new int[size];
    }

    @Override
    public final int compareTo(PropertiesAction a) {
        if (this.prop.length > a.prop.length) {
            return 1;
        }
        int i = 0;
        while (i < this.prop.length) {
            if (this.prop[i] < a.prop[i]) {
                return 1;
            }
            if (this.prop[i] > a.prop[i]) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    @Override
    public final int compareTo(Action a) {
        if (!(a instanceof PropertiesAction)) {
            return -1;
        }
        return this.compareTo((PropertiesAction)a);
    }

    @Override
    public final int[] getProperties() {
        int[] newProp = new int[this.prop.length];
        System.arraycopy(this.prop, 0, newProp, 0, this.prop.length);
        return newProp;
    }

    @Override
    public int getProperty(int index) {
        return this.prop[index];
    }

    protected void setProperty(int index, int value) {
        this.prop[index] = value;
    }

    @Override
    public int getNumProps() {
        return this.prop.length;
    }

    @Override
    public PropertiesAction clone() {
        return new PropertiesAction(this.prop);
    }
}

