/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import examples.jmarkov.Jackson;
import jmarkov.MarkovProcess;
import jmarkov.Utils;
import jmarkov.basic.exceptions.NotUnichainException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class JacksonTest
extends TestCase {
    private Jackson jackie = null;

    public static void main(String[] args) {
        TestRunner.run(JacksonTest.class);
    }

    public JacksonTest(String name) {
        super(name);
        int[] wip = new int[]{10, 10, 15};
        int[] servers = new int[]{2, 2, 3};
        double[] rates = new double[]{10.0, 8.0, 12.0};
        double[][] probs = new double[][]{{0.0, 0.5, 0.5}, {0.0, 0.0, 1.0}, {1.0, 0.0, 0.0}};
        this.jackie = new Jackson(wip, servers, rates, (double[][])probs);
        this.jackie.setDebugLevel(0);
    }

    public void testGenerate() {
        this.jackie.generate();
        JacksonTest.assertTrue((this.jackie.getStatus() == MarkovProcess.Status.GENERATED ? 1 : 0) != 0);
    }

    public void oldtestStatusBig() {
        Jackson jacko = new Jackson("JacksonFiles/BigWiplevel.txt", "JacksonFiles/BigNumservers.txt", "JacksonFiles/BigServicesrates.txt", "JacksonFiles/BigProbabilities.txt");
        jacko.setMaxStates(Long.MAX_VALUE);
        jacko.generate();
        JacksonTest.assertTrue((jacko.getStatus() == MarkovProcess.Status.GENERATED ? 1 : 0) != 0);
    }

    public void testGetSteadyState() throws NotUnichainException {
        double[] prob = this.jackie.getSteadyState();
        JacksonTest.assertEquals((String)"Wrong prob value", (double)0.03985, (double)prob[665], (double)0.001);
    }

    public void testMOPsAvg() throws NotUnichainException {
        double[] mops = this.jackie.getMOPsAvg();
        Utils.assertArrayEquals("MOPS not equal: ", new double[]{1.9999978951064057, 1.2500006423494994, 1.6666593265864875, 30.90737210525042, 2.0512648064879384, 2.041335065754373}, mops, 1.0E-4);
    }

    public void testMVA() throws NotUnichainException {
        Utils.resetMVA();
        int M = 1;
        while (M <= 5) {
            int N = 1;
            while (N <= 10) {
                double[] mu = new double[M];
                int m = 0;
                while (m < M) {
                    mu[m] = 1.0 / ((double)m + 1.0);
                    ++m;
                }
                double[][] prob = Utils.getProb(M);
                double[] expThr = Utils.getMVAthruput(N, M, mu, prob);
                Jackson jacky = new Jackson(N, M, mu, prob);
                jacky.setDebugLevel(0);
                double[] thr = jacky.effLambdas();
                Utils.assertArrayEquals("Thruput not equal comparing with MVA, for N = " + N + " and M = " + M + ". ", expThr, thr, 1.0E-5);
                jacky = null;
                N += 2;
            }
            M += 2;
        }
    }
}

