/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import java.io.PrintWriter;
import java.util.TreeSet;
import jmarkov.GeomRelState;
import jmarkov.GeomState;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.Event;
import jmarkov.basic.EventsSet;
import jmarkov.basic.State;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;
import jmarkov.solvers.GeometricSolver;
import jmarkov.solvers.MtjLogRedSolver;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.FlexCompRowMatrix;

public abstract class GeomProcess<Sub extends State, E extends Event>
extends SimpleMarkovProcess<GeomState<Sub>, E> {
    private int level1Idx = -1;
    private int level2Idx = -1;
    private int boundaryIdx = -1;
    protected GeometricSolver GeometrixSolver = null;
    protected GeometricSolver defaultGeometrixSolver = null;
    private Sub[] theBoundaryStates = null;
    private Sub[] theTypicalStates = null;
    private Matrix R = null;
    private Matrix[] A;
    private Matrix[] B = null;
    private double[] pis = null;
    private double[] pi1 = null;
    private double[] pi1mod = null;
    private double[] pi0 = null;
    private boolean stabilityChecked = false;
    private boolean isStable = false;

    public GeomProcess(Sub i0, EventsSet<E> eSet) {
        super(new GeomState<Sub>(i0, 0), eSet);
        this.addMOP("Expected Level");
    }

    @Override
    public StatesSet<GeomState<Sub>> getStates() {
        StatesSet<GeomState<Sub>> states = super.getStates();
        this.getLevelsIndices();
        return states;
    }

    private int[] getLevelsIndices() {
        GeomState[] theGeomStates = null;
        theGeomStates = (GeomState[])super.getStates().toStateArray();
        int[] maxIdx = new int[3];
        GeomState[] geomStateArray = theGeomStates;
        int n = theGeomStates.length;
        int n2 = 0;
        while (n2 < n) {
            GeomState s = geomStateArray[n2];
            int level = s.getLevel();
            maxIdx[level] = s.getIndex();
            ++n2;
        }
        this.boundaryIdx = maxIdx[0];
        this.level1Idx = maxIdx[1];
        this.level2Idx = maxIdx[2];
        return maxIdx;
    }

    public Sub[] getBoundaryStates() {
        if (this.theBoundaryStates == null) {
            GeomState[] theStates = (GeomState[])this.getStates().toStateArray();
            StatesSet bdrySet = new StatesSet();
            int i = 0;
            while (i <= this.boundaryIdx) {
                bdrySet.add(theStates[i].getSubState());
                ++i;
            }
            this.theBoundaryStates = bdrySet.toStateArray();
        }
        return this.theBoundaryStates;
    }

    public Sub[] getTypicalStates() {
        if (this.theTypicalStates == null) {
            GeomState[] theStates = (GeomState[])this.getStates().toStateArray();
            StatesSet typicStates = new StatesSet();
            int i = this.boundaryIdx + 1;
            while (i <= this.level1Idx) {
                typicStates.add(theStates[i].getSubState());
                ++i;
            }
            this.theTypicalStates = typicStates.toStateArray();
        }
        return this.theTypicalStates;
    }

    public int getNumBoundaryStates() {
        if (!this.isGenerated()) {
            this.generate();
        }
        this.getLevelsIndices();
        return this.boundaryIdx + 1;
    }

    public int getNumTypicalStates() {
        if (!this.isGenerated()) {
            this.generate();
        }
        this.getLevelsIndices();
        return this.level1Idx - this.boundaryIdx;
    }

    public Matrix getSubMatrices(int rowMin, int rowMax, int colMin, int colMax) {
        int[] rows = new int[rowMax - rowMin + 1];
        int[] rowsSub = new int[rowMax - rowMin + 1];
        int[] columns = new int[colMax - colMin + 1];
        int[] columnsSub = new int[colMax - colMin + 1];
        int i = rowMin;
        while (i < rowMax + 1) {
            rows[i - rowMin] = i;
            rowsSub[i - rowMin] = i - rowMin;
            ++i;
        }
        i = colMin;
        while (i < colMax + 1) {
            columns[i - colMin] = i;
            columnsSub[i - colMin] = i - colMin;
            ++i;
        }
        Matrix generator = this.getMtjGenerator();
        Matrix SubMatrix = Matrices.getSubMatrix((Matrix)generator, (int[])rows, (int[])columns);
        return SubMatrix;
    }

    public Matrix getRmatrix() throws NotUnichainException {
        if (this.R == null) {
            int n = this.getNumTypicalStates();
            if (!this.stabilityChecked) {
                this.isStable = this.isStable();
            }
            if (!this.isStable) {
                return new DenseMatrix(n, n);
            }
            this.R = new DenseMatrix(this.getGeometrixSolver().getRmatrix());
        }
        return this.R;
    }

    public double[][] matrixRtoArray() throws NotUnichainException {
        if (this.R == null) {
            this.R = this.getRmatrix();
        }
        int n = this.R.numRows();
        double[][] matrixR = new double[n][n];
        for (MatrixEntry e : this.R) {
            int row = e.row();
            int column = e.column();
            matrixR[row][column] = e.get();
        }
        return matrixR;
    }

    public Matrix[] getAMatrices() {
        if (this.A == null) {
            this.getLevelsIndices();
            Matrix A0 = this.getSubMatrices(this.boundaryIdx + 1, this.level1Idx, this.level1Idx + 1, this.level2Idx);
            Matrix A1 = this.getSubMatrices(this.boundaryIdx + 1, this.level1Idx, this.boundaryIdx + 1, this.level1Idx);
            Matrix A2 = this.getSubMatrices(this.level1Idx + 1, this.level2Idx, this.boundaryIdx + 1, this.level1Idx);
            this.A = new Matrix[]{A0, A1, A2};
            this.debug(3, "A0 is:\n" + A0.toString());
            this.debug(3, "A1 is:\n" + A1.toString());
            this.debug(3, "A2 is:\n" + A2.toString());
        }
        return this.A;
    }

    public Matrix[] getBMatrices() {
        if (this.B == null) {
            this.getLevelsIndices();
            Matrix B00 = this.getSubMatrices(0, this.boundaryIdx, 0, this.boundaryIdx);
            Matrix B01 = this.getSubMatrices(0, this.boundaryIdx, this.boundaryIdx + 1, this.level1Idx);
            Matrix B10 = this.getSubMatrices(this.boundaryIdx + 1, this.level1Idx, 0, this.boundaryIdx);
            this.B = new Matrix[]{B00, B01, B10};
            this.debug(3, "B00 is:\n" + B00.toString());
            this.debug(3, "B01 is:\n" + B01.toString());
            this.debug(3, "B10 is:\n" + B10.toString());
        }
        return this.B;
    }

    public double[] getInitialSol() throws NotUnichainException {
        if (this.pis == null) {
            boolean stable = this.isStable();
            if (!stable) {
                this.debug(0, "The system is unstable");
                return new double[this.getNumBoundaryStates() + this.getNumTypicalStates()];
            }
            this.getLevelsIndices();
            Matrix[] A = this.getAMatrices();
            Matrix A1 = A[1];
            Matrix A2 = A[2];
            Matrix[] B = this.getBMatrices();
            FlexCompRowMatrix B00 = new FlexCompRowMatrix(B[0], true);
            Matrix B01 = B[1];
            FlexCompRowMatrix B10 = new FlexCompRowMatrix(B[2], true);
            int i = 0;
            while (i < B00.numRows()) {
                B00.set(i, 0, 1.0);
                ++i;
            }
            Matrix R = this.getRmatrix();
            DenseMatrix I = new DenseMatrix((Matrix)Matrices.identity((int)R.numRows()));
            DenseMatrix e = new DenseMatrix(R.numRows(), 1);
            int i2 = 0;
            while (i2 < e.numRows()) {
                e.set(i2, 0, 1.0);
                ++i2;
            }
            DenseMatrix inversa = new DenseMatrix(R.numRows(), R.numColumns());
            I.add(-1.0, R);
            I.solve((Matrix)Matrices.identity((int)R.numRows()), (Matrix)inversa);
            I = new DenseMatrix(R.numRows(), 1);
            inversa.mult((Matrix)e, (Matrix)I);
            int i3 = 0;
            while (i3 < B10.numRows()) {
                B10.set(i3, 0, I.get(i3, 0));
                ++i3;
            }
            int columDimension = B00.numColumns() + B01.numColumns();
            int rowDimension = B00.numRows() + B10.numRows();
            Matrix M22 = R.multAdd(A2, A1);
            DenseVector Pis = new DenseVector(rowDimension);
            DenseVector zeros = new DenseVector(columDimension);
            zeros.zero();
            zeros.set(0, 1.0);
            DenseMatrix MTotal = this.assmbleMatrix((Matrix)B00, B01, (Matrix)B10, M22);
            MTotal.transSolve((Vector)zeros, (Vector)Pis);
            this.pis = Pis.getData();
        }
        return this.pis;
    }

    private DenseMatrix assmbleMatrix(Matrix B00, Matrix B01, Matrix B10, Matrix B11) {
        int columDimension = B00.numColumns() + B01.numColumns();
        int rowDimension = B00.numRows() + B10.numRows();
        DenseMatrix MTotal = new DenseMatrix(rowDimension, columDimension);
        this.setSubMatrix((Matrix)MTotal, B00, 0, 0);
        this.setSubMatrix((Matrix)MTotal, B01, 0, B00.numColumns());
        this.setSubMatrix((Matrix)MTotal, B10, B00.numRows(), 0);
        this.setSubMatrix((Matrix)MTotal, B11, B00.numRows(), B00.numColumns());
        return MTotal;
    }

    private void setSubMatrix(Matrix mat, Matrix submatrix, int rowOffset, int colOffset) {
        for (MatrixEntry entry : submatrix) {
            mat.set(entry.row() + rowOffset, entry.column() + colOffset, entry.get());
        }
    }

    public double[] getVectorPi1() throws NotUnichainException {
        if (this.pi1 == null) {
            this.pis = this.getInitialSol();
            int n0 = this.getNumBoundaryStates();
            int n = this.getNumTypicalStates();
            this.pi1 = new double[n];
            System.arraycopy(this.pis, n0, this.pi1, 0, n);
        }
        return this.pi1;
    }

    public double[] getVectorPi1Mod() throws NotUnichainException {
        if (this.pi1mod == null) {
            this.pi1 = this.getVectorPi1();
            int n = this.getNumTypicalStates();
            this.R = this.getRmatrix();
            DenseVector sol = new DenseVector(n);
            DenseMatrix ImR = new DenseMatrix((Matrix)Matrices.identity((int)n));
            ImR.add(-1.0, this.R);
            ImR.transSolve((Vector)new DenseVector(this.pi1), (Vector)sol);
            this.pi1mod = sol.getData();
        }
        return this.pi1mod;
    }

    public double[] getVectorPi0() throws NotUnichainException {
        if (this.pi0 == null) {
            this.pis = this.getInitialSol();
            this.pi0 = new double[this.boundaryIdx + 1];
            int i = 0;
            while (i < this.boundaryIdx + 1) {
                this.pi0[i] = this.pis[i];
                ++i;
            }
        }
        return this.pi0;
    }

    public double[] getSteadyState(int level) throws NotUnichainException {
        DenseVector piLevel;
        if (level == 0) {
            piLevel = new DenseVector(this.getVectorPi0());
        } else {
            piLevel = new DenseVector(this.getVectorPi1());
            Matrix R = this.getRmatrix();
            int size = piLevel.size();
            int i = 1;
            while (i < level) {
                DenseVector newPiLevel = new DenseVector(size);
                R.transMult((Vector)piLevel, (Vector)newPiLevel);
                piLevel = newPiLevel;
                ++i;
            }
        }
        return piLevel.getData();
    }

    public double[] steadyProbabilities() throws NotUnichainException {
        int N = this.getNumStates();
        double[] steadyProb = new double[N];
        if (this.isStable()) {
            double[] initialPis = this.getInitialSol();
            int n0 = initialPis.length;
            System.arraycopy(initialPis, 0, steadyProb, 0, n0);
            double[] pi2 = this.getSteadyState(2);
            int n2 = pi2.length;
            System.arraycopy(pi2, 0, steadyProb, n0, n2);
        }
        return steadyProb;
    }

    public double getExpectedLevel() throws NotUnichainException {
        double expLevel = -1.0;
        if (expLevel == -1.0) {
            double[] pi1mod = this.getVectorPi1Mod();
            int n = this.getNumTypicalStates();
            this.R = this.getRmatrix();
            DenseVector sol = new DenseVector(n);
            DenseMatrix ImR = new DenseMatrix((Matrix)Matrices.identity((int)n));
            ImR.add(-1.0, this.R);
            ImR.transSolve((Vector)new DenseVector(pi1mod), (Vector)sol);
            expLevel = sol.norm(Vector.Norm.One);
        }
        return expLevel;
    }

    private double getExpectedLevelOld() throws NotUnichainException {
        double result = 0.0;
        Matrix R = this.getRmatrix();
        DenseVector Pi1 = new DenseVector(this.getVectorPi1());
        DenseMatrix TMP = new DenseMatrix((Matrix)Matrices.identity((int)R.numRows()));
        DenseVector Vtmp = new DenseVector(R.numRows());
        DenseMatrix Square = new DenseMatrix(R.numRows(), R.numRows());
        DenseMatrix Inv = new DenseMatrix(R.numRows(), R.numRows());
        TMP.add(-1.0, R);
        TMP.mult((Matrix)TMP, (Matrix)Square);
        Square.solve((Matrix)Matrices.identity((int)Square.numRows()), (Matrix)Inv);
        TMP = new DenseMatrix((Matrix)Matrices.identity((int)R.numRows()));
        R.mult((Matrix)Square, (Matrix)TMP);
        TMP.transpose();
        TMP.mult((Vector)Pi1, (Vector)Vtmp);
        int i = 0;
        while (i < R.numRows()) {
            result += Vtmp.get(i);
            ++i;
        }
        return result;
    }

    public boolean isStable() {
        if (!this.stabilityChecked) {
            Matrix[] A = this.getAMatrices();
            Matrix A0 = A[0];
            Matrix A1 = A[1];
            Matrix A2 = A[2];
            int dim = A0.numRows();
            DenseMatrix sum = new DenseMatrix(dim, dim);
            DenseMatrix b = new DenseMatrix(dim, 1);
            DenseMatrix f = new DenseMatrix(dim, 1);
            DenseMatrix ft = new DenseMatrix(1, dim);
            DenseMatrix rigth = new DenseMatrix(1, dim);
            DenseMatrix left = new DenseMatrix(1, dim);
            double R = 0.0;
            double L = 0.0;
            b.zero();
            b.set(dim - 1, 0, 1.0);
            sum.add(A0);
            sum.add(A1);
            sum.add(A2);
            int i = 0;
            while (i < dim) {
                sum.set(i, dim - 1, 1.0);
                ++i;
            }
            sum.transSolve((Matrix)b, (Matrix)f);
            f.transpose((Matrix)ft);
            ft.mult(A2, (Matrix)rigth);
            ft.mult(A0, (Matrix)left);
            i = 0;
            while (i < dim) {
                R += rigth.get(0, i);
                L += left.get(0, i);
                ++i;
            }
            this.isStable = L < R;
            this.stabilityChecked = true;
        }
        return this.isStable;
    }

    @Override
    public void printAll(PrintWriter out) {
        int N = this.getNumStates();
        out.println(String.valueOf(this.description()) + "\n");
        out.println("System has: \n" + this.getNumBoundaryStates() + " Boundary States.\n" + this.getNumTypicalStates() + " States in  typical levels.\n");
        boolean isStable = this.isStable();
        if (!isStable) {
            out.println("The system is NOT stable !");
        }
        if (N < 100) {
            this.printStates(out);
            this.printDenseMatrix(out, 10, 4, false, false, this.getLevelsIndices());
        }
        out.println();
        try {
            Matrix[] A = this.getAMatrices();
            Matrix A0 = A[0];
            Matrix A1 = A[1];
            Matrix A2 = A[2];
            Matrix R = this.getRmatrix();
            out.println();
            this.printDenseAMatrix(out, A0, this.getTypicalStates(), "A0");
            out.println();
            this.printDenseAMatrix(out, A1, this.getTypicalStates(), "A1");
            out.println();
            this.printDenseAMatrix(out, A2, this.getTypicalStates(), "A2");
            out.println();
            if (isStable) {
                this.printDenseAMatrix(out, R, this.getTypicalStates(), "R");
                out.println();
                this.printMOPs(out);
                this.printEventsRates(out);
            }
        }
        catch (NotUnichainException e) {
            out.print(e);
        }
    }

    @Override
    public void printStates(PrintWriter out, int width, int probDecimals) {
        State[] stts = this.getStates().toStateArray();
        this.debug(1, "Printing States...");
        int n = stts.length;
        int maxL = 9;
        try {
            double[] pi = this.steadyProbabilities();
            int i = 0;
            while (i < n) {
                maxL = Math.max(maxL, stts[i].label().length());
                ++i;
            }
            int w = maxL + 3;
            int w2 = width + 3;
            out.println(String.valueOf(this.pad("", w)) + this.pad("EQUILIBRUM", w2, false));
            out.println(String.valueOf(this.pad("STATE", w, false)) + this.pad("PROBAB.", w2, false) + "DESCRIPTION");
            out.println();
            String hLine = this.hLine(w + w2 + w + w2 + 15);
            int[] idx = this.getLevelsIndices();
            int k = 0;
            out.println(hLine);
            int i2 = 0;
            while (i2 < n) {
                out.println(String.valueOf(this.pad(stts[i2].label(), w, false)) + this.pad(pi[i2], w, probDecimals, false) + (stts[i2].description() != "" ? stts[i2].description() : ""));
                if (i2 == idx[k]) {
                    out.println(hLine);
                    ++k;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < 3) {
                out.println(String.valueOf(this.pad(".", w, false)) + this.pad(".", w, false) + this.pad(".", w, false));
                ++i2;
            }
        }
        catch (NotUnichainException e) {
            out.print(e);
        }
        out.println();
    }

    private void printDenseAMatrix(PrintWriter out, Matrix A, Sub[] states, String Matrix2) {
        this.printDenseAMatrix(out, 10, 4, false, A, (State[])states, Matrix2);
    }

    private void printDenseAMatrix(PrintWriter out, int width, int rateDecimals, boolean printZeros, Matrix A, Sub[] subStates, String matrixName) {
        int n = subStates.length;
        int maxL = 0;
        int i = 0;
        while (i < n) {
            maxL = Math.max(maxL, ((State)subStates[i]).label().length());
            ++i;
        }
        int w = Math.max(maxL + 1, width);
        out.println(String.valueOf(matrixName) + " MATRIX: ");
        out.print(this.pad(" ", w));
        int i2 = 0;
        while (i2 < n) {
            out.print(this.pad(((State)subStates[i2]).toString(), w));
            ++i2;
        }
        this.cnt = 0;
        while (this.cnt < n) {
            i2 = this.cnt;
            out.println();
            out.print(this.pad(((State)subStates[i2]).toString(), w));
            int j = 0;
            while (j < n) {
                if (A.get(i2, j) == 0.0 && !printZeros) {
                    out.print(this.pad("", w));
                } else {
                    out.print(this.pad(A.get(i2, j), w, rateDecimals));
                }
                ++j;
            }
            ++this.cnt;
        }
        out.flush();
    }

    private void printDenseRMatrix(PrintWriter out, Matrix R, String Matrix2) {
        this.printDenseRMatrix(out, 10, 3, false, R, Matrix2);
    }

    private void printDenseRMatrix(PrintWriter out, int width, int rateDecimals, boolean printZeros, Matrix R, String Matrix2) {
        int n = R.numColumns();
        int maxL = 0;
        int w = Math.max(maxL + 1, width);
        out.println(String.valueOf(Matrix2) + " MATRIX: ");
        out.print(this.pad(" ", w));
        this.cnt = 0;
        while (this.cnt < n) {
            int i = this.cnt;
            out.println();
            int j = 0;
            while (j < n) {
                if (R.get(i, j) == 0.0 && !printZeros) {
                    out.print(this.pad("", w));
                } else {
                    out.print(this.pad(R.get(i, j), w, rateDecimals));
                }
                ++j;
            }
            ++this.cnt;
        }
        out.flush();
    }

    public abstract GeomRelState[] dests(Sub var1, int var2, E var3);

    @Override
    public final States<GeomState<Sub>> dests(GeomState<Sub> i, E e) {
        GeomRelState[] dests = this.dests(i.getSubState(), i.getLevel(), e);
        TreeSet newDest = new TreeSet();
        GeomRelState[] geomRelStateArray = dests;
        int n = dests.length;
        int n2 = 0;
        while (n2 < n) {
            GeomState j;
            GeomRelState s = geomRelStateArray[n2];
            if (s.isBoundary()) {
                j = new GeomState(s.getSubState(), 0);
                newDest.add(j);
            } else {
                int newLevel = i.getLevel() + s.getRelLevel();
                if (newLevel <= 2) {
                    j = new GeomState(s.getSubState(), newLevel);
                    newDest.add(j);
                }
            }
            ++n2;
        }
        int size = newDest.size();
        if (size == 0) {
            return null;
        }
        return new StatesSet<GeomState<Sub>>(newDest);
    }

    public abstract boolean active(Sub var1, int var2, E var3);

    @Override
    public final boolean active(GeomState<Sub> i, E e) {
        return this.active(i.getSubState(), i.getLevel(), e);
    }

    public abstract double rate(Sub var1, int var2, Sub var3, int var4, E var5);

    @Override
    public double rate(GeomState<Sub> i, GeomState<Sub> j, E e) {
        Sub iSub = i.getSubState();
        Sub jSub = j.getSubState();
        return this.rate(iSub, i.getLevel(), jSub, j.getLevel(), e);
    }

    @Override
    public void reset() {
        super.reset();
        this.A = null;
        this.B = null;
        this.boundaryIdx = -1;
        this.level1Idx = -1;
        this.level2Idx = -1;
        this.pi0 = null;
        this.pi1 = null;
        this.pis = null;
        this.R = null;
        this.pi1mod = null;
        this.stabilityChecked = false;
    }

    @Override
    public double getMOPsMoment(int mopNum, int m) throws NotUnichainException {
        if (this.getMOPNames(mopNum) == "Expected Level") {
            if (m == 1) {
                return this.getExpectedLevel();
            }
            return Double.NaN;
        }
        double[] pi0 = this.getVectorPi0();
        double[] pi1m = this.getVectorPi1Mod();
        String mopName = this.getMOPNames(mopNum);
        this.debug(1, "Computing moment " + m + " for MOP " + mopName);
        int N0 = this.getNumBoundaryStates();
        int N1 = this.getNumTypicalStates();
        double sum = 0.0;
        State[] theBStates = this.getBoundaryStates();
        int i = 0;
        while (i < N0) {
            sum += pi0[i] * Math.pow(theBStates[i].getMOP(mopNum), m);
            ++i;
        }
        State[] theTStates = this.getTypicalStates();
        int i2 = 0;
        while (i2 < N1) {
            sum += pi1m[i2] * Math.pow(theTStates[i2].getMOP(mopNum), m);
            ++i2;
        }
        return sum;
    }

    @Override
    public double getEventRate(int eNum) throws NotUnichainException {
        State i;
        Event e = this.theEvents[eNum];
        this.debug(1, "Computing Events Rate for Event " + e);
        double sumRate = 0.0;
        double[] pi0 = this.getVectorPi0();
        State[] bdryStates = this.getBoundaryStates();
        int N0 = pi0.length;
        int s = 0;
        while (s < N0) {
            i = bdryStates[s];
            if (this.active(i, 0, e)) {
                GeomRelState[] geomRelStateArray = this.dests(i, 0, e);
                int n = geomRelStateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    GeomRelState j = geomRelStateArray[n2];
                    sumRate += pi0[s] * this.rate(i, 0, j.subState, j.rLevel, e);
                    ++n2;
                }
            }
            ++s;
        }
        double[] pi1m = this.getVectorPi1Mod();
        State[] typStates = this.getTypicalStates();
        int N1 = pi1m.length;
        int s2 = 0;
        while (s2 < N1) {
            i = typStates[s2];
            if (this.active(i, 1, e)) {
                GeomRelState[] geomRelStateArray = this.dests(i, 1, e);
                int n = geomRelStateArray.length;
                int n3 = 0;
                while (n3 < n) {
                    GeomRelState j = geomRelStateArray[n3];
                    sumRate += pi1m[s2] * this.rate(i, 1, j.subState, 1 + j.rLevel, e);
                    ++n3;
                }
            }
            ++s2;
        }
        return sumRate;
    }

    @Override
    public Class getStateClass() {
        return ((GeomState)this.getInitialState()).getSubState().getClass();
    }

    protected final GeometricSolver getDefaultGeometrixSolver() {
        if (this.defaultGeometrixSolver == null) {
            this.defaultGeometrixSolver = new MtjLogRedSolver(this);
        }
        return this.defaultGeometrixSolver;
    }

    public GeometricSolver getGeometrixSolver() {
        if (this.GeometrixSolver == null) {
            this.GeometrixSolver = this.getDefaultGeometrixSolver();
        }
        return this.GeometrixSolver;
    }

    public void setGeometrixSolver(GeometricSolver geometrixSolver) {
        this.GeometrixSolver = geometrixSolver;
        this.resetResults();
        this.debug(1, "New geometrix solver set: " + geometrixSolver);
    }
}

