/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import java.io.PrintWriter;
import java.io.Writer;

public class DebugReporter {
    private int curLevel = 1;
    private PrintWriter dbgWt = null;

    public DebugReporter(int initDebugLevel) {
        this.curLevel = initDebugLevel;
    }

    public DebugReporter(PrintWriter dbgWt) {
        this.dbgWt = new PrintWriter((Writer)dbgWt, true);
    }

    public final void setCurLevel(int curLevel) {
        this.curLevel = curLevel;
    }

    public final int getCurLevel() {
        return this.curLevel;
    }

    public void debug(int level, String s) {
        this.debug(level, s, true, true);
    }

    public void debug(int level, String s, boolean newline) {
        this.debug(level, s, newline, newline);
    }

    public void debug(int level, String s, boolean newline, boolean indent) {
        if (level <= this.curLevel) {
            String string = s = indent ? String.valueOf(this.blank(2 * level)) + s : s;
            if (this.dbgWt == null) {
                this.dbgWt = new PrintWriter(System.out, true);
            }
            if (newline) {
                this.dbgWt.println(s);
            } else {
                this.dbgWt.print(s);
            }
            Thread.yield();
        }
    }

    public synchronized int getDebugLevel() {
        return this.curLevel;
    }

    public synchronized void setDebugLevel(int level) {
        this.curLevel = level;
    }

    private String blank(int b) {
        String stg = "";
        int i = 0;
        while (i < b) {
            stg = String.valueOf(stg) + ' ';
            ++i;
        }
        return stg;
    }
}

