/*
 * Decompiled with CFR 0.152.
 */
package jmarkov;

import examples.jmarkov.BucketBrigades;
import examples.jmarkov.BucketBuffers;
import jmarkov.Utils;
import jmarkov.basic.exceptions.NotUnichainException;
import junit.framework.TestCase;
import junit.textui.TestRunner;

public class BucketBrigadesTest
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(BucketBrigadesTest.class);
    }

    public void testIdenticallExpo() throws NotUnichainException {
        double mu = 1.0;
        BucketBrigades bb = null;
        int M = 1;
        while (M <= 5) {
            int N = 1;
            while (N <= 5) {
                double[][] vels = new double[N][M];
                int n = 0;
                while (n < N) {
                    int m = 0;
                    while (m < M) {
                        vels[n][m] = 1.0;
                        ++m;
                    }
                    ++n;
                }
                double expTh = (double)N * mu / (double)(M + N - 1);
                bb = new BucketBrigades(N, M, vels);
                bb.setDebugLevel(0);
                bb.setMaxStates(2000L);
                double val = bb.getEventRate(M - 1);
                bb.debug(1, "M=" + M + ", N= " + N + ", States = " + bb.getNumStates());
                BucketBrigadesTest.assertEquals((String)"Error in Thruput ", (double)expTh, (double)val, (double)1.0E-10);
                N += 2;
            }
            M += 2;
        }
    }

    public void testIdenticalWorkers() throws NotUnichainException {
        BucketBrigades bb = null;
        Utils.resetMVA();
        int M = 1;
        while (M <= 7) {
            int N = 1;
            while (N <= 5) {
                double[] mu = new double[M];
                double[][] vels = new double[N][M];
                int n = 0;
                while (n < N) {
                    int m = 0;
                    while (m < M) {
                        mu[m] = m + 1;
                        vels[n][m] = 1.0 * mu[m];
                        ++m;
                    }
                    ++n;
                }
                double expTh = Utils.getMVAthruput(N, M, mu)[M - 1];
                bb = new BucketBrigades(N, M, vels);
                bb.setDebugLevel(0);
                bb.setMaxStates(2000L);
                double val = bb.getEventRate(M - 1);
                bb.debug(1, "M=" + M + ", N= " + N + ", States = " + bb.getNumStates());
                BucketBrigadesTest.assertEquals((String)"Error in Thruput ", (double)expTh, (double)val, (double)1.0E-5);
                N += 2;
            }
            M += 2;
        }
    }

    public void testIdenticallExpoBuff() throws NotUnichainException {
        double mu = 1.0;
        BucketBuffers bbb = null;
        int M = 1;
        while (M <= 7) {
            int N = 1;
            while (N <= 5) {
                double[][] vels = new double[N][M];
                int n = 0;
                while (n < N) {
                    int m = 0;
                    while (m < M) {
                        vels[n][m] = 1.0;
                        ++m;
                    }
                    ++n;
                }
                double expTh = (double)N * mu / (double)(M + N - 1);
                bbb = new BucketBuffers(vels, new int[M]);
                bbb.setDebugLevel(0);
                bbb.setMaxStates(2000L);
                double val = bbb.getEventRate(M - 1);
                bbb.debug(1, "M=" + M + ", N= " + N + ", States = " + bbb.getNumStates());
                BucketBrigadesTest.assertEquals((String)"Error in Thruput ", (double)expTh, (double)val, (double)1.0E-10);
                N += 2;
            }
            M += 2;
        }
    }

    public void testIdenticalWorkersBuff() throws NotUnichainException {
        BucketBuffers bbb = null;
        Utils.resetMVA();
        int M = 1;
        while (M <= 7) {
            int N = 1;
            while (N <= 5) {
                double[] mu = new double[M];
                double[][] vels = new double[N][M];
                int n = 0;
                while (n < N) {
                    int m = 0;
                    while (m < M) {
                        mu[m] = m + 1;
                        vels[n][m] = 1.0 * mu[m];
                        ++m;
                    }
                    ++n;
                }
                double expTh = Utils.getMVAthruput(N, M, mu)[M - 1];
                bbb = new BucketBuffers(vels, new int[M]);
                bbb.setDebugLevel(0);
                bbb.setMaxStates(2000L);
                double val = bbb.getEventRate(M - 1);
                bbb.debug(1, "M=" + M + ", N= " + N + ", States = " + bbb.getNumStates());
                BucketBrigadesTest.assertEquals((String)"Error in Thruput ", (double)expTh, (double)val, (double)1.0E-5);
                N += 2;
            }
            M += 2;
        }
    }
}

