/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.jmdp.FiniteMDP;

public class StochasticDemand
extends FiniteMDP<InvLevel, Order> {
    int lastStage;
    int maxInventory;
    int maxBackorders;
    int truckSize;
    double K;
    double b;
    double h;
    double theta;
    double price;
    double cost;
    double[] demandProbability;
    double[] demandCumulativeProbability;

    public StochasticDemand(States<InvLevel> initSet, int lastStage, int maxInventory, int maxBackorders, int truckSize, double K, double b, double price, double cost, double h, double theta) {
        super(initSet, lastStage);
        this.maxInventory = maxInventory;
        this.maxBackorders = maxBackorders;
        this.truckSize = truckSize;
        this.K = K;
        this.b = b;
        this.price = price;
        this.cost = cost;
        this.h = h;
        this.theta = theta;
        this.initializeProbabilities();
    }

    double holdingCost(int x) {
        double temp = x > 0 ? this.h * this.cost * (double)x : 0.0;
        return temp;
    }

    double orderCost(int x) {
        double temp = x > 0 ? Math.ceil(new Integer(x).doubleValue() / (double)this.truckSize) * this.K : 0.0;
        return temp;
    }

    double backorderCost(double x) {
        return x < 0.0 ? -this.b * x : 0.0;
    }

    double lostOrderCost(int x) {
        int mB = this.maxBackorders;
        double expectedBackorders = 0.0;
        int n = Math.max(x + 1, 0);
        while (n <= x + mB) {
            expectedBackorders += (double)(n - x) * this.demandProbability[n];
            ++n;
        }
        double expectedLostDemand = this.demandCumulativeProbability[x + mB] * (this.theta - (double)x - (double)mB) + (double)(x + mB) * this.demandProbability[x + mB];
        return (this.price - this.cost) * expectedLostDemand + this.backorderCost(-expectedBackorders);
    }

    @Override
    public double finalCost(InvLevel i) {
        return 0.0;
    }

    @Override
    public double prob(InvLevel i, InvLevel j, Order a, int t) {
        int iLevel = i.getLevel();
        int jLevel = j.getLevel();
        int orderSize = a.getSize();
        if (-this.maxBackorders < jLevel && jLevel <= orderSize + iLevel && orderSize + iLevel <= this.maxInventory) {
            return this.demandProbability[orderSize + iLevel - jLevel];
        }
        if (orderSize + iLevel <= this.maxInventory && jLevel == -this.maxBackorders) {
            return this.demandCumulativeProbability[Math.max(orderSize + iLevel, 0)];
        }
        return 0.0;
    }

    @Override
    public double immediateCost(InvLevel i, Order a, int t) {
        int iLevel = i.getLevel();
        int orderSize = a.getSize();
        double toReturn = this.orderCost(orderSize) + this.holdingCost(iLevel) + this.lostOrderCost(iLevel + orderSize);
        return toReturn;
    }

    void initStates() {
        InvLevel[] ssts = new InvLevel[this.maxInventory + this.maxBackorders + 1];
        int n = 0;
        while (n <= this.maxInventory) {
            ssts[n] = new InvLevel(n);
            ++n;
        }
        n = this.maxInventory + 1;
        while (n <= this.maxInventory + this.maxBackorders) {
            ssts[n] = new InvLevel(n - this.maxInventory - this.maxBackorders - 1);
            ++n;
        }
    }

    void initializeProbabilities() {
        this.demandProbability = new double[this.maxInventory + this.maxBackorders + 1];
        this.demandCumulativeProbability = new double[this.maxInventory + this.maxBackorders + 1];
        this.demandProbability[0] = Math.exp(-this.theta);
        this.demandCumulativeProbability[0] = 1.0;
        double q = 1.0;
        int i = 1;
        while (i <= this.maxInventory + this.maxBackorders) {
            q = this.demandCumulativeProbability[i - 1];
            this.demandCumulativeProbability[i] = q - this.demandProbability[i - 1];
            this.demandProbability[i] = this.demandProbability[i - 1] * this.theta / (double)i;
            ++i;
        }
    }

    @Override
    public Actions<Order> feasibleActions(InvLevel i, int t) {
        int max = this.maxInventory - i.getLevel();
        Order[] vec = new Order[max + 1];
        int n = 0;
        while (n <= max) {
            vec[n] = new Order(n);
            ++n;
        }
        return new ActionsSet<Order[]>(vec);
    }

    @Override
    public States<InvLevel> reachable(InvLevel i, Order a, int t) {
        StatesSet<InvLevel> statesSet = new StatesSet<InvLevel>();
        int n = -this.maxBackorders;
        while (n <= i.getLevel() + a.getSize()) {
            statesSet.add(new InvLevel(n));
            ++n;
        }
        return statesSet;
    }

    public static void main(String[] a) throws Exception {
        int lastStage = 12;
        int maxInventory = 15;
        int maxBackorders = 5;
        int truckSize = 6;
        int K = 500;
        double b = 1000.0;
        double h = 0.0050582;
        double theta = 4.0;
        double price = 22000.0;
        double cost = 20000.0;
        InvLevel initial = new InvLevel(0);
        StatesSet<InvLevel> initSet = new StatesSet<InvLevel>(initial);
        StochasticDemand pro = new StochasticDemand(initSet, lastStage, maxInventory, maxBackorders, truckSize, K, b, price, cost, h, theta);
        pro.solve();
        pro.getSolver().setPrintValueFunction(true);
        pro.printSolution();
    }
}

