/*
 * Decompiled with CFR 0.152.
 */
package examples.jmdp;

import Jama.Matrix;
import examples.jmdp.InvLevel;
import examples.jmdp.Order;
import jmarkov.basic.Actions;
import jmarkov.basic.ActionsSet;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.SolverException;
import jmarkov.jmdp.DTMDP;
import jmarkov.jmdp.solvers.RelativeValueIterationSolver;
import jmarkov.jmdp.solvers.ValueIterationSolver;

public class InfStochasticDemand
extends DTMDP<InvLevel, Order> {
    private int maxInv;
    private int maxBO;
    private int truckSize;
    private double truckCost;
    private double backorderCost;
    private double holdingCost;
    private double intRate;
    private double expDemand;
    private double price;
    private double cost;
    private double[] demPMF;
    private double[] demCDF;
    private double[] demandLoss1;
    private boolean isdisc = false;

    public InfStochasticDemand(int maxInv, int maxBO, int truckSize, double truckCost, double backorderCost, double price, double cost, double holdingCost, double intRate, double expDemand, boolean discounted) {
        super(new StatesSet<InvLevel>(new InvLevel(0)));
        this.maxInv = maxInv;
        this.maxBO = maxBO;
        this.truckSize = truckSize;
        this.truckCost = truckCost;
        this.backorderCost = backorderCost;
        this.price = price;
        this.cost = cost;
        this.holdingCost = holdingCost;
        this.expDemand = expDemand;
        this.initializeProbabilities();
        this.isdisc = discounted;
        this.intRate = intRate;
        if (discounted) {
            this.setSolver(new ValueIterationSolver<InvLevel, Order>(this, intRate));
        } else {
            this.setSolver(new RelativeValueIterationSolver<InvLevel, Order>(this));
        }
    }

    private void initializeProbabilities() {
        double p;
        this.demPMF = new double[this.maxInv + this.maxBO + 1];
        this.demCDF = new double[this.maxInv + this.maxBO + 1];
        this.demandLoss1 = new double[this.maxInv + this.maxBO + 1];
        this.demCDF[0] = this.demPMF[0] = (p = Math.exp(-this.expDemand));
        double cdf = this.demPMF[0];
        this.demandLoss1[0] = this.expDemand;
        int maxlevel = this.maxInv + this.maxBO;
        int i = 1;
        while (i <= maxlevel) {
            this.demPMF[i] = p *= this.expDemand / (double)i;
            this.demCDF[i] = cdf += p;
            this.demandLoss1[i] = (this.expDemand - (double)i) * (1.0 - cdf) + this.expDemand * p;
            ++i;
        }
    }

    @Override
    public States<InvLevel> reachable(InvLevel i, Order a) {
        StatesSet<InvLevel> statesSet = new StatesSet<InvLevel>();
        int maxLevel = i.getLevel() + a.getSize();
        int n = -this.maxBO;
        while (n <= maxLevel) {
            statesSet.add(new InvLevel(n));
            ++n;
        }
        return statesSet;
    }

    @Override
    public double prob(InvLevel i, InvLevel j, Order a) {
        int iLevel = i.getLevel();
        int jLevel = j.getLevel();
        int orderSize = a.getSize();
        int demand = orderSize + iLevel - jLevel;
        assert (demand >= 0);
        try {
            if (jLevel == -this.maxBO) {
                return 1.0 - (demand > 0 ? this.demCDF[demand - 1] : 0.0);
            }
            return this.demPMF[demand];
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("'prob' called on non-reachable state!!. i=" + iLevel + ", j=" + jLevel + ", a =" + orderSize, e);
        }
    }

    @Override
    public Actions<Order> feasibleActions(InvLevel i) {
        int max = this.maxInv - i.getLevel();
        Order[] vec = new Order[max + 1];
        int n = 0;
        while (n <= max) {
            vec[n] = new Order(n);
            ++n;
        }
        return new ActionsSet<Order[]>(vec);
    }

    double holdingCost(int x) {
        double totHoldCost = this.holdingCost + (this.isdisc ? this.intRate * this.cost : 0.0);
        return x > 0 ? totHoldCost * (double)x : 0.0;
    }

    double orderCost(int x) {
        return this.truckCost * Math.ceil((double)x / (double)this.truckSize) + (double)x * this.cost;
    }

    double backorderCost(double x) {
        return x < 0.0 ? -this.backorderCost * x : 0.0;
    }

    @Override
    public double immediateCost(InvLevel i, Order a) {
        int maxSale = i.getLevel() + a.getSize() + this.maxBO;
        double expectedSales = this.expDemand - this.demandLoss1[maxSale];
        double netProfit = this.price * expectedSales - this.orderCost(a.getSize()) - this.holdingCost(i.getLevel()) - this.backorderCost(i.getLevel());
        return -netProfit;
    }

    public void printMatrices() {
        double[][] cost = new double[this.maxBO + this.maxInv + 1][this.maxBO + this.maxInv + 1];
        double[][][] prb = new double[this.maxBO + this.maxInv + 1][this.maxBO + this.maxInv + 1][this.maxBO + this.maxInv + 1];
        for (InvLevel s : this.getAllStates()) {
            int i = s.getLevel();
            for (Order o : this.feasibleActions(s)) {
                int a = o.getSize();
                cost[i + this.maxBO][a] = this.immediateCost(new InvLevel(i), new Order(a));
                for (InvLevel y : this.reachable(s, o)) {
                    int j = y.getLevel();
                    prb[a][i + this.maxBO][j + this.maxBO] = this.prob(new InvLevel(i), new InvLevel(j), new Order(a));
                }
            }
        }
        new Matrix(cost).print(8, 2);
        int a = 0;
        while (a < this.maxInv) {
            new Matrix(prb[a]).print(10, 6);
            ++a;
        }
        new Matrix((double[][])new double[][]{this.demPMF}).print(10, 6);
        new Matrix((double[][])new double[][]{this.demCDF}).print(10, 6);
        new Matrix((double[][])new double[][]{this.demandLoss1}).print(10, 6);
    }

    public static void main(String[] a) throws SolverException {
        int maxInventory = 25;
        int maxBackorders = 0;
        int truckSize = 4;
        int truckCost = 1000;
        double b = 0.0;
        double holdCost = 50.0;
        double intRate = Math.pow(1.3, 0.0);
        double theta = 20.0;
        double price = 1100.0;
        double cost = 500.0;
        InfStochasticDemand prob = new InfStochasticDemand(maxInventory, maxBackorders, truckSize, truckCost, b, price, cost, holdCost, intRate, theta, false);
        RelativeValueIterationSolver<InvLevel, Order> solv = new RelativeValueIterationSolver<InvLevel, Order>(prob);
        prob.setSolver(solv);
        prob.getSolver().setPrintValueFunction(true);
        prob.solve();
        prob.printSolution();
    }
}

