/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.State;

class DriveThruState
extends State {
    private int numQ;
    private int avlServ;
    private CustStatus[] prop = null;

    DriveThruState(int micPos, int serv) {
        this(new CustStatus[micPos], CustStatus.EMPTY, 0, serv);
        int i = 0;
        while (i < this.prop.length) {
            this.prop[i] = CustStatus.EMPTY;
            ++i;
        }
    }

    DriveThruState(CustStatus[] statusVec, CustStatus micStatus, int numQ, int avServs) {
        this.prop = new CustStatus[statusVec.length + 1];
        int micPos = statusVec.length;
        System.arraycopy(statusVec, 0, this.prop, 0, micPos);
        this.prop[micPos] = micStatus;
        this.numQ = numQ;
        this.avlServ = avServs;
    }

    public void computeMOPs(MarkovProcess mp) {
        int servEtapa1 = 0;
        int servEtapa2 = 0;
        int blockedDone = 0;
        int blockedBefore = 0;
        int total = 0;
        CustStatus[] custStatusArray = this.prop;
        int n = this.prop.length;
        int n2 = 0;
        while (n2 < n) {
            CustStatus s = custStatusArray[n2];
            servEtapa1 += s == CustStatus.ORDERING ? 1 : 0;
            servEtapa2 += s == CustStatus.COOKING ? 1 : 0;
            blockedDone += s == CustStatus.BLOCKED_DONE ? 1 : 0;
            blockedBefore += s == CustStatus.WAIT_MIC ? 1 : 0;
            total += s != CustStatus.EMPTY ? 1 : 0;
            ++n2;
        }
        this.setMOP(mp, "Tamano Cola", this.getQLength());
        this.setMOP(mp, "Serv Ocupados Microfono ", servEtapa1);
        this.setMOP(mp, "Serv Ocupados Cocinando", servEtapa2);
        this.setMOP(mp, "Serv Ocupados ", servEtapa1 + servEtapa2);
        this.setMOP(mp, "Clientes Bloqueados antes de ordenar", blockedBefore);
        this.setMOP(mp, "Clientes Bloqueados con orden lista", blockedDone);
        this.setMOP(mp, "Clientes Bloqueados", blockedBefore + blockedDone);
        this.setMOP(mp, "Total clientes en Espera", blockedBefore + blockedDone + this.getQLength());
        this.setMOP(mp, "Total Clientes ", total + this.getQLength());
    }

    public int getQLength() {
        return this.numQ;
    }

    public CustStatus getStatus(int i) {
        return this.prop[i];
    }

    public CustStatus[] getStatus() {
        int micPos = this.getMicPos();
        CustStatus[] status = new CustStatus[micPos];
        System.arraycopy(this.prop, 0, status, 0, micPos);
        return status;
    }

    public CustStatus getMicStatus() {
        int n = this.prop.length - 1;
        return this.prop[n];
    }

    public int getMicPos() {
        return this.prop.length - 1;
    }

    public CustStatus getVentana() {
        return this.prop[0];
    }

    public int getAvlServs() {
        return this.avlServ;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public String label() {
        String stg = "";
        CustStatus[] custStatusArray = this.prop;
        int n = this.prop.length;
        int n2 = 0;
        while (n2 < n) {
            CustStatus s = custStatusArray[n2];
            switch (s) {
                case EMPTY: {
                    stg = String.valueOf(stg) + "0";
                    break;
                }
                case ORDERING: {
                    stg = String.valueOf(stg) + "m";
                    break;
                }
                case WAIT_MIC: {
                    stg = String.valueOf(stg) + "w";
                    break;
                }
                case COOKING: {
                    stg = String.valueOf(stg) + "c";
                    break;
                }
                case BLOCKED_DONE: {
                    stg = String.valueOf(stg) + "b";
                }
            }
            ++n2;
        }
        return String.valueOf(stg) + "Q" + this.numQ;
    }

    String statusDesc(CustStatus stat) {
        switch (stat) {
            case EMPTY: {
                return "empty";
            }
            case ORDERING: {
                return "ordering,";
            }
            case WAIT_MIC: {
                return "waiting";
            }
            case COOKING: {
                return "cooking";
            }
        }
        return "blocked";
    }

    @Override
    public String description() {
        String stg = "";
        int N = this.getMicPos();
        stg = "Queue CustStatus: (";
        int i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + this.statusDesc(this.getStatus(i));
            stg = String.valueOf(stg) + (i < N - 1 ? ", " : "");
            ++i;
        }
        stg = String.valueOf(stg) + "). Mic status: " + this.statusDesc(this.getMicStatus());
        stg = String.valueOf(stg) + ". Queue Size: " + this.getQLength();
        return stg;
    }

    @Override
    public int compareTo(State j) {
        if (!(j instanceof DriveThruState)) {
            throw new IllegalArgumentException("Comparing wrong types!");
        }
        DriveThruState u = (DriveThruState)j;
        int micPos = this.getMicPos();
        int k = 0;
        while (k <= micPos) {
            if (this.getStatus(k).ordinal() > u.getStatus(k).ordinal()) {
                return 1;
            }
            if (this.getStatus(k).ordinal() < u.getStatus(k).ordinal()) {
                return -1;
            }
            ++k;
        }
        if (this.getQLength() > u.getQLength()) {
            return 1;
        }
        if (this.getQLength() < u.getQLength()) {
            return -1;
        }
        if (this.getAvlServs() > u.getAvlServs()) {
            return 1;
        }
        if (this.getAvlServs() < u.getAvlServs()) {
            return -1;
        }
        return 0;
    }

    public static enum CustStatus {
        EMPTY,
        ORDERING,
        WAIT_MIC,
        COOKING,
        BLOCKED_DONE;

    }
}

