/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.DriveThruEvent;
import examples.jmarkov.DriveThruState;
import java.io.PrintWriter;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;

public class DriveThru
extends SimpleMarkovProcess<DriveThruState, DriveThruEvent> {
    double lambda;
    double mu1;
    double mu2;
    int M;
    int S;
    int N;

    public DriveThru(double lambda, double mu1, double mu2, int M, int S, int N) {
        super(new DriveThruState(N, S), DriveThruEvent.getAllEvents(N));
        this.lambda = lambda;
        this.mu1 = mu1;
        this.mu2 = mu2;
        this.M = M;
        this.S = S;
        this.N = N;
    }

    public DriveThru() {
        this(80.0, 12.0, 30.0, 4, 2, 1);
    }

    @Override
    public boolean active(DriveThruState s, DriveThruEvent ev) {
        boolean result = false;
        switch (ev.getType()) {
            case ARRIVAL: {
                result = s.getQLength() < this.M - this.N - 1;
                break;
            }
            case MIC_COMPLETION: {
                result = s.getMicStatus() == DriveThruState.CustStatus.ORDERING;
                break;
            }
            default: {
                result = ev.getPos() == this.N ? s.getMicStatus() == DriveThruState.CustStatus.COOKING : s.getStatus(ev.getPos()) == DriveThruState.CustStatus.COOKING;
            }
        }
        return result;
    }

    @Override
    public double rate(DriveThruState i, DriveThruState j, DriveThruEvent e) {
        switch (e.getType()) {
            case ARRIVAL: {
                return this.lambda;
            }
            case MIC_COMPLETION: {
                return this.mu1;
            }
        }
        return this.mu2;
    }

    @Override
    public States<DriveThruState> dests(DriveThruState i, DriveThruEvent e) {
        int numServ = i.getAvlServs();
        DriveThruState.CustStatus[] status = i.getStatus();
        DriveThruState.CustStatus newMic = i.getMicStatus();
        int newQsize = i.getQLength();
        int numGone = 0;
        boolean micMoves = false;
        switch (e.getType()) {
            case ARRIVAL: {
                if (i.getMicStatus() == DriveThruState.CustStatus.EMPTY && numServ > 0) {
                    newMic = DriveThruState.CustStatus.ORDERING;
                    --numServ;
                    break;
                }
                if (i.getMicStatus() == DriveThruState.CustStatus.EMPTY && numServ == 0) {
                    newMic = DriveThruState.CustStatus.WAIT_MIC;
                    break;
                }
                if (i.getQLength() >= this.M - this.N - 1) break;
                newQsize = i.getQLength() + 1;
                break;
            }
            case MIC_COMPLETION: {
                newMic = DriveThruState.CustStatus.COOKING;
                int k = 0;
                while (k < this.N && status[k] != DriveThruState.CustStatus.EMPTY) {
                    ++k;
                }
                if (k == this.N) break;
                status[k] = DriveThruState.CustStatus.COOKING;
                newMic = DriveThruState.CustStatus.EMPTY;
                micMoves = true;
                break;
            }
            default: {
                ++numServ;
                int p = e.getPos();
                if (p > 0 && p < this.N) {
                    status[p] = DriveThruState.CustStatus.BLOCKED_DONE;
                    break;
                }
                if (p == this.N) {
                    newMic = DriveThruState.CustStatus.BLOCKED_DONE;
                    break;
                }
                status[0] = DriveThruState.CustStatus.EMPTY;
                int k = 1;
                while (k < this.N && status[k] == DriveThruState.CustStatus.BLOCKED_DONE) {
                    ++k;
                }
                numGone = k;
                if (k != this.N) {
                    int pos1 = k;
                    int pos2 = this.N - 1;
                    k = pos1;
                    while (k <= pos2) {
                        status[k - numGone] = status[k];
                        ++k;
                    }
                }
                k = this.N - numGone;
                while (k < this.N) {
                    status[k] = DriveThruState.CustStatus.EMPTY;
                    ++k;
                }
                if (newMic == DriveThruState.CustStatus.COOKING) {
                    status[this.N - numGone] = newMic;
                    newMic = DriveThruState.CustStatus.EMPTY;
                    micMoves = true;
                    break;
                }
                if (newMic != DriveThruState.CustStatus.BLOCKED_DONE) break;
                newMic = DriveThruState.CustStatus.EMPTY;
                micMoves = true;
            }
        }
        if (newMic == DriveThruState.CustStatus.WAIT_MIC && numServ > 0) {
            newMic = DriveThruState.CustStatus.ORDERING;
            --numServ;
        }
        if (micMoves) {
            if (i.getQLength() > 0 && numServ > 0) {
                newMic = DriveThruState.CustStatus.ORDERING;
                --numServ;
                newQsize = i.getQLength() - 1;
            } else if (i.getQLength() > 0 && numServ == 0) {
                newMic = DriveThruState.CustStatus.WAIT_MIC;
                newQsize = i.getQLength() - 1;
            }
        }
        StatesSet<DriveThruState> set = new StatesSet<DriveThruState>();
        set.add(new DriveThruState(status, newMic, newQsize, numServ));
        return set;
    }

    @Override
    public String description() {
        return "SISTEMA DRIVE THRU. \nTasa de Entrada   = " + this.lambda + "\nTasa en el Mic    = " + this.mu1 + "\nTasa de sevicio 2 = " + this.mu2 + "\nPosici\u00ef\u00bf\u00bdn del mic  = " + this.N + "\nServidores        = " + this.S + "\nCap en el sistema = " + this.M;
    }

    @Override
    public int printMOPs(PrintWriter out, int width, int decimals) {
        int namesWidth = super.printMOPs(out, width, decimals);
        try {
            double ldaEff = this.getEventRate(DriveThruEvent.Type.ARRIVAL.ordinal());
            String[] names = this.getMOPNames();
            int N = names.length;
            namesWidth += 20;
            int i = 0;
            while (i < N) {
                double waitTime = 60.0 * this.getMOPsAvg(names[i]) / ldaEff;
                String name = "Waiting time for " + names[i];
                out.println(String.valueOf(this.pad(name, namesWidth, false)) + this.pad(waitTime, width, decimals) + " minutes");
                ++i;
            }
        }
        catch (NotUnichainException e) {
            out.println(e);
        }
        return namesWidth;
    }

    public static void main(String[] a) {
        DriveThru theDT = new DriveThru(80.0, 12.0, 30.0, 4, 2, 1);
        theDT.setDebugLevel(5);
        theDT.showGUI();
        theDT.printAll();
        theDT.printMOPs();
    }
}

