/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class BucketState
extends PropertiesState {
    private static int M;
    private static int N;

    public BucketState(int numWorkers, int numMachines) {
        super(2 * numWorkers + numMachines);
        M = numMachines;
        N = numWorkers;
        int i = 0;
        while (i < numWorkers) {
            this.prop[i] = 0;
            this.prop[i + numWorkers] = 0;
            ++i;
        }
        this.prop[2 * numWorkers - 1] = 1;
        i = 1;
        while (i < numMachines) {
            this.prop[2 * numWorkers + i] = 0;
            ++i;
        }
        this.prop[2 * numWorkers] = 1;
    }

    BucketState(int[] machines, int[] workerStatus, int[] machineStatus) {
        super(2 * machines.length + machineStatus.length);
        System.arraycopy(machines, 0, this.prop, 0, N);
        System.arraycopy(workerStatus, 0, this.prop, N, N);
        System.arraycopy(machineStatus, 0, this.prop, 2 * N, M);
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        int sumWk = 0;
        int i = 0;
        while (i < N) {
            int j = 0;
            while (j < M) {
                this.setMOP(mp, "Machine " + (j + 1) + " used by worker " + (i + 1), this.askMachWorker(i, j));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            sumWk += this.getWorkerStatus(i);
            this.setMOP(mp, "Status Worker " + (i + 1), this.getWorkerStatus(i));
            ++i;
        }
        i = 0;
        while (i < M) {
            this.setMOP(mp, "Status Machine" + (i + 1), this.getMachineStatus(i));
            ++i;
        }
        this.setMOP(mp, "Number of active workers in the system", sumWk);
    }

    private int askMachWorker(int worker, int machine) {
        int result = 0;
        if (this.prop[worker] == machine) {
            result = 1;
        }
        return result;
    }

    public int getMachine(int j) {
        return this.prop[j];
    }

    public int[] getMachines() {
        int[] machines = new int[N];
        System.arraycopy(this.prop, 0, machines, 0, N);
        return machines;
    }

    public int getWorkerStatus(int i) {
        return this.prop[i + N];
    }

    public int getMachineStatus(int j) {
        return this.prop[j + 2 * N];
    }

    @Override
    public String label() {
        String stg = "";
        int i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getMachine(i) + 1);
            ++i;
        }
        return stg;
    }

    @Override
    public String description() {
        String stg = "Macines: ";
        int i = 0;
        while (i < N - 1) {
            stg = String.valueOf(stg) + this.getMachine(i) + ",";
            ++i;
        }
        stg = String.valueOf(stg) + this.getMachine(N - 1) + ". Act.Wkrs. (";
        i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getWorkerStatus(i) == 1 ? String.valueOf(i) : "");
            ++i;
        }
        stg = String.valueOf(stg) + ") Wkrs hold. (";
        i = 0;
        while (i < N) {
            stg = String.valueOf(stg) + (this.getWorkerStatus(i) == 0 ? String.valueOf(i) : "");
            ++i;
        }
        stg = String.valueOf(stg) + ") Act. M. (";
        int j = 0;
        while (j < M) {
            stg = String.valueOf(stg) + (this.getMachineStatus(j) == 1 ? String.valueOf(j) : "");
            ++j;
        }
        stg = String.valueOf(stg) + "} M hold {";
        j = 0;
        while (j < M) {
            stg = String.valueOf(stg) + (this.getMachineStatus(j) == 0 ? String.valueOf(j) : "");
            ++j;
        }
        stg = String.valueOf(stg) + "}";
        return stg;
    }

    @Override
    public boolean isConsistent() {
        return true;
    }
}

