/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import jmarkov.MarkovProcess;
import jmarkov.basic.PropertiesState;

class BankState
extends PropertiesState {
    int M;
    int S;
    int K;

    BankState(int M, int S, int K) {
        this(new int[K + K + 2], 0, 0, K, M, S);
    }

    BankState(int[] status, int VIPQsize, int OTHERQsize, int K, int M, int S) {
        super(K + K + 2);
        this.M = M;
        this.S = S;
        this.K = K;
        int j = 0;
        while (j < K + K + 2) {
            this.prop[j] = status[j];
            ++j;
        }
        this.prop[K + K] = VIPQsize;
        this.prop[K + K + 1] = OTHERQsize;
    }

    @Override
    public void computeMOPs(MarkovProcess mp) {
        this.setMOP(mp, "VIPQueue Length", this.getVIPQSize());
        this.setMOP(mp, "OTHERQueue Length", this.getOTHERQSize());
    }

    public int getProp(int i) {
        return this.prop[i];
    }

    public int getVIPQSize() {
        return this.prop[this.K + this.K];
    }

    public int getOTHERQSize() {
        return this.prop[this.K + this.K + 1];
    }

    public int getVIPTrans() {
        int aux = 0;
        int i = 0;
        while (i < this.K) {
            aux += this.prop[i];
            ++i;
        }
        return aux;
    }

    public int getOTHERTrans() {
        int aux = 0;
        int i = this.K;
        while (i < 2 * this.K) {
            aux += this.prop[i];
            ++i;
        }
        return aux;
    }

    public int getVIPSingleTrans(int t) {
        return this.prop[t];
    }

    public int getOTHERSingleTrans(int t) {
        return this.prop[this.K + t];
    }

    @Override
    public boolean isConsistent() {
        return true;
    }

    @Override
    public String label() {
        String stg = "";
        stg = String.valueOf(stg) + " VIP transactions: ";
        int k = 0;
        while (k < this.K) {
            stg = String.valueOf(stg) + this.prop[k] + ",";
            ++k;
        }
        stg = String.valueOf(stg) + " OTHER Transactions: ";
        k = 0;
        while (k < this.K) {
            stg = String.valueOf(stg) + this.prop[this.K + k] + ",";
            ++k;
        }
        return String.valueOf(stg) + " VIPQ: " + this.getVIPQSize() + " OTHERQ: " + this.getOTHERQSize();
    }
}

