/*
 * Decompiled with CFR 0.152.
 */
package examples.jmarkov;

import examples.jmarkov.BBPhaseEvent;
import examples.jmarkov.BBPhaseState;
import java.util.ArrayList;
import jmarkov.SimpleMarkovProcess;
import jmarkov.basic.States;
import jmarkov.basic.StatesSet;
import jmarkov.basic.exceptions.NotUnichainException;
import jphase.ContPhaseVar;
import jphase.DenseContPhaseVar;
import no.uib.cipr.matrix.Matrix;

public class BBPhase
extends SimpleMarkovProcess<BBPhaseState, BBPhaseEvent> {
    private int N;
    private int M;
    private ContPhaseVar[][] processTimes;

    private BBPhase(int Op, int M, ContPhaseVar[][] procTimes) {
        super(new BBPhaseState(Op), BBPhaseEvent.getAllEvents(Op));
        this.N = Op;
        this.M = M;
        this.processTimes = procTimes;
    }

    public BBPhase(int N, int M, ContPhaseVar[] machineTimes, double[][] vels) {
        this(N, M, BBPhase.setPhasesMatrix(machineTimes, vels));
    }

    private static ContPhaseVar[][] setPhasesMatrix(ContPhaseVar[] machineTimes, double[][] vels) {
        int Op = vels.length;
        int M = machineTimes.length;
        ContPhaseVar[][] processTimes = new ContPhaseVar[Op][M];
        int i = 0;
        while (i < Op) {
            int j = 0;
            while (j < M) {
                processTimes[i][j] = machineTimes[j].copy();
                processTimes[i][j] = machineTimes[j].times(1.0 / vels[i][j]);
                ++j;
            }
            ++i;
        }
        return processTimes;
    }

    @Override
    public boolean active(BBPhaseState i, BBPhaseEvent e) {
        boolean result = false;
        int curWorker = e.getWorker();
        int[] curMachines = new int[this.N];
        curMachines = i.getWrkMach();
        int[] curPhases = new int[this.N];
        curPhases = i.getWkrPhase();
        if (i.getWkrStatus(curWorker) == 1) {
            switch (e.getType()) {
                case Change_Phase: {
                    int m = this.processTimes[curWorker][curMachines[curWorker] - 1].getNumPhases();
                    result = m > 1 && curPhases[curWorker] != 0;
                    break;
                }
                case Change_Machine: {
                    double[] a = this.processTimes[curWorker][curMachines[curWorker] - 1].getMat0Array();
                    result = curMachines[curWorker] != 0 && curPhases[curWorker] != 0 && a[curPhases[curWorker] - 1] > 0.0;
                }
            }
        }
        return result;
    }

    @Override
    public double rate(BBPhaseState i, BBPhaseState j, BBPhaseEvent e) {
        double rate = -1.0;
        int actWkr = e.getWorker();
        int[] curPhs = i.getWkrPhase();
        int[] newPhs = j.getWkrPhase();
        int[] curMacs = i.getWrkMach();
        int[] newMacs = j.getWrkMach();
        int curPh = curPhs[actWkr];
        int newPh = newPhs[actWkr];
        int curMac = curMacs[actWkr];
        int newMac = newMacs[actWkr];
        switch (e.getType()) {
            case Change_Phase: {
                Matrix A = this.processTimes[actWkr][curMac - 1].getMatrix();
                rate = A.get(curPh - 1, newPh - 1);
                break;
            }
            case Change_Machine: {
                double[] alfa = this.processTimes[actWkr][newMac - 1].getVectorArray();
                double[] a = this.processTimes[actWkr][curMac - 1].getMat0Array();
                if (newPh != 0) {
                    if (alfa[newPh - 1] == 0.0) {
                        rate = a[curPh - 1];
                        break;
                    }
                    rate = a[curPh - 1] * alfa[newPh - 1];
                    break;
                }
                rate = a[curPh - 1];
            }
        }
        return rate;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public States<BBPhaseState> dests(BBPhaseState i, BBPhaseEvent e) {
        destState = new StatesSet<BBPhaseState>();
        curPhs = i.getWkrPhase();
        curMachines = i.getWrkMach();
        actOpe = e.getWorker();
        curMac = curMachines[actOpe];
        switch (BBPhase.$SWITCH_TABLE$examples$jmarkov$BBPhaseEvent$Type()[e.getType().ordinal()]) {
            case 1: {
                curPh = curPhs[actOpe];
                phases = this.getNewPhases(actOpe, curMac, curPh, this.processTimes);
                for (int newPhase : phases) {
                    destState.add(i.newPhase(actOpe, curMac, newPhase));
                }
                break;
            }
            case 2: {
                if (curMac == this.M) {
                    newPhs = new int[this.N];
                    newMacs = new int[this.N];
                    newMacs = this.getResetMacs(curMachines);
                    newPhs = this.getResetPhases(curPhs, newMacs);
                    destState.add(i.reset(newPhs, newMacs));
                    break;
                }
                if (this.N <= 1) ** GOTO lbl89
                if (actOpe == this.N - 1 && curPhs[actOpe - 1] == 0) {
                    newMac1 = curMac + 1;
                    newMac2 = curMachines[actOpe - 1];
                    fases1 = this.getNewMachPhases(actOpe, newMac1, this.processTimes);
                    fases2 = this.getNewMachPhases(actOpe - 1, newMac2, this.processTimes);
                    for (Integer newPhs1 : fases1) {
                        for (Integer newPhs2 : fases2) {
                            destState.add(i.newMach(actOpe, newPhs1, newPhs2, newMac1, newMac2));
                        }
                    }
                    break;
                }
                if (actOpe == this.N - 1 && curPhs[actOpe - 1] > 0) {
                    newMac = curMac + 1;
                    fases = this.getNewMachPhases(actOpe, newMac, this.processTimes);
                    for (Integer newPhs : fases) {
                        destState.add(i.newMach(actOpe, newMac, newPhs));
                    }
                    break;
                }
                if (actOpe != 0) ** GOTO lbl58
                newMac = curMac + 1;
                if (i.getMachStatus(newMac) == 0) {
                    fases = this.getNewMachPhases(actOpe, newMac, this.processTimes);
                    for (Integer newPhs : fases) {
                        destState.add(i.newMach(actOpe, newMac, newPhs));
                    }
                } else {
                    newPhs = 0;
                    destState.add(i.newMach(actOpe, newMac, newPhs));
                    break;
lbl58:
                    // 1 sources

                    newMac = curMac + 1;
                    if (i.getMachStatus(newMac) == 0) {
                        if (curPhs[actOpe - 1] == 0) {
                            newMac2 = curMachines[actOpe - 1];
                            fases = this.getNewMachPhases(actOpe, newMac, this.processTimes);
                            fases2 = this.getNewMachPhases(actOpe - 1, newMac2, this.processTimes);
                            for (Integer newPhs1 : fases) {
                                for (Integer newPhs2 : fases2) {
                                    destState.add(i.newMach(actOpe, newPhs1, newPhs2, newMac, newMac2));
                                }
                            }
                        } else {
                            fases = this.getNewMachPhases(actOpe, newMac, this.processTimes);
                            for (Integer newPhs : fases) {
                                destState.add(i.newMach(actOpe, newMac, newPhs));
                            }
                        }
                    } else {
                        newPhs = 0;
                        if (curPhs[actOpe - 1] == 1) {
                            destState.add(i.newMach(actOpe, newMac, newPhs));
                            break;
                        }
                        newMac2 = curMachines[actOpe - 1];
                        fases2 = this.getNewMachPhases(actOpe - 1, newMac2, this.processTimes);
                        for (Integer newPhs2 : fases2) {
                            destState.add(i.newMach(actOpe, newPhs, newPhs2, newMac, newMac2));
                        }
                    }
                }
                break;
lbl89:
                // 1 sources

                newMac = curMac + 1;
                fases = this.getNewMachPhases(actOpe, newMac, this.processTimes);
                for (Integer newPhs : fases) {
                    destState.add(i.newMach(actOpe, newMac, newPhs));
                }
                break;
            }
        }
        return destState;
    }

    public ArrayList<Integer> getNewPhases(int actOpe, int curMach, int curPhase, ContPhaseVar[][] phases) {
        ArrayList<Integer> newPhases = new ArrayList<Integer>();
        int m = phases[actOpe][curMach - 1].getNumPhases();
        Matrix A = phases[actOpe][curMach - 1].getMatrix();
        int i = 1;
        while (i <= m) {
            if (A.get(curPhase - 1, i - 1) > 0.0) {
                newPhases.add(i);
            }
            ++i;
        }
        return newPhases;
    }

    public ArrayList<Integer> getNewMachPhases(int actOpe, int newMach, ContPhaseVar[][] phases) {
        ArrayList<Integer> newMachPhs = new ArrayList<Integer>();
        double[] alpha = phases[actOpe][newMach - 1].getVectorArray();
        int m = phases[actOpe][newMach - 1].getNumPhases();
        int i = 1;
        while (i <= m) {
            if (alpha[i - 1] > 0.0) {
                newMachPhs.add(i);
            }
            ++i;
        }
        return newMachPhs;
    }

    public int[] getResetPhases(int[] curPhs, int[] curMacs) {
        int[] newPhs = new int[this.N];
        if (this.N > 1) {
            ArrayList<Integer> fases;
            int i = this.N - 1;
            while (i > 0) {
                if (curPhs[i - 1] > 0) {
                    newPhs[i] = curPhs[i - 1];
                } else if (curPhs[i - 1] == 0) {
                    fases = this.getNewMachPhases(i, curMacs[i], this.processTimes);
                    for (Integer newPh : fases) {
                        newPhs[i] = newPh;
                    }
                }
                --i;
            }
            i = 0;
            while (i < this.N - 1) {
                if (curMacs[i] == curMacs[i + 1]) {
                    newPhs[i] = 0;
                } else {
                    fases = this.getNewMachPhases(i, curMacs[i], this.processTimes);
                    for (Integer newPh : fases) {
                        newPhs[i] = newPh;
                    }
                }
                ++i;
            }
        } else {
            ArrayList<Integer> fases = this.getNewMachPhases(0, curMacs[0], this.processTimes);
            for (Integer newPhases : fases) {
                newPhs[0] = newPhases;
            }
        }
        return newPhs;
    }

    public int[] getResetMacs(int[] curMacs) {
        int[] newMacs = new int[this.N];
        int i = this.N - 1;
        while (i > 0) {
            newMacs[i] = curMacs[i - 1];
            --i;
        }
        newMacs[0] = 1;
        return newMacs;
    }

    public double getResetRate() throws NotUnichainException {
        StatesSet theStates = this.getStates();
        BBPhaseEvent[] theEvents = (BBPhaseEvent[])this.getEvents();
        double resetRate = 0.0;
        double[] pi = this.getSteadyState();
        int E = theEvents.length;
        int l = 0;
        while (l < E) {
            if (theEvents[l].getWorker() == this.N - 1) {
                BBPhaseEvent e = theEvents[l];
                int s = 0;
                for (BBPhaseState i : theStates) {
                    States<BBPhaseState> dsst;
                    if (i.getWrkMach(e.getWorker()) != this.M || !this.active(i, e) || (dsst = this.dests(i, e)) == null) continue;
                    for (BBPhaseState j : dsst) {
                        switch (e.getType()) {
                            case Change_Machine: {
                                resetRate += pi[s++] * this.rate(i, j, e);
                                break;
                            }
                            case Change_Phase: {
                                resetRate += 0.0;
                            }
                        }
                    }
                }
            }
            ++l;
        }
        return resetRate;
    }

    @Override
    public String description() {
        String stg = "  ";
        stg = String.valueOf(stg) + "Bucket Brigades Production System with " + this.M + " Machines and " + this.N + " Workers\n";
        stg = String.valueOf(stg) + "\nMatrix Phases: Process rate of worker w. on machine m.\n ";
        int i = 0;
        while (i < this.N) {
            int j = 0;
            while (j < this.M) {
                stg = String.valueOf(stg) + "{ Worker (" + (i + 1) + "):Station (" + (j + 1) + ") }.\n";
                stg = String.valueOf(stg) + this.processTimes[i][j].toString();
                ++j;
            }
            ++i;
        }
        return stg;
    }

    public static void main(String[] a) {
        int Op = 2;
        int M = 2;
        DenseContPhaseVar v = DenseContPhaseVar.Erlang(1.0, 2);
        ContPhaseVar[] distMaq = new DenseContPhaseVar[]{v, v};
        double[][] vels = new double[][]{{1.0, 1.0}, {2.0, 3.0}};
        BBPhase model = new BBPhase(Op, M, distMaq, vels);
        model.generate();
        model.setDebugLevel(0);
        model.printAll();
    }
}

