// Copyright (C) GAMS Development 2006
// All Rights Reserved.
// This code is published under the Common Public License.
//
// $Id: GamsMessageHandler.hpp 56 2007-02-03 17:51:56Z stefan $
//
// Authors: Michael Bussieck, Stefan Vigerske

#ifndef GamsMessageHandler_H
#define GamsMessageHandler_H

#if defined(_MSC_VER)
// Turn off compiler warning about long names
#  pragma warning(disable:4786)
#endif

#include "CoinMessageHandler.hpp"
#include "GamsModel.hpp"

/** A COIN-OR message handler that writes into the GAMS status- and logfile.
 */
class GamsMessageHandler : public CoinMessageHandler {
public:

	/** Constructor.
	 * @param GMptr The GamsModel required for printing.
	 */  
  GamsMessageHandler(GamsModel* GMptr);

	/** Sets the number of spaces to remove at the front of a message.
	 */
  inline void setRemoveLBlanks(int rm) { rmlblanks_ = rm; }

	/** Prints the message from the message buffer.
	 * Removes at most rmlblanks_ from the beginning and all newlines at the end of the message buffer.
	 * If currentMessage().detail() is smaller then 2, the message is written to logfile and statusfile, otherwise it is written only to the logfile.
	 * If the pointer to the GamsModel is not set, the output goes to standard out. 
	 */  
  int print();

private:
  GamsModel *GMptr_;
  int rmlblanks_;
};

#endif // GamsMessageHandler_H
