// ------------------------------------------------------------ 
// Copyright (C) Bradley M. Bell 1998-2015, All rights reserved 
// ------------------------------------------------------------ 
Keyword = 
[
'CppAD  cppad-20170000.2: A Package for Differentiation of C++ Algorithms  ',' algorithmic automatic derivative version cppad.hpp syntax introduction example include file preprocessor symbols namespace ',
'Install  CppAD Download, Test, and Install Instructions  ',' step 1: 2: cmake 3: check 4: installation ',
'download  Download The CppAD Source Code  ',' purpose distribution directory compressed archives current version subversion git release versions coin github monthly daily windows file extraction testing install instructions no documentation building ',
'cmake  Using CMake to Configure CppAD  ',' makefile install prefix postfix include directories lib datadir documentation package compile flags profile maximum number threads sparsity internal structure vector sets memory usage tape implicit explicit the program command build directory check cmake_verbose_makefile generator cppad_prefix cppad_postfix cmake_install_includedirs cmake_install_libdirs cmake_install_datadir cmake_install_docdir package_prefix cppad_cxx_flags c++11 cppad_profile_flag eigen fadbad cppad_testvector cppad_max_num_threads cppad_tape_id_type cstdint cppad_tape_addr_type cppad_deprecated ',
'adolc_prefix  Including the ADOL-C Examples and Tests  ',' get purpose speed unix cygwin get_adolc ',
'get_adolc.sh  Download and Install Adolc in Build Directory  ',' syntax purpose requirements distribution external prefix reuse ',
'colpack_prefix  Including the ColPack Sparsity Calculations  ',' get purpose cppad_lib example get_colpack ',
'colpack_jac.cpp  Using ColPack: Example and Test  ',' jacobian sparse ',
'colpack_hes.cpp  Using ColPack: Example and Test  ',' hessian sparse ',
'get_colpack.sh  Download and Install ColPack in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'eigen_prefix  Including the Eigen Examples and Tests  ',' get purpose vector get_eigen ',
'get_eigen.sh  Download and Install Eigen in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'fadbad_prefix  Including the FADBAD Speed Tests  ',' get purpose get_fadbad ',
'get_fadbad.sh  Download and Install Fadbad in Build Directory  ',' syntax purpose distribution external prefix ',
'ipopt_prefix  Including the cppad_ipopt Library and Tests  ',' get purpose examples get_ipopt ',
'get_ipopt.sh  Download and Install Ipopt in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'sacado_prefix  Including the Sacado Speed Tests  ',' get purpose get_sacado ',
'get_sacado.sh  Download and Install Sacado in Build Directory  ',' syntax purpose distribution external prefix reuse ',
'cppad_testvector  Choosing the CppAD Test Vector Template Class  ',' purpose std boost eigen ',
'cmake_check  Checking the CppAD Examples and Tests  ',' purpose all windows subsets ',
'pkgconfig  CppAD pkg-config Files  ',' pc purpose usage defined fields configuration ',
'auto_tools  Auto Tools Unix Test and Installation  ',' speed profile prefix std vector boost eigen sparse internal sets implicit explicit compile flags openmp postfix adolc fadbad ipopt sacado memory usage tape deprecated 2012-12-26 distribution directory work configure make examples tests profiling cppad prefix_dir --with-documentation --with-testvector --with-deprecated max_num_threads cxx_flags openmp_flags postfix_dir adolc_dir linux cygwin boost_dir eigen_dir fadbad_dir ipopt_dir sacado_dir tape_addr_type tape_id_type ',
'Introduction  An Introduction by Example to Algorithmic Differentiation  ',' ad automatic purpose preface forward mode reverse operation count efficiency outline reference ',
'get_started.cpp  Getting Started Using CppAD to Compute Derivatives  ',' simple example purpose function value poly exercises program output running ',
'exp_2  Second Order Exponential Approximation  ',' example algorithm syntax purpose mathematical form include type implementation test exercises ',
'exp_2.hpp  exp_2: Implementation  ',' ',
'exp_2.cpp  exp_2: Test  ',' ',
'exp_2_for0  exp_2: Operation Sequence and Zero Order Forward Mode  ',' example mathematical form expansion index code sweep return value verification exercises ',
'exp_2_for1  exp_2: First Order Forward Mode  ',' expansion purpose mathematical form operation sequence index zero derivative sweep return value verification exercises ',
'exp_2_rev1  exp_2: First Order Reverse Mode  ',' purpose mathematical form f_5 index 5: f_4 4: f_3 3: f_2 f_1 verification exercises ',
'exp_2_for2  exp_2: Second Order Forward Mode  ',' expansion purpose mathematical form operation sequence index zero first derivative sweep return value verification exercises ',
'exp_2_rev2  exp_2: Second Order Reverse Mode  ',' purpose mathematical form f_5 index 5: f_4 4: f_3 3: f_2 f_1 verification exercises ',
'exp_2_for0.cpp  exp_2: Verify Zero Order Forward Sweep  ',' ',
'exp_2_for1.cpp  exp_2: Verify First Order Forward Sweep  ',' ',
'exp_2_rev1.cpp  exp_2: Verify First Order Reverse Sweep  ',' mode ',
'exp_2_for2.cpp  exp_2: Verify Second Order Forward Sweep  ',' ',
'exp_2_rev2.cpp  exp_2: Verify Second Order Reverse Sweep  ',' mode ',
'exp_2_cppad  exp_2: CppAD Forward and Reverse Sweeps  ',' purpose exercises ',
'exp_eps  An Epsilon Accurate Exponential Approximation  ',' example algorithm syntax purpose mathematical function include type implementation test exercises ',
'exp_eps.hpp  exp_eps: Implementation  ',' ',
'exp_eps.cpp  exp_eps: Test of exp_eps  ',' ',
'exp_eps_for0  exp_eps: Operation Sequence and Zero Order Forward Sweep  ',' example mathematical form variable parameter index code return value comparisons verification exercises ',
'exp_eps_for1  exp_eps: First Order Forward Sweep  ',' expansion mathematical form operation sequence index zero derivative return value verification exercises ',
'exp_eps_rev1  exp_eps: First Order Reverse Sweep  ',' mode purpose mathematical form epsilon f_7 index 7: f_6 6: f_5 5: f_4 4: f_3 3: f_2 2: f_1 verification exercises ',
'exp_eps_for2  exp_eps: Second Order Forward Mode  ',' expansion purpose mathematical form operation sequence index zero first derivative sweep return value verification exercises ',
'exp_eps_rev2  exp_eps: Second Order Reverse Sweep  ',' purpose mathematical form epsilon f_7 index 7: f_6 6: f_5 5: f_4 4: f_3 3: f_2 2: f_1 verification exercises ',
'exp_eps_for0.cpp  exp_eps: Verify Zero Order Forward Sweep  ',' ',
'exp_eps_for1.cpp  exp_eps: Verify First Order Forward Sweep  ',' exp_2 ',
'exp_eps_rev1.cpp  exp_eps: Verify First Order Reverse Sweep  ',' ',
'exp_eps_for2.cpp  exp_eps: Verify Second Order Forward Sweep  ',' first exp_2 ',
'exp_eps_rev2.cpp  exp_eps: Verify Second Order Reverse Sweep  ',' ',
'exp_eps_cppad  exp_eps: CppAD Forward and Reverse Sweeps  ',' purpose exercises ',
'exp_apx_main.cpp  Correctness Tests For Exponential Approximation in Introduction  ',' run running ',
'AD  AD Objects  ',' require purpose base type requirements ',
'ad_ctor  AD Constructors  ',' convert base vecad syntax purpose implicit explicit deprecated 2013-12-31 example ',
'ad_ctor.cpp  AD Constructors: Example and Test  ',' object ',
'ad_assign  AD Assignment Operator  ',' base vecad syntax purpose example ',
'ad_assign.cpp  AD Assignment: Example and Test  ',' object ',
'Convert  Conversion and I/O of AD Objects  ',' from ',
'Value  Convert From an AD Type to its Base Type  ',' syntax see also purpose operation sequence restriction example ',
'value.cpp  Convert From AD to its Base Type: Example and Test  ',' record ',
'Integer  Convert From AD to Integer  ',' syntax purpose real types complex operation sequence example ',
'integer.cpp  Convert From AD to Integer: Example and Test  ',' ',
'ad_to_string  Convert An AD or Base Type to String  ',' syntax see also value example ',
'ad_input  AD Output Stream Operator  ',' >> write syntax purpose is result operation sequence example ',
'ad_output  AD Output Stream Operator  ',' << syntax purpose assumption result operation sequence example ',
'ad_input.cpp  AD Output Operator: Example and Test  ',' << ',
'ad_output.cpp  AD Output Operator: Example and Test  ',' << ',
'PrintFor  Printing AD Values During Forward Mode  ',' text output debug syntax purpose f.forward(0 x) before var after redirecting discussion alternative example ',
'print_for_cout.cpp  Printing During Forward Mode: Example and Test  ',' running source code output ',
'print_for_string.cpp  Print During Zero Order Forward Mode: Example and Test  ',' ',
'Var2Par  Convert an AD Variable to a Parameter  ',' from value_ obtain during taping syntax see also purpose example ',
'var2par.cpp  Convert an AD Variable to a Parameter: Example and Test  ',' value during taping ',
'ADValued  AD Valued Operations and Functions  ',' ',
'Arithmetic  AD Arithmetic Operators and Computed Assignments  ',' ',
'UnaryPlus  AD Unary Plus Operator  ',' + syntax purpose operation sequence derivative example ',
'unary_plus.cpp  AD Unary Plus Operator: Example and Test  ',' ',
'UnaryMinus  AD Unary Minus Operator  ',' - syntax purpose base operation sequence derivative example ',
'unary_minus.cpp  AD Unary Minus Operator: Example and Test  ',' ',
'ad_binary  AD Binary Arithmetic Operators  ',' + add plus - subtract minus * multiply times / divide syntax purpose base z operation sequence example derivative addition subtraction multiplication division ',
'add.cpp  AD Binary Addition: Example and Test  ',' + plus ',
'sub.cpp  AD Binary Subtraction: Example and Test  ',' - minus ',
'mul.cpp  AD Binary Multiplication: Example and Test  ',' * multiply times ',
'div.cpp  AD Binary Division: Example and Test  ',' / divide quotient ',
'compute_assign  AD Computed Assignment Operators  ',' + add plus - subtract minus * multiply times / divide multiple syntax purpose base result operation sequence example derivative addition subtraction multiplication division ',
'AddEq.cpp  AD Computed Assignment Addition: Example and Test  ',' += plus ',
'sub_eq.cpp  AD Computed Assignment Subtraction: Example and Test  ',' -= plus add ',
'mul_eq.cpp  AD Computed Assignment Multiplication: Example and Test  ',' *= multiply plus add ',
'div_eq.cpp  AD Computed Assignment Division: Example and Test  ',' /= divide plus add ',
'unary_standard_math  The Unary Standard Math Functions  ',' syntax purpose possible types base ad<base> vecad<base> ',
'binary_math  The Binary Math Functions  ',' ',
'acos  Inverse Sine Function: acos  ',' syntax atomic derivative example ',
'asin  Inverse Sine Function: asin  ',' syntax atomic derivative example ',
'atan  Inverse Tangent Function: atan  ',' syntax atomic derivative example ',
'cos  The Cosine Function: cos  ',' syntax atomic derivative example ',
'cosh  The Hyperbolic Cosine Function: cosh  ',' syntax atomic derivative example ',
'exp  The Exponential Function: exp  ',' syntax atomic derivative example ',
'log  The Exponential Function: log  ',' syntax atomic derivative example ',
'log10  The Base 10 Logarithm Function: log10  ',' syntax method example ',
'sin  The Sine Function: sin  ',' syntax atomic derivative example ',
'sinh  The Hyperbolic Sine Function: sinh  ',' syntax atomic derivative example ',
'sqrt  The Square Root Function: sqrt  ',' syntax atomic derivative example ',
'tan  The Tangent Function: tan  ',' syntax atomic derivative example ',
'tanh  The Hyperbolic Tangent Function: tanh  ',' syntax atomic derivative example ',
'acos.cpp  The AD acos Function: Example and Test  ',' ',
'asin.cpp  The AD asin Function: Example and Test  ',' ',
'atan.cpp  The AD atan Function: Example and Test  ',' ',
'cos.cpp  The AD cos Function: Example and Test  ',' ',
'cosh.cpp  The AD cosh Function: Example and Test  ',' ',
'exp.cpp  The AD exp Function: Example and Test  ',' ',
'log.cpp  The AD log Function: Example and Test  ',' ',
'log10.cpp  The AD log10 Function: Example and Test  ',' ',
'sin.cpp  The AD sin Function: Example and Test  ',' ',
'sinh.cpp  The AD sinh Function: Example and Test  ',' ',
'sqrt.cpp  The AD sqrt Function: Example and Test  ',' ',
'tan.cpp  The AD tan Function: Example and Test  ',' ',
'tanh.cpp  The AD tanh Function: Example and Test  ',' ',
'abs  AD Absolute Value Functions: abs, fabs  ',' syntax atomic complex types derivative example ',
'abs.cpp  AD Absolute Value Function: Example and Test  ',' fabs ',
'acosh  The Inverse Hyperbolic Cosine Function: acosh  ',' syntax description cppad_use_cplusplus_2011 true false example ',
'acosh.cpp  The AD acosh Function: Example and Test  ',' ',
'asinh  The Inverse Hyperbolic Sine Function: asinh  ',' syntax description cppad_use_cplusplus_2011 true false example ',
'asinh.cpp  The AD asinh Function: Example and Test  ',' ',
'atanh  The Inverse Hyperbolic Tangent Function: atanh  ',' syntax description cppad_use_cplusplus_2011 true false example ',
'atanh.cpp  The AD atanh Function: Example and Test  ',' ',
'erf  The Error Function  ',' syntax description cppad_use_cplusplus_2011 true false example ',
'erf.cpp  The AD erf Function: Example and Test  ',' ',
'expm1  The Exponential Function Minus One: expm1  ',' syntax description cppad_use_cplusplus_2011 true false example ',
'expm1.cpp  The AD exp Function: Example and Test  ',' ',
'log1p  The Logarithm of One Plus Argument: log1p  ',' syntax description cppad_use_cplusplus_2011 true false example ',
'log1p.cpp  The AD log1p Function: Example and Test  ',' ',
'sign  The Sign: sign  ',' syntax description atomic derivative example ',
'sign.cpp  Sign Function: Example and Test  ',' ',
'atan2  AD Two Argument Inverse Tangent Function  ',' syntax purpose theta operation sequence example ',
'atan2.cpp  The AD atan2 Function: Example and Test  ',' ',
'pow  The AD Power Function  ',' exponent syntax see also purpose z operation sequence example ',
'pow.cpp  The AD Power Function: Example and Test  ',' ',
'azmul  Absolute Zero Multiplication  ',' syntax purpose base ad<base> vecad<base> example ',
'azmul.cpp  AD Absolute Zero Multiplication: Example and Test  ',' ',
'CondExp  AD Conditional Expressions  ',' assign syntax purpose rel type left right if_true if_false result optimize deprecate 2005-08-07 operation sequence example test atan2 ',
'cond_exp.cpp  Conditional Expressions: Example and Test  ',' see also description ',
'Discrete  Discrete AD Functions  ',' cppad_discrete_function syntax purpose base name ay create version operation sequence derivatives parallel mode example cppadcreatediscrete deprecated 2007-07-28 ',
'tape_index.cpp  Taping Array Index Operation: Example and Test  ',' ',
'interp_onetape.cpp  Interpolation With Out Retaping: Example and Test  ',' interpolate retape see also ',
'interp_retape.cpp  Interpolation With Retaping: Example and Test  ',' interpolate see also ',
'numeric_limits  Numeric Limits For an AD and Base Types  ',' syntax cppad::numeric_limits std::numeric_limits float epsilon min max quiet_nan example ',
'num_limits.cpp  Numeric Limits: Example and Test  ',' ',
'atomic  Atomic AD Functions  ',' operation ',
'checkpoint  Checkpointing Functions  ',' syntax see also purpose reduce memory faster recording repeating forward restriction multiple level ad method constructor base advector name ay sparsity optimize size_var option algo atom_fun clear example ',
'checkpoint.cpp  Simple Checkpointing: Example and Test  ',' purpose ',
'atomic_mul_level.cpp  Atomic Operations and Multiple-Levels of AD: Example and Test  ',' discussion ',
'checkpoint_ode.cpp  Checkpointing an ODE Solver: Example and Test  ',' see also purpose problem solution ',
'checkpoint_extended_ode.cpp  Checkpointing an Extended ODE Solver: Example and Test  ',' mul_level see also discussion problem solution ',
'atomic_base  User Defined Atomic AD Functions  ',' syntax purpose virtual examples getting started scalar vector range hessian sparsity patterns general case ',
'atomic_ctor  Atomic Function Constructor  ',' syntax atomic_user ctor_arg_list afun implementation atomic_base restrictions name sparsity example define ',
'atomic_option  Set Atomic Function Options  ',' syntax atomic_sparsity pack_sparsity_enum bool_sparsity_enum set_sparsity_enum ',
'atomic_afun  Using AD Version of Atomic Function  ',' syntax purpose advector ay examples ',
'atomic_forward  Atomic Forward Mode  ',' callback virtual syntax purpose implementation q vx vy tx ty ok discussion examples ',
'atomic_reverse  Atomic Reverse Mode  ',' syntax purpose implementation q tx ty f g h py px ok examples ',
'atomic_for_sparse_jac  Atomic Forward Jacobian Sparsity Patterns  ',' syntax deprecated 2016-06-27 purpose implementation q ok examples ',
'atomic_rev_sparse_jac  Atomic Reverse Jacobian Sparsity Patterns  ',' syntax deprecated 2016-06-27 purpose implementation q rt st ok examples ',
'atomic_for_sparse_hes  Atomic Forward Hessian Sparsity Patterns  ',' syntax deprecated 2016-06-27 purpose implementation vx examples ',
'atomic_rev_sparse_hes  Atomic Reverse Hessian Sparsity Patterns  ',' syntax deprecated 2016-06-27 purpose implementation vx q examples ',
'atomic_base_clear  Free Static Variables  ',' syntax purpose future use restriction ',
'atomic_forward.cpp  Atomic Forward: Example and Test  ',' purpose function start class definition constructor use ',
'atomic_reverse.cpp  Atomic Reverse: Example and Test  ',' purpose function start class definition constructor forward use ',
'atomic_for_sparse_jac.cpp  Atomic Forward Jacobian Sparsity: Example and Test  ',' purpose function start class definition constructor use with x_1 both variable parameter ',
'atomic_rev_sparse_jac.cpp  Atomic Reverse Jacobian Sparsity: Example and Test  ',' purpose function start class definition constructor forward use with x_1 both variable parameter ',
'atomic_for_sparse_hes.cpp  Atomic Forward Hessian Sparsity: Example and Test  ',' purpose function start class definition constructor for_sparse_jac rev_sparse_jac use with x_1 both variable parameter ',
'atomic_rev_sparse_hes.cpp  Atomic Reverse Hessian Sparsity: Example and Test  ',' purpose function start class definition constructor forward for_sparse_jac rev_sparse_jac use with x_1 both variable parameter ',
'atomic_get_started.cpp  Getting Started with Atomic Operations: Example and Test  ',' purpose class definition constructor forward end use function recording ',
'atomic_norm_sq.cpp  Atomic Euclidean Norm Squared: Example and Test  ',' bool_sparsity_enum theory start class definition constructor forward reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end use function recording ',
'atomic_reciprocal.cpp  Reciprocal as an Atomic Operation: Example and Test  ',' set_sparsity_enum theory start class definition constructor forward reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end use function recording ',
'atomic_set_sparsity.cpp  Atomic Sparsity with Set Patterns: Example and Test  ',' function set_sparsity_enum start class definition constructor forward for_sparse_jac rev_sparse_jac for_sparse_hes rev_sparse_hes end recording result ',
'atomic_tangent.cpp  Tan and Tanh as User Atomic Operations: Example and Test  ',' theory sparsity start class definition constructor forward reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end function recording large values ',
'atomic_eigen_mat_mul.cpp  Atomic Eigen Matrix Multiply: Example and Test  ',' description class definition use function constructor ',
'atomic_eigen_mat_mul.hpp  Atomic Eigen Matrix Multiply Class  ',' see also purpose dimensions theory forward product two matrices reverse start definition public types constructor op private variables for_sparse_jac rev_sparse_jac for_sparse_hes rev_sparse_hes end ',
'atomic_eigen_mat_inv.cpp  Atomic Eigen Matrix Inverse: Example and Test  ',' description class definition use function constructor ',
'atomic_eigen_mat_inv.hpp  Atomic Eigen Matrix Inversion Class  ',' purpose dimensions theory forward product three matrices reverse start definition public types constructor op private variables end ',
'atomic_eigen_cholesky.cpp  Atomic Eigen Cholesky Factorization: Example and Test  ',' description use function constructor ',
'cholesky_theory  AD Theory for Cholesky Factorization  ',' reference notation taylor coefficient lower triangular part forward mode lemma 1 proof 2 reverse case = 0 > ',
'atomic_eigen_cholesky.hpp  Atomic Eigen Cholesky Factorization Class  ',' purpose start definition public types constructor op private variables forward reverse end ',
'atomic_mat_mul.cpp  User Atomic Matrix Multiply: Example and Test  ',' see also class definition function constructor recording forward reverse option for_sparse_jac rev_sparse_jac rev_sparse_hes ',
'atomic_mat_mul.hpp  Matrix Multiply as an Atomic Operation  ',' see also dimensions start class definition constructor left operand element index right result forward reverse for_sparse_jac rev_sparse_jac rev_sparse_hes end ',
'BoolValued  Bool Valued Operations and Functions with AD Arguments  ',' ',
'Compare  AD Binary Comparison Operators  ',' < <= > >= == != syntax purpose operation sequence assumptions example ',
'compare.cpp  AD Binary Comparison Operators: Example and Test  ',' < <= > >= == != ',
'NearEqualExt  Compare AD and Base Objects for Nearly Equal  ',' with syntax purpose type operation sequence example ',
'near_equal_ext.cpp  Compare AD with Base Objects: Example and Test  ',' nearequalext ',
'BoolFun  AD Boolean Functions  ',' cppad_bool_unary cppad_bool_binary syntax purpose unary_name create binary_name v operation sequence example deprecated 2007-07-31 ',
'bool_fun.cpp  AD Boolean Functions: Example and Test  ',' ',
'ParVar  Is an AD Object a Parameter or Variable  ',' syntax purpose operation sequence example ',
'par_var.cpp  AD Parameter and Variable Functions: Example and Test  ',' ',
'EqualOpSeq  Check if Two Value are Identically Equal  ',' operation sequence syntax purpose motivation b example ',
'equal_op_seq.cpp  EqualOpSeq: Example and Test  ',' ',
'VecAD  AD Vectors that Record Index Operations  ',' tape reference vecad<base> syntax purpose alternatives vecad<base>::reference exceptions constructor size size_t indexing example speed memory ',
'vec_ad.cpp  AD Vectors that Record Index Operations: Example and Test  ',' vecad ',
'base_require  AD<Base> Requirements for a CppAD Base Type  ',' syntax purpose api warning standard types include order numeric output operator integer suggestion absolute zero azmul ',
'base_member  Required Base Class Member Functions  ',' notation default constructor double copy unary operators assignment binary bool example ',
'base_cond_exp  Base Type Requirements for Conditional Expressions  ',' condexp cppad_cond_exp_rel purpose compareop condexptemplate ordered not condexprel ',
'base_identical  Base Type Requirements for Identically Equal Comparisons  ',' equalopseq the simple case more complicated cases identicalpar prototypes functions examples ',
'base_ordered  Base Type Requirements for Ordered Comparisons  ',' purpose not ',
'base_std_math  Base Type Requirements for Standard Math Functions  ',' purpose unary cppad_standard_math_unary erf asinh acosh atanh expm1 log1p sign pow isnan ',
'base_limits  Base Type Requirements for Numeric Limits  ',' cppad::numeric_limits cppad_numeric_limits ',
'base_to_string  Extending to_string To Another Floating Point Type  ',' requirement cppad_to_string ',
'base_hash  Base Type Requirements for Hash Coding Values  ',' syntax purpose default code inline example ',
'base_example  Example AD Base Types That are not AD<OtherBase>  ',' ',
'base_alloc.hpp  Example AD<Base> Where Base Constructor Allocates Memory  ',' purpose include file computed assignment macro binary operator boolean class definition condexpop condexprel equalopseq identical output integer azmul ordered unary standard math erf asinh acosh atanh expm1 log1p pow numeric_limits to_string hash_code ',
'base_require.cpp  Using a User Defined AD Base Type: Example and Test  ',' purpose ',
'base_adolc.hpp  Enable use of AD<Base> where Base is Adolc\'s adouble Type  ',' syntax example include files condexpop condexprel equalopseq identical integer azmul ordered unary standard math erf asinh acosh atanh expm1 log1p sign abs pow numeric_limits to_string hash_code ',
'mul_level_adolc.cpp  Using Adolc with Multiple Levels of Taping: Example and Test  ',' purpose memory management configuration requirement source ',
'base_float.hpp  Enable use of AD<Base> where Base is float  ',' condexpop condexprel equalopseq identical integer azmul ordered unary standard math sign pow numeric_limits to_string ',
'base_double.hpp  Enable use of AD<Base> where Base is double  ',' condexpop condexprel equalopseq identical integer azmul ordered unary standard math sign pow numeric_limits to_string ',
'base_complex.hpp  Enable use of AD<Base> where Base is std::complex<double>  ',' example include order condexpop condexprel equalopseq identical ordered integer azmul isnan valid unary math invalid pow numeric_limits to_string ',
'complex_poly.cpp  Complex Polynomial: Example and Test  ',' ',
'ADFun  ADFun Objects  ',' purpose ',
'Independent  Declare Independent Variables and Start Recording  ',' syntax purpose stop abort_op_index vectorad parallel mode example ',
'independent.cpp  Independent and ADFun Constructor: Example and Test  ',' ',
'FunConstruct  Construct an ADFun Object and Stop Recording  ',' tape syntax purpose vectorad default constructor sequence copy assignment operator taylor coefficients sparsity patterns parallel mode example ',
'fun_assign.cpp  ADFun Assignment: Example and Test  ',' ',
'Dependent  Stop Recording and Store Operation Sequence  ',' adfun tape syntax purpose advector taping forward parallel mode example ',
'abort_recording  Abort Recording of an Operation Sequence  ',' tape syntax purpose example ',
'abort_recording.cpp  Abort Current Recording: Example and Test  ',' ',
'seq_property  ADFun Sequence Properties  ',' syntax see also purpose domain range parameter size_var size_par size_op size_op_arg size_text size_vecad size_op_seq example ',
'seq_property.cpp  ADFun Sequence Properties: Example and Test  ',' domain range parameter size_var size_par size_op_arg size_vecad ',
'FunEval  Evaluate ADFun Functions, Derivatives, and Sparsity Patterns  ',' ',
'Forward  Forward Mode  ',' ',
'forward_zero  Zero Order Forward Mode: Function Values  ',' syntax purpose x0 y0 vector example special case ',
'forward_one  First Order Forward Mode: Derivative Values  ',' syntax purpose x0 x1 vector example special case ',
'forward_two  Second Order Forward Mode: Derivative Values  ',' syntax purpose x0 x1 x2 y2 vector example special case ',
'forward_order  Multiple Order Forward Mode  ',' any syntax purpose function values derivative notation one q xq orders restrictions x(t) y(t) yq vector zero first second example ',
'forward.cpp  Forward Mode: Example and Test  ',' ',
'forward_order.cpp  Forward Mode: Example and Test of Multiple Orders  ',' ',
'forward_dir  Multiple Directions Forward Mode  ',' syntax purpose reverse notation q xq zero order non-zero lower orders x(t) y(t) yq vector example ',
'forward_dir.cpp  Forward Mode: Example and Test of Multiple Directions  ',' orders ',
'size_order  Number Taylor Coefficient Orders Currently Stored  ',' syntax see also purpose constructor forward capacity_order example ',
'compare_change  Comparison Changes Between Taping and Zero Order Forward  ',' adfun syntax purpose count speed number discussion op_index example ',
'compare_change.cpp  CompareChange and Re-Tape: Example and Test  ',' ',
'capacity_order  Controlling Taylor Coefficients Memory Allocation  ',' forward syntax see also purpose pre-allocating freeing original state example ',
'capacity_order.cpp  Controlling Taylor Coefficient Memory Allocation: Example and Test  ',' ',
'number_skip  Number of Variables that Can be Skipped  ',' syntax see also purpose example ',
'number_skip.cpp  Number of Variables That Can be Skipped: Example and Test  ',' optimize conditional expression ',
'Reverse  Reverse Mode  ',' multiple directions ',
'reverse_one  First Order Reverse Mode  ',' derivative syntax purpose w dw vector example ',
'reverse_one.cpp  First Order Reverse Mode: Example and Test  ',' ',
'reverse_two  Second Order Reverse Mode  ',' derivative syntax purpose x^(k) f dw first partials vector hessian times direction example ',
'reverse_two.cpp  Second Order Reverse ModeExample and Test  ',' ',
'hes_times_dir.cpp  Hessian Times Direction: Example and Test  ',' ',
'reverse_any  Any Order Reverse Mode  ',' derivative syntax purpose notation u^(k) x(t u) y(t w^(k) w(u) f q dw first second vector example ',
'reverse_three.cpp  Third Order Reverse Mode: Example and Test  ',' taylor coefficients ',
'reverse_checkpoint.cpp  Reverse Mode General Case (Checkpointing): Example and Test  ',' see also purpose processing steps ',
'Sparse  Calculating Sparsity Patterns  ',' ',
'ForSparseJac  Jacobian Sparsity Pattern: Forward Mode  ',' syntax purpose size_forward_bool size_forward_set q transpose dependency false true vectorset entire example ',
'for_sparse_jac.cpp  Forward Mode Jacobian Sparsity: Example and Test  ',' forsparsejac ',
'RevSparseJac  Jacobian Sparsity Pattern: Reverse Mode  ',' syntax purpose f q transpose dependency false true vectorset entire example ',
'rev_sparse_jac.cpp  Reverse Mode Jacobian Sparsity: Example and Test  ',' revsparsejac ',
'dependency.cpp  Computing Dependency: Example and Test  ',' discussion pattern ',
'RevSparseHes  Hessian Sparsity Pattern: Reverse Mode  ',' syntax purpose f q transpose false true vectorset entire example ',
'rev_sparse_hes.cpp  Reverse Mode Hessian Sparsity: Example and Test  ',' revsparsehes ',
'sparsity_sub.cpp  Sparsity Patterns For a Subset of Variables: Example and Test  ',' see also forsparsejac revsparsehes ',
'ForSparseHes  Hessian Sparsity Pattern: Forward Mode  ',' syntax purpose vectorset algorithm example ',
'for_sparse_hes.cpp  Forward Mode Hessian Sparsity: Example and Test  ',' forsparsehes ',
'bool_sparsity.cpp  Using vectorBool Sparsity To Conserve Memory: Example and Test  ',' purpose ',
'Drivers  First and Second Derivatives: Easy Drivers  ',' forward reverse ',
'Jacobian  Jacobian: Driver Routine  ',' first derivative syntax purpose vector forward reverse example ',
'jacobian.cpp  Jacobian: Example and Test  ',' ',
'ForOne  First Order Partial Derivative: Driver Routine  ',' easy syntax purpose j dy vector uses forward example ',
'for_one.cpp  First Order Partial Driver: Example and Test  ',' ',
'RevOne  First Order Derivative: Driver Routine  ',' easy syntax purpose dw vector uses forward example ',
'rev_one.cpp  First Order Derivative Driver: Example and Test  ',' ',
'Hessian  Hessian: Easy Driver  ',' second derivative syntax purpose f l w vector uses forward example ',
'hessian.cpp  Hessian: Example and Test  ',' ',
'hes_lagrangian.cpp  Hessian of Lagrangian and ADFun Default Constructor: Example and Test  ',' heslagrangian ',
'ForTwo  Forward Mode Second Partial Derivative Driver  ',' order easy syntax purpose j k ddy vectorbase vectorsize_t uses examples ',
'for_two.cpp  Subset of Second Order Partials: Example and Test  ',' ',
'RevTwo  Reverse Mode Second Partial Derivative Driver  ',' order easy syntax purpose f j ddw vectorbase vectorsize_t uses forward examples ',
'rev_two.cpp  Second Partials Reverse Driver: Example and Test  ',' ',
'sparse_jacobian  Sparse Jacobian: Easy Driver  ',' sparsejacobian syntax purpose f row col work color_method n_sweep vectorbase vectorset restrictions vectorsize uses forward example ',
'sparse_jacobian.cpp  Sparse Jacobian: Example and Test  ',' spare ',
'sparse_hessian  Sparse Hessian: Easy Driver  ',' sparsehessian syntax purpose f w work column subset row color_method n_sweep vectorbase vectorset restrictions vectorsize uses forward example ',
'sparse_hessian.cpp  Sparse Hessian: Example and Test  ',' spare ',
'sub_sparse_hes.cpp  Computing Sparse Hessian for a Subset of Variables  ',' purpose see also function example ',
'sparse_sub_hes.cpp  Sparse Hessian on Subset of Variables: Example and Test  ',' purpose see also ',
'FunCheck  Check an ADFun Sequence of Operations  ',' syntax purpose g ok vector uses forward discussion example ',
'fun_check.cpp  ADFun Check and Re-Tape: Example and Test  ',' funcheck dependent ',
'optimize  Optimize an ADFun Object Tape  ',' sequence operations speed memory ndebug syntax purpose options no_conditional_skip no_compare_op no_print_for_op examples efficiency testing atomic functions rev_sparse_jac nan checking optimization ',
'optimize_forward_active.cpp  Example Optimization and Forward Activity Analysis  ',' ',
'optimize_reverse_active.cpp  Example Optimization and Reverse Activity Analysis  ',' ',
'optimize_compare_op.cpp  Example Optimization and Comparison Operators  ',' see also ',
'optimize_print_for.cpp  Example Optimization and Print Forward Operators  ',' ',
'optimize_conditional_skip.cpp  Example Optimization and Conditional Expressions  ',' see also ',
'optimize_nest_conditional.cpp  Example Optimization and Nested Conditional Expressions  ',' see also ',
'optimize_cumulative_sum.cpp  Example Optimization and Cumulative Sum Operations  ',' ',
'check_for_nan  Check an ADFun Object For Nan Results  ',' syntax debugging default error message vector_size file_name index get_check_for_nan example ',
'check_for_nan.cpp  ADFun Checking For Nan: Example and Test  ',' ',
'preprocessor  CppAD API Preprocessor Symbols  ',' cppad_ null pointer purpose documented here cppad_null cppad_package_string cppad_use_cplusplus_2011 elsewhere deprecated ',
'multi_thread  Using CppAD in a Multi-Threading Environment  ',' mode execution maximum number purpose cppad_max_num_threads parallel_setup hold_memory initialization same prohibited ',
'parallel_ad  Enable AD Calculations During Parallel Mode  ',' syntax purpose discussion checksimplevector example restriction ',
'thread_test.cpp  Run Multi-Threading Examples and Speed Tests  ',' openmp pthread bthread syntax running purpose a11c simple_ad team_example harmonic test_time max_threads mega_sum multi_newton num_zero num_sub num_sum use_ad implementations source ',
'a11c_openmp.cpp  A Simple OpenMP Example and Test  ',' a.1.1c thread purpose source code ',
'a11c_bthread.cpp  A Simple Boost Thread Example and Test  ',' a.1.1c purpose source code ',
'a11c_pthread.cpp  A Simple Parallel Pthread Example and Test  ',' openmp a.1.1c purpose source code ',
'simple_ad_openmp.cpp  A Simple OpenMP AD: Example and Test  ',' purpose source code ',
'simple_ad_bthread.cpp  A Simple Boost Threading AD: Example and Test  ',' purpose source code ',
'simple_ad_pthread.cpp  A Simple pthread AD: Example and Test  ',' purpose source code ',
'team_example.cpp  Using a Team of AD Threads: Example and Test  ',' purpose thread_team source code ',
'harmonic.cpp  Multi-Threaded Implementation of Summation of 1/i  ',' multi_thread syntax ok num_sum num_threads source ',
'harmonic_time.cpp  Timing Test of Multi-Threaded Summation of 1/i  ',' multi_thread speed syntax purpose ok time_out test_time num_threads mega_sum source ',
'harmonic_work.cpp  Multi-threading Sum of 1/i Utility Routines  ',' setup worker combine syntax purpose harmonic_setup num_sum num_threads harmonic_worker harmonic_combine source ',
'multi_newton.cpp  A Multi-Threaded Newton\'s Method  ',' threading multi-threading syntax purpose ok xout fun num_sub xlow xup epsilon max_itr num_threads source ',
'multi_newton_time.cpp  Timing Test of Multi-Threaded Newton Method  ',' multi_thread speed syntax purpose ok time_out test_time num_threads num_zero num_sub num_sum use_ad source ',
'multi_newton_work.cpp  Multi-threading Newton Method Utility Routines  ',' setup worker combine syntax purpose multi_newton_setup fun num_sub xlow xup epsilon max_itr num_threads multi_newton_worker multi_newton_combine xout source ',
'team_thread.hpp  Specifications for A Team of AD Threads  ',' syntax purpose restrictions team_create team_work team_destroy team_name ok example use implementation speed test source ',
'team_openmp.cpp  OpenMP Implementation of a Team of AD Threads  ',' ',
'team_bthread.cpp  Boost Thread Implementation of a Team of AD Threads  ',' ',
'team_pthread.cpp  Pthread Implementation of a Team of AD Threads  ',' pthread_exit bug cygwin ',
'utility  Some General Purpose Utilities  ',' testing c++ concepts numerical routines miscellaneous error handler simple vector template class multi-threading memory allocation sorting indices to_string set_union ',
'ErrorHandler  Replacing the CppAD Error Handler  ',' replace assert exception syntax constructor parallel mode call info known line file exp msg example ',
'error_handler.cpp  Replacing The CppAD Error Handler: Example and Test  ',' ',
'cppad_assert  CppAD Assertions During Execution  ',' macro cppad_assert_known cppad_assert_unknown syntax purpose ndebug restriction exp msg error handler ',
'NearEqual  Determine if Two Values Are Nearly Equal  ',' absolute difference relative syntax purpose type include files example exercise ',
'near_equal.cpp  NearEqual Function: Example and Test  ',' file name ',
'speed_test  Run One Speed Test and Return Results  ',' syntax purpose motivation include vector size repeat size_vec time_min rate_vec timing example ',
'SpeedTest  Run One Speed Test and Print Results  ',' syntax purpose motivation include size repeat name first last rate errors example ',
'speed_test.cpp  speed_test: Example and test  ',' ',
'speed_program.cpp  Example Use of SpeedTest  ',' running this output ',
'time_test  Determine Amount of Time to Execute a Test  ',' speed syntax purpose motivation include size repeat time_min test_size timing example ',
'elapsed_seconds  Returns Elapsed Number of Seconds  ',' time syntax purpose microsoft systems example ',
'elapsed_seconds.cpp  Elapsed Seconds: Example and Test  ',' timer ',
'time_test.cpp  time_test: Example and test  ',' ',
'NumericType  Definition of a Numeric Type  ',' int requirements default constructor from integer copy assignment operators example exercise ',
'numeric_type.cpp  The NumericType: Example and Test  ',' ',
'CheckNumericType  Check NumericType Class Concept  ',' syntax purpose include parallel mode example ',
'check_numeric_type.cpp  The CheckNumericType Function: Example and Test  ',' ',
'SimpleVector  Definition of a Simple Vector  ',' value_type [] ndebug template class requirements elements specified default constructor sizing copy destructor assignment size resize access using example exercise ',
'simple_vector.cpp  Simple Vector Template Class: Example and Test  ',' ',
'CheckSimpleVector  Check Simple Vector Concept  ',' syntax purpose restrictions include parallel mode example ',
'check_simple_vector.cpp  The CheckSimpleVector Function: Example and Test  ',' ',
'nan  Obtain Nan or Determine if a Value is Nan  ',' syntax purpose include macros isnan hasnan nan(zero) deprecated 2015-10-04 scalar vector example ',
'nan.cpp  nan: Example and Test  ',' ',
'pow_int  The Integer Power Function  ',' exponent syntax see also purpose include z type operation sequence example ',
'pow_int.cpp  The Pow Integer Exponent: Example and Test  ',' ',
'Poly  Evaluate a Polynomial or its Derivative  ',' template syntax description include k z type operations vector sequence example source ',
'poly.cpp  Polynomial Evaluation: Example and Test  ',' ',
'poly.hpp  Source: Poly  ',' ',
'LuDetAndSolve  Compute Determinants and Solve Equations by LU Factorization  ',' matrix linear ',
'LuSolve  Compute Determinant and Solve Linear Equations  ',' syntax description include factor invert matrix storage signdet b logdet float floatvector leqzero absgeq example source ',
'lu_solve.cpp  LuSolve With Complex Arguments: Example and Test  ',' ',
'lu_solve.hpp  Source: LuSolve  ',' ',
'LuFactor  LU Factorization of A Square Matrix  ',' linear equation solve syntax description include storage sign jp determinant sizevector floatvector absgeq example source ',
'lu_factor.cpp  LuFactor: Example and Test  ',' ',
'lu_factor.hpp  Source: LuFactor  ',' ',
'LuInvert  Invert an LU Factored Equation  ',' linear syntax description include matrix storage jp example source ',
'lu_invert.cpp  LuInvert: Example and Test  ',' ',
'lu_invert.hpp  Source: LuInvert  ',' ',
'RombergOne  One DimensionalRomberg Integration  ',' integrate syntax description include f float example source code ',
'romberg_one.cpp  One Dimensional Romberg Integration: Example and Test  ',' ',
'RombergMul  Multi-dimensional Romberg Integration  ',' integrate syntax description include f float floatvector example source code ',
'Rombergmul.cpp  One Dimensional Romberg Integration: Example and Test  ',' ',
'Runge45  An Embedded 4th and 5th Order Runge-Kutta ODE Solver  ',' differential equation syntax purpose operation sequence include xf fun warning tf xi scalar fabs vector parallel mode example source code ',
'runge45_1.cpp  Runge45: Example and Test  ',' ',
'runge45_2.cpp  Runge45: Example and Test  ',' ',
'Rosen34  A 3rd and 4th Order Rosenbrock ODE Solver  ',' stiff differential equation syntax description include xf fun f_t f_x nan warning optimization tf xi scalar vector parallel mode example source code ',
'rosen_34.cpp  Rosen34: Example and Test  ',' ',
'OdeErrControl  An Error Controller for ODE Solvers  ',' differential equation syntax description include notation xf method step nan order tf xi smin smax scur eabs erel ef maxabs nstep criteria discussion scalar vector example theory source code ',
'ode_err_control.cpp  OdeErrControl: Example and Test  ',' nan ',
'ode_err_maxabs.cpp  OdeErrControl: Example and Test Using Maxabs Argument  ',' ',
'OdeGear  An Arbitrary Order Gear Method  ',' stiff differential equation syntax purpose include fun f_x warning scalar vector example source code theory gear\'s ',
'ode_gear.cpp  OdeGear: Example and Test  ',' ',
'OdeGearControl  An Error Controller for Gear\'s Ode Solvers  ',' differential equation syntax purpose include notation xf fun f_x warning m tf xi smin smax sini eabs erel ef maxabs nstep criteria discussion scalar vector example theory source code ',
'ode_gear_control.cpp  OdeGearControl: Example and Test  ',' ',
'CppAD_vector  The CppAD::vector Template Class  ',' [] push thread_alloc syntax description include capacity assignment check size return reference move semantics element access push_back push_vector output resize clear data vectorbool memory bit_per_unit type parallel mode example exercise ',
'cppad_vector.cpp  CppAD::vector Template Class: Example and Test  ',' ',
'vector_bool.cpp  CppAD::vectorBool Class: Example and Test  ',' ',
'thread_alloc  A Fast Multi-Threading Memory Allocator  ',' allocation syntax purpose include ',
'thread_alloc.cpp  Fast Multi-Threading Memory Allocator: Example and Test  ',' openmp allocation pthread boost ',
'ta_parallel_setup  Setup thread_alloc For Use in Multi-Threading Environment  ',' initialize syntax purpose speed num_threads in_parallel thread_num restrictions example ',
'ta_num_threads  Get Number of Threads  ',' syntax purpose example ',
'ta_in_parallel  Is The Current Execution in Parallel Mode  ',' sequential syntax purpose flag example ',
'ta_thread_num  Get the Current Thread Number  ',' syntax purpose example ',
'ta_get_memory  Get At Least A Specified Amount of Memory  ',' allocate syntax purpose min_bytes cap_bytes v_ptr allocation speed alignment example ',
'ta_return_memory  Return Memory to thread_alloc  ',' available syntax purpose v_ptr ndebug example ',
'ta_free_available  Free Memory Currently Available for Quick Use by a Thread  ',' syntax purpose extra example ',
'ta_hold_memory  Control When Thread Alloc Retains Memory For Future Use  ',' syntax purpose value free_available ',
'ta_inuse  Amount of Memory a Thread is Currently Using  ',' syntax purpose num_bytes example ',
'ta_available  Amount of Memory Available for Quick Use by a Thread  ',' syntax purpose num_bytes example ',
'ta_create_array  Allocate An Array and Call Default Constructor for its Elements  ',' syntax purpose type size_min size_out delta alignment example ',
'ta_delete_array  Deallocate An Array and Call Destructor for its Elements  ',' syntax purpose type thread delta example ',
'ta_free_all  Free All Memory That Was Allocated for Use by thread_alloc  ',' syntax purpose ok restrictions example ',
'index_sort  Returns Indices that Sort a Vector  ',' syntax keys input example ',
'index_sort.cpp  Index Sort: Example and Test  ',' ',
'to_string  Convert Certain Types to a String  ',' syntax see also purpose value integer float example ',
'to_string.cpp  to_string: Example and Test  ',' ',
'set_union  Union of Standard Sets  ',' syntax purpose element left right result example ',
'set_union.cpp  Set Union: Example and Test  ',' ',
'ipopt_solve  Use Ipopt to Solve a Nonlinear Programming Problem  ',' syntax purpose include file bvector dvector options retape sparse string numeric integer xi xl xu gl gu fg_eval advector solution status zl zu lambda obj_value example get_started ode_inverse ',
'ipopt_solve_get_started.cpp  Nonlinear Programming Using CppAD and Ipopt: Example and Test  ',' purpose configuration requirement ',
'ipopt_solve_retape.cpp  Nonlinear Programming Retaping: Example and Test  ',' purpose ',
'ipopt_solve_ode_inverse.cpp  ODE Inverse Problem Definitions: Source Code  ',' example purpose forward measurements simulation analytic solution parameter values simulated trapezoidal approximation method ',
'Example  Examples  ',' introduction running the cppad test vector template class ',
'General  General Examples  ',' realistic description ',
'ExampleUtility  Utility Routines used by CppAD Examples  ',' ',
'ListAllExamples  List of All the CppAD Examples  ',' ',
'ad_fun.cpp  Creating Your Own Interface to an ADFun Object  ',' example test ',
'ad_in_c.cpp  Example and Test Linking CppAD to Languages Other than C++  ',' algorithmic differentiation automatic ',
'conj_grad.cpp  Differentiate Conjugate Gradient Algorithm: Example and Test  ',' purpose ',
'cppad_eigen.hpp  Enable Use of Eigen Linear Algebra Package with CppAD  ',' syntax purpose example include files numtraits namespace ',
'eigen_plugin.hpp  Source Code for eigen_plugin.hpp  ',' ',
'eigen_array.cpp  Using Eigen Arrays: Example and Test  ',' ',
'eigen_det.cpp  Using Eigen To Compute Determinant: Example and Test  ',' ',
'hes_minor_det.cpp  Gradient of Determinant Using Expansion by Minors: Example and Test  ',' ',
'hes_lu_det.cpp  Gradient of Determinant Using LU Factorization: Example and Test  ',' ',
'interface2c.cpp  Interfacing to C: Example and Test  ',' difference central ',
'jac_minor_det.cpp  Gradient of Determinant Using Expansion by Minors: Example and Test  ',' ',
'jac_lu_det.cpp  Gradient of Determinant Using Lu Factorization: Example and Test  ',' ',
'mul_level  Using Multiple Levels of AD  ',' background motivation procedure first start ad<double> recording inner function second outer derivatives example ',
'mul_level.cpp  Multiple Level of AD: Example and Test  ',' purpose source ',
'change_param.cpp  Computing a Jacobian With Constants that Change  ',' multiple ad level purpose ',
'ode_stiff.cpp  A Stiff Ode: Example and Test  ',' ',
'mul_level_ode.cpp  Taylor\'s Ode Solver: A Multi-Level AD Example and Test  ',' purpose solution derivative method using source ',
'mul_level_adolc_ode.cpp  Taylor\'s Ode Solver: A Multi-Level Adolc Example and Test  ',' purpose solution derivative method using base_adolc.hpp memory management configuration requirement source ',
'ode_taylor.cpp  Taylor\'s Ode Solver: An Example and Test  ',' purpose solution forward mode ',
'stack_machine.cpp  Example Differentiating a Stack Machine Interpreter  ',' test ',
'example.cpp  CppAD Examples and Tests  ',' running ',
'speed_example.cpp  Run the Speed Examples  ',' program running tests ',
'lu_vec_ad.cpp  Lu Factor and Solve with Recorded Pivoting  ',' luvecad linear equation determinant syntax purpose storage convention matrix rhs result logdet example ',
'lu_vec_ad_ok.cpp  Lu Factor and Solve With Recorded Pivoting: Example and Test  ',' ',
'testvector  Using The CppAD Test Vector Template Class  ',' cppad_testvector syntax introduction cppad::vector std::vector boost::numeric::ublas::vector eigen vectors ',
'speed  Speed Test an Operator Overloading AD Package  ',' purpose ',
'speed_main  Running the Speed Test Program  ',' cppad uniform_01 syntax purpose package double profile correct seed global options onetape optimize atomic memory sparsity boolsparsity revsparsity colpack correctness results n_sweep link functions ',
'link_det_lu  Speed Testing Gradient of Determinant Using Lu Factorization  ',' prototype purpose method return value size repeat matrix double ',
'link_det_minor  Speed Testing Gradient of Determinant by Minor Expansion  ',' prototype purpose method return value size repeat matrix double ',
'link_mat_mul  Speed Testing Derivative of Matrix Multiply  ',' multiple prototype purpose return value repeat z dz ',
'link_ode  Speed Testing the Jacobian of Ode Solution  ',' prototype purpose method return value size repeat x double ',
'link_poly  Speed Testing Second Derivative of a Polynomial  ',' prototype purpose method return value size repeat ddp double ',
'link_sparse_hessian  Speed Testing Sparse Hessian  ',' prototype method size repeat x row col n_sweep double ',
'link_sparse_jacobian  Speed Testing Sparse Jacobian  ',' prototype method size repeat row col x n_sweep double ',
'microsoft_timer  Microsoft Version of Elapsed Number of Seconds  ',' syntax purpose linking ',
'speed_utility  Speed Testing Utilities  ',' main program routines library source code ',
'det_by_lu  Determinant Using Expansion by Lu Factorization  ',' syntax inclusion constructor scalar vector example source code ',
'det_by_lu.cpp  Determinant Using Lu Factorization: Example and Test  ',' minors ',
'det_by_lu.hpp  Source: det_by_lu  ',' ',
'det_of_minor  Determinant of a Minor  ',' matrix syntax inclusion purpose scalar example source code ',
'det_of_minor.cpp  Determinant of a Minor: Example and Test  ',' ',
'det_of_minor.hpp  Source: det_of_minor  ',' ',
'det_by_minor  Determinant Using Expansion by Minors  ',' syntax inclusion constructor scalar vector example source code ',
'det_by_minor.cpp  Determinant Using Expansion by Minors: Example and Test  ',' ',
'det_by_minor.hpp  Source: det_by_minor  ',' ',
'det_33  Check Determinant of 3 by 3 matrix  ',' correct syntax purpose inclusion vector ok source code ',
'det_33.hpp  Source: det_33  ',' ',
'det_grad_33  Check Gradient of Determinant of 3 by 3 matrix  ',' correct syntax purpose inclusion vector ok source code ',
'det_grad_33.hpp  Source: det_grad_33  ',' ',
'mat_sum_sq  Sum Elements of a Matrix Times Itself  ',' multiply speed test syntax purpose inclusion z vector example source code ',
'mat_sum_sq.cpp  Sum of the Elements of the Square of a Matrix: Example and Test  ',' ',
'mat_sum_sq.hpp  Source: mat_sum_sq  ',' ',
'ode_evaluate  Evaluate a Function Defined in Terms of an ODE  ',' syntax purpose inclusion float operation sequence fabs == 0 1 fp gradient example source code ',
'ode_evaluate.cpp  ode_evaluate: Example and test  ',' ',
'ode_evaluate.hpp  Source: ode_evaluate  ',' ',
'sparse_jac_fun  Evaluate a Function That Has a Sparse Jacobian  ',' syntax purpose inclusion float floatvector m row col fp example source code ',
'sparse_jac_fun.cpp  sparse_jac_fun: Example and test  ',' ',
'sparse_jac_fun.hpp  Source: sparse_jac_fun  ',' ',
'sparse_hes_fun  Evaluate a Function That Has a Sparse Hessian  ',' syntax purpose inclusion float floatvector row col fp example source code ',
'sparse_hes_fun.cpp  sparse_hes_fun: Example and test  ',' ',
'sparse_hes_fun.hpp  Source: sparse_hes_fun  ',' ',
'uniform_01  Simulate a [0,1] Uniform Random Variate  ',' [01] syntax purpose inclusion seed vector source code ',
'uniform_01.hpp  Source: uniform_01  ',' ',
'speed_double  Speed Test of Functions in Double  ',' purpose running tests ',
'double_det_minor.cpp  Double Speed: Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'double_det_lu.cpp  Double Speed: Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'double_mat_mul.cpp  CppAD Speed: Matrix Multiplication (Double Version)  ',' multiply link_mat_mul specifications implementation ',
'double_ode.cpp  Double Speed: Ode Solution  ',' link_ode specifications implementation ',
'double_poly.cpp  Double Speed: Evaluate a Polynomial  ',' link_poly specifications implementation ',
'double_sparse_hessian.cpp  Double Speed: Sparse Hessian  ',' link_sparse_hessian specifications implementation ',
'double_sparse_jacobian.cpp  Double Speed: Sparse Jacobian  ',' link_sparse_jacobian specifications implementation ',
'speed_adolc  Speed Test of Derivatives Using Adolc  ',' purpose adolc_prefix running tests ',
'adolc_det_minor.cpp  Adolc Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'adolc_det_lu.cpp  Adolc Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'adolc_mat_mul.cpp  Adolc Speed: Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'adolc_ode.cpp  Adolc Speed: Ode  ',' link_ode specifications implementation ',
'adolc_poly.cpp  Adolc Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'adolc_sparse_hessian.cpp  Adolc Speed: Sparse Hessian  ',' link_sparse_hessian specifications implementation ',
'adolc_sparse_jacobian.cpp  adolc Speed: Sparse Jacobian  ',' link_sparse_jacobian specifications implementation ',
'adolc_alloc_mat  Adolc Test Utility: Allocate and Free Memory For a Matrix  ',' syntax purpose ',
'speed_cppad  Speed Test Derivatives Using CppAD  ',' purpose running tests ',
'cppad_det_minor.cpp  CppAD Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'cppad_det_lu.cpp  CppAD Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'cppad_mat_mul.cpp  CppAD Speed, Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'cppad_ode.cpp  CppAD Speed: Gradient of Ode Solution  ',' link_ode specifications implementation ',
'cppad_poly.cpp  CppAD Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'cppad_sparse_hessian.cpp  CppAD Speed: Sparse Hessian  ',' link_sparse_hessian specifications implementation ',
'cppad_sparse_jacobian.cpp  CppAD Speed: Sparse Jacobian  ',' link_sparse_jacobian specifications implementation ',
'speed_fadbad  Speed Test Derivatives Using Fadbad  ',' purpose fadbad_prefix running tests ',
'fadbad_det_minor.cpp  Fadbad Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'fadbad_det_lu.cpp  Fadbad Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'fadbad_mat_mul.cpp  Fadbad Speed: Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'fadbad_ode.cpp  Fadbad Speed: Ode  ',' link_ode specifications implementation ',
'fadbad_poly.cpp  Fadbad Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'fadbad_sparse_hessian.cpp  Fadbad Speed: Sparse Hessian  ',' ',
'fadbad_sparse_jacobian.cpp  fadbad Speed: sparse_jacobian  ',' ',
'speed_sacado  Speed Test Derivatives Using Sacado  ',' purpose sacado_prefix running tests ',
'sacado_det_minor.cpp  Sacado Speed: Gradient of Determinant by Minor Expansion  ',' link_det_minor specifications implementation ',
'sacado_det_lu.cpp  Sacado Speed: Gradient of Determinant Using Lu Factorization  ',' link_det_lu matrix specifications implementation ',
'sacado_mat_mul.cpp  Sacado Speed: Matrix Multiplication  ',' link_mat_mul multiply specifications implementation ',
'sacado_ode.cpp  Sacado Speed: Gradient of Ode Solution  ',' link_ode specifications implementation ',
'sacado_poly.cpp  Sacado Speed: Second Derivative of a Polynomial  ',' link_poly specifications implementation ',
'sacado_sparse_hessian.cpp  Sacado Speed: Sparse Hessian  ',' ',
'sacado_sparse_jacobian.cpp  sacado Speed: sparse_jacobian  ',' ',
'Appendix  Appendix  ',' ',
'Faq  Frequently Asked Questions and Answers  ',' operator reporting errorhandler avoid record taping mode cppad_testvector standard math function storage assignment independent bugs comparechange complex types exceptions variables matrix inverse mode: forward reverse namespace preprocessor symbol using speed ndebug optimize memory allocation tape storage: disk ',
'Theory  The Theory of Derivative Calculations  ',' ',
'ForwardTheory  The Theory of Forward Mode  ',' taylor notation binary operators addition subtraction multiplication division standard math functions differential equation coefficients recursion formula cases that apply above special ',
'exp_forward  Exponential Function Forward Mode Theory  ',' expm1 derivatives taylor coefficients recursion ',
'log_forward  Logarithm Function Forward Mode Theory  ',' log1p derivatives taylor coefficients recursion ',
'sqrt_forward  Square Root Function Forward Mode Theory  ',' ',
'sin_cos_forward  Trigonometric and Hyperbolic Sine and Cosine Forward Theory  ',' sinh cosh differential equation ',
'atan_forward  Inverse Tangent and Hyperbolic Tangent Forward Mode Theory  ',' atanh derivatives taylor coefficients recursion ',
'asin_forward  Inverse Sine and Hyperbolic Sine Forward Mode Theory  ',' asinh derivatives taylor coefficients recursion ',
'acos_forward  Inverse Cosine and Hyperbolic Cosine Forward Mode Theory  ',' acosh derivatives taylor coefficients recursion ',
'tan_forward  Tangent and Hyperbolic Tangent Forward Taylor Polynomial Theory  ',' derivatives coefficients recursion ',
'erf_forward  Error Function Forward Taylor Polynomial Theory  ',' derivatives coefficients recursion ',
'ReverseTheory  The Theory of Reverse Mode  ',' taylor notation binary operators addition subtraction multiplication division standard math functions ',
'exp_reverse  Exponential Function Reverse Mode Theory  ',' expm1 ',
'log_reverse  Logarithm Function Reverse Mode Theory  ',' log1p ',
'sqrt_reverse  Square Root Function Reverse Mode Theory  ',' ',
'sin_cos_reverse  Trigonometric and Hyperbolic Sine and Cosine Reverse Theory  ',' sinh cosh ',
'atan_reverse  Inverse Tangent and Hyperbolic Tangent Reverse Mode Theory  ',' ',
'asin_reverse  Inverse Sine and Hyperbolic Sine Reverse Mode Theory  ',' asinh ',
'acos_reverse  Inverse Cosine and Hyperbolic Cosine Reverse Mode Theory  ',' acosh ',
'tan_reverse  Tangent and Hyperbolic Tangent Reverse Mode Theory  ',' notation eliminating y(t) positive orders z(t) zero ',
'erf_reverse  Error Function Reverse Mode Theory  ',' notation positive orders z(t) zero ',
'reverse_identity  An Important Reverse Mode Identity  ',' notation sweep theorem proof ',
'glossary  Glossary  ',' efficient ad function base type above elementary vector operation atomic sequence dependent independent parameter sparsity pattern boolean sets tape active inactive variable variables taylor coefficient ',
'Bib  Bibliography  ',' abramowitz stegun the c++ programming language evaluating derivatives numerical recipes shampine l.f. ',
'wish_list  The CppAD Wish List  ',' optimization taping special operators checkpoint retape testing sparsity patterns check_finite compilation speed base requirements adolc forward mode recomputation iterator interface operation sequence software guidelines tracing atan2 benderquad ',
'whats_new  Changes and Additions to CppAD  ',' introduction this year previous years ',
'whats_new_16  Changes and Additions to CppAD During 2016  ',' introduction 12-23 12-20 12-18 12-13 12-11 12-09 11-18 11-14 11-13 10-27 10-12 09-29 09-27 09-26 09-16 09-13 08-30 08-25 07-17 07-14 06-30 06-29 06-27 06-25 06-10 05-05 04-17 03-27 03-26 03-25 03-24 03-23 03-22 03-21 03-20 03-19 03-17 03-12 03-05 03-01 02-29 02-28 02-27 02-26 02-25 02-23 01-21 01-20 01-18 ',
'whats_new_15  CppAD Changes and Additions During 2015  ',' introduction 12-31 12-29 12-28 12-08 12-01 11-30 11-25 11-24 11-14 11-08 11-06 10-21 10-16 10-06 10-04 10-03 10-02 09-28 09-27 09-25 09-24 09-23 09-21 09-20 09-19 09-16 09-03 09-02 08-31 08-30 08-29 08-28 08-26 08-25 08-20 08-17 08-16 08-09 08-06 07-31 06-16 06-11 06-09 06-07 05-26 cond_exp_1 cond_exp_2 05-11 05-10 05-09 05-08 05-07 05-05 04-18 03-13 03-06 02-28 02-18 02-16 02-14 02-11 02-10 02-09 02-07 02-06 02-04 02-03 02-02 01-30 01-29 01-26 01-23 01-21 01-20 01-09 01-07 01-02 ',
'whats_new_14  CppAD Changes and Additions During 2014  ',' introduction 12-30 12-29 12-28 12-27 12-26 12-25 12-23 12-22 12-17 12-16 12-15 11-28 11-27 09-28 09-27 09-25 09-21 05-28 05-27 05-23 05-22 05-20 05-19 05-16 05-14 03-18 03-17 03-09 03-05 03-02 03-01 02-28 02-27 02-26 02-23 02-22 02-17 02-15 01-26 01-21 01-10 ',
'whats_new_13  CppAD Changes and Additions During 2013  ',' introduction 12-29 12-27 12-26 12-24 11-27 11-13 11-12 10-29 10-23 10-22 10-16 10-15 10-14 10-13 10-12 09-20 09-19 09-18 09-07 08-12 08-11 08-06 07-26 05-28 05-21 05-17 05-15 05-14 05-12 05-11 05-04 04-28 04-27 04-26 ',
'whats_new_12  CppAD Changes and Additions During 2012  ',' introduction 12-30 12-29 12-28 12-27 12-26 12-23 12-22 12-20 12-19 12-17 12-15 12-14 12-13 11-28 11-21 11-20 11-17 11-16 11-14 11-09 11-06 11-04 10-31 10-30 10-25 10-24 10-12 10-04 10-03 10-02 09-24 09-11 08-05 07-30 07-08 07-07 07-05 07-04 07-03 07-02 07-01 06-17 06-16 06-15 06-12 06-10 06-09 06-08 06-07 06-05 06-04 06-03 06-02 06-01 05-31 05-30 05-29 05-27 05-24 04-19 04-18 04-17 04-10 04-06 04-05 04-01 03-27 03-26 03-23 03-21 03-17 03-11 03-03 03-02 02-11 02-10 02-09 01-30 01-27 01-24 01-23 01-20 01-19 01-16 01-15 01-12 01-07 01-02 ',
'whats_new_11  Changes and Additions to CppAD During 2011  ',' introduction 12-30 12-28 12-21 12-20 11-29 11-27 11-24 11-21 11-20 11-18 11-17 11-09 11-07 11-06 11-04 11-01 10-30 10-29 10-14 10-12 09-06 09-05 09-02 09-01 08-31 08-30 08-25 08-23 08-21 08-11 08-10 08-09 08-08 08-07 08-06 08-04 08-03 08-02 07-31 07-29 07-28 07-27 07-25 07-18 07-17 07-14 07-13 07-11 openmp/run.sh 07-10 07-09 07-07 06-23 06-21 06-18 05-29 05-28 05-26 05-22 05-11 05-03 04-29 04-20 04-19 03-19 03-11 03-05 02-22 02-19 02-17 02-15 02-09 02-06 02-02 02-01 01-19 01-16 01-09 ',
'whats_new_10  Changes and Additions to CppAD During 2010  ',' introduction 12-31 11-27 09-26 09-22 08-21 07-14 07-11 06-01 04-28 04-26 04-24 04-01 03-11 03-10 03-09 03-03 02-11 02-08 02-06 02-05 02-03 01-26 01-24 01-23 01-20 01-18 01-04 ',
'whats_new_09  Changes and Additions to CppAD During 2009  ',' introduction 12-23 12-22 12-18 12-12 12-04 12-02 11-28 11-27 11-26 10-30 10-29 10-28 10-27 10-24 10-23 10-21 10-16 10-14 10-03 09-30 09-29 09-28 09-26 09-20 09-19 09-18 08-25 08-14 08_13 08-13 08-11 08-10 08-09 08-06 08-02 08-01 07-31 07-26 07-25 07-24 07-23 07-06 07-04 07-03 07-02 07-01 06-30 06-29 06-28 06-25 06-22 06-21 06-20 06-06 05-20 03-24 02-20 02-15 02-01 01-31 01-18 01-06 ',
'whats_new_08  Changes and Additions to CppAD During 2008  ',' erf ipopt_cppad_nlp introduction 12-19 12-14 12-04 11-22 11-21 11-20 10-27 10-17 10-16 09-30 09-26 09-18 09-17 09-16 09-12 09-10 09-09 09-07 09-06 09-05 09-04 09-03 09-01 08-29 08-19 08-08 07-02 06-18 06-15 06-11 06-10 05-08 05-03 04-20 04-18 04-10 04-06 04-04 03-27 02-05 02-03 01-26 01-24 01-21 01-20 01-11 01-08 ',
'whats_new_07  Changes and Additions to CppAD During 2007  ',' introduction 12-29 12-25 12-21 12-08 12-05 12-04 12-03 12-02 11-29 11-23 11-18 11-06 11-05 11-04 11-03 11-02 11-01 10-30 10-27 10-23 10-22 10-16 10-13 10-05 10-02 09-06 08-09 08-07 07-30 07-29 07-28 07-26 07-25 07-23 07-22 07-21 07-20 07-19 07-18 07-14 07-13 06-22 06-20 06-14 05-26 05-25 05-24 05-22 05-08 05-05 04-19 04-17 04-14 04-11 04-10 04-07 04-06 04-05 03-31 03-30 03-29 03-20 03-15 03-14 03-13 03-09 03-28 02-27 02-22 02-17 02-16 02-15 02-06 02-04 02-03 02-02 02-01 01-29 ',
'whats_new_06  Changes and Additions to CppAD During 2006  ',' aclocal introduction 12-24 12-23 12-22 12-21 12-19 12-18 12-17 12-15 12-13 12-12 12-11 12-10 12-09 12-07 12-05 12-03 12-02 12-01 11-30 11-29 11-28 11-23 11-18 11-12 11-08 11-06 11-05 11-04 11-02 11-01 10-31 10-29 10-28 10-27 10-26 10-25 10-18 10-16 10-10 09-30 08-17 07-14 07-12 06-29 06-22 06-19 06-17 06-18 06-15 06-09 06-07 06-05 06-02 05-31 05-29 05-27 05-03 04-29 04-28 04-26 04-25 04-19 04-18 04-17 04-15 04-14 04-13 04-08 04-06 04-05 04-04 04-03 04-02 04-01 03-31 03-30 03-29 03-28 03-27 03-26 03-24 03-23 03-22 03-18 03-17 03-16 03-15 03-11 03-10 03-09 03-07 03-05 02-28 02-25 02-24 02-23 02-21 02-15 02-14 02-13 02-11 02-10 02-04 01-20 01-18 01-08 01-07 01-02 01-05 ',
'whats_new_05  Changes and Additions to CppAD During 2005  ',' 12-24 12-23 12-22 12-20 12-19 12-16 12-15 12-14 12-11 12-08 12-07 12-06 12-05 12-03 12-02 12-01 11-23 11-22 11-20 11-19 11-15 11-12 11-09 11-07 11-06 11-01 10-20 10-18 10-14 10-12 10-06 09-29 09-27 09-24 09-20 09-14 09-09 09-07 08-30 08-24 08-20 08-19 08-15 08-14 08-13 08-07 07-21 07-19 07-15 07-11 07-08 07-05 07-04 07-03 07-02 07-01 06-25 06-24 06-18 06-14 06-13 06-06 05-19 05-18 05-16 05-12 05-06 05-01 04-21 04-20 04-19 03-26 03-23 03-22 03-09 03-04 03-01 02-24 01-08 ',
'whats_new_04  Changes and Additions to CppAD During 2004  ',' introduction 12-11 12-09 12-03 11-17 11-16 11-15 11-14 11-13 11-12 11-10 11-04 11-02 11-01 10-29 10-28 10-27 10-21 10-19 10-16 10-06 09-29 09-26 09-23 09-21 09-13 09-10 09-09 09-07 09-04 09-02 08-27 08-25 08-24 08-12 07-31 07-08 07-07 07-03 07-02 06-29 06-25 06-12 06-04 06-03 06-01 05-30 05-29 05-26 05-25 05-14 05-12 05-09 05-07 05-04 05-03 04-29 04-28 04-25 04-24 04-22 04-21 04-20 04-19 04-09 04-08 04-07 04-03 04-02 04-01 03-30 03-28 03-25 03-18 03-17 03-15 03-12 03-11 03-09 03-07 03-06 03-05 03-04 03-03 03-01 02-29 02-28 02-21 02-20 02-17 02-16 02-15 02-12 02-01 01-29 01-28 01-22 ',
'whats_new_03  Changes and Additions to CppAD During 2003  ',' introduction 12-24 12-22 12-14 12-13 12-12 12-10 12-05 12-01 11-21 11-20 11-16 11-15 11-14 11-12 11-11 11-06 11-04 11-02 10-21 10-16 10-14 10-10 10-06 10-05 09-30 09-20 09-19 09-18 09-15 09-14 09-13 09-06 09-05 09-04 09-03 08-23 08-22 08-19 08-17 08-16 08-11 08-10 08-07 08-06 08-05 08-04 08-03 08-01 07-30 07-29 07-26 07-22 07-20 07-18 07-16 07-14 ',
'deprecated  CppAD Deprecated API Features  ',' atomic functions ',
'include_deprecated  Deprecated Include Files  ',' 2015-11-30 2006-12-17 linking new to commands ',
'FunDeprecated  ADFun Object Deprecated Member Functions  ',' syntax purpose dependent 2007-08-07 order 2006-03-31 memory size 2006-04-03 taylor_size 2006-06-17 use_vecad 2006-04-08 size_taylor 2014-03-18 capacity_taylor ',
'CompareChange  Comparison Changes During Zero Order Forward Mode  ',' adfun syntax deprecated 2015-01-20 purpose discussion ',
'omp_max_thread  OpenMP Parallel Setup  ',' deprecated 2011-06-23 syntax purpose number independent restriction ',
'TrackNewDel  Routines That Track Use of New and Delete  ',' memory ndebug cppad_track_new_vec cppadtracknewvec cppad_track_del_vec cppadtrackdelvec cppad_track_extend cppadtrackextend cppad_track_count thread multi deprecated 2007-07-23 syntax purpose include file line oldptr newlen head newptr ncopy macro previously trackcount multi-threading example ',
'TrackNewDel.cpp  Tracking Use of New and Delete: Example and Test  ',' ',
'omp_alloc  A Quick OpenMP Memory Allocator Used by CppAD  ',' multi-threading allocation syntax purpose include deprecated 2011-08-23 ',
'omp_max_num_threads  Set and Get Maximum Number of Threads for omp_alloc Allocator  ',' deprecated 2011-08-31 syntax purpose set_max_num_threads get_max_num_threads restrictions ',
'omp_in_parallel  Is The Current Execution in OpenMP Parallel Mode  ',' deprecated 2011-08-31 syntax purpose flag example ',
'omp_get_thread_num  Get the Current OpenMP Thread Number  ',' deprecated 2011-08-31 syntax purpose example ',
'omp_get_memory  Get At Least A Specified Amount of Memory  ',' deprecated 2011-08-31 syntax purpose min_bytes cap_bytes v_ptr allocation speed example ',
'omp_return_memory  Return Memory to omp_alloc  ',' deprecated 2011-08-31 syntax purpose v_ptr thread ndebug example ',
'omp_free_available  Free Memory Currently Available for Quick Use by a Thread  ',' deprecated 2011-08-31 syntax purpose example ',
'omp_inuse  Amount of Memory a Thread is Currently Using  ',' deprecated 2011-08-31 syntax purpose num_bytes example ',
'omp_available  Amount of Memory Available for Quick Use by a Thread  ',' deprecated 2011-08-31 syntax purpose num_bytes example ',
'omp_create_array  Allocate Memory and Create A Raw Array  ',' deprecated 2011-08-31 syntax purpose type size_min size_out delta example ',
'omp_delete_array  Return A Raw Array to The Available Memory for a Thread  ',' deprecated 2011-08-31 syntax purpose type delta example ',
'omp_efficient  Check If A Memory Allocation is Efficient for Another Use  ',' removed syntax purpose v_ptr num_bytes flag thread ndebug ',
'old_max_num_threads  Set Maximum Number of Threads for omp_alloc Allocator  ',' removed syntax purpose restrictions ',
'omp_alloc.cpp  OpenMP Memory Allocator: Example and Test  ',' allocation multi thread deprecated 2011-08-31 ',
'memory_leak  Memory Leak Detection  ',' check static deprecated 2012-04-06 syntax purpose thread add_static flag inuse available track_count error message ',
'epsilon  Machine Epsilon For AD Types  ',' deprecated 2012-06-17 syntax purpose float ',
'test_vector  Choosing The Vector Testing Template Class  ',' cppad_test_vector deprecated 2012-07-03 syntax introduction ms windows cppad::vector std::vector boost::numeric::ublas::vector cppadvector 2007-07-28 ',
'cppad_ipopt_nlp  Nonlinear Programming Using the CppAD Interface to Ipopt  ',' deprecated 2012-11-28 syntax purpose namespace ipopt_library_paths fg(x) index vector projection injection representation simple sizevector numbervector adnumber advector x_i x_l x_u g_l g_u fg_info fg_info.number_functions fg_info.eval_r fg_info.retape fg_info.domain_size fg_info.range_size fg_info.number_terms fg_info.index solution status z_l z_u lambda obj_value example wish list ',
'ipopt_nlp_get_started.cpp  Nonlinear Programming Using CppAD and Ipopt: Example and Test  ',' purpose configuration requirement ',
'ipopt_nlp_ode  Example Simultaneous Solution of Forward and Inverse Problem  ',' ',
'ipopt_nlp_ode_problem  An ODE Inverse Problem Example  ',' notation forward measurements simulation analytic solution parameter values simulated trapezoidal approximation time grid black box method two levels iteration derivatives simultaneous source ',
'ipopt_nlp_ode_simple  ODE Fitting Using Simple Representation  ',' cppad_ipopt_nlp purpose argument vector objective function initial condition constraint trapezoidal approximation source ',
'ipopt_nlp_ode_fast  ODE Fitting Using Fast Representation  ',' purpose objective function range indices i(k0) domain j(k0) initial condition trapezoidal approximation source ',
'ipopt_nlp_ode_problem.hpp  ODE Inverse Problem Definitions: Source Code  ',' example ',
'ipopt_nlp_ode_simple.hpp  ODE Fitting Using Simple Representation  ',' cppad_ipopt_nlp example source ',
'ipopt_nlp_ode_fast.hpp  ODE Fitting Using Fast Representation  ',' cppad_ipopt_nlp example source ',
'ipopt_nlp_ode_run.hpp  Driver for Running the Ipopt ODE Example  ',' ',
'ipopt_nlp_ode_check.cpp  Correctness Check for Both Simple and Fast Representations  ',' ',
'ipopt_ode_speed.cpp  Speed Test for Both Simple and Fast Representations  ',' ',
'old_atomic  User Defined Atomic AD Functions  ',' operation deprecated 2013-05-27 syntax callback routines free static memory purpose partial implementation cppad_user_atomic tvector base ok id tx ty forward reverse afun ay parallel mode usage vx vy py px for_jac_sparse q rev_jac_sparse rev_hes_sparse clear restriction example simple tangent matrix multiplication ',
'old_reciprocal.cpp  Old Atomic Operation Reciprocal: Example and Test  ',' deprecated 2013-05-27 theory ',
'old_usead_1.cpp  Using AD to Compute Atomic Function Derivatives  ',' inside user checkpoint deprecated 2013-05-27 purpose simple case ',
'old_usead_2.cpp  Using AD to Compute Atomic Function Derivatives  ',' inside user checkpoint deprecated 2013-05-27 purpose ',
'old_tan.cpp  Old Tan and Tanh as User Atomic Operations: Example and Test  ',' deprecated 2013-05-27 theory ',
'old_mat_mul.cpp  Old Matrix Multiply as a User Atomic Operation: Example and Test  ',' deprecated 2013-05-27 include file ',
'old_mat_mul.hpp  Define Matrix Multiply as a User Atomic Operation  ',' old_atomic test syntax example begin source extra call information indexing one reverse partials order set union cppad callback functions declare ',
'zdouble  zdouble: An AD Base Type With Absolute Zero  ',' deprecated 2015-09-26 syntax constructor assignment comparison operators arithmetic standard math nan motivation general cppad requirements example ',
'zdouble.cpp  zdouble: Example and Test  ',' ',
'compare_c  Compare Speed of C and C++  ',' with syntax purpose ',
'det_of_minor_c  Determinant of a Minor  ',' syntax purpose source code ',
'det_by_minor_c  Compute Determinant using Expansion by Minors  ',' syntax purpose source code ',
'uniform_01_c  Simulate a [0,1] Uniform Random Variate  ',' [01] syntax purpose seed source code ',
'correct_det_by_minor_c  Correctness Test of det_by_minor Routine  ',' syntax flag source code ',
'repeat_det_by_minor_c  Repeat det_by_minor Routine A Specified Number of Times  ',' syntax size source code ',
'elapsed_seconds_c  Returns Elapsed Number of Seconds  ',' syntax purpose source code ',
'time_det_by_minor_c  Determine Amount of Time to Execute det_by_minor  ',' syntax purpose time_min source code ',
'main_compare_c  Main Program For Comparing C and C++ Speed  ',' source code ',
'numeric_ad  Some Numerical AD Utilities  ',' ',
'BenderQuad  Computing Jacobian and Hessian of Bender\'s Reduced Objective  ',' syntax see also problem purpose fun fun.f fun.h fun.dy gx gxx bavector advector example ',
'bender_quad.cpp  BenderQuad: Example and Test  ',' ',
'opt_val_hes  Jacobian and Hessian of Optimal Values  ',' syntax see also reference purpose basevector fun fun::ad_vector fun.ell fun.s fun.sy signdet example ',
'opt_val_hes.cpp  opt_val_hes: Example and Test  ',' ',
'LuRatio  LU Factorization of A Square Matrix and Stability Calculation  ',' linear equation solve syntax description include storage sign jp determinant purpose sizevector advector example ',
'lu_ratio.cpp  LuRatio: Example and Test  ',' ',
'addon  CppAD Addons  ',' name include files library preprocessor symbols namespace ',
'License  Your License for the CppAD Software  ',' '
]

var MaxList = 100;
var Nstring = -1;
var Nkeyword = Keyword.length / 2;
Initialize();

function Initialize()
{
	UpdateList();
	document.search.keywords.focus();
}
function UpdateList(event)
{
	key = 0;
	if( window.event )
		key = window.event.keyCode;
	else if( event )
		key = event.which;
	if( key == 13 )
	{	Goto();
		return;
	}
	var string  = document.search.keywords.value;
	if( Nstring == string.length )
		return;
	Nstring     = string.length;

	var word    = string.match(/\S+/g);
	var nword   = 0;
	if(word != null )
		nword   = word.length;

	var pattern = new Array(nword);
	for(var j = 0; j < nword; j++)
		pattern[j] = new RegExp(word[j], 'i');

	var nlist = 0;
	var list  = '';
	for(i = 0; (i < Nkeyword) && (nlist < MaxList) ; i++)
	{
		var match = true;
		for(j = 0; j < nword; j++)
		{	var flag = pattern[j].test(Keyword[2*i]);
			flag     = flag || pattern[j].test(Keyword[2*i+1]);
			match    = match && flag;
		}

		if( match )
		{
			line  = Keyword[2*i].split(/\s+/);
			line  = line.join(' ');
			list  = list + line + '\n';
			nlist = nlist + 1;
		}
	}
	document.search.list.value    = list;
}
function Choose(textarea)
{	var start_select = textarea.value.substring(0, textarea.selectionStart);
	var start_pos    = Math.max(0, start_select.lastIndexOf('\n') );
	var length       = textarea.value.length;
	var end_select   = 
		textarea.value.substring(textarea.selectionEnd, length);
	var end_pos      = end_select.indexOf('\n');
	if( end_pos >= 0 ) 
	{	end_pos = textarea.selectionEnd + end_pos;
	} else 
	{	end_pos = length;
	}
	// highlight the selected line
	textarea.selectionStart = start_pos;
	textarea.selectionEnd   = end_pos;
	// get the choice from the beginning of the line
	var line = textarea.value.substring(start_pos, length);
	var end_choice = line.indexOf(' ');
	if( end_choice >= 0 )
	{	var choice = line.substring(0, end_choice);
		document.search.choice.value = choice.toLowerCase();
	}
	
	return true;
}
function Goto()
{
parent.location = document.search.choice.value + '.xml';
}
