# $Id: test_one.sh.in 2237 2011-12-28 11:47:15Z bradbell $
# -----------------------------------------------------------------------------
# CppAD: C++ Algorithmic Differentiation: Copyright (C) 2003-11 Bradley M. Bell
#
# CppAD is distributed under multiple licenses. This distribution is under
# the terms of the 
#                     GNU General Public License Version 2.
#
# A copy of this license is included in the COPYING file of this distribution.
# Please visit http://www.coin-or.org/CppAD/ for information on other licenses.
# -----------------------------------------------------------------------------
#
# Run one of the tests
if [ "$1" = "" ]
then
	echo "usage: test_one.sh file [extra]"
	echo "file is the *.cpp file name with extension"
	echo "and extra is extra options for g++ command"
	exit 1
fi
if [ ! -e "$1" ]
then
	echo "Cannot find the file $1"
	exit 1
fi
fun=`grep "^bool *[a-zA-Z0-9_]*( *void *)" $1 | tail -1 | \
	sed -e "s/^bool *\([a-zA-Z0-9_]*\) *( *void *)/\1/"`
if [ -e test_one.exe ]
then
	rm test_one.exe
fi
sed < test_more.cpp > test_one.cpp \
-e '/ok *\&= *Run( /d' \
-e "s/.*This line is used by test_one.sh.*/	ok \&= Run( $fun, \"$fun\");/"  
#
cmd="g++ test_one.cpp $*
	-o test_one.exe
	-g -Wall -ansi -pedantic-errors -Wshadow
	-std=c++98 -DCPPAD_ADOLC_TEST
	-I.. -I/usr/include/boost-1_33_1
"
if [ -e /include ]
then
	cmd="$cmd -I/include"
fi
if [ -e /include ]
then
	cmd="$cmd -I/include"
fi
for lib in lib lib64
do
	if [ -e /$lib ]
	then
		cmd="$cmd -L/$lib -ladolc"
		export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/$lib"
	fi
	if [ -e /$lib ]
	then
		cmd="$cmd -L/$lib -lipopt"
		cmd="$cmd  -L/usr/lib/gcc/x86_64-redhat-linux/4.4.7 -L/usr/lib/gcc/x86_64-redhat-linux/4.4.7/../../../../lib64 -L/lib/../lib64 -L/usr/lib/../lib64 -L/usr/lib/gcc/x86_64-redhat-linux/4.4.7/../../.. -lgfortranbegin -lgfortran -lm -lpthread -ldl"
		export LD_LIBRARY_PATH="$LD_LIBRARY_PATH:/$lib"
	fi
done
if [ "$1" == 'ndebug.cpp' ]
then
	cmd="$cmd -DNDEBUG"
fi
echo $cmd
$cmd
echo "./test_one.exe"
if ! ./test_one.exe
then
	exit 1
fi
exit 0
