% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin tridiag_solve_ok.m$$ $newlinech %$$
% $spell
%	ckbs
%	ak
%	blk
%	lhs
%	qk
%	tridiag
%	uk
% $$
%
% $section ckbs_tridiag_solve Example and Test$$
%
% $index ckbs_tridiag_solve, example and test$$
% $index tridiag_solve, example and test$$
% $index example, tridiag_solve$$
% $index test, tridiag_solve$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [ok] = tridiag_solve_ok()
ok = true;
m  = 2;
n  = 3;
N  = 4;
% case where uk = 0, qk = I, and ak is random
rand('seed', 123);
a = rand(n, n, N);
r = rand(n * N, m);
c = zeros(n, n, N);
for k = 1 : N
	ak         = a(:, :, k);
	b(:, :, k) = 2 * eye(n) + ak * ak';
	c(:, :, k) = ak';
end  
% ----------------------------------------
[e, lambda] = ckbs_tridiag_solve(b, c, r);
% ----------------------------------------
%
% check equation corresponding to first row
blk_n = 1 : n;
lhs   = b(:, :, 1) * e(blk_n, :) + c(:, :, 2)' * e(blk_n + n, :);
ok    = ok & ( max( max( abs( lhs - r(blk_n, :) ) ) ) < 1e-10 );
%
% check equation corresponding to last row
blk_n = (N-1) * n + (1 : n);
lhs   = c(:, :, N) * e(blk_n - n, :) + b(:, :, N) * e(blk_n, :);
ok    = ok & ( max( max( abs( lhs - r(blk_n, :) ) ) ) < 1e-10 );
%
% check other rows
blk_n = 1 : n;
for k = 2 : N-1
	blk_n = blk_n + n;
	lhs   = c(:, :, k)    * e(blk_n - n, :)  ...
	      + b(:, :, k)    * e(blk_n, :)    ...
	      + c(:, :, k+1)' * e(blk_n + n, :);
	ok    = ok & ( max( max( abs( lhs - r(blk_n, :) ) ) ) < 1e-10 );
end
return
end
% $$ $newlinech %$$
% $end
