% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin nonlinear_ok_sin_f.m$$ $newlinech %$$ 
%
% $spell
%	ckbs
%	fk
%	xk
%	cos
% $$
%
% $section Example Constraint Function: nonlinear_ok_sin_f$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [fk, Fk] = nonlinear_ok_sin_f(k, xk)
	global nonlinear_ok_sin_x4_min
	x4_min = nonlinear_ok_sin_x4_min;
	%
	% constrained so that x(4) >= 1 - sin( x(1) ) + x4_min
        ell      = 1;
	n        = size(xk, 1);
	% 
	fk       = 1 - sin( xk(2) ) + x4_min - xk(4);
	Fk       = zeros(ell, n);
	Fk(1, 2) = - cos( xk(2) );
	Fk(1, 4) = -1;
	return
end
% $$ $newlinech %$$ 
% $end
