% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin nonlinear_ok_simple_h.m$$ $newlinech %$$ 
%
% $spell
%	ckbs
%	hk
%	xk
%	sqrt
%	dr
% $$
%
% $section Example Measurement Function: nonlinear_ok_simple_h$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [hk, Hk] = nonlinear_ok_simple_h(k, xk)
	global nonlinear_ok_simple_m
	%
	n        = size(xk, 1);
	m        = nonlinear_ok_simple_m;
	hk       = xk(1:m);
	Hk       = [ eye(m) , zeros(m, n-m) ];
	return
end
% $$ $newlinech %$$
% $end
