% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin nonlinear_ok_simple_g.m$$ $newlinech %$$ 
%
% $spell
%	ckbs
%	gk
%	xk
%	dt
% $$
%
% $section Example Transition Function: nonlinear_ok_simple_g$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [gk, Gk] = nonlinear_ok_simple_g(k, xk1)
	n  = size(xk1, 1);
	if k == 1 
		Gk = zeros(n, n);
		gk = Gk * xk1 + 1;
	else
		Gk = eye(n);
		gk = Gk * xk1 + 1;
	end
	return
end
% $$ $newlinech %$$
% $end
