% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin nonlinear_ok_simple_f.m$$ $newlinech %$$ 
%
% $spell
%	ckbs
%	fk
%	xk
% $$
%
% $section Example Constraint Function: nonlinear_ok_simple_f$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [fk, Fk] = nonlinear_ok_simple_f(k, xk)
	global nonlinear_ok_simple_N
	global nonlinear_ok_simple_ell
	%
        N   = nonlinear_ok_simple_N;
        ell = nonlinear_ok_simple_ell;
	n   = size(xk, 1);
	% xk(1:ell)^2 <= N - .5
	fk = xk(1:ell).^2 - (N - .5);
	Fk = zeros(ell, n);
	for i = 1 : ell
		Fk(i, i) = 2 * xk(i);
	end
	return
end
% $$ $newlinech %$$
% $end
