% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin nonlinear_ok_box_g.m$$ $newlinech %$$ 
%
% $spell
%	ckbs
%	gk
%	xk
%	dt
% $$
%
% $section Example Transition Function: nonlinear_ok_box_g$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [gk, Gk] = nonlinear_ok_box_g(k, xk1)
	global nonlinear_ok_box_x1
	global nonlinear_ok_box_dt
	if k == 1 
		Gk = zeros(4, 4);
		gk = nonlinear_ok_box_x1;
		return;
	end 
	dt = nonlinear_ok_box_dt;
	Gk = [ ... 
		1  0  0  0 
		dt 1  0  0
		0  0  1  0
		0  0  dt 1 ...
	];
	gk = Gk * xk1;
	return
end
% $$ $newlinech %$$
% $end
