% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin nonlinear_ok_box_f.m$$ $newlinech %$$ 
%
% $spell
%	ckbs
%	fk
%	xk
% $$
%
% $section Example Constraint Function: nonlinear_ok_box_f$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [fk, Fk] = nonlinear_ok_box_f(k, xk)
	global nonlinear_ok_box_x4_min
	global nonlinear_ok_box_x4_max
	%
	% constrained so that x4_min <= x4(t) <= x4_max
	x4_min = nonlinear_ok_box_x4_min;
	x4_max = nonlinear_ok_box_x4_max;
        ell    = 2;
	n      = size(xk, 1);
	% 
	fk = [ ...
		xk(4) - x4_max;
		x4_min - xk(4) ...
	];
	Fk = zeros(ell, n);
	Fk(1, 4) = 1;
	Fk(2, 4) = -1;
	return
end
% $$ $newlinech %$$ 
% $end
