# read data file as character vector
data   <- scan(file="nonlinear_ok_box.out", what="character")
#
# minimum allowable value for x4(t)
x4_min <- .25
#
# convert to a character matrix
len    <- length(data)
nc     <- 8
#
# separate from the header line
header <- data[1 : nc]
data   <- data[(nc+1) : len]
#
# convert data to double precision
data   <- as.double(data)
#
# convert to a matrix
nr     <- (len - 1)  / nc
data   <- matrix(data, nrow=nr, ncol=nc, byrow=TRUE)
#
# plot true values with solid line
solid   <- 1
x2_true <- data[, "x2_true" == header]
x4_true <- data[, "x4_true" == header]
plot(
	x = x2_true, 
	y = x4_true, 
	type = "l", 
	ylim = c(0, 2.5),
	main = "Nonlinear Kalman-Bucy Smoother",
	xlab = "x2", 
	ylab = "x4", 
	lty=solid
)
#
# plot lower and upper bounds with a straight line
x2_bnd   <- c(0, 2*pi)
x4_low   <- c(x4_min, x4_min)
x4_up    <- c(2 + x4_min, 2 + x4_min)
lines(x = x2_bnd, y = x4_low, type = "l", lty=solid)
lines(x = x2_bnd, y = x4_up,  type = "l", lty=solid)
#
# plot constrained estimate with longdash line
longdash <- 5
x2_con   <- data[, "x2_con" == header]
x4_con   <- data[, "x4_con" == header]
lines(x = x2_con, y = x4_con, type = "l", lty=longdash)
#
# plot unconstrained estimate with dotted line
dotted <- 3
x2_free <- data[, "x2_free" == header]
x4_free <- data[, "x4_free" == header]
lines(x = x2_free, y = x4_free, type = "l", lty=dotted)
#
# add legend to plot
xleg    <- .3 
yleg    <- 2.
legend (
	x = xleg , 
	y = yleg, 
	legend = c("true",     "con",   "free"), 
	lty    = c( solid,  longdash,   dotted) 
)
#
# save the plot in encapsulated postscript
savePlot(filename = "nonlinear_ok_box", type = "eps");
