% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin kuhn_tucker_ok.m$$ $newlinech %$$
% $spell
%	ckbs
%	Bdiag
%	blk
%	blkdiag
%	mul
%	Kuhn
%	mu
%	Bdia
%	Hdia
%	Hlow
% $$
%
% $section ckbs_kuhn_tucker Example and Test$$
%
% $index ckbs_kuhn_tucker, example and test$$
% $index kuhn_tucker, example and test$$
% $index example, kuhn_tucker$$
% $index test, kuhn_tucker$$
%
% $head Source Code$$
% $newlinech $$ $codep
function [ok] = kuhn_tucker_ok()
ok = true;
% -------------------------------------------------------------
% You can change these parameters
m    = 5; 
n    = 4;
N    = 3;
% -------------------------------------------------------------
rand('seed', 123);
p     = n * N;
r     = m * N;
mu    = 1.5;
s     = rand(r, 1);
y     = rand(p, 1);
u     = rand(r, 1);
b     = rand(r, 1);
d     = rand(p, 1);
Bdia  = rand(m, n, N);
Hdia  = rand(n, n, N);
Hlow  = rand(n, n, N);
B     = zeros(r, p);
H     = zeros(p, p);
blk_n = 1 : n;
blk_m = 1 : m;
for k = 1 : N
	B(blk_m, blk_n) = Bdia(:,:, k);
	H(blk_n, blk_n) = Hdia(:,:, k);
	blk_n           = blk_n + n;
	blk_m           = blk_m + m;
end
blk_n = 1 : n;
for k = 2 : N;
	blk_minus           = blk_n;
	blk_n               = blk_n + n;
	H(blk_n, blk_minus) = Hlow(:,:, k);
	H(blk_minus, blk_n) = Hlow(:,:, k)';
end 
% -------------------------------------
F = ckbs_kuhn_tucker(mu, s, y, u, b, d, Bdia, Hdia, Hlow);
% -------------------------------------
check = [ ...
	s + b + B * y; ...
	H * y + B' * u + d; ...
	s .* u - mu ...
];
ok    = ok & ( max(abs(F - check)) < 1e-10 );
return
end
% $$ $newlinech %$$
% $end
