% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin all_ok.m$$  $newlinech %$$
% $spell
%	nargin
%	ckbs
%	blkdiag
%	Mul
%	ok ok
%	ckbs_sumsq_hes
%	Obj
%	ckbs_tridiag_solve
%	feval
%	vec
%	cputime
%	cputime
%	disp
%	num2str
%	ind
%	findstr
%	Kuhn
%	dotdot
% $$
%
% $section Run All Correctness Tests$$
%
% $index all_ok$$
% $index test, run all$$
% $index correct, test all$$
%
% $head Syntax$$
% $syntax%all_ok
% all_ok(%quick%)%$$
%
% $head quick$$
% If $italic quick$$ is true (or not present), only the quick tests are run,
% otherwise all the tests are run.
%
% $children%
%	test/test_path.m
% %$$
% $head Test Utility Functions$$
% $table
% $rref test_path.m$$
% $tend
%
% $head Source Code$$
% $newlinech $$ $codep
function [ok] = all_ok(quick)
if nargin < 1
	quick = true;
end
test_path;
ok = true;
t0 = cputime;
ok = ok & one_ok('affine_ok_box');
ok = ok & one_ok('blkdiag_mul_ok');
ok = ok & one_ok('blkdiag_mul_t_ok');
ok = ok & one_ok('kuhn_tucker_ok');
ok = ok & one_ok('newton_step_ok');
ok = ok & one_ok('nonlinear_ok_simple');
ok = ok & one_ok('sumsq_grad_ok');
ok = ok & one_ok('sumsq_hes_ok');
ok = ok & one_ok('sumsq_obj_ok');
ok = ok & one_ok('tridiag_solve_ok');
if ~ quick
	ok = ok & one_ok('nonlinear_ok_box');
	ok = ok & one_ok('nonlinear_ok_sin');
end
% 
t1 = cputime;
if ok 
	disp(['All tests passed: cputime (secs) = ', num2str(t1-t0)]);
else
	disp(['One or more tests failed: cputime (secs) = ', num2str(t1-t0)]);
end
return
end
function [ok] = one_ok(name)
ok = feval(name);
if ok 
	['Ok:    ', name ]
else
	['Error: ', name ]
end
return
end
% $$ $newlinech %$$
% $end
