% -------------------------------------------------------------------
% ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
% Authors: Bradlely Bell:        bradbell at washington dot edu
%          Gianluigi Pillonetto: giapi at dei dot unipd dot it
% License: GNU General Public License Version 2
% -------------------------------------------------------------------
% $begin ckbs_blkdiag_mul$$ $newlinech %$$
% $spell
%	ckbs
%	blkdiag
%	Mul
%	Blk
%	Bdia
% $$
%
% $section Packed Block Diagonal Matrix Times a Vector$$
%
% $index ckbs_blkdiag_mul$$
% $index blkdiag_mul$$
%
% $index block, diagonal multiply$$
% $index diagonal, block multiply$$
% $index multiply, block diagonal$$
%
% $head Syntax$$
% $syntax%[%w%] = ckbs_blkdiag_mul(%Bdia%, %v%)%$$
%
% $head Purpose$$
% This routine enables one to used the packed form of a block diagonal matrix
% and returns the matrix times a vector; i.e.,
% $latex \[
%	w = B * v
% \] $$
%
% $head Bdia$$
% The argument $italic Bdia$$ is an $latex m \times n \times N$$ array.
% For $latex k = 1 , \ldots , N$$ we define $latex B_k \in \R^{m \times n}$$ by
% $latex \[
%	B_k = Bdia(:, :, k)
% \] $$
%
% $head B$$
% The matrix $latex B$$ is defined by
% $latex \[
% B 
% =
% \left( \begin{array}{cccc}
%	B_1 & 0      & 0      &           \\
%	0   & B_2    & 0      & 0         \\
%	0   & 0      & \ddots & 0         \\
%	    & 0      & 0      & B_N 
% \end{array} \right)
% \] $$
% 
% $head v$$
% The argument $italic v$$ is a column vector of length $latex n * N$$.
% 
% $head w$$
% The result $italic w$$ is a column vector of length $latex m * N$$.
% 
%
% $children#
%	test/blkdiag_mul_ok.m
% #$$
% 
% $head Example$$
% The file $cref/blkdiag_mul_ok.m/$$ contains an example and test of 
% $code ckbs_blkdiag_mul$$.
% It returns true if $code ckbs_blkdiag_mul$$ passes the test
% and false otherwise.
% 
% $end
% -------------------------------------------------------------------
function [w] = ckbs_blkdiag_mul(Bdia, v)
m     = size(Bdia, 1);
n     = size(Bdia, 2);
N     = size(Bdia, 3);
blk_m = 1 : m;
blk_n = 1 : n;
%
w     = zeros(m * N, 1);
for k = 1 : N;
	w(blk_m, :) = Bdia(:,:, k) * v(blk_n);
	blk_m = blk_m + m;
	blk_n = blk_n + n;
end
return
end
