#! /bin/bash
# -------------------------------------------------------------------
# ckbs: Constrained Kalman-Bucy Smoother Program: Copyright (C) 2006
# Authors: Bradlely Bell:        bradbell at washington dot edu
#          Gianluigi Pillonetto: giapi at dei dot unipd dot it
# License: GNU General Public License Version 2
# ----------------------------------------------------------------------------
echo "Current revision number = "
rev=`svn info --revision HEAD | grep '^Revision:' | sed -e 's|^Revision: *||'`
echo "$rev"
stable_version=`date +%F |sed -e 's/-//g' -e 's|^|0.|'`
repository="https://projects.coin-or.org/svn/CoinBazaar/projects/ckbs"
rep_trunk="$repository/trunk"
rep_stable="$repository/stable/$stable_version"
rep_release="$repository/releases/$stable_version.0"
#
# check initial working directory
dir=`pwd | sed -e 's|.*/||'`
if [ "$dir" != "trunk" ]
then
	echo "new_stable.sh: must execute this script in the trunk"
	exit 1
fi
doc_version=`grep '$section' omh/ckbs.omh | \
	sed -e 's|.*ckbs-\([0-9.]\{10\}\).*|\1|'`
if [ "$doc_version" != "$stable_version" ]
then
	echo "new_stable.sh: run ./copy_doc.sh to bring doc version up to date"
	echo "new_stable.sh: stable_version = $stable_version"
	echo "new_stable.sh: doc_version    = $doc_version"
	exit 1
fi
#
# create the new stable version
msg="[ckbs/stable] Create ckbs/stable/$stable_version 
from ckbs/trunk at revision $rev."
echo "svn copy $rep_trunk $rep_stable -m \"$msg\""
if ! svn copy  $rep_trunk $rep_stable -m "$msg"
then
	"new_stable.sh: Cannot create $rep_stable"
	exit 1
fi
#
# create the new release version
msg="[ckbs/releases] Create ckbs/releases/$stable_version.0 
from ckbs/stable/$stable_version at revision $rev."
echo "svn copy $rep_stable $rep_release -m \"$msg\""
if ! svn copy  $rep_stable $rep_release -m "$msg"
then
	"new_stable.sh: Cannot create $rep_release"
	exit 1
fi
echo ""
echo "To check out this stable version use the command:"
echo "	svn_checkout.sh ckbs stable/$stable_version"
echo "To check out this release version use the command:"
echo "	svn_checkout.sh ckbs releases/$stable_version.0"
