
/***********************************************************************
*  This code is part of Coliop3
*
*  Coliop3 and CMPL are projects of the Institute for Operations Research
*  and Business Management at the Martin Luther University Halle-Wittenberg 
*  and the University of Applied Sciences Wildau. 
*  Please visit the project homepage <www.coliop.org>
*
*  Coliop3 is free software: you can redistribute it and/or modify it
*  under the terms of the GNU General Public License as published by
*  the Free Software Foundation, either version 3 of the License, or
*  (at your option) any later version.
*
*  Coliop3 is distributed in the hope that it will be useful, but WITHOUT
*  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*  or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public
*  License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with Coliop. If not, see <http://www.gnu.org/licenses/>.
***********************************************************************/

package coliop3;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.*;

import javax.swing.JOptionPane;
/**
/**
 *
 * @author  Mike Steglich
 */
public class ColiopOptions extends javax.swing.JDialog {
    
    
    protected String clpPrg;
    /** Creates new form koliopOptions
     * @param parent */
    public ColiopOptions(java.awt.Frame parent) {
        super(parent, true);
        initComponents();

        pack();
        Rectangle parentBounds = parent.getBounds();
        Dimension size = getSize();
        // Center in the parent
        int x = Math.max(0, parentBounds.x + (parentBounds.width - size.width) / 2);
        int y = Math.max(0, parentBounds.y + (parentBounds.height - size.height) / 2);
        setLocation(new Point(x, y));
        
        clpOptionsRead();
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        clpPreferredSolverButtonGroup = new javax.swing.ButtonGroup();
        clpOptionsSaveButton = new javax.swing.JButton();
        clpOptionsCancelButton = new javax.swing.JButton();
        clpOptionTab = new javax.swing.JTabbedPane();
        clpHomeOptionPanel = new javax.swing.JPanel();
        clpHomePathLabel = new javax.swing.JLabel();
        clpHomePathLocation = new javax.swing.JTextField();
        clpFontSizeOptionPanel = new javax.swing.JPanel();
        clpFontSizeOptionBox = new javax.swing.JComboBox();
        jLabel1 = new javax.swing.JLabel();
        clpHelpPanel = new javax.swing.JPanel();
        clpBrowserLocationLabel = new javax.swing.JLabel();
        clpBrowserArgumentsLabel = new javax.swing.JLabel();
        clpBrowserLocationField = new javax.swing.JTextField();
        clpBrowserArgumentsField = new javax.swing.JTextField();
        clpCMPLPanel = new javax.swing.JPanel();
        clpKLMPArgumentsLabel = new javax.swing.JLabel();
        clpKLMPLocationLabel = new javax.swing.JLabel();
        clpKLMPArgumentsField = new javax.swing.JTextField();
        clpKLMPLocationField = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Coliop Options");
        setName("clpSolverKLMPOptions"); // NOI18N
        setResizable(false);

        clpOptionsSaveButton.setText("OK");
        clpOptionsSaveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clpOptionsSaveButtonActionPerformed(evt);
            }
        });

        clpOptionsCancelButton.setText("Cancel");
        clpOptionsCancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clpOptionsCancelButtonActionPerformed(evt);
            }
        });

        clpHomePathLabel.setText("Projects Path:");

        org.jdesktop.layout.GroupLayout clpHomeOptionPanelLayout = new org.jdesktop.layout.GroupLayout(clpHomeOptionPanel);
        clpHomeOptionPanel.setLayout(clpHomeOptionPanelLayout);
        clpHomeOptionPanelLayout.setHorizontalGroup(
            clpHomeOptionPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(clpHomeOptionPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(clpHomePathLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(clpHomePathLocation, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 662, Short.MAX_VALUE)
                .addContainerGap())
        );
        clpHomeOptionPanelLayout.setVerticalGroup(
            clpHomeOptionPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(clpHomeOptionPanelLayout.createSequentialGroup()
                .add(21, 21, 21)
                .add(clpHomeOptionPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(clpHomePathLocation, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(clpHomePathLabel))
                .addContainerGap(45, Short.MAX_VALUE))
        );

        clpOptionTab.addTab("Project Home", clpHomeOptionPanel);

        clpFontSizeOptionBox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24" }));

        jLabel1.setText("Font size for editor and viewers:");

        org.jdesktop.layout.GroupLayout clpFontSizeOptionPanelLayout = new org.jdesktop.layout.GroupLayout(clpFontSizeOptionPanel);
        clpFontSizeOptionPanel.setLayout(clpFontSizeOptionPanelLayout);
        clpFontSizeOptionPanelLayout.setHorizontalGroup(
            clpFontSizeOptionPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(clpFontSizeOptionPanelLayout.createSequentialGroup()
                .add(103, 103, 103)
                .add(jLabel1)
                .add(29, 29, 29)
                .add(clpFontSizeOptionBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(391, Short.MAX_VALUE))
        );
        clpFontSizeOptionPanelLayout.setVerticalGroup(
            clpFontSizeOptionPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(clpFontSizeOptionPanelLayout.createSequentialGroup()
                .add(20, 20, 20)
                .add(clpFontSizeOptionPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(clpFontSizeOptionBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabel1))
                .addContainerGap(47, Short.MAX_VALUE))
        );

        clpOptionTab.addTab("Font Size", clpFontSizeOptionPanel);

        clpBrowserLocationLabel.setText("Location:");

        clpBrowserArgumentsLabel.setText("Arguments:");

        org.jdesktop.layout.GroupLayout clpHelpPanelLayout = new org.jdesktop.layout.GroupLayout(clpHelpPanel);
        clpHelpPanel.setLayout(clpHelpPanelLayout);
        clpHelpPanelLayout.setHorizontalGroup(
            clpHelpPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(clpHelpPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(clpHelpPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(clpBrowserArgumentsLabel)
                    .add(clpBrowserLocationLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(clpHelpPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(clpBrowserArgumentsField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 674, Short.MAX_VALUE)
                    .add(clpBrowserLocationField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 674, Short.MAX_VALUE))
                .addContainerGap())
        );
        clpHelpPanelLayout.setVerticalGroup(
            clpHelpPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(clpHelpPanelLayout.createSequentialGroup()
                .add(20, 20, 20)
                .add(clpHelpPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(clpBrowserLocationField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(clpBrowserLocationLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(clpHelpPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(clpBrowserArgumentsLabel)
                    .add(clpBrowserArgumentsField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        clpOptionTab.addTab("Help Browser", clpHelpPanel);

        clpKLMPArgumentsLabel.setText("Arguments:");

        clpKLMPLocationLabel.setText("Location:");

        org.jdesktop.layout.GroupLayout clpCMPLPanelLayout = new org.jdesktop.layout.GroupLayout(clpCMPLPanel);
        clpCMPLPanel.setLayout(clpCMPLPanelLayout);
        clpCMPLPanelLayout.setHorizontalGroup(
            clpCMPLPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, clpCMPLPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(clpCMPLPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(clpKLMPLocationLabel)
                    .add(clpKLMPArgumentsLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(clpCMPLPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(clpKLMPArgumentsField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 674, Short.MAX_VALUE)
                    .add(clpKLMPLocationField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 674, Short.MAX_VALUE))
                .addContainerGap())
        );
        clpCMPLPanelLayout.setVerticalGroup(
            clpCMPLPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(clpCMPLPanelLayout.createSequentialGroup()
                .add(20, 20, 20)
                .add(clpCMPLPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(clpKLMPLocationField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(clpKLMPLocationLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(clpCMPLPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(clpKLMPArgumentsField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(clpKLMPArgumentsLabel))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        clpOptionTab.addTab("CMPL", clpCMPLPanel);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(clpOptionTab)
                    .add(layout.createSequentialGroup()
                        .add(clpOptionsSaveButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(clpOptionsCancelButton)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {clpOptionsCancelButton, clpOptionsSaveButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(clpOptionTab, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 140, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(clpOptionsCancelButton)
                    .add(clpOptionsSaveButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void clpOptionsCancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpOptionsCancelButtonActionPerformed
        setVisible(false);
        dispose();
}//GEN-LAST:event_clpOptionsCancelButtonActionPerformed

    private void clpOptionsSaveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpOptionsSaveButtonActionPerformed
       clpOptionsWrite();
    }//GEN-LAST:event_clpOptionsSaveButtonActionPerformed
    
   
    private void clpOptionsRead(){
        
        BufferedReader clpOptFile; 
       
        String zeile = null ;
        int i=0;
    	File pfad = new File("");
        
        String optFilePath;
        String optFile;
       
        if ( System.getProperty("os.name", "unknown").indexOf("Windows")==-1)  optFilePath=System.getenv("HOME"); 
        else optFilePath=System.getenv("HOMEPATH"); 
        
        optFilePath+="/.coliop/";
        optFile = optFilePath+"Coliop3.opt";
        
        
        try {
           clpOptFile = new BufferedReader ( new FileReader(optFile));
           
           while (( zeile = clpOptFile.readLine()) != null) {
               i++;
               
               switch (i) {
                   case 1: { clpHomePathLocation.setText(zeile);  break;}
                   case 2: { clpBrowserLocationField.setText(zeile); break;}
                   case 3: { clpBrowserArgumentsField.setText(zeile);  break;}
                   case 4: { clpKLMPLocationField.setText(zeile); break;}
                   case 5: { clpKLMPArgumentsField.setText(zeile); break;}
                   case 6: { clpPrg=zeile; break; }
                   case 7: { clpFontSizeOptionBox.setSelectedIndex(Integer.parseInt(  zeile.substring(14)) -8);  break;}
                   
               }
                      
           }
               
          clpOptFile.close();
            
        } catch (IOException e ) {
            
            JOptionPane.showMessageDialog(this,
                    "Internal Error - Cant read the option file!\n"+ e+"\n"+ pfad.getAbsolutePath(),
                    "ERROR", JOptionPane.WARNING_MESSAGE);
            
            setVisible(false);
            dispose();
        }
        
        
    }
    
    private void clpOptionsWrite() {
       
        String optFilePath;
        String optFile;
       
        if ( System.getProperty("os.name", "unknown").indexOf("Windows")==-1)  optFilePath=System.getenv("HOME"); 
        else optFilePath=System.getenv("HOMEPATH"); 
        
        optFilePath+="/.coliop/";
        optFile = optFilePath+"Coliop3.opt";

        int i=0;

        try {
  
            PrintWriter clpOptFile = new PrintWriter (new FileWriter (optFile) );
            
             clpOptFile.println( clpHomePathLocation.getText() );
             clpOptFile.println( clpBrowserLocationField.getText() ); 
             clpOptFile.println( clpBrowserArgumentsField.getText() ); 
             clpOptFile.println( clpKLMPLocationField.getText() ); 
             clpOptFile.println( clpKLMPArgumentsField.getText() ); 
             clpOptFile.println( clpPrg); 
             clpOptFile.println( "Courier-plain-"+ (String) clpFontSizeOptionBox.getSelectedItem()); 
             
           
            clpOptFile.close();
            
        } catch (IOException e) {
              JOptionPane.showMessageDialog(this,
                    "Internal Error - Cant write the option file!\n"+ e,
                    "ERROR", JOptionPane.WARNING_MESSAGE);
            
        }
        setVisible(false);
        dispose();

        
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane clpOptionTab;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField clpBrowserArgumentsField;
    private javax.swing.JLabel clpBrowserArgumentsLabel;
    private javax.swing.JTextField clpBrowserLocationField;
    private javax.swing.JLabel clpBrowserLocationLabel;
    private javax.swing.JComboBox clpFontSizeOptionBox;
    private javax.swing.JPanel clpFontSizeOptionPanel;
    private javax.swing.JPanel clpHelpPanel;
    private javax.swing.JPanel clpHomeOptionPanel;
    private javax.swing.JLabel clpHomePathLabel;
    private javax.swing.JTextField clpHomePathLocation;
    private javax.swing.JTextField clpKLMPArgumentsField;
    private javax.swing.JLabel clpKLMPArgumentsLabel;
    private javax.swing.JTextField clpKLMPLocationField;
    private javax.swing.JLabel clpKLMPLocationLabel;
    private javax.swing.JPanel clpCMPLPanel;
    private javax.swing.JButton clpOptionsCancelButton;
    private javax.swing.JButton clpOptionsSaveButton;
    private javax.swing.ButtonGroup clpPreferredSolverButtonGroup;
    // End of variables declaration//GEN-END:variables
    
}
