/**
 * *********************************************************************
 * This code is part of Coliop3
 * 
* Coliop3 and CMPL are projects of the Institute for Operations Research and
 * Business Management at the Martin Luther University Halle-Wittenberg and the
 * University of Applied Sciences Wildau. Please visit the project homepage
 * <www.coliop.org>
 *
 * Coliop3 is free software: you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
* Coliop3 is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
* You should have received a copy of the GNU General Public License along with
 * Coliop. If not, see <http://www.gnu.org/licenses/>.
**********************************************************************
 */
package coliop3;

import com.apple.eawt.Application;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import javax.swing.JFileChooser;

/**
 *
 * @author Mike Steglich
 */
public class Coliop3 extends javax.swing.JFrame {

    public Coliop clp;

    public ColiopRunProgs activeSolverHandler;

    //private boolean solveInterupted;
    private PipedInputStream cmplIn;
    private PipedOutputStream cmplOut;

    private PipedInputStream solverIn;
    private PipedOutputStream solverOut;

    final UndoManager cmplEditorUndomanager = new UndoManager();

    /**
     * Creates new form koliopUI
     */
    public Coliop3() {

        initComponents();

        cmplEditor.getDocument().addUndoableEditListener(cmplEditorUndomanager);
        cmplEditorUndomanager.setLimit(1000);

        clp = new Coliop();
        
               
        setButtons("init");
        setTitle();
        clpSetFont();
        
        
        
        
      //   solveInterupted=false;
    }

    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {

                System.setProperty("apple.laf.useScreenMenuBar", "true");
                            
                Coliop3 clpUI = new Coliop3();

                if (System.getProperty("os.name", "unknown").indexOf("Mac") != -1) {
                    Application app;
                    app = new Application();

                    app.addPreferencesMenuItem(); // "Einstellen..." Dialog
                    app.setEnabledPreferencesMenu(true); // diesen Dialog auch freischalten

                    app.addApplicationListener(new ColiopMacApplicationListener(clpUI, clpUI));

                }
                
                Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                double width = screenSize.getWidth();
                double height = screenSize.getHeight();

                if ( (screenSize.getWidth()<1200) || (screenSize.getHeight()<750)) {
                    clpUI.setExtendedState(clpUI.getExtendedState() | clpUI.MAXIMIZED_BOTH);
                }
                
                clpUI.setVisible(true);
                
             
            }
        });
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        clpEditPanel = new javax.swing.JTabbedPane();
        clpCMPLTab = new javax.swing.JPanel();
        clpCMPLEditorScrollPanel = new javax.swing.JScrollPane();
        cmplEditor = new javax.swing.JTextArea();
        solveButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        goToLineButton = new javax.swing.JButton();
        cmplFilesComboBox = new javax.swing.JComboBox();
        clpMatrixTab = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        matrixViewer = new javax.swing.JTextArea();
        clpSolutionTab = new javax.swing.JPanel();
        jScrollPane4 = new javax.swing.JScrollPane();
        solutionViewer = new javax.swing.JTextArea();
        clpLogPanel = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        jScrollPane2 = new javax.swing.JScrollPane();
        cmplLog = new javax.swing.JTextArea();
        clpClearCMPLLogButton = new javax.swing.JButton();
        clpStatusBar = new javax.swing.JLabel();
        clpMenuBar = new javax.swing.JMenuBar();
        clpFileMenue = new javax.swing.JMenu();
        clpMenueNewWindow = new javax.swing.JMenuItem();
        jSeparator13 = new javax.swing.JSeparator();
        clpMenueNewProblem = new javax.swing.JMenuItem();
        clpMenueOpenProblem = new javax.swing.JMenuItem();
        clpFileMenueSaveProblem = new javax.swing.JMenuItem();
        clpFileMenueSaveProblemAs = new javax.swing.JMenuItem();
        jSeparator7 = new javax.swing.JSeparator();
        clpMenuPrint = new javax.swing.JMenuItem();
        jSeparator9 = new javax.swing.JSeparator();
        clpMenueQuit = new javax.swing.JMenuItem();
        clpEditMenue = new javax.swing.JMenu();
        clpEditMenuUndo = new javax.swing.JMenuItem();
        clpEditMenuRedo = new javax.swing.JMenuItem();
        jSeparator10 = new javax.swing.JSeparator();
        clpEditMenuCut = new javax.swing.JMenuItem();
        clpEditMenuCopy = new javax.swing.JMenuItem();
        clpEditMenuPaste = new javax.swing.JMenuItem();
        jSeparator11 = new javax.swing.JSeparator();
        clpEditMenuGoToRow = new javax.swing.JMenuItem();
        clpActionMenue = new javax.swing.JMenu();
        clpActionMenueSolve = new javax.swing.JMenuItem();
        clpActionMenueCancel = new javax.swing.JMenuItem();
        clpOptionsMenue = new javax.swing.JMenu();
        clpKLMPSolverOptionsItem2 = new javax.swing.JMenuItem();
        clpHelpMenue = new javax.swing.JMenu();
        clpMenueAbout = new javax.swing.JMenuItem();
        jSeparator12 = new javax.swing.JSeparator();
        clpMenueCMPLHelp = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                formWindowClosing(evt);
            }
        });

        clpEditPanel.setFont(clpEditPanel.getFont());

        cmplEditor.setColumns(20);
        cmplEditor.setFont(new java.awt.Font("Courier", 0, 13)); // NOI18N
        cmplEditor.setRows(5);
        cmplEditor.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                cmplEditorInputMethodTextChanged(evt);
            }
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
        });
        cmplEditor.getDocument().addDocumentListener( new DocumentListener() {

            public void insertUpdate(DocumentEvent arg0) {
                clpCMPLEditorTextChanged();
            }

            public void removeUpdate(DocumentEvent arg0) {
                clpCMPLEditorTextChanged();
            }

            public void changedUpdate(DocumentEvent arg0) {
                clpCMPLEditorTextChanged();
            }
        }
    );
    clpCMPLEditorScrollPanel.setViewportView(cmplEditor);

    solveButton.setText("Solve");
    solveButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            startSolver(evt);
        }
    });

    cancelButton.setText("Cancel ");
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            interuptSolverHandler(evt);
        }
    });

    goToLineButton.setText("Go to Line");
    goToLineButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            goToLineButtonActionPerformed(evt);
        }
    });

    cmplFilesComboBox.setMaximumRowCount(20);
    cmplFilesComboBox.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            cmplFilesComboBoxActionPerformed(evt);
        }
    });
    cmplFilesComboBox.addFocusListener(new java.awt.event.FocusAdapter() {
        public void focusGained(java.awt.event.FocusEvent evt) {
            cmplFilesComboBoxFocusGained(evt);
        }
    });

    org.jdesktop.layout.GroupLayout clpCMPLTabLayout = new org.jdesktop.layout.GroupLayout(clpCMPLTab);
    clpCMPLTab.setLayout(clpCMPLTabLayout);
    clpCMPLTabLayout.setHorizontalGroup(
        clpCMPLTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(org.jdesktop.layout.GroupLayout.TRAILING, clpCMPLTabLayout.createSequentialGroup()
            .addContainerGap()
            .add(clpCMPLTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                .add(clpCMPLEditorScrollPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 1103, Short.MAX_VALUE)
                .add(clpCMPLTabLayout.createSequentialGroup()
                    .add(goToLineButton)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(cmplFilesComboBox, 0, 825, Short.MAX_VALUE)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(cancelButton)
                    .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                    .add(solveButton)))
            .addContainerGap())
    );

    clpCMPLTabLayout.linkSize(new java.awt.Component[] {cancelButton, solveButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

    clpCMPLTabLayout.setVerticalGroup(
        clpCMPLTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(org.jdesktop.layout.GroupLayout.TRAILING, clpCMPLTabLayout.createSequentialGroup()
            .add(clpCMPLEditorScrollPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 398, Short.MAX_VALUE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(clpCMPLTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                .add(goToLineButton)
                .add(cmplFilesComboBox, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(solveButton)
                .add(cancelButton)))
    );

    clpEditPanel.addTab("CMPL", clpCMPLTab);

    matrixViewer.setColumns(20);
    matrixViewer.setRows(5);
    jScrollPane1.setViewportView(matrixViewer);

    org.jdesktop.layout.GroupLayout clpMatrixTabLayout = new org.jdesktop.layout.GroupLayout(clpMatrixTab);
    clpMatrixTab.setLayout(clpMatrixTabLayout);
    clpMatrixTabLayout.setHorizontalGroup(
        clpMatrixTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(clpMatrixTabLayout.createSequentialGroup()
            .addContainerGap()
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 1131, Short.MAX_VALUE)
            .addContainerGap())
    );
    clpMatrixTabLayout.setVerticalGroup(
        clpMatrixTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(clpMatrixTabLayout.createSequentialGroup()
            .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 421, Short.MAX_VALUE)
            .add(12, 12, 12))
    );

    clpEditPanel.addTab("Generated Model", clpMatrixTab);

    solutionViewer.setEditable(false);
    solutionViewer.setColumns(20);
    solutionViewer.setFont(new java.awt.Font("Courier", 0, 13)); // NOI18N
    solutionViewer.setRows(5);
    jScrollPane4.setViewportView(solutionViewer);

    org.jdesktop.layout.GroupLayout clpSolutionTabLayout = new org.jdesktop.layout.GroupLayout(clpSolutionTab);
    clpSolutionTab.setLayout(clpSolutionTabLayout);
    clpSolutionTabLayout.setHorizontalGroup(
        clpSolutionTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(clpSolutionTabLayout.createSequentialGroup()
            .addContainerGap()
            .add(jScrollPane4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 1131, Short.MAX_VALUE)
            .addContainerGap())
    );
    clpSolutionTabLayout.setVerticalGroup(
        clpSolutionTabLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(clpSolutionTabLayout.createSequentialGroup()
            .add(jScrollPane4, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 421, Short.MAX_VALUE)
            .add(12, 12, 12))
    );

    clpEditPanel.addTab("Solution", clpSolutionTab);

    clpLogPanel.setMaximumSize(new java.awt.Dimension(106, 67));

    jScrollPane2.setAutoscrolls(true);

    cmplLog.setEditable(false);
    cmplLog.setColumns(20);
    cmplLog.setFont(new java.awt.Font("Courier", 0, 13)); // NOI18N
    cmplLog.setLineWrap(true);
    cmplLog.setRows(5);
    cmplLog.setAutoscrolls(false);
    cmplLog.setMaximumSize(new java.awt.Dimension(2147483647, 100));
    jScrollPane2.setViewportView(cmplLog);

    clpClearCMPLLogButton.setText("Clear Messages");
    clpClearCMPLLogButton.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpClearCMPLLogButtonActionPerformed(evt);
        }
    });

    org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
    jPanel1.setLayout(jPanel1Layout);
    jPanel1Layout.setHorizontalGroup(
        jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(jPanel1Layout.createSequentialGroup()
            .addContainerGap()
            .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                .add(org.jdesktop.layout.GroupLayout.TRAILING, jScrollPane2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 1131, Short.MAX_VALUE)
                .add(org.jdesktop.layout.GroupLayout.TRAILING, clpClearCMPLLogButton))
            .addContainerGap())
    );
    jPanel1Layout.setVerticalGroup(
        jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(jPanel1Layout.createSequentialGroup()
            .add(jScrollPane2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 167, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(clpClearCMPLLogButton)
            .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
    );

    clpLogPanel.addTab("Messages", jPanel1);

    clpStatusBar.setFont(new java.awt.Font("Lucida Grande", 0, 10)); // NOI18N
    clpStatusBar.setForeground(new java.awt.Color(51, 51, 51));
    clpStatusBar.setText("jLabel1");
    clpStatusBar.setAlignmentY(0.0F);
    clpStatusBar.setBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.RAISED));

    clpFileMenue.setText("File");
    clpFileMenue.setFont(clpFileMenue.getFont());

    clpMenueNewWindow.setText("New Window");
    clpMenueNewWindow.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpMenueNewWindowActionPerformed(evt);
        }
    });
    clpFileMenue.add(clpMenueNewWindow);
    clpFileMenue.add(jSeparator13);

    clpMenueNewProblem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpMenueNewProblem.setText("New Problem");
    clpMenueNewProblem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpFileMenueNewProblemActionPerformed(evt);
        }
    });
    clpFileMenue.add(clpMenueNewProblem);

    clpMenueOpenProblem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_O, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpMenueOpenProblem.setText("Open Problem");
    clpMenueOpenProblem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpMenueOpenProblemActionPerformed(evt);
        }
    });
    clpFileMenue.add(clpMenueOpenProblem);

    clpFileMenueSaveProblem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpFileMenueSaveProblem.setText("Save File");
    clpFileMenueSaveProblem.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpFileMenueSaveProblemActionPerformed(evt);
        }
    });
    clpFileMenue.add(clpFileMenueSaveProblem);

    clpFileMenueSaveProblemAs.setText("Save File As...");
    clpFileMenueSaveProblemAs.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpFileMenueSaveProblemAsActionPerformed(evt);
        }
    });
    clpFileMenue.add(clpFileMenueSaveProblemAs);
    clpFileMenue.add(jSeparator7);

    clpMenuPrint.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_P, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpMenuPrint.setText("Print");
    clpMenuPrint.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpMenuPrintActionPerformed(evt);
        }
    });
    clpFileMenue.add(clpMenuPrint);

    if ( System.getProperty("os.name", "unknown").indexOf("Mac")==-1) {
        clpFileMenue.add(jSeparator9);
    };

    clpMenueQuit.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Q, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpMenueQuit.setText("Exit");
    clpMenueQuit.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            exitColiop(evt);
        }
    });
    if ( System.getProperty("os.name", "unknown").indexOf("Mac")==-1) {
        clpFileMenue.add(clpMenueQuit);
    };

    clpMenuBar.add(clpFileMenue);

    clpEditMenue.setText("Edit");
    clpEditMenue.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            goToLineButtonActionPerformed(evt);
        }
    });

    clpEditMenuUndo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Z, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpEditMenuUndo.setText("Undo");
    clpEditMenuUndo.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpEditMenuUndoActionPerformed(evt);
        }
    });
    clpEditMenue.add(clpEditMenuUndo);

    clpEditMenuRedo.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_Y, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpEditMenuRedo.setText("Redo");
    clpEditMenuRedo.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpEditMenuRedoActionPerformed(evt);
        }
    });
    clpEditMenue.add(clpEditMenuRedo);
    clpEditMenue.add(jSeparator10);

    clpEditMenuCut.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_X, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpEditMenuCut.setText("Cut");
    clpEditMenuCut.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpEditMenuCutActionPerformed(evt);
        }
    });
    clpEditMenue.add(clpEditMenuCut);

    clpEditMenuCopy.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_C, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpEditMenuCopy.setText("Copy");
    clpEditMenuCopy.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpEditMenuCopyActionPerformed(evt);
        }
    });
    clpEditMenue.add(clpEditMenuCopy);

    clpEditMenuPaste.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_V, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpEditMenuPaste.setText("Paste");
    clpEditMenuPaste.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpEditMenuPasteActionPerformed(evt);
        }
    });
    clpEditMenue.add(clpEditMenuPaste);
    clpEditMenue.add(jSeparator11);

    clpEditMenuGoToRow.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_G, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
    clpEditMenuGoToRow.setText("Go to Line");
    clpEditMenuGoToRow.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpEditMenuGoToRowActionPerformed(evt);
        }
    });
    clpEditMenue.add(clpEditMenuGoToRow);

    clpMenuBar.add(clpEditMenue);

    clpActionMenue.setText("Actions");
    clpActionMenue.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            interuptSolverHandler(evt);
        }
    });

    clpActionMenueSolve.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F5, 0));
    clpActionMenueSolve.setText("Solve");
    clpActionMenueSolve.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            startSolver(evt);
        }
    });
    clpActionMenue.add(clpActionMenueSolve);

    clpActionMenueCancel.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_F6, 0));
    clpActionMenueCancel.setText("Cancel");
    clpActionMenueCancel.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            interuptSolverHandler(evt);
        }
    });
    clpActionMenue.add(clpActionMenueCancel);

    clpMenuBar.add(clpActionMenue);

    clpOptionsMenue.setText("Options");

    clpKLMPSolverOptionsItem2.setText("Coliop Options");
    clpKLMPSolverOptionsItem2.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpOptionsItemAction(evt);
        }
    });
    clpOptionsMenue.add(clpKLMPSolverOptionsItem2);

    if ( System.getProperty("os.name", "unknown").indexOf("Mac")==-1) {

        clpMenuBar.add(clpOptionsMenue);
    };

    clpHelpMenue.setText("Help");

    clpMenueAbout.setText("About Coliop 3");
    clpMenueAbout.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            koliopAboutItemActionPerformed(evt);
        }
    });
    if ( System.getProperty("os.name", "unknown").indexOf("Mac")==-1) {
        clpHelpMenue.add(clpMenueAbout);
    };

    if ( System.getProperty("os.name", "unknown").indexOf("Mac")==-1) {
        clpHelpMenue.add(jSeparator12);
    };

    clpMenueCMPLHelp.setText("CMPL Manual");
    clpMenueCMPLHelp.addActionListener(new java.awt.event.ActionListener() {
        public void actionPerformed(java.awt.event.ActionEvent evt) {
            clpMenueCMPLHelpActionPerformed(evt);
        }
    });
    clpHelpMenue.add(clpMenueCMPLHelp);

    clpMenuBar.add(clpHelpMenue);

    setJMenuBar(clpMenuBar);

    org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
    getContentPane().setLayout(layout);
    layout.setHorizontalGroup(
        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(org.jdesktop.layout.GroupLayout.TRAILING, clpEditPanel)
        .add(org.jdesktop.layout.GroupLayout.TRAILING, clpStatusBar, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        .add(org.jdesktop.layout.GroupLayout.TRAILING, clpLogPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
    );
    layout.setVerticalGroup(
        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
        .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
            .add(10, 10, 10)
            .add(clpEditPanel)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
            .add(clpLogPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 247, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
            .add(clpStatusBar))
    );

    getAccessibleContext().setAccessibleName("mainWindow");

    pack();
    }// </editor-fold>//GEN-END:initComponents

    public void clpSetFont() {
        cmplEditor.setFont(clp.clpFont);
        solutionViewer.setFont(clp.clpFont);
        cmplLog.setFont(clp.clpFont);
        matrixViewer.setFont(clp.clpFont);

    }

    private void koliopAboutItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_koliopAboutItemActionPerformed
        new ColiopAbout(this).setVisible(true);
}//GEN-LAST:event_koliopAboutItemActionPerformed

    private void clpFileMenueNewProblemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpFileMenueNewProblemActionPerformed
        if (clp.probChanged) {
            int ret = JOptionPane.showConfirmDialog(this,
                    "Save your problem?\n" + clp.name, "unsaved problem",
                    JOptionPane.YES_NO_CANCEL_OPTION);
            switch (ret) {
                case JOptionPane.YES_OPTION: {
                    clpSaveProblem(0);
                    clpNewProb();
                    break;
                }
                case JOptionPane.CANCEL_OPTION: {
                    break;
                }
                case JOptionPane.NO_OPTION: {
                    clpNewProb();
                    break;
                }
            }

        } else {
            clpNewProb();
            clpDeleteFileList();
        }

        setTitle();
        setButtons("init");
    }//GEN-LAST:event_clpFileMenueNewProblemActionPerformed

    private void clpNewProb() {
        clp.newProblem();
        cmplEditor.setText("parameters:\n\n\nvariables:\n\n\nobjectives:\n\n\nconstraints:\n\n\n");

        solutionViewer.setText("");
        clpDelMatrix();
        clpEditPanel.setSelectedIndex(0);
        clp.probChanged = false;

        clp.genFile = true;
        clp.clpExtension = ".cmpl";
    }


    private void clpFileMenueSaveProblemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpFileMenueSaveProblemActionPerformed
        clpSaveProblem(0);
}//GEN-LAST:event_clpFileMenueSaveProblemActionPerformed

    public int clpSaveProblem(int mode) {

        if (clp.name.equals("new problem") || mode == 1) {

            String tmpName;
            boolean isMainFile = false;
            boolean isExtension = true;
            boolean isError=false;

            if (clp.actCmplFile.toLowerCase().indexOf(".cmpl") != -1) {
                clp.clpExtension = ".cmpl";
                if (clp.actCmplFile.equals(clp.cmplFileName + clp.clpExtension)) {
                    isMainFile = true;
                }
            } else if (clp.actCmplFile.toLowerCase().indexOf(".cdat") != -1) {
                clp.clpExtension = ".cdat";
            } else if (clp.name.equals("new problem")) {
                clp.clpExtension = ".cmpl";
                isMainFile = true;
            }
           
            JFileChooser fd = new JFileChooser();
            fd.setCurrentDirectory(clp.homePath); // Pfad setzen
   
            fd.setFileFilter(new javax.swing.filechooser.FileFilter() {

                public boolean accept(File f) {
                    return f.getName().toLowerCase().endsWith(".cmpl") || f.getName().toLowerCase().endsWith(".cdat") ||f.isDirectory();
                }

                public String getDescription() {
                    return "Coliop and CmplData files";
                }
            });

            int r = fd.showSaveDialog(this);

            if (r == JFileChooser.APPROVE_OPTION) {
            
                tmpName=fd.getSelectedFile().getName();
                
                if (tmpName.indexOf(".") != -1) {
                    if (tmpName.toLowerCase().endsWith(".cmpl") && tmpName.toLowerCase().endsWith(".cdat")) {
                        if ((clp.clpExtension.equals(".cmpl") && !clp.cmplFileName.toLowerCase().endsWith(".cmpl"))
                                || (clp.clpExtension.equals(".cdat") && !clp.cmplFileName.toLowerCase().endsWith(".cdat"))) {
                            isError = true;
                        }
                    } else {
                        isError = true;
                    }
                } else {
                    isExtension = false;
                }

                if (isError) {
                    JOptionPane.showMessageDialog(this,
                            "Wrong file extension! \nMust be " + clp.clpExtension,
                            "ERROR", JOptionPane.WARNING_MESSAGE);
                    clp.clpExtension = ".cmpl";
                    return -1;
                }

                if (isExtension) {
                    clp.actCmplFile = fd.getSelectedFile().getAbsolutePath();
                    clp.name = tmpName.substring(0, tmpName.toLowerCase().lastIndexOf(clp.clpExtension));
                } else {
                    clp.actCmplFile = fd.getSelectedFile().getAbsolutePath()+  clp.clpExtension;
                    clp.name = tmpName;
                }

                if (isMainFile) {
                    if (isExtension) {
                        clp.cmplFileName = fd.getSelectedFile().getAbsolutePath();
                        clp.cmplFileName = clp.cmplFileName.substring(0, clp.cmplFileName.toLowerCase().lastIndexOf(clp.clpExtension));

                    } else {
                        clp.cmplFileName = fd.getSelectedFile().getAbsolutePath();
                    }
                }

            } else {
                clp.name = clp.oldName;
                clp.clpExtension = ".cmpl";
                return -1;
            }
        }

        if (clp.genFile) {
            if (clpWriteCMPLFile() == -1) {
                clp.clpExtension = ".cmpl";
                return -1;
            }
        }

        clp.clpExtension = ".cmpl";
        
        clpCmplFilesComboBoxItems();
        setStatusBar();
        setTitle();

        return 1;
    }

    private ArrayList clpGetArgumentsList(String clpCode, String clpArguments) {
        ArrayList cmplcode = new ArrayList();
        cmplcode.add(clpCode);

        int index1 = 0;
        int index2 = 0;
        int lastIndex1 = 0;
        int lastIndex2 = 0;

        while (index1 != -1) {
            index1 = clpArguments.indexOf("{", lastIndex1);
            index2 = clpArguments.indexOf("}", lastIndex2);
            if (index1 != -1) {
                cmplcode.add(clpArguments.substring(index1 + 1, index2));
            }
            lastIndex1 = index2++;
            lastIndex2 = index2++;
        }
        return cmplcode;
    }

    private void clpCMPLEditorTextChanged() {
        clp.probChanged = true;
        clp.genFile = true;
        clp.solFile = false;
        setButtons("init");
        setStatusBar();
    }

    private void clpMenueOpenProblemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpMenueOpenProblemActionPerformed
        if (clp.probChanged) {
            int ret = JOptionPane.showConfirmDialog(this,
                    "Save your problem?\n" + clp.name, "unsaved problem",
                    JOptionPane.YES_NO_CANCEL_OPTION);
            switch (ret) {
                case JOptionPane.CANCEL_OPTION:
                    break;
                case JOptionPane.YES_OPTION: {
                    clpSaveProblem(0);
                    clpOpenProblem();
                    break;
                }
                case JOptionPane.NO_OPTION: {
                    clpOpenProblem();
                    break;
                }
            }

        } else {
            clpOpenProblem();
        }
        setButtons("init");
    }//GEN-LAST:event_clpMenueOpenProblemActionPerformed

    private void clpClearCMPLLogButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpClearCMPLLogButtonActionPerformed

        cmplLog.setText("");

    }//GEN-LAST:event_clpClearCMPLLogButtonActionPerformed

    private void clpMenuPrintActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpMenuPrintActionPerformed

        String fName = clp.cmplFileName;

        switch (clpEditPanel.getSelectedIndex()) {
            case 0: {
                fName += clp.clpExtension;
                break;
            }
            case 1: {
                fName += ".mat";
                break;
            }
            case 2: {
                fName += ".sol";
                if (!solutionViewer.getText().isEmpty()) {
                    
                    try {
                        PrintWriter solFile = new PrintWriter(new FileWriter(fName));
                        solFile.println(solutionViewer.getText() + " ");
                        solFile.close();
                    } catch (IOException e) {

                    }
                
                }
                break;
            }
        }

        filePrinter sfp = new filePrinter(fName);
        if (sfp.setupPageFormat()) {
            if (sfp.setupJobOptions()) {
                try {
                    sfp.printFile();
                } catch (PrinterException e) {
                    JOptionPane.showMessageDialog(this,
                            "Internal Error - Cant print! \n Empty file",
                            "ERROR", JOptionPane.WARNING_MESSAGE);
                } catch (IOException e) {
                    JOptionPane.showMessageDialog(this,
                            "Internal Error - Cant print! \n Empty file",
                            "ERROR", JOptionPane.WARNING_MESSAGE);
                }
            }
        }
        if (clpEditPanel.getSelectedIndex() == 2) {
            if (checkFile(clp.cmplFileName + ".sol")) {
                File f = new File(clp.cmplFileName + ".sol");
                f.delete();
            }
        }
    }//GEN-LAST:event_clpMenuPrintActionPerformed

    private void clpMenueCMPLHelpActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpMenueCMPLHelpActionPerformed
        clpHelp("CMPL");
}//GEN-LAST:event_clpMenueCMPLHelpActionPerformed

    private void clpFileMenueSaveProblemAsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpFileMenueSaveProblemAsActionPerformed
        clp.oldName = clp.name;
        clp.name = "saveAs";
        clpSaveProblem(1);
        setTitle();
        setButtons("init");
        clp.probChanged = false;
    }//GEN-LAST:event_clpFileMenueSaveProblemAsActionPerformed

    private void goToLineButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_goToLineButtonActionPerformed
        clpGoToRow();
    }//GEN-LAST:event_goToLineButtonActionPerformed

    private void clpEditMenuUndoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpEditMenuUndoActionPerformed
        if (cmplEditorUndomanager.canUndo()) {
            cmplEditorUndomanager.undo();
        }

    }//GEN-LAST:event_clpEditMenuUndoActionPerformed

    private void clpEditMenuRedoActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpEditMenuRedoActionPerformed
        if (cmplEditorUndomanager.canRedo()) {
            cmplEditorUndomanager.redo();
        }
    }//GEN-LAST:event_clpEditMenuRedoActionPerformed

    private void clpEditMenuGoToRowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpEditMenuGoToRowActionPerformed
        clpGoToRow();
    }//GEN-LAST:event_clpEditMenuGoToRowActionPerformed

    private void clpEditMenuPasteActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpEditMenuPasteActionPerformed
        if (cmplEditor.isFocusOwner()) {
            cmplEditor.paste();
        }

    }//GEN-LAST:event_clpEditMenuPasteActionPerformed


    private void clpEditMenuCutActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpEditMenuCutActionPerformed
        if (cmplEditor.isFocusOwner()) {
            cmplEditor.cut();
        }
    }//GEN-LAST:event_clpEditMenuCutActionPerformed


    private void clpEditMenuCopyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpEditMenuCopyActionPerformed
        if (cmplEditor.isFocusOwner()) {
            cmplEditor.copy();
        }
    }//GEN-LAST:event_clpEditMenuCopyActionPerformed


    private void clpMenueNewWindowActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpMenueNewWindowActionPerformed

        String clpCode;
        String clpArgs;

        if (clp.loadOptions() == 1) {
            try {

                ArrayList clpCodes = new ArrayList();

                int index = clp.clpPath.indexOf("{", 0);

                if (index != -1) {

                    clpCode = clp.clpPath.substring(0, index);
                    clpArgs = clp.clpPath.substring(index, clp.clpPath.length());

                } else {
                    clpCode = clp.clpPath;
                    clpArgs = "";
                }

                clpCodes = clpGetArgumentsList(clpCode, clpArgs);

                ProcessBuilder launcher = new ProcessBuilder(clpCodes);
                launcher.redirectErrorStream(true);
                Process p = launcher.start();

            } catch (IOException e) {

                JOptionPane.showMessageDialog(this,
                        "Internal Error - Cant open a new Coliop3 window!\n" + e,
                        "ERROR", JOptionPane.WARNING_MESSAGE);
            }
        }
    }//GEN-LAST:event_clpMenueNewWindowActionPerformed


    private void cmplFilesComboBoxFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_cmplFilesComboBoxFocusGained
        clpCmplFilesComboBoxItems();
}//GEN-LAST:event_cmplFilesComboBoxFocusGained


    private void cmplFilesComboBoxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmplFilesComboBoxActionPerformed

        String selectedFile = (String) cmplFilesComboBox.getSelectedItem();
        if (selectedFile != null) {
            if (!selectedFile.equals(clp.actCmplFile)) {
                if (clp.probChanged) {
                    clpSaveProblem(0);
                }
                clp.actCmplFile = (String) cmplFilesComboBox.getSelectedItem();
                clpLoadAdditionalCMPLFile();
                setTitle();
            }
        }
    }//GEN-LAST:event_cmplFilesComboBoxActionPerformed


    private void cmplEditorInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_cmplEditorInputMethodTextChanged
        clp.probChanged = true;
}//GEN-LAST:event_cmplEditorInputMethodTextChanged


    private void interuptSolverHandler(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_interuptSolverHandler
        if (activeSolverHandler != null) {
            activeSolverHandler.interrupt();
        }
     //  solveInterupted=true;

        setButtons("init");
    }//GEN-LAST:event_interuptSolverHandler

    private void startSolver(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_startSolver
        solve();
    }//GEN-LAST:event_startSolver

    private void exitColiop(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitColiop
        exitClp();
    }//GEN-LAST:event_exitColiop

    private void formWindowClosing(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowClosing
        exitClp();
}//GEN-LAST:event_formWindowClosing

    private void clpOptionsItemAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clpOptionsItemAction
        new ColiopOptions(this).setVisible(true);
        clp.loadOptions();
        clpSetFont();
        setStatusBar();
    }//GEN-LAST:event_clpOptionsItemAction

    public void exitClp() {

        if (clp.probChanged) {
            int ret = JOptionPane.showConfirmDialog(this,
                    "Save your problem?\n" + clp.name, "unsaved problem",
                    JOptionPane.YES_NO_OPTION);
            if (ret == JOptionPane.YES_OPTION) {
                clpSaveProblem(0);
            }
        }

        if (activeSolverHandler != null && activeSolverHandler.isAlive()) {
            JOptionPane.showMessageDialog(this,
                    "Solver is running - Please cancel Solver before closing Coliop3",
                    "Solver is running", JOptionPane.WARNING_MESSAGE);

        } else {
            System.exit(0);
        }
    }

    private void clpDeleteFileList() {

        cmplFilesComboBox.removeAllItems();
        cmplFilesComboBox.requestFocus();
        cmplFilesComboBox.repaint();
    }

    private void clpCmplFilesComboBoxItems() {

        if (!clp.name.equals("new problem") && clp.actCmplFile.equals(clp.cmplFileName + clp.clpExtension)) {

            changeCmplFileList();

            cmplFilesComboBox.removeAllItems();

            for (int i = 0; i < clp.cmplFileList.size(); i++) {
                cmplFilesComboBox.addItem(clp.cmplFileList.get(i));
            }

            cmplFilesComboBox.requestFocus();
            cmplFilesComboBox.repaint();

            for (int i = 0; i < clp.cmplFileList.size(); i++) {
                if (cmplFilesComboBox.getItemAt(i).equals(clp.actCmplFile)) {
                    cmplFilesComboBox.setSelectedIndex(i);
                }
            }
        }
    }

    private void changeCmplFileList() {
        int importPos, pos, pos1, pos2, pos3;
        int importFileStartPos;
        int importFileEndPos;
        String tmpCode = "";
        boolean stdDataFile;

        if (clp.actCmplFile.equals(clp.cmplFileName + clp.clpExtension)) {

            clp.cmplFileList.clear();
            clp.cmplFileList.add(clp.cmplFileName + clp.clpExtension);

            String cmplCode = cmplEditor.getText();

            importPos = cmplCode.toLowerCase().indexOf("include", 0);

            while (importPos != -1) {

                pos = cmplCode.indexOf("\"", importPos);
                pos1 = cmplCode.indexOf("\n", importPos);

                if (pos1 < pos) {
                    importFileStartPos = -1;
                } else {
                    importFileStartPos = pos;
                }

                if (importFileStartPos != -1) {

                    pos = cmplCode.indexOf("\"", importFileStartPos + 1);
                    pos1 = cmplCode.indexOf("\n", importFileStartPos + 1);

                    if (pos1 < pos) {
                        importFileEndPos = -1;
                    } else {
                        importFileEndPos = pos;
                    }

                    if (importFileEndPos != -1) {

                        tmpCode = cmplCode.substring(importFileStartPos + 1, importFileEndPos);

                        if (System.getProperty("os.name", "unknown").indexOf("Windows") != -1) {
                            if (!tmpCode.substring(0, 1).equals("\\")) {
                                tmpCode = clp.cmplFileName.substring(0, clp.cmplFileName.lastIndexOf("\\")) + "\\" + tmpCode;
                            }
                        } else {
                            if (!tmpCode.substring(0, 1).equals("/")) {
                                tmpCode = clp.cmplFileName.substring(0, clp.cmplFileName.lastIndexOf("/")) + "/" + tmpCode;
                            }
                        }

                        clp.cmplFileList.add(tmpCode);

                        importPos = cmplCode.toLowerCase().indexOf("include", importFileEndPos);

                    } else {
                        importPos = -1;
                    }

                } else {
                    importPos = -1;
                }
            }

            stdDataFile = false;

            importPos = cmplCode.toLowerCase().indexOf("%data", 0);

            while (importPos != -1) {

                pos1 = cmplCode.indexOf("\n", importPos);
                pos2 = cmplCode.indexOf(":", importPos);

                if (pos1 < pos2) {
                    tmpCode = cmplCode.substring(importPos + 5, pos1).trim();
                } else {
                    tmpCode = cmplCode.substring(importPos + 5, pos2).trim();
                }

                if (tmpCode.isEmpty()) {
                    if (!stdDataFile) {
                        tmpCode = clp.name + ".cdat";
                        importFileStartPos = -1;
                        stdDataFile = true;
                    } else {
                        tmpCode = "";
                    }
                } else {

                    if (tmpCode.startsWith("\"")) {
                        tmpCode = tmpCode.substring(1);
                    }

                    if (tmpCode.endsWith("\"")) {
                        tmpCode = tmpCode.substring(0, tmpCode.length() - 1);
                    }

                }

                if (!tmpCode.isEmpty()) {

                    if (System.getProperty("os.name", "unknown").indexOf("Windows") != -1) {
                        if (!tmpCode.substring(0, 1).equals("\\")) {
                            tmpCode = clp.cmplFileName.substring(0, clp.cmplFileName.lastIndexOf("\\")) + "\\" + tmpCode;
                        }
                    } else {
                        if (!tmpCode.substring(0, 1).equals("/")) {
                            tmpCode = clp.cmplFileName.substring(0, clp.cmplFileName.lastIndexOf("/")) + "/" + tmpCode;
                        }
                    }

                    clp.cmplFileList.add(tmpCode);
                }
                importPos = cmplCode.toLowerCase().indexOf("%data", pos1);

            }

        }
    }

    private void clpGoToRow() {

        String returnValue = (String) JOptionPane.showInputDialog(this,
                "Go to row - max " + (cmplEditor.getLineCount() - 1),
                "Go to row  ",
                JOptionPane.QUESTION_MESSAGE);

        if (returnValue != null) {

            try {
                int row = Integer.parseInt(returnValue) - 1;

                int start = cmplEditor.getLineStartOffset(row);
                int end = cmplEditor.getLineEndOffset(row);

                cmplEditor.select(start, end);
                cmplEditor.requestFocusInWindow();

            } catch (NumberFormatException e) {

                JOptionPane.showMessageDialog(this,
                        returnValue + " is not a correct row number",
                        "ERROR", JOptionPane.WARNING_MESSAGE);
            } catch (BadLocationException e) {
                JOptionPane.showMessageDialog(this,
                        returnValue + " is not a correct row ",
                        "ERROR", JOptionPane.WARNING_MESSAGE);
            }
        }
    }

    private void clpHelp(String hlp) {

        if (hlp.equals("CMPL")) {

            if (clp.loadOptions() == 1) {
                try {

                    ArrayList hlpCodes = new ArrayList();

                    String appPath = System.getProperty("user.dir");

                    String hlpArgs = clp.browserArguments;

                    hlpCodes = clpGetArgumentsList(clp.browserFile, hlpArgs);
                    ProcessBuilder launcher = new ProcessBuilder(hlpCodes);
                    launcher.redirectErrorStream(true);
                    Process p = launcher.start();

                } catch (IOException e) {

                    JOptionPane.showMessageDialog(this,
                            "Internal Error - Cant catch the help browser!\n" + e,
                            "ERROR", JOptionPane.WARNING_MESSAGE);
                }
            }
        }
    }

    private void clpOpenProblem() {

        int dotCmpl = 0;
        String tmpName;

        JFileChooser fd = new JFileChooser();
        
        fd.setCurrentDirectory(clp.homePath);

        fd.setFileFilter(new javax.swing.filechooser.FileFilter() {

            public boolean accept(File f) {
                return f.getName().toLowerCase().endsWith(".cmpl") || f.isDirectory();
            }

            public String getDescription() {
                return "CMPL Files";
            }
        });

        int r = fd.showOpenDialog(this);
    

        if (r == JFileChooser.APPROVE_OPTION) {

            clp.cmplFileName = fd.getSelectedFile().getAbsolutePath();
            clp.actCmplFile = fd.getSelectedFile().getAbsolutePath();
            clp.name = fd.getSelectedFile().getName();
            
            dotCmpl = clp.cmplFileName.toLowerCase().lastIndexOf(".cmpl");
            clp.cmplFileName = clp.cmplFileName.substring(0, dotCmpl);

            clp.name = clp.name.substring(0, clp.name.toLowerCase().lastIndexOf(".cmpl"));

            clp.clpExtension = ".cmpl";
          
            cmplEditor.setText("");

            clpDelMatrix();
            solutionViewer.setText("");

            clp.genFile = true;
            clpLoadCMPLFile();
            clpCmplFilesComboBoxItems();
            clpEditPanel.setSelectedIndex(0);

            

            setTitle();
            setButtons("init");
        }
    }

    private boolean checkFile(String fileName) {
        File f = new File(fileName);
        return f.exists();
    }

    private void solve() {

        clp.oldName = clp.name;

        if (clpSaveProblem(0) == 1) {
            if (clp.loadOptions() == 1) {

                // general initialisation
                if (checkFile(clp.cmplFileName + ".mps")) {
                    File f = new File(clp.cmplFileName + ".mps");
                    f.delete();
                }

                if (checkFile(clp.cmplFileName + ".sol")) {
                    File f = new File(clp.cmplFileName + ".sol");
                    f.delete();
                }

                if (checkFile(clp.cmplFileName + ".mat")) {
                    File f = new File(clp.cmplFileName + ".mat");
                    f.delete();
                }

                setButtons("solveStart");

                clp.solFile = false;

                solutionViewer.setText("");
                clpDelMatrix();

//                solveInterupted=false;
                // Init CMPL
                String clpCMPLArgs = clp.cmplArguments.replace("$problem$", clp.cmplFileName);
                clpCMPLArgs = clpCMPLArgs.replace(".$ext$", clp.clpExtension);

                ArrayList cmplCode = new ArrayList();
                cmplCode = clpGetArgumentsList(clp.cmplFile, clpCMPLArgs);

                startMessagePipes();
                ColiopRunProgs solverHandler = new ColiopRunProgs(cmplOut);
                activeSolverHandler = solverHandler;
                solverHandler.setModel(cmplCode);
                solverHandler.start();
            }
        }
    }

    public int clpLoadSolutionFile() {
        BufferedReader clpSolutionFile;
        String zeile = null;

        try {
            clpSolutionFile = new BufferedReader(new FileReader(clp.cmplFileName + ".sol"));

            solutionViewer.setText("");

            while ((zeile = clpSolutionFile.readLine()) != null) {
                solutionViewer.append(zeile + "\n");
            }

            clpSolutionFile.close();

        } catch (IOException e) {

            JOptionPane.showMessageDialog(this,
                    "Internal Error - Cant read the Solution file!\n",
                    "ERROR", JOptionPane.WARNING_MESSAGE);

            return -1;
        }

        clp.solFile = true;

        clpEditPanel.setSelectedIndex(2);
        solutionViewer.select(1, 1);

        return 1;
    }

    private int clpWriteCMPLFile() {
        try {
            PrintWriter clpGenFile = new PrintWriter(new FileWriter(clp.actCmplFile));
            clpGenFile.println(cmplEditor.getText() + " ");
            clpGenFile.close();
        } catch (IOException e) {
            JOptionPane.showMessageDialog(this,
                    "Internal Error - Cant write the CMPL file!\n" + e,
                    "ERROR", JOptionPane.WARNING_MESSAGE);
            return -1;
        }
        clp.probChanged = false;
        return 1;
    }

    private int clpLoadCMPLFile() {
        BufferedReader clpCMPLFile;
        String zeile = null;

        try {
            clpCMPLFile = new BufferedReader(new FileReader(clp.cmplFileName + clp.clpExtension));
            cmplEditor.setText("");

            while ((zeile = clpCMPLFile.readLine()) != null) {

                cmplEditor.append(zeile + "\n");
            }

            clpCMPLFile.close();
        } catch (IOException e) {
            JOptionPane.showMessageDialog(this,
                    "Internal Error - Cant read the CMPL file!\n",
                    "ERROR", JOptionPane.WARNING_MESSAGE);
            return -1;
        }

        clp.genFile = true;
        clp.probChanged = false;
        clp.actCmplFile = clp.cmplFileName + clp.clpExtension;

        clpEditPanel.setSelectedIndex(0);
        cmplEditor.select(1, 1);

        return 1;
    }

    private int clpLoadAdditionalCMPLFile() {

        File addclpCMPLFile = new File(clp.actCmplFile);
        if (!addclpCMPLFile.exists()) {
            try {

                int ret = JOptionPane.showConfirmDialog(this, "CMPL file does not exist. Create this file?\n" + clp.actCmplFile, "Create this file?", JOptionPane.YES_NO_OPTION);

                if (ret == JOptionPane.YES_OPTION) {
                    addclpCMPLFile.createNewFile();
                } else {
                    return -1;
                }
            } catch (IOException e) {
                JOptionPane.showMessageDialog(this,
                        "Internal Error - Cant create the CMPL file!\n",
                        "ERROR", JOptionPane.WARNING_MESSAGE);
                return -1;
            }

        }

        BufferedReader clpCMPLFile;
        String zeile = null;

        try {
            clpCMPLFile = new BufferedReader(new FileReader(clp.actCmplFile));

            cmplEditor.setText("");

            while ((zeile = clpCMPLFile.readLine()) != null) {

                cmplEditor.append(zeile + "\n");
            }

            clpCMPLFile.close();

        } catch (IOException e) {

            JOptionPane.showMessageDialog(this,
                    "Internal Error - Cant read the CMPL file!\n",
                    "ERROR", JOptionPane.WARNING_MESSAGE);
            return -1;

        }

        clp.genFile = true;
        clp.probChanged = false;

        clpEditPanel.setSelectedIndex(0);
        cmplEditor.select(1, 1);

        return 1;
    }

    public void clpDelMatrix() {

        matrixViewer.setText("");

    }

    public int clpLoadMatrix(String mpsName) {

        BufferedReader matrixFile;
        String zeile = null;

        try {
            matrixFile = new BufferedReader(new FileReader(mpsName));
            matrixViewer.setText("");

            while ((zeile = matrixFile.readLine()) != null) {

                matrixViewer.append(zeile + "\n");
            }

            matrixFile.close();

        } catch (IOException e) {
            JOptionPane.showMessageDialog(this,
                    "Internal Error - Cant read the Matrix file!\n",
                    "ERROR", JOptionPane.WARNING_MESSAGE);
            return -1;
        }

        return 1;

    }

    private void getMatrix() {
        if (checkFile(clp.cmplFileName + ".mat")) {
            clpLoadMatrix(clp.cmplFileName + ".mat");

            File f = new File(clp.cmplFileName + ".mat");
            f.delete();
        }

        setButtons("init");
    }

    private void getSolution() {
        if (checkFile(clp.cmplFileName + ".sol")) {
            clp.solFile = true;
            clpLoadSolutionFile();
            selectEditPanel(2);
                
            File f = new File(clp.cmplFileName + ".sol");
            f.delete();
        } else {
            clp.solFile = false;
        }
        
        setButtons("init");
    }

    private void cmplMessages(PipedInputStream clpIn) {
        try {
            for (int c; (c = clpIn.read()) != -1;) {
                cmplLog.append("" + (char) c);
                cmplLog.select(cmplLog.getLineStartOffset(cmplLog.getLineCount() - 1), cmplLog.getLineStartOffset(cmplLog.getLineCount() - 1));
                //cmplLog.repaint();
                //clpLogPanel.setSelectedIndex(0);
            }
            getMatrix();
            getSolution();

        } catch (BadLocationException ex) {
            Logger.getLogger(Coliop3.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            System.out.println("error cmplMsg:" + ex.getMessage());
        }
    }

    public void startMessagePipes() {

        try {
            cmplIn = new PipedInputStream();
            cmplOut = new PipedOutputStream(cmplIn);

            solverIn = new PipedInputStream();
            solverOut = new PipedOutputStream(solverIn);

        } catch (IOException ex) {
            Logger.getLogger(Coliop3.class.getName()).log(Level.SEVERE, null, ex);
        }

        // message pipe for CMPL
        Runnable cmplMsg = new Runnable() {
            public void run() {
                cmplMessages(cmplIn);
            }
        };

        Thread threadCmplMsg = new Thread(cmplMsg, "threadCmplpMsg");
        threadCmplMsg.start();

    }

    private void setTitle() {

        int lastSlash = clp.actCmplFile.lastIndexOf("/") + 1;

        if (clp.actCmplFile.equals(clp.cmplFileName + clp.clpExtension) || clp.name.equals("new problem")) {
            this.setTitle("Coliop3 - " + clp.name);
        } else {
            this.setTitle("Coliop3 - " + clp.name + " < " + clp.actCmplFile.substring(lastSlash, clp.actCmplFile.length()) + " > ");
        }

        setStatusBar();

    }

    public void setStatusBar() {

        String statusText = clp.cmplFileName;

        clpStatusBar.setText(statusText);

    }

    public void selectEditPanel(int panelNumber) {
        clpEditPanel.setSelectedIndex(panelNumber);
    }

    public void setButtons(String clpMod) {

        if (clpMod.equals("solveStart")) {
            cmplEditor.setEditable(false);
            cancelButton.setEnabled(true);
            solveButton.setEnabled(false);
            clpActionMenueCancel.setEnabled(true);
            clpActionMenueSolve.setEnabled(false);
        }

        if (clpMod.equals("init")) {
            cmplEditor.setEditable(true);
            cancelButton.setEnabled(false);
            clpActionMenueCancel.setEnabled(false);
            if (clp.genFile) {
                solveButton.setEnabled(true);
                clpActionMenueSolve.setEnabled(true);
            } else {
                solveButton.setEnabled(false);
                clpActionMenueSolve.setEnabled(false);
            }
        }

    }


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JMenu clpActionMenue;
    private javax.swing.JMenuItem clpActionMenueCancel;
    private javax.swing.JMenuItem clpActionMenueSolve;
    private javax.swing.JScrollPane clpCMPLEditorScrollPanel;
    private javax.swing.JPanel clpCMPLTab;
    private javax.swing.JButton clpClearCMPLLogButton;
    private javax.swing.JMenuItem clpEditMenuCopy;
    private javax.swing.JMenuItem clpEditMenuCut;
    private javax.swing.JMenuItem clpEditMenuGoToRow;
    private javax.swing.JMenuItem clpEditMenuPaste;
    private javax.swing.JMenuItem clpEditMenuRedo;
    private javax.swing.JMenuItem clpEditMenuUndo;
    private javax.swing.JMenu clpEditMenue;
    private javax.swing.JTabbedPane clpEditPanel;
    private javax.swing.JMenu clpFileMenue;
    private javax.swing.JMenuItem clpFileMenueSaveProblem;
    private javax.swing.JMenuItem clpFileMenueSaveProblemAs;
    private javax.swing.JMenu clpHelpMenue;
    private javax.swing.JMenuItem clpKLMPSolverOptionsItem2;
    private javax.swing.JTabbedPane clpLogPanel;
    private javax.swing.JPanel clpMatrixTab;
    private javax.swing.JMenuBar clpMenuBar;
    private javax.swing.JMenuItem clpMenuPrint;
    private javax.swing.JMenuItem clpMenueAbout;
    private javax.swing.JMenuItem clpMenueCMPLHelp;
    private javax.swing.JMenuItem clpMenueNewProblem;
    private javax.swing.JMenuItem clpMenueNewWindow;
    private javax.swing.JMenuItem clpMenueOpenProblem;
    private javax.swing.JMenuItem clpMenueQuit;
    private javax.swing.JMenu clpOptionsMenue;
    private javax.swing.JPanel clpSolutionTab;
    private javax.swing.JLabel clpStatusBar;
    private javax.swing.JTextArea cmplEditor;
    private javax.swing.JComboBox cmplFilesComboBox;
    private javax.swing.JTextArea cmplLog;
    private javax.swing.JButton goToLineButton;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JScrollPane jScrollPane4;
    private javax.swing.JSeparator jSeparator10;
    private javax.swing.JSeparator jSeparator11;
    private javax.swing.JSeparator jSeparator12;
    private javax.swing.JSeparator jSeparator13;
    private javax.swing.JSeparator jSeparator7;
    private javax.swing.JSeparator jSeparator9;
    private javax.swing.JTextArea matrixViewer;
    private javax.swing.JTextArea solutionViewer;
    private javax.swing.JButton solveButton;
    // End of variables declaration//GEN-END:variables
}
