/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmplSet {
    private String _name;
    private int _type;
    private Object _valueList;
    private Object[] _valueArray;
    private int _rank;
    private int _valType;
    private int _count;

    private void setDefaults(String string) throws CmplException {
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            throw new CmplException("Set name " + string + " contains whitespaces");
        }
        this._name = string;
        this._type = 0;
        this._rank = 1;
        this._valueList = null;
        this._count = -99;
    }

    public CmplSet(String string, int n) throws CmplException {
        this.setDefaults(string);
        this._rank = n;
    }

    public CmplSet(String string) throws CmplException {
        this.setDefaults(string);
    }

    public String name() {
        return this._name;
    }

    public int type() {
        return this._type;
    }

    public int rank() {
        return this._rank;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int len() throws CmplException {
        if (this._count != -99) {
            return this._count;
        }
        this._count = 0;
        if (this._type == 0 || this._type == 1) {
            if (this._valType == 1) {
                this._count = ((ArrayList)this._valueList).size();
                return this._count;
            } else if (this._valueList instanceof int[]) {
                this._count = ((int[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof long[]) {
                this._count = ((long[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof Integer[]) {
                this._count = ((Integer[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof Long[]) {
                this._count = ((Long[])this._valueList).length;
                return this._count;
            } else if (this._valueList instanceof String[]) {
                this._count = ((String[])this._valueList).length;
                return this._count;
            } else {
                if (!(this._valueList instanceof Object[])) throw new CmplException("set " + this._name + " containts data with unsupported data type" + this._valueList.getClass().toString());
                this._count = ((Object[])this._valueList).length;
            }
            return this._count;
        } else if (this._type == 2) {
            this._count = (Integer)this._valueArray[1] - (Integer)this._valueArray[0] + 1;
            return this._count;
        } else {
            if (this._type != 3) return this._count;
            this._count = (Integer)this._valueArray[1] > 0 ? (int)Math.ceil(Double.valueOf((Integer)this._valueArray[2] - (Integer)this._valueArray[0] + 1) / (double)Math.abs((Integer)this._valueArray[1])) : (int)Math.ceil(Double.valueOf((Integer)this._valueArray[0] - (Integer)this._valueArray[2] + 1) / (double)Math.abs((Integer)this._valueArray[1]));
        }
        return this._count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object get(int n) throws CmplException {
        if (this._type == 1) {
            throw new CmplException("CmplSet.get(int i) is not apllicable for tuple sets with rank>1 -> " + this._name);
        }
        Object object = null;
        boolean bl = false;
        if (this._valType == 1) {
            if (n < ((ArrayList)this._valueList).size()) {
                object = ((ArrayList)this._valueList).get(n);
            } else {
                bl = true;
            }
        } else if (this._valType == 2) {
            if (n < this._count) {
                if (this._valueList instanceof int[]) {
                    object = ((int[])this._valueList)[n];
                } else if (this._valueList instanceof long[]) {
                    object = ((long[])this._valueList)[n];
                } else if (this._valueList instanceof Integer[]) {
                    object = ((Integer[])this._valueList)[n];
                } else if (this._valueList instanceof Long[]) {
                    object = ((Long[])this._valueList)[n];
                } else {
                    if (!(this._valueList instanceof String[])) throw new CmplException("unsupported data type for the set: " + this._name);
                    object = ((String[])this._valueList)[n];
                }
            } else {
                bl = true;
            }
        } else if (this._valType == 3) {
            if (n < this._valueArray.length) {
                object = this._valueArray[n];
            } else {
                bl = true;
            }
        }
        if (!bl) return object;
        throw new CmplException("Index out of range for set " + this._name);
    }

    public Object get(int n, int n2) throws CmplException {
        if (this._type != 1) {
            throw new CmplException("CmplSet.get(int i, int j) is only apllicable for tuple sets with rank>1 -> " + this._name);
        }
        Object object = null;
        boolean bl = false;
        try {
            if (this._valType == 1) {
                if (n < ((ArrayList)this._valueList).size()) {
                    object = ((ArrayList)((ArrayList)this._valueList).get(n)).get(n2);
                } else if (((ArrayList)this._valueList).get(n).getClass().isArray()) {
                    if (((ArrayList)this._valueList).get(n) instanceof int[]) {
                        object = ((int[])((ArrayList)this._valueList).get(n))[n2];
                    } else if (((ArrayList)this._valueList).get(n) instanceof long[]) {
                        object = ((long[])((ArrayList)this._valueList).get(n))[n2];
                    } else if (((ArrayList)this._valueList).get(n) instanceof Integer[]) {
                        object = ((Integer[])((ArrayList)this._valueList).get(n))[n2];
                    } else if (((ArrayList)this._valueList).get(n) instanceof Long[]) {
                        object = ((Long[])((ArrayList)this._valueList).get(n))[n2];
                    } else if (((ArrayList)this._valueList).get(n) instanceof String[]) {
                        object = ((String[])((ArrayList)this._valueList).get(n))[n2];
                    }
                }
            } else if (this._valType == 2) {
                if (this._valueList instanceof int[][]) {
                    object = ((int[][])this._valueList)[n][n2];
                } else if (this._valueList instanceof long[][]) {
                    object = ((long[][])this._valueList)[n][n2];
                } else if (this._valueList instanceof Integer[][]) {
                    object = ((Integer[][])this._valueList)[n][n2];
                } else if (this._valueList instanceof Long[][]) {
                    object = ((Long[][])this._valueList)[n][n2];
                } else if (this._valueList instanceof String[][]) {
                    object = ((String[][])this._valueList)[n][n2];
                }
            }
        }
        catch (Exception exception) {
            throw new CmplException("Index out of range for set " + this._name);
        }
        return object;
    }

    public void setValues(Object object) throws CmplException {
        if (!object.getClass().toString().contains("List") && !object.getClass().isArray()) {
            throw new CmplException("Incompatible data - not a list or an array - for set :" + this._name);
        }
        if (object.getClass().toString().contains("List")) {
            this._valType = 1;
            this._type = ((ArrayList)object).get(0).getClass().toString().contains("List") || ((ArrayList)object).get(0).getClass().isArray() ? 1 : 0;
        } else if (object.getClass().isArray()) {
            this._valType = 2;
            if (object instanceof int[] || object instanceof long[] || object instanceof Integer[] || object instanceof Long[] || object instanceof String[]) {
                this._type = 0;
            } else if (object instanceof Object[]) {
                this._type = ((Object[])object)[0].getClass().isArray() || ((Object[])object)[0].getClass().toString().contains("List") ? 1 : 0;
            } else {
                throw new CmplException("Incompatible data for set :" + this._name);
            }
        }
        if (this._type == 0 && this._rank > 1) {
            throw new CmplException("incorrect definition of the tuple set: " + this._name);
        }
        this._valueList = object;
        this._count = -99;
        this.len();
    }

    public void setValues(int n, int n2) throws CmplException {
        this._type = 2;
        this._rank = 1;
        if (n2 < n) {
            throw new CmplException("unexpected values for set " + this._name + " : end value " + String.valueOf(n2) + " is less then start value " + String.valueOf(n));
        }
        this._valueArray = new Object[2];
        this._valueArray[0] = n;
        this._valueArray[1] = n2;
        this._valType = 3;
        this._count = -99;
        this.len();
    }

    public void setValues(int n, int n2, int n3) throws CmplException {
        this._type = 3;
        this._rank = 1;
        if (n2 > 0) {
            if (n3 <= n) {
                throw new CmplException("unexpected values for set " + this._name + " : end value " + String.valueOf(n3) + " is less than or equal to start value " + String.valueOf(n) + " and the increment is positive " + String.valueOf(n2));
            }
        } else if (n2 < 0) {
            if (n <= n3) {
                throw new CmplException("unexpected values for set " + this._name + " : end value " + String.valueOf(n3) + " is greater than or equal to start value " + String.valueOf(n) + " and the increment is negative " + String.valueOf(n2));
            }
        } else {
            throw new CmplException("unexpected values for the set " + this._name + " :  increment/decrement equals zero  ");
        }
        this._valueArray = new Object[3];
        this._valueArray[0] = n;
        this._valueArray[1] = n2;
        this._valueArray[2] = n3;
        this._valType = 3;
        this._count = -99;
        this.len();
    }

    public int valType() {
        return this._valType;
    }

    public Object values() {
        ArrayList<Integer> arrayList;
        block7: {
            Integer n;
            arrayList = null;
            if (this._type == 0 || this._type == 1) {
                return this._valueList;
            }
            if (this._type == 2) {
                arrayList = new ArrayList<Integer>();
                n = (Integer)this._valueArray[0];
                while (n <= (Integer)this._valueArray[1]) {
                    arrayList.add(n);
                    Integer n2 = n;
                    Integer n3 = n = Integer.valueOf(n + 1);
                }
            }
            if (this._type != 3) break block7;
            arrayList = new ArrayList();
            if ((Integer)this._valueArray[1] > 0) {
                n = (Integer)this._valueArray[0];
                while (n <= (Integer)this._valueArray[2]) {
                    arrayList.add(n);
                    n = n + (Integer)this._valueArray[1];
                }
            } else {
                n = (Integer)this._valueArray[0];
                while (n >= (Integer)this._valueArray[2]) {
                    arrayList.add(n);
                    n = n + (Integer)this._valueArray[1];
                }
            }
        }
        return arrayList;
    }
}

