/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplSet;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CmplParameter {
    private String _name;
    private Object _valueList;
    private ArrayList<CmplSet> _setList;
    private long _count;
    private int _rank;
    private int _valType;

    private void setDefaults(String string) throws CmplException {
        this._count = 1L;
        this._rank = 0;
        Pattern pattern = Pattern.compile("\\s");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            throw new CmplException("parameter name " + this._name + " contains whitespaces");
        }
        this._name = string;
        this._rank = 0;
        this._setList = new ArrayList();
    }

    public CmplParameter(String string) throws CmplException {
        this.setDefaults(string);
    }

    public CmplParameter(String string, CmplSet ... cmplSetArray) throws CmplException {
        this.setDefaults(string);
        for (CmplSet cmplSet : cmplSetArray) {
            this._setList.add(cmplSet);
            this._rank += cmplSet.rank();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long countElements(Object object) throws CmplException {
        long l = 0L;
        if (object.getClass().toString().contains("List")) {
            l = ((ArrayList)object).size();
            if (!((ArrayList)object).get(0).getClass().toString().contains("List") && !((ArrayList)object).get(0).getClass().isArray()) return l;
            l *= this.countElements(((ArrayList)object).get(0));
            return l;
        } else {
            if (!object.getClass().isArray()) return 1L;
            if (object instanceof int[]) {
                l = ((int[])object).length;
                l *= this.countElements(((int[])object)[0]);
                return l;
            } else if (object instanceof long[]) {
                l = ((long[])object).length;
                l *= this.countElements(((long[])object)[0]);
                return l;
            } else if (object instanceof float[]) {
                l = ((float[])object).length;
                l *= this.countElements(Float.valueOf(((float[])object)[0]));
                return l;
            } else if (object instanceof double[]) {
                l = ((double[])object).length;
                l *= this.countElements(((double[])object)[0]);
                return l;
            } else {
                if (!(object instanceof Object[])) throw new CmplException("parameter name " + this._name + " containts data with unsupported data type" + object.getClass().toString());
                l = ((Object[])object).length;
                l *= this.countElements(((Object[])object)[0]);
            }
        }
        return l;
    }

    private void setScalarParam(Object object) throws CmplException {
        if (this._rank > 0) {
            throw new CmplException("incompatible data for a parameter array : " + object.toString());
        }
        this._valueList = object;
        this._valType = 3;
    }

    public void setValues(Integer n) throws CmplException {
        this.setScalarParam(n);
    }

    public void setValues(Long l) throws CmplException {
        this.setScalarParam(l);
    }

    public void setValues(Float f) throws CmplException {
        this.setScalarParam(f);
    }

    public void setValues(Double d) throws CmplException {
        this.setScalarParam(d);
    }

    public void setValues(String string) throws CmplException {
        this.setScalarParam(string);
    }

    public void setValues(Object object) throws CmplException {
        if (!object.getClass().toString().contains("List") && !object.getClass().isArray()) {
            throw new CmplException("Incompatible data - not a list or an array - for parameter :" + this._name);
        }
        if (this._rank == 0) {
            throw new CmplException("incompatible data for a scalar parameter : " + object.toString());
        }
        this._valueList = object;
        if (object.getClass().toString().contains("List")) {
            this._valType = 1;
        } else if (object.getClass().isArray()) {
            this._valType = 2;
        }
        long l = 1L;
        for (int i = 0; i < this._setList.size(); ++i) {
            l *= (long)this._setList.get(i).len();
        }
        this._count = this.countElements(this._valueList);
        if (this._count != l) {
            throw new CmplException("The dimension of the paramter " + this._name + " doesn't match the dimension of the set(s).");
        }
    }

    public List<CmplSet> setList() {
        return this._setList;
    }

    public Object values() {
        return this._valueList;
    }

    public Object value() {
        return this._valueList;
    }

    public String name() {
        return this._name;
    }

    public int rank() {
        return this._rank;
    }

    public long len() {
        return this._count;
    }

    public int valType() {
        return this._valType;
    }
}

