/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplMsg;
import jCMPL.CmplTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;

class CmplMessages {
    private String _cmplStatus;
    private String _cmplVersion;
    private String _cmplMessage;
    private String _msgFile;
    private ArrayList<CmplMsg> _cmplMessageList;

    private void setDefaults() {
        this._cmplStatus = "";
        this._cmplVersion = "";
        this._cmplMessage = "";
        this._msgFile = "";
        this._cmplMessageList = new ArrayList();
    }

    public CmplMessages() {
        this.setDefaults();
    }

    public CmplMessages(String string) {
        this.setDefaults();
        this._msgFile = string;
    }

    public int cmplStatus() {
        int n = -99;
        n = this._cmplStatus.equalsIgnoreCase("normal") ? 1 : (this._cmplStatus.equalsIgnoreCase("warning") ? 2 : (this._cmplStatus.equalsIgnoreCase("error") ? 3 : 0));
        return n;
    }

    public ArrayList<CmplMsg> cmplMessageList() {
        return this._cmplMessageList;
    }

    protected void readCmplMessages() throws CmplException {
        this.readCmplMessages("");
    }

    protected void readCmplMessages(String string) throws CmplException {
        Object object;
        if (string.isEmpty() && this._msgFile.isEmpty()) {
            throw new CmplException("Neither cmplMessageFile nor cmplMessageString defined");
        }
        ArrayList<String> arrayList = null;
        if (!this._msgFile.isEmpty()) {
            String string2 = "";
            try {
                object = new BufferedReader(new FileReader(this._msgFile));
                arrayList = new ArrayList();
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    arrayList.add(string2);
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                throw new CmplException("Cannot read message file :" + this._msgFile + " ->" + iOException);
            }
        } else {
            arrayList = new ArrayList<String>(Arrays.asList(string.split("\n")));
        }
        int n = 1;
        object = false;
        Boolean bl = false;
        for (String string3 : arrayList) {
            if (n == 1) {
                if (string3.contains("<?xml version")) {
                    ++n;
                    continue;
                }
                throw new CmplException("Cant't read cmplMessage file  - Not a XML file !");
            }
            if (n == 2) {
                if (string3.contains("<CmplMessages")) {
                    ++n;
                    continue;
                }
                throw new CmplException("Cant't read cmplMessage file  - Not a CmplMessages file !");
            }
            if (string3.contains("<general>")) {
                object = true;
                bl = false;
                continue;
            }
            if (string3.contains("</general>")) {
                object = false;
                continue;
            }
            if (string3.contains("<messages")) {
                object = false;
                bl = true;
                continue;
            }
            if (string3.contains("</messages")) {
                bl = false;
                continue;
            }
            if (((Boolean)object).booleanValue()) {
                if (string3.contains("<generalStatus")) {
                    this._cmplStatus = CmplTools.xmlStrToString(string3, "<generalStatus>([^\"]*)</generalStatus>");
                    continue;
                }
                if (string3.contains("<message")) {
                    this._cmplMessage = CmplTools.xmlStrToString(string3, "<message>([^\"]*)</message>");
                    continue;
                }
                if (string3.contains("<cmplVersion")) {
                    this._cmplVersion = CmplTools.xmlStrToString(string3, "<cmplVersion>([^\"]*)</cmplVersion>");
                    continue;
                }
            }
            if (!bl.booleanValue() || !string3.contains("<message")) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            String string4 = "\"([^\"]*)\"";
            Pattern pattern = Pattern.compile(string4);
            Matcher matcher = pattern.matcher(string3);
            while (matcher.find()) {
                arrayList2.add(matcher.group(1));
            }
            CmplMsg cmplMsg = new CmplMsg();
            cmplMsg.setType((String)arrayList2.get(0));
            cmplMsg.setFile((String)arrayList2.get(1));
            cmplMsg.setLine((String)arrayList2.get(2));
            cmplMsg.setDesrciption(StringEscapeUtils.unescapeXml((String)arrayList2.get(3)));
            this._cmplMessageList.add(cmplMsg);
        }
    }
}

