/*
 * Decompiled with CFR 0.152.
 */
package coliop3;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;

public class ColiopRunProgs
extends Thread {
    private ArrayList progSolverCodes;
    private ArrayList progCmplCodes;
    private Process p;
    private boolean runCanceled = false;
    private PrintWriter cmplOutputStream;

    ColiopRunProgs(PipedOutputStream pipedOutputStream) {
        this.cmplOutputStream = new PrintWriter(pipedOutputStream, true);
    }

    public void interrupt() {
        this.stopActions();
        this.p.destroy();
        this.runCanceled = true;
    }

    public void run() {
        try {
            String string;
            ProcessBuilder processBuilder = new ProcessBuilder(this.progCmplCodes);
            processBuilder.redirectErrorStream(true);
            this.p = processBuilder.start();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.p.getInputStream()));
            while ((string = bufferedReader.readLine()) != null) {
                this.cmplOutputStream.println(string);
            }
            if (!this.runCanceled) {
                this.p.waitFor();
            }
            this.cmplOutputStream.close();
        }
        catch (IOException iOException) {
            this.cmplOutputStream.println("Runtime Error " + iOException);
        }
        catch (InterruptedException interruptedException) {
            this.cmplOutputStream.println("Runtime Error " + interruptedException);
        }
    }

    public void setModel(ArrayList arrayList) {
        this.progCmplCodes = arrayList;
    }

    public int exitValue() {
        return this.p.exitValue();
    }

    public boolean isRunning() {
        return this.isAlive();
    }

    private void stopActions() {
        this.cmplOutputStream.println("CMPL - Canceled by user");
        this.cmplOutputStream.close();
    }
}

