/*
 * Decompiled with CFR 0.152.
 */
package coliop3;

import coliop3.Coliop;
import coliop3.ColiopAbout;
import coliop3.ColiopMacApplicationListener;
import coliop3.ColiopOptions;
import coliop3.ColiopRunProgs;
import coliop3.filePrinter;
import com.apple.eawt.Application;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.undo.UndoManager;
import org.jdesktop.layout.GroupLayout;

public class Coliop3
extends JFrame {
    public Coliop clp;
    public ColiopRunProgs activeSolverHandler;
    private PipedInputStream cmplIn;
    private PipedOutputStream cmplOut;
    private PipedInputStream solverIn;
    private PipedOutputStream solverOut;
    final UndoManager cmplEditorUndomanager = new UndoManager();
    private JButton cancelButton;
    private JMenu clpActionMenue;
    private JMenuItem clpActionMenueCancel;
    private JMenuItem clpActionMenueSolve;
    private JScrollPane clpCMPLEditorScrollPanel;
    private JPanel clpCMPLTab;
    private JButton clpClearCMPLLogButton;
    private JMenuItem clpEditMenuCopy;
    private JMenuItem clpEditMenuCut;
    private JMenuItem clpEditMenuGoToRow;
    private JMenuItem clpEditMenuPaste;
    private JMenuItem clpEditMenuRedo;
    private JMenuItem clpEditMenuUndo;
    private JMenu clpEditMenue;
    private JTabbedPane clpEditPanel;
    private JMenu clpFileMenue;
    private JMenuItem clpFileMenueSaveProblem;
    private JMenuItem clpFileMenueSaveProblemAs;
    private JMenu clpHelpMenue;
    private JMenuItem clpKLMPSolverOptionsItem2;
    private JTabbedPane clpLogPanel;
    private JPanel clpMatrixTab;
    private JMenuBar clpMenuBar;
    private JMenuItem clpMenuPrint;
    private JMenuItem clpMenueAbout;
    private JMenuItem clpMenueCMPLHelp;
    private JMenuItem clpMenueNewProblem;
    private JMenuItem clpMenueNewWindow;
    private JMenuItem clpMenueOpenProblem;
    private JMenuItem clpMenueQuit;
    private JMenu clpOptionsMenue;
    private JPanel clpSolutionTab;
    private JLabel clpStatusBar;
    private JTextArea cmplEditor;
    private JComboBox cmplFilesComboBox;
    private JTextArea cmplLog;
    private JButton goToLineButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JSeparator jSeparator10;
    private JSeparator jSeparator11;
    private JSeparator jSeparator12;
    private JSeparator jSeparator13;
    private JSeparator jSeparator7;
    private JSeparator jSeparator9;
    private JTextArea matrixViewer;
    private JTextArea solutionViewer;
    private JButton solveButton;

    public Coliop3() {
        this.initComponents();
        this.cmplEditor.getDocument().addUndoableEditListener(this.cmplEditorUndomanager);
        this.cmplEditorUndomanager.setLimit(1000);
        this.clp = new Coliop();
        this.setButtons("init");
        this.setTitle();
        this.clpSetFont();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                Object object;
                System.setProperty("apple.laf.useScreenMenuBar", "true");
                Coliop3 coliop3 = new Coliop3();
                if (System.getProperty("os.name", "unknown").indexOf("Mac") != -1) {
                    object = new Application();
                    ((Application)object).addPreferencesMenuItem();
                    ((Application)object).setEnabledPreferencesMenu(true);
                    ((Application)object).addApplicationListener(new ColiopMacApplicationListener(coliop3, coliop3));
                }
                object = Toolkit.getDefaultToolkit().getScreenSize();
                double d = ((Dimension)object).getWidth();
                double d2 = ((Dimension)object).getHeight();
                if (((Dimension)object).getWidth() < 1200.0 || ((Dimension)object).getHeight() < 750.0) {
                    coliop3.setExtendedState(coliop3.getExtendedState() | 6);
                }
                coliop3.setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.clpEditPanel = new JTabbedPane();
        this.clpCMPLTab = new JPanel();
        this.clpCMPLEditorScrollPanel = new JScrollPane();
        this.cmplEditor = new JTextArea();
        this.solveButton = new JButton();
        this.cancelButton = new JButton();
        this.goToLineButton = new JButton();
        this.cmplFilesComboBox = new JComboBox();
        this.clpMatrixTab = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.matrixViewer = new JTextArea();
        this.clpSolutionTab = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.solutionViewer = new JTextArea();
        this.clpLogPanel = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.cmplLog = new JTextArea();
        this.clpClearCMPLLogButton = new JButton();
        this.clpStatusBar = new JLabel();
        this.clpMenuBar = new JMenuBar();
        this.clpFileMenue = new JMenu();
        this.clpMenueNewWindow = new JMenuItem();
        this.jSeparator13 = new JSeparator();
        this.clpMenueNewProblem = new JMenuItem();
        this.clpMenueOpenProblem = new JMenuItem();
        this.clpFileMenueSaveProblem = new JMenuItem();
        this.clpFileMenueSaveProblemAs = new JMenuItem();
        this.jSeparator7 = new JSeparator();
        this.clpMenuPrint = new JMenuItem();
        this.jSeparator9 = new JSeparator();
        this.clpMenueQuit = new JMenuItem();
        this.clpEditMenue = new JMenu();
        this.clpEditMenuUndo = new JMenuItem();
        this.clpEditMenuRedo = new JMenuItem();
        this.jSeparator10 = new JSeparator();
        this.clpEditMenuCut = new JMenuItem();
        this.clpEditMenuCopy = new JMenuItem();
        this.clpEditMenuPaste = new JMenuItem();
        this.jSeparator11 = new JSeparator();
        this.clpEditMenuGoToRow = new JMenuItem();
        this.clpActionMenue = new JMenu();
        this.clpActionMenueSolve = new JMenuItem();
        this.clpActionMenueCancel = new JMenuItem();
        this.clpOptionsMenue = new JMenu();
        this.clpKLMPSolverOptionsItem2 = new JMenuItem();
        this.clpHelpMenue = new JMenu();
        this.clpMenueAbout = new JMenuItem();
        this.jSeparator12 = new JSeparator();
        this.clpMenueCMPLHelp = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Coliop3.this.formWindowClosing(windowEvent);
            }
        });
        this.clpEditPanel.setFont(this.clpEditPanel.getFont());
        this.cmplEditor.setColumns(20);
        this.cmplEditor.setFont(new Font("Courier", 0, 13));
        this.cmplEditor.setRows(5);
        this.cmplEditor.addInputMethodListener(new InputMethodListener(){

            public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                Coliop3.this.cmplEditorInputMethodTextChanged(inputMethodEvent);
            }

            public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
            }
        });
        this.cmplEditor.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                Coliop3.this.clpCMPLEditorTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                Coliop3.this.clpCMPLEditorTextChanged();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                Coliop3.this.clpCMPLEditorTextChanged();
            }
        });
        this.clpCMPLEditorScrollPanel.setViewportView(this.cmplEditor);
        this.solveButton.setText("Solve");
        this.solveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.startSolver(actionEvent);
            }
        });
        this.cancelButton.setText("Cancel ");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.interuptSolverHandler(actionEvent);
            }
        });
        this.goToLineButton.setText("Go to Line");
        this.goToLineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.goToLineButtonActionPerformed(actionEvent);
            }
        });
        this.cmplFilesComboBox.setMaximumRowCount(20);
        this.cmplFilesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.cmplFilesComboBoxActionPerformed(actionEvent);
            }
        });
        this.cmplFilesComboBox.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Coliop3.this.cmplFilesComboBoxFocusGained(focusEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.clpCMPLTab);
        this.clpCMPLTab.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(1).add(2, groupLayout.createSequentialGroup().addContainerGap().add(groupLayout.createParallelGroup(2).add(this.clpCMPLEditorScrollPanel, -1, 1103, Short.MAX_VALUE).add(groupLayout.createSequentialGroup().add(this.goToLineButton).addPreferredGap(0).add(this.cmplFilesComboBox, 0, 825, Short.MAX_VALUE).addPreferredGap(0).add(this.cancelButton).addPreferredGap(0).add(this.solveButton))).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.cancelButton, this.solveButton}, 1);
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(1).add(2, groupLayout.createSequentialGroup().add(this.clpCMPLEditorScrollPanel, -1, 398, Short.MAX_VALUE).addPreferredGap(0).add(groupLayout.createParallelGroup(4).add(this.goToLineButton).add(this.cmplFilesComboBox, -2, -1, -2).add(this.solveButton).add(this.cancelButton))));
        this.clpEditPanel.addTab("CMPL", this.clpCMPLTab);
        this.matrixViewer.setColumns(20);
        this.matrixViewer.setRows(5);
        this.jScrollPane1.setViewportView(this.matrixViewer);
        GroupLayout groupLayout2 = new GroupLayout(this.clpMatrixTab);
        this.clpMatrixTab.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(1).add(groupLayout2.createSequentialGroup().addContainerGap().add(this.jScrollPane1, -1, 1131, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(1).add(groupLayout2.createSequentialGroup().add(this.jScrollPane1, -1, 421, Short.MAX_VALUE).add(12, 12, 12)));
        this.clpEditPanel.addTab("Generated Model", this.clpMatrixTab);
        this.solutionViewer.setEditable(false);
        this.solutionViewer.setColumns(20);
        this.solutionViewer.setFont(new Font("Courier", 0, 13));
        this.solutionViewer.setRows(5);
        this.jScrollPane4.setViewportView(this.solutionViewer);
        GroupLayout groupLayout3 = new GroupLayout(this.clpSolutionTab);
        this.clpSolutionTab.setLayout(groupLayout3);
        groupLayout3.setHorizontalGroup(groupLayout3.createParallelGroup(1).add(groupLayout3.createSequentialGroup().addContainerGap().add(this.jScrollPane4, -1, 1131, Short.MAX_VALUE).addContainerGap()));
        groupLayout3.setVerticalGroup(groupLayout3.createParallelGroup(1).add(groupLayout3.createSequentialGroup().add(this.jScrollPane4, -1, 421, Short.MAX_VALUE).add(12, 12, 12)));
        this.clpEditPanel.addTab("Solution", this.clpSolutionTab);
        this.clpLogPanel.setMaximumSize(new Dimension(106, 67));
        this.jScrollPane2.setAutoscrolls(true);
        this.cmplLog.setEditable(false);
        this.cmplLog.setColumns(20);
        this.cmplLog.setFont(new Font("Courier", 0, 13));
        this.cmplLog.setLineWrap(true);
        this.cmplLog.setRows(5);
        this.cmplLog.setAutoscrolls(false);
        this.cmplLog.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.jScrollPane2.setViewportView(this.cmplLog);
        this.clpClearCMPLLogButton.setText("Clear Messages");
        this.clpClearCMPLLogButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpClearCMPLLogButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout4 = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(groupLayout4);
        groupLayout4.setHorizontalGroup(groupLayout4.createParallelGroup(1).add(groupLayout4.createSequentialGroup().addContainerGap().add(groupLayout4.createParallelGroup(1).add(2, this.jScrollPane2, -1, 1131, Short.MAX_VALUE).add(2, this.clpClearCMPLLogButton)).addContainerGap()));
        groupLayout4.setVerticalGroup(groupLayout4.createParallelGroup(1).add(groupLayout4.createSequentialGroup().add(this.jScrollPane2, -2, 167, -2).addPreferredGap(0).add(this.clpClearCMPLLogButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.clpLogPanel.addTab("Messages", this.jPanel1);
        this.clpStatusBar.setFont(new Font("Lucida Grande", 0, 10));
        this.clpStatusBar.setForeground(new Color(51, 51, 51));
        this.clpStatusBar.setText("jLabel1");
        this.clpStatusBar.setAlignmentY(0.0f);
        this.clpStatusBar.setBorder(BorderFactory.createBevelBorder(0));
        this.clpFileMenue.setText("File");
        this.clpFileMenue.setFont(this.clpFileMenue.getFont());
        this.clpMenueNewWindow.setText("New Window");
        this.clpMenueNewWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpMenueNewWindowActionPerformed(actionEvent);
            }
        });
        this.clpFileMenue.add(this.clpMenueNewWindow);
        this.clpFileMenue.add(this.jSeparator13);
        this.clpMenueNewProblem.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpMenueNewProblem.setText("New Problem");
        this.clpMenueNewProblem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpFileMenueNewProblemActionPerformed(actionEvent);
            }
        });
        this.clpFileMenue.add(this.clpMenueNewProblem);
        this.clpMenueOpenProblem.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpMenueOpenProblem.setText("Open Problem");
        this.clpMenueOpenProblem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpMenueOpenProblemActionPerformed(actionEvent);
            }
        });
        this.clpFileMenue.add(this.clpMenueOpenProblem);
        this.clpFileMenueSaveProblem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpFileMenueSaveProblem.setText("Save File");
        this.clpFileMenueSaveProblem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpFileMenueSaveProblemActionPerformed(actionEvent);
            }
        });
        this.clpFileMenue.add(this.clpFileMenueSaveProblem);
        this.clpFileMenueSaveProblemAs.setText("Save File As...");
        this.clpFileMenueSaveProblemAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpFileMenueSaveProblemAsActionPerformed(actionEvent);
            }
        });
        this.clpFileMenue.add(this.clpFileMenueSaveProblemAs);
        this.clpFileMenue.add(this.jSeparator7);
        this.clpMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpMenuPrint.setText("Print");
        this.clpMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpMenuPrintActionPerformed(actionEvent);
            }
        });
        this.clpFileMenue.add(this.clpMenuPrint);
        if (System.getProperty("os.name", "unknown").indexOf("Mac") == -1) {
            this.clpFileMenue.add(this.jSeparator9);
        }
        this.clpMenueQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpMenueQuit.setText("Exit");
        this.clpMenueQuit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.exitColiop(actionEvent);
            }
        });
        if (System.getProperty("os.name", "unknown").indexOf("Mac") == -1) {
            this.clpFileMenue.add(this.clpMenueQuit);
        }
        this.clpMenuBar.add(this.clpFileMenue);
        this.clpEditMenue.setText("Edit");
        this.clpEditMenue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.goToLineButtonActionPerformed(actionEvent);
            }
        });
        this.clpEditMenuUndo.setAccelerator(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpEditMenuUndo.setText("Undo");
        this.clpEditMenuUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpEditMenuUndoActionPerformed(actionEvent);
            }
        });
        this.clpEditMenue.add(this.clpEditMenuUndo);
        this.clpEditMenuRedo.setAccelerator(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpEditMenuRedo.setText("Redo");
        this.clpEditMenuRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpEditMenuRedoActionPerformed(actionEvent);
            }
        });
        this.clpEditMenue.add(this.clpEditMenuRedo);
        this.clpEditMenue.add(this.jSeparator10);
        this.clpEditMenuCut.setAccelerator(KeyStroke.getKeyStroke(88, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpEditMenuCut.setText("Cut");
        this.clpEditMenuCut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpEditMenuCutActionPerformed(actionEvent);
            }
        });
        this.clpEditMenue.add(this.clpEditMenuCut);
        this.clpEditMenuCopy.setAccelerator(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpEditMenuCopy.setText("Copy");
        this.clpEditMenuCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpEditMenuCopyActionPerformed(actionEvent);
            }
        });
        this.clpEditMenue.add(this.clpEditMenuCopy);
        this.clpEditMenuPaste.setAccelerator(KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpEditMenuPaste.setText("Paste");
        this.clpEditMenuPaste.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpEditMenuPasteActionPerformed(actionEvent);
            }
        });
        this.clpEditMenue.add(this.clpEditMenuPaste);
        this.clpEditMenue.add(this.jSeparator11);
        this.clpEditMenuGoToRow.setAccelerator(KeyStroke.getKeyStroke(71, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        this.clpEditMenuGoToRow.setText("Go to Line");
        this.clpEditMenuGoToRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpEditMenuGoToRowActionPerformed(actionEvent);
            }
        });
        this.clpEditMenue.add(this.clpEditMenuGoToRow);
        this.clpMenuBar.add(this.clpEditMenue);
        this.clpActionMenue.setText("Actions");
        this.clpActionMenue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.interuptSolverHandler(actionEvent);
            }
        });
        this.clpActionMenueSolve.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.clpActionMenueSolve.setText("Solve");
        this.clpActionMenueSolve.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.startSolver(actionEvent);
            }
        });
        this.clpActionMenue.add(this.clpActionMenueSolve);
        this.clpActionMenueCancel.setAccelerator(KeyStroke.getKeyStroke(117, 0));
        this.clpActionMenueCancel.setText("Cancel");
        this.clpActionMenueCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.interuptSolverHandler(actionEvent);
            }
        });
        this.clpActionMenue.add(this.clpActionMenueCancel);
        this.clpMenuBar.add(this.clpActionMenue);
        this.clpOptionsMenue.setText("Options");
        this.clpKLMPSolverOptionsItem2.setText("Coliop Options");
        this.clpKLMPSolverOptionsItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpOptionsItemAction(actionEvent);
            }
        });
        this.clpOptionsMenue.add(this.clpKLMPSolverOptionsItem2);
        if (System.getProperty("os.name", "unknown").indexOf("Mac") == -1) {
            this.clpMenuBar.add(this.clpOptionsMenue);
        }
        this.clpHelpMenue.setText("Help");
        this.clpMenueAbout.setText("About Coliop 3");
        this.clpMenueAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.koliopAboutItemActionPerformed(actionEvent);
            }
        });
        if (System.getProperty("os.name", "unknown").indexOf("Mac") == -1) {
            this.clpHelpMenue.add(this.clpMenueAbout);
        }
        if (System.getProperty("os.name", "unknown").indexOf("Mac") == -1) {
            this.clpHelpMenue.add(this.jSeparator12);
        }
        this.clpMenueCMPLHelp.setText("CMPL Manual");
        this.clpMenueCMPLHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Coliop3.this.clpMenueCMPLHelpActionPerformed(actionEvent);
            }
        });
        this.clpHelpMenue.add(this.clpMenueCMPLHelp);
        this.clpMenuBar.add(this.clpHelpMenue);
        this.setJMenuBar(this.clpMenuBar);
        GroupLayout groupLayout5 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout5);
        groupLayout5.setHorizontalGroup(groupLayout5.createParallelGroup(1).add(2, this.clpEditPanel).add(2, this.clpStatusBar, -1, -1, Short.MAX_VALUE).add(2, this.clpLogPanel, -1, -1, Short.MAX_VALUE));
        groupLayout5.setVerticalGroup(groupLayout5.createParallelGroup(1).add(2, groupLayout5.createSequentialGroup().add(10, 10, 10).add(this.clpEditPanel).addPreferredGap(0).add(this.clpLogPanel, -2, 247, -2).addPreferredGap(1).add(this.clpStatusBar)));
        this.getAccessibleContext().setAccessibleName("mainWindow");
        this.pack();
    }

    public void clpSetFont() {
        this.cmplEditor.setFont(this.clp.clpFont);
        this.solutionViewer.setFont(this.clp.clpFont);
        this.cmplLog.setFont(this.clp.clpFont);
        this.matrixViewer.setFont(this.clp.clpFont);
    }

    private void koliopAboutItemActionPerformed(ActionEvent actionEvent) {
        new ColiopAbout(this).setVisible(true);
    }

    private void clpFileMenueNewProblemActionPerformed(ActionEvent actionEvent) {
        if (this.clp.probChanged) {
            int n = JOptionPane.showConfirmDialog(this, "Save your problem?\n" + this.clp.name, "unsaved problem", 1);
            switch (n) {
                case 0: {
                    this.clpSaveProblem(0);
                    this.clpNewProb();
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    this.clpNewProb();
                }
            }
        } else {
            this.clpNewProb();
            this.clpDeleteFileList();
        }
        this.setTitle();
        this.setButtons("init");
    }

    private void clpNewProb() {
        this.clp.newProblem();
        this.cmplEditor.setText("parameters:\n\n\nvariables:\n\n\nobjectives:\n\n\nconstraints:\n\n\n");
        this.solutionViewer.setText("");
        this.clpDelMatrix();
        this.clpEditPanel.setSelectedIndex(0);
        this.clp.probChanged = false;
        this.clp.genFile = true;
        this.clp.clpExtension = ".cmpl";
    }

    private void clpFileMenueSaveProblemActionPerformed(ActionEvent actionEvent) {
        this.clpSaveProblem(0);
    }

    public int clpSaveProblem(int n) {
        if (this.clp.name.equals("new problem") || n == 1) {
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = false;
            if (this.clp.actCmplFile.toLowerCase().indexOf(".cmpl") != -1) {
                this.clp.clpExtension = ".cmpl";
                if (this.clp.actCmplFile.equals(this.clp.cmplFileName + this.clp.clpExtension)) {
                    bl = true;
                }
            } else if (this.clp.actCmplFile.toLowerCase().indexOf(".cdat") != -1) {
                this.clp.clpExtension = ".cdat";
            } else if (this.clp.name.equals("new problem")) {
                this.clp.clpExtension = ".cmpl";
                bl = true;
            }
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setCurrentDirectory(this.clp.homePath);
            jFileChooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.getName().toLowerCase().endsWith(".cmpl") || file.getName().toLowerCase().endsWith(".cdat") || file.isDirectory();
                }

                public String getDescription() {
                    return "Coliop and CmplData files";
                }
            });
            int n2 = jFileChooser.showSaveDialog(this);
            if (n2 == 0) {
                String string = jFileChooser.getSelectedFile().getName();
                if (string.indexOf(".") != -1) {
                    if (string.toLowerCase().endsWith(".cmpl") && string.toLowerCase().endsWith(".cdat")) {
                        if (this.clp.clpExtension.equals(".cmpl") && !this.clp.cmplFileName.toLowerCase().endsWith(".cmpl") || this.clp.clpExtension.equals(".cdat") && !this.clp.cmplFileName.toLowerCase().endsWith(".cdat")) {
                            bl3 = true;
                        }
                    } else {
                        bl3 = true;
                    }
                } else {
                    bl2 = false;
                }
                if (bl3) {
                    JOptionPane.showMessageDialog(this, "Wrong file extension! \nMust be " + this.clp.clpExtension, "ERROR", 2);
                    this.clp.clpExtension = ".cmpl";
                    return -1;
                }
                if (bl2) {
                    this.clp.actCmplFile = jFileChooser.getSelectedFile().getAbsolutePath();
                    this.clp.name = string.substring(0, string.toLowerCase().lastIndexOf(this.clp.clpExtension));
                } else {
                    this.clp.actCmplFile = jFileChooser.getSelectedFile().getAbsolutePath() + this.clp.clpExtension;
                    this.clp.name = string;
                }
                if (bl) {
                    if (bl2) {
                        this.clp.cmplFileName = jFileChooser.getSelectedFile().getAbsolutePath();
                        this.clp.cmplFileName = this.clp.cmplFileName.substring(0, this.clp.cmplFileName.toLowerCase().lastIndexOf(this.clp.clpExtension));
                    } else {
                        this.clp.cmplFileName = jFileChooser.getSelectedFile().getAbsolutePath();
                    }
                }
            } else {
                this.clp.name = this.clp.oldName;
                this.clp.clpExtension = ".cmpl";
                return -1;
            }
        }
        if (this.clp.genFile && this.clpWriteCMPLFile() == -1) {
            this.clp.clpExtension = ".cmpl";
            return -1;
        }
        this.clp.clpExtension = ".cmpl";
        this.clpCmplFilesComboBoxItems();
        this.setStatusBar();
        this.setTitle();
        return 1;
    }

    private ArrayList clpGetArgumentsList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n != -1) {
            n = string2.indexOf("{", n3);
            n2 = string2.indexOf("}", n4);
            if (n != -1) {
                arrayList.add(string2.substring(n + 1, n2));
            }
            n3 = n2++;
            n4 = n2++;
        }
        return arrayList;
    }

    private void clpCMPLEditorTextChanged() {
        this.clp.probChanged = true;
        this.clp.genFile = true;
        this.clp.solFile = false;
        this.setButtons("init");
        this.setStatusBar();
    }

    private void clpMenueOpenProblemActionPerformed(ActionEvent actionEvent) {
        if (this.clp.probChanged) {
            int n = JOptionPane.showConfirmDialog(this, "Save your problem?\n" + this.clp.name, "unsaved problem", 1);
            switch (n) {
                case 2: {
                    break;
                }
                case 0: {
                    this.clpSaveProblem(0);
                    this.clpOpenProblem();
                    break;
                }
                case 1: {
                    this.clpOpenProblem();
                }
            }
        } else {
            this.clpOpenProblem();
        }
        this.setButtons("init");
    }

    private void clpClearCMPLLogButtonActionPerformed(ActionEvent actionEvent) {
        this.cmplLog.setText("");
    }

    private void clpMenuPrintActionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = this.clp.cmplFileName;
        switch (this.clpEditPanel.getSelectedIndex()) {
            case 0: {
                string = string + this.clp.clpExtension;
                break;
            }
            case 1: {
                string = string + ".mat";
                break;
            }
            case 2: {
                string = string + ".sol";
                if (this.solutionViewer.getText().isEmpty()) break;
                try {
                    object = new PrintWriter(new FileWriter(string));
                    ((PrintWriter)object).println(this.solutionViewer.getText() + " ");
                    ((PrintWriter)object).close();
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        object = new filePrinter(string);
        if (((filePrinter)object).setupPageFormat() && ((filePrinter)object).setupJobOptions()) {
            try {
                ((filePrinter)object).printFile();
            }
            catch (PrinterException printerException) {
                JOptionPane.showMessageDialog(this, "Internal Error - Cant print! \n Empty file", "ERROR", 2);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Internal Error - Cant print! \n Empty file", "ERROR", 2);
            }
        }
        if (this.clpEditPanel.getSelectedIndex() == 2 && this.checkFile(this.clp.cmplFileName + ".sol")) {
            File file = new File(this.clp.cmplFileName + ".sol");
            file.delete();
        }
    }

    private void clpMenueCMPLHelpActionPerformed(ActionEvent actionEvent) {
        this.clpHelp("CMPL");
    }

    private void clpFileMenueSaveProblemAsActionPerformed(ActionEvent actionEvent) {
        this.clp.oldName = this.clp.name;
        this.clp.name = "saveAs";
        this.clpSaveProblem(1);
        this.setTitle();
        this.setButtons("init");
        this.clp.probChanged = false;
    }

    private void goToLineButtonActionPerformed(ActionEvent actionEvent) {
        this.clpGoToRow();
    }

    private void clpEditMenuUndoActionPerformed(ActionEvent actionEvent) {
        if (this.cmplEditorUndomanager.canUndo()) {
            this.cmplEditorUndomanager.undo();
        }
    }

    private void clpEditMenuRedoActionPerformed(ActionEvent actionEvent) {
        if (this.cmplEditorUndomanager.canRedo()) {
            this.cmplEditorUndomanager.redo();
        }
    }

    private void clpEditMenuGoToRowActionPerformed(ActionEvent actionEvent) {
        this.clpGoToRow();
    }

    private void clpEditMenuPasteActionPerformed(ActionEvent actionEvent) {
        if (this.cmplEditor.isFocusOwner()) {
            this.cmplEditor.paste();
        }
    }

    private void clpEditMenuCutActionPerformed(ActionEvent actionEvent) {
        if (this.cmplEditor.isFocusOwner()) {
            this.cmplEditor.cut();
        }
    }

    private void clpEditMenuCopyActionPerformed(ActionEvent actionEvent) {
        if (this.cmplEditor.isFocusOwner()) {
            this.cmplEditor.copy();
        }
    }

    private void clpMenueNewWindowActionPerformed(ActionEvent actionEvent) {
        if (this.clp.loadOptions() == 1) {
            try {
                String string;
                String string2;
                ArrayList arrayList = new ArrayList();
                int n = this.clp.clpPath.indexOf("{", 0);
                if (n != -1) {
                    string2 = this.clp.clpPath.substring(0, n);
                    string = this.clp.clpPath.substring(n, this.clp.clpPath.length());
                } else {
                    string2 = this.clp.clpPath;
                    string = "";
                }
                arrayList = this.clpGetArgumentsList(string2, string);
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Internal Error - Cant open a new Coliop3 window!\n" + iOException, "ERROR", 2);
            }
        }
    }

    private void cmplFilesComboBoxFocusGained(FocusEvent focusEvent) {
        this.clpCmplFilesComboBoxItems();
    }

    private void cmplFilesComboBoxActionPerformed(ActionEvent actionEvent) {
        String string = (String)this.cmplFilesComboBox.getSelectedItem();
        if (string != null && !string.equals(this.clp.actCmplFile)) {
            if (this.clp.probChanged) {
                this.clpSaveProblem(0);
            }
            this.clp.actCmplFile = (String)this.cmplFilesComboBox.getSelectedItem();
            this.clpLoadAdditionalCMPLFile();
            this.setTitle();
        }
    }

    private void cmplEditorInputMethodTextChanged(InputMethodEvent inputMethodEvent) {
        this.clp.probChanged = true;
    }

    private void interuptSolverHandler(ActionEvent actionEvent) {
        if (this.activeSolverHandler != null) {
            this.activeSolverHandler.interrupt();
        }
        this.setButtons("init");
    }

    private void startSolver(ActionEvent actionEvent) {
        this.solve();
    }

    private void exitColiop(ActionEvent actionEvent) {
        this.exitClp();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.exitClp();
    }

    private void clpOptionsItemAction(ActionEvent actionEvent) {
        new ColiopOptions(this).setVisible(true);
        this.clp.loadOptions();
        this.clpSetFont();
        this.setStatusBar();
    }

    public void exitClp() {
        int n;
        if (this.clp.probChanged && (n = JOptionPane.showConfirmDialog(this, "Save your problem?\n" + this.clp.name, "unsaved problem", 0)) == 0) {
            this.clpSaveProblem(0);
        }
        if (this.activeSolverHandler != null && this.activeSolverHandler.isAlive()) {
            JOptionPane.showMessageDialog(this, "Solver is running - Please cancel Solver before closing Coliop3", "Solver is running", 2);
        } else {
            System.exit(0);
        }
    }

    private void clpDeleteFileList() {
        this.cmplFilesComboBox.removeAllItems();
        this.cmplFilesComboBox.requestFocus();
        this.cmplFilesComboBox.repaint();
    }

    private void clpCmplFilesComboBoxItems() {
        if (!this.clp.name.equals("new problem") && this.clp.actCmplFile.equals(this.clp.cmplFileName + this.clp.clpExtension)) {
            int n;
            this.changeCmplFileList();
            this.cmplFilesComboBox.removeAllItems();
            for (n = 0; n < this.clp.cmplFileList.size(); ++n) {
                this.cmplFilesComboBox.addItem(this.clp.cmplFileList.get(n));
            }
            this.cmplFilesComboBox.requestFocus();
            this.cmplFilesComboBox.repaint();
            for (n = 0; n < this.clp.cmplFileList.size(); ++n) {
                if (!this.cmplFilesComboBox.getItemAt(n).equals(this.clp.actCmplFile)) continue;
                this.cmplFilesComboBox.setSelectedIndex(n);
            }
        }
    }

    private void changeCmplFileList() {
        String string = "";
        if (this.clp.actCmplFile.equals(this.clp.cmplFileName + this.clp.clpExtension)) {
            int n;
            int n2;
            this.clp.cmplFileList.clear();
            this.clp.cmplFileList.add(this.clp.cmplFileName + this.clp.clpExtension);
            String string2 = this.cmplEditor.getText();
            int n3 = string2.toLowerCase().indexOf("include", 0);
            while (n3 != -1) {
                int n4 = string2.indexOf("\"", n3);
                n2 = string2.indexOf("\n", n3);
                n = n2 < n4 ? -1 : n4;
                if (n != -1) {
                    n4 = string2.indexOf("\"", n + 1);
                    n2 = string2.indexOf("\n", n + 1);
                    int n5 = n2 < n4 ? -1 : n4;
                    if (n5 != -1) {
                        string = string2.substring(n + 1, n5);
                        if (System.getProperty("os.name", "unknown").indexOf("Windows") != -1) {
                            if (!string.substring(0, 1).equals("\\")) {
                                string = this.clp.cmplFileName.substring(0, this.clp.cmplFileName.lastIndexOf("\\")) + "\\" + string;
                            }
                        } else if (!string.substring(0, 1).equals("/")) {
                            string = this.clp.cmplFileName.substring(0, this.clp.cmplFileName.lastIndexOf("/")) + "/" + string;
                        }
                        this.clp.cmplFileList.add(string);
                        n3 = string2.toLowerCase().indexOf("include", n5);
                        continue;
                    }
                    n3 = -1;
                    continue;
                }
                n3 = -1;
            }
            boolean bl = false;
            n3 = string2.toLowerCase().indexOf("%data", 0);
            while (n3 != -1) {
                int n6;
                n2 = string2.indexOf("\n", n3);
                string = n2 < (n6 = string2.indexOf(":", n3)) ? string2.substring(n3 + 5, n2).trim() : string2.substring(n3 + 5, n6).trim();
                if (string.isEmpty()) {
                    if (!bl) {
                        string = this.clp.name + ".cdat";
                        n = -1;
                        bl = true;
                    } else {
                        string = "";
                    }
                } else {
                    if (string.startsWith("\"")) {
                        string = string.substring(1);
                    }
                    if (string.endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                }
                if (!string.isEmpty()) {
                    if (System.getProperty("os.name", "unknown").indexOf("Windows") != -1) {
                        if (!string.substring(0, 1).equals("\\")) {
                            string = this.clp.cmplFileName.substring(0, this.clp.cmplFileName.lastIndexOf("\\")) + "\\" + string;
                        }
                    } else if (!string.substring(0, 1).equals("/")) {
                        string = this.clp.cmplFileName.substring(0, this.clp.cmplFileName.lastIndexOf("/")) + "/" + string;
                    }
                    this.clp.cmplFileList.add(string);
                }
                n3 = string2.toLowerCase().indexOf("%data", n2);
            }
        }
    }

    private void clpGoToRow() {
        String string = JOptionPane.showInputDialog(this, "Go to row - max " + (this.cmplEditor.getLineCount() - 1), "Go to row  ", 3);
        if (string != null) {
            try {
                int n = Integer.parseInt(string) - 1;
                int n2 = this.cmplEditor.getLineStartOffset(n);
                int n3 = this.cmplEditor.getLineEndOffset(n);
                this.cmplEditor.select(n2, n3);
                this.cmplEditor.requestFocusInWindow();
            }
            catch (NumberFormatException numberFormatException) {
                JOptionPane.showMessageDialog(this, string + " is not a correct row number", "ERROR", 2);
            }
            catch (BadLocationException badLocationException) {
                JOptionPane.showMessageDialog(this, string + " is not a correct row ", "ERROR", 2);
            }
        }
    }

    private void clpHelp(String string) {
        if (string.equals("CMPL") && this.clp.loadOptions() == 1) {
            try {
                ArrayList arrayList = new ArrayList();
                String string2 = System.getProperty("user.dir");
                String string3 = this.clp.browserArguments;
                arrayList = this.clpGetArgumentsList(this.clp.browserFile, string3);
                ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Internal Error - Cant catch the help browser!\n" + iOException, "ERROR", 2);
            }
        }
    }

    private void clpOpenProblem() {
        int n = 0;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(this.clp.homePath);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(".cmpl") || file.isDirectory();
            }

            public String getDescription() {
                return "CMPL Files";
            }
        });
        int n2 = jFileChooser.showOpenDialog(this);
        if (n2 == 0) {
            this.clp.cmplFileName = jFileChooser.getSelectedFile().getAbsolutePath();
            this.clp.actCmplFile = jFileChooser.getSelectedFile().getAbsolutePath();
            this.clp.name = jFileChooser.getSelectedFile().getName();
            n = this.clp.cmplFileName.toLowerCase().lastIndexOf(".cmpl");
            this.clp.cmplFileName = this.clp.cmplFileName.substring(0, n);
            this.clp.name = this.clp.name.substring(0, this.clp.name.toLowerCase().lastIndexOf(".cmpl"));
            this.clp.clpExtension = ".cmpl";
            this.cmplEditor.setText("");
            this.clpDelMatrix();
            this.solutionViewer.setText("");
            this.clp.genFile = true;
            this.clpLoadCMPLFile();
            this.clpCmplFilesComboBoxItems();
            this.clpEditPanel.setSelectedIndex(0);
            this.setTitle();
            this.setButtons("init");
        }
    }

    private boolean checkFile(String string) {
        File file = new File(string);
        return file.exists();
    }

    private void solve() {
        this.clp.oldName = this.clp.name;
        if (this.clpSaveProblem(0) == 1 && this.clp.loadOptions() == 1) {
            ColiopRunProgs coliopRunProgs;
            Object object;
            if (this.checkFile(this.clp.cmplFileName + ".mps")) {
                object = new File(this.clp.cmplFileName + ".mps");
                ((File)object).delete();
            }
            if (this.checkFile(this.clp.cmplFileName + ".sol")) {
                object = new File(this.clp.cmplFileName + ".sol");
                ((File)object).delete();
            }
            if (this.checkFile(this.clp.cmplFileName + ".mat")) {
                object = new File(this.clp.cmplFileName + ".mat");
                ((File)object).delete();
            }
            this.setButtons("solveStart");
            this.clp.solFile = false;
            this.solutionViewer.setText("");
            this.clpDelMatrix();
            object = this.clp.cmplArguments.replace("$problem$", this.clp.cmplFileName);
            object = ((String)object).replace(".$ext$", this.clp.clpExtension);
            ArrayList arrayList = new ArrayList();
            arrayList = this.clpGetArgumentsList(this.clp.cmplFile, (String)object);
            this.startMessagePipes();
            this.activeSolverHandler = coliopRunProgs = new ColiopRunProgs(this.cmplOut);
            coliopRunProgs.setModel(arrayList);
            coliopRunProgs.start();
        }
    }

    public int clpLoadSolutionFile() {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.clp.cmplFileName + ".sol"));
            this.solutionViewer.setText("");
            while ((string = bufferedReader.readLine()) != null) {
                this.solutionViewer.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Internal Error - Cant read the Solution file!\n", "ERROR", 2);
            return -1;
        }
        this.clp.solFile = true;
        this.clpEditPanel.setSelectedIndex(2);
        this.solutionViewer.select(1, 1);
        return 1;
    }

    private int clpWriteCMPLFile() {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.clp.actCmplFile));
            printWriter.println(this.cmplEditor.getText() + " ");
            printWriter.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Internal Error - Cant write the CMPL file!\n" + iOException, "ERROR", 2);
            return -1;
        }
        this.clp.probChanged = false;
        return 1;
    }

    private int clpLoadCMPLFile() {
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.clp.cmplFileName + this.clp.clpExtension));
            this.cmplEditor.setText("");
            while ((string = bufferedReader.readLine()) != null) {
                this.cmplEditor.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Internal Error - Cant read the CMPL file!\n", "ERROR", 2);
            return -1;
        }
        this.clp.genFile = true;
        this.clp.probChanged = false;
        this.clp.actCmplFile = this.clp.cmplFileName + this.clp.clpExtension;
        this.clpEditPanel.setSelectedIndex(0);
        this.cmplEditor.select(1, 1);
        return 1;
    }

    private int clpLoadAdditionalCMPLFile() {
        File file = new File(this.clp.actCmplFile);
        if (!file.exists()) {
            try {
                int n = JOptionPane.showConfirmDialog(this, "CMPL file does not exist. Create this file?\n" + this.clp.actCmplFile, "Create this file?", 0);
                if (n != 0) {
                    return -1;
                }
                file.createNewFile();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this, "Internal Error - Cant create the CMPL file!\n", "ERROR", 2);
                return -1;
            }
        }
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.clp.actCmplFile));
            this.cmplEditor.setText("");
            while ((string = bufferedReader.readLine()) != null) {
                this.cmplEditor.append(string + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Internal Error - Cant read the CMPL file!\n", "ERROR", 2);
            return -1;
        }
        this.clp.genFile = true;
        this.clp.probChanged = false;
        this.clpEditPanel.setSelectedIndex(0);
        this.cmplEditor.select(1, 1);
        return 1;
    }

    public void clpDelMatrix() {
        this.matrixViewer.setText("");
    }

    public int clpLoadMatrix(String string) {
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.matrixViewer.setText("");
            while ((string2 = bufferedReader.readLine()) != null) {
                this.matrixViewer.append(string2 + "\n");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this, "Internal Error - Cant read the Matrix file!\n", "ERROR", 2);
            return -1;
        }
        return 1;
    }

    private void getMatrix() {
        if (this.checkFile(this.clp.cmplFileName + ".mat")) {
            this.clpLoadMatrix(this.clp.cmplFileName + ".mat");
            File file = new File(this.clp.cmplFileName + ".mat");
            file.delete();
        }
        this.setButtons("init");
    }

    private void getSolution() {
        if (this.checkFile(this.clp.cmplFileName + ".sol")) {
            this.clp.solFile = true;
            this.clpLoadSolutionFile();
            this.selectEditPanel(2);
            File file = new File(this.clp.cmplFileName + ".sol");
            file.delete();
        } else {
            this.clp.solFile = false;
        }
        this.setButtons("init");
    }

    private void cmplMessages(PipedInputStream pipedInputStream) {
        try {
            int n;
            while ((n = pipedInputStream.read()) != -1) {
                this.cmplLog.append("" + (char)n);
                this.cmplLog.select(this.cmplLog.getLineStartOffset(this.cmplLog.getLineCount() - 1), this.cmplLog.getLineStartOffset(this.cmplLog.getLineCount() - 1));
            }
            this.getMatrix();
            this.getSolution();
        }
        catch (BadLocationException badLocationException) {
            Logger.getLogger(Coliop3.class.getName()).log(Level.SEVERE, null, badLocationException);
        }
        catch (IOException iOException) {
            System.out.println("error cmplMsg:" + iOException.getMessage());
        }
    }

    public void startMessagePipes() {
        try {
            this.cmplIn = new PipedInputStream();
            this.cmplOut = new PipedOutputStream(this.cmplIn);
            this.solverIn = new PipedInputStream();
            this.solverOut = new PipedOutputStream(this.solverIn);
        }
        catch (IOException iOException) {
            Logger.getLogger(Coliop3.class.getName()).log(Level.SEVERE, null, iOException);
        }
        Runnable runnable = new Runnable(){

            public void run() {
                Coliop3.this.cmplMessages(Coliop3.this.cmplIn);
            }
        };
        Thread thread = new Thread(runnable, "threadCmplpMsg");
        thread.start();
    }

    private void setTitle() {
        int n = this.clp.actCmplFile.lastIndexOf("/") + 1;
        if (this.clp.actCmplFile.equals(this.clp.cmplFileName + this.clp.clpExtension) || this.clp.name.equals("new problem")) {
            this.setTitle("Coliop3 - " + this.clp.name);
        } else {
            this.setTitle("Coliop3 - " + this.clp.name + " < " + this.clp.actCmplFile.substring(n, this.clp.actCmplFile.length()) + " > ");
        }
        this.setStatusBar();
    }

    public void setStatusBar() {
        String string = this.clp.cmplFileName;
        this.clpStatusBar.setText(string);
    }

    public void selectEditPanel(int n) {
        this.clpEditPanel.setSelectedIndex(n);
    }

    public void setButtons(String string) {
        if (string.equals("solveStart")) {
            this.cmplEditor.setEditable(false);
            this.cancelButton.setEnabled(true);
            this.solveButton.setEnabled(false);
            this.clpActionMenueCancel.setEnabled(true);
            this.clpActionMenueSolve.setEnabled(false);
        }
        if (string.equals("init")) {
            this.cmplEditor.setEditable(true);
            this.cancelButton.setEnabled(false);
            this.clpActionMenueCancel.setEnabled(false);
            if (this.clp.genFile) {
                this.solveButton.setEnabled(true);
                this.clpActionMenueSolve.setEnabled(true);
            } else {
                this.solveButton.setEnabled(false);
                this.clpActionMenueSolve.setEnabled(false);
            }
        }
    }
}

