/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplSolElement;
import jCMPL.CmplSolution;
import jCMPL.CmplTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class CmplSolutions {
    private long _nrOfVariables;
    private long _nrOfConstraints;
    private String _objectiveName;
    private String _objectiveSense;
    private int _nrOfSolutions;
    private String _solverName;
    private String _solverMsg;
    private String _varDisplayOptions;
    private String _conDisplayOptions;
    private String _asciiSolFile;
    private String _csvSolFile;
    private String _cmplSolFile;
    private ArrayList<CmplSolution> _solList;
    private String _solutionFile;
    private ArrayList<String> _solFileContent;
    private boolean _isIntegerProgram;

    public CmplSolutions(String string) {
        this.setDefaults();
        this._solutionFile = string;
    }

    public CmplSolutions() {
        this.setDefaults();
    }

    private void setDefaults() {
        this._nrOfVariables = 0L;
        this._nrOfConstraints = 0L;
        this._objectiveName = "";
        this._objectiveSense = "";
        this._nrOfSolutions = 0;
        this._solverName = "";
        this._solverMsg = "";
        this._varDisplayOptions = "";
        this._conDisplayOptions = "";
        this._asciiSolFile = "";
        this._csvSolFile = "";
        this._cmplSolFile = "";
        this._solList = new ArrayList();
        this._solutionFile = "";
        this._isIntegerProgram = false;
    }

    public long nrOfVariables() {
        return this._nrOfVariables;
    }

    public long nrOfConstraints() {
        return this._nrOfConstraints;
    }

    public String objectiveName() {
        return this._objectiveName;
    }

    public String objectiveSense() {
        return this._objectiveSense;
    }

    public int nrOfSolutions() {
        return this._nrOfSolutions;
    }

    public String solver() {
        return this._solverName;
    }

    public String solverMessage() {
        return this._solverMsg;
    }

    public String conDisplayOptions() {
        return this._conDisplayOptions;
    }

    public String varDisplayOptions() {
        return this._varDisplayOptions;
    }

    public String asciiSolFile() {
        return this._asciiSolFile;
    }

    public String csvSolFile() {
        return this._csvSolFile;
    }

    public String cmplSolFile() {
        return this._cmplSolFile;
    }

    public ArrayList<CmplSolution> solutions() {
        return this._solList;
    }

    public CmplSolution solution() {
        return this._solList.get(0);
    }

    public ArrayList<String> solFileContent() {
        return this._solFileContent;
    }

    public void delSolFileContent() {
        this._solFileContent.clear();
    }

    public boolean isIntegerProgram() {
        return this._isIntegerProgram;
    }

    private CmplSolElement readSolLine(String string) throws CmplException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "\"([^\"]*)\"";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        String string3 = "";
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        CmplSolElement cmplSolElement = new CmplSolElement();
        cmplSolElement.setIdx(CmplTools.xmlStrToInteger((String)arrayList.get(0)));
        cmplSolElement.setName((String)arrayList.get(1));
        cmplSolElement.setType((String)arrayList.get(2));
        if (string.contains("<constraint")) {
            cmplSolElement.setActivity(CmplTools.xmlStrToDouble((String)arrayList.get(3)));
        } else if (cmplSolElement.type().equals("I") || cmplSolElement.type().equals("B")) {
            cmplSolElement.setActivity(CmplTools.xmlStrToLong((String)arrayList.get(3)));
            this._isIntegerProgram = true;
        } else {
            cmplSolElement.setActivity(CmplTools.xmlStrToDouble((String)arrayList.get(3)));
        }
        string3 = ((String)arrayList.get(4)).contains("INF") ? ((String)arrayList.get(4)).replace("INF", "Infinity") : (String)arrayList.get(4);
        cmplSolElement.setLowerBound(CmplTools.xmlStrToDouble(string3));
        string3 = ((String)arrayList.get(5)).contains("INF") ? ((String)arrayList.get(5)).replace("INF", "Infinity") : (String)arrayList.get(5);
        cmplSolElement.setUpperBound(CmplTools.xmlStrToDouble(string3));
        if (((String)arrayList.get(6)).equals("NaN")) {
            cmplSolElement.setMarginal(Double.NaN);
        } else {
            cmplSolElement.setMarginal(CmplTools.xmlStrToDouble((String)arrayList.get(6)));
        }
        return cmplSolElement;
    }

    protected void readSolution() throws CmplException {
        this.readSolution("");
    }

    protected void readSolution(String string) throws CmplException {
        if (string.isEmpty() && this._solutionFile.isEmpty()) {
            throw new CmplException("Solver failed or cannot be executed");
        }
        this._solList.clear();
        if (!this._solutionFile.isEmpty()) {
            String string2 = "";
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this._solutionFile));
                this._solFileContent = new ArrayList();
                while ((string2 = bufferedReader.readLine()) != null) {
                    this._solFileContent.add(string2);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new CmplException("Cannot read solution file :" + this._solutionFile + " ->" + iOException);
            }
        } else {
            this._solFileContent = new ArrayList<String>(Arrays.asList(string.split("\n")));
        }
        long l = 1L;
        Boolean bl = false;
        Boolean bl2 = false;
        Boolean bl3 = false;
        Boolean bl4 = false;
        CmplSolution cmplSolution = null;
        for (String string3 : this._solFileContent) {
            if (l == 1L) {
                if (!string3.contains("<?xml version")) {
                    throw new CmplException("File " + this._solutionFile + " - is not a XML file!");
                }
                ++l;
                continue;
            }
            if (l == 2L) {
                if (!string3.contains("<CmplSolutions")) {
                    throw new CmplException("Can't read cmplSolution file " + this._solutionFile + " - wrong file type!");
                }
                ++l;
                continue;
            }
            if (string3.contains("<general>")) {
                bl = true;
                bl2 = false;
                continue;
            }
            if (string3.contains("</general>")) {
                bl = false;
                continue;
            }
            if (string3.contains("<solution")) {
                bl = false;
                bl2 = true;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string4 = "\"([^\"]*)\"";
                Pattern pattern = Pattern.compile(string4);
                Matcher matcher = pattern.matcher(string3);
                while (matcher.find()) {
                    arrayList.add(matcher.group(1));
                }
                cmplSolution = new CmplSolution();
                cmplSolution.setIdx(CmplTools.xmlStrToInteger((String)arrayList.get(0)));
                cmplSolution.setStatus((String)arrayList.get(1));
                cmplSolution.setValue(CmplTools.xmlStrToDouble((String)arrayList.get(2)));
                continue;
            }
            if (string3.contains("</solution")) {
                bl2 = false;
                this._solList.add(cmplSolution);
                continue;
            }
            if (bl.booleanValue()) {
                if (string3.contains("<nrOfVariables")) {
                    this._nrOfVariables = CmplTools.xmlStrToLong(string3, "<nrOfVariables>(.*)</nrOfVariables>");
                    continue;
                }
                if (string3.contains("<nrOfConstraints")) {
                    this._nrOfConstraints = CmplTools.xmlStrToLong(string3, "<nrOfConstraints>([^\"]*)</nrOfConstraints>");
                    continue;
                }
                if (string3.contains("<objectiveName")) {
                    this._objectiveName = CmplTools.xmlStrToString(string3, "<objectiveName>([^\"]*)</objectiveName>");
                    continue;
                }
                if (string3.contains("<objectiveSense")) {
                    this._objectiveSense = CmplTools.xmlStrToString(string3, "<objectiveSense>([^\"]*)</objectiveSense>");
                    continue;
                }
                if (string3.contains("<nrOfSolutions")) {
                    this._nrOfSolutions = CmplTools.xmlStrToInteger(string3, "<nrOfSolutions>([^\"]*)</nrOfSolutions>");
                    continue;
                }
                if (string3.contains("<solverName")) {
                    this._solverName = CmplTools.xmlStrToString(string3, "<solverName>([^\"]*)</solverName>");
                    continue;
                }
                if (string3.contains("<solverMsg")) {
                    this._solverMsg = CmplTools.xmlStrToString(string3, "<solverMsg>([^\"]*)</solverMsg>");
                    continue;
                }
                if (string3.contains("<variablesDisplayOptions")) {
                    this._varDisplayOptions = CmplTools.xmlStrToString(string3, "<variablesDisplayOptions>([^\"]*)</variablesDisplayOptions>");
                    continue;
                }
                if (string3.contains("<constraintsDisplayOptions")) {
                    this._conDisplayOptions = CmplTools.xmlStrToString(string3, "<constraintsDisplayOptions>([^\"]*)</constraintsDisplayOptions>");
                    continue;
                }
                if (string3.contains("<asciiSolFile")) {
                    this._asciiSolFile = CmplTools.xmlStrToString(string3, "<asciiSolFile>([^\"]*)</asciiSolFile>");
                    continue;
                }
                if (string3.contains("<csvSolFile")) {
                    this._csvSolFile = CmplTools.xmlStrToString(string3, "<csvSolFile>([^\"]*)</csvSolFile>");
                    continue;
                }
                if (string3.contains("<cmplSolFile")) {
                    this._cmplSolFile = CmplTools.xmlStrToString(string3, "<cmplSolFile>([^\"]*)</cmplSolFile>");
                    continue;
                }
            }
            if (!bl2.booleanValue()) continue;
            if (string3.contains("<variables>")) {
                bl3 = true;
                bl4 = false;
                continue;
            }
            if (string3.contains("</variables>")) {
                bl3 = false;
                continue;
            }
            if (string3.contains("<linearConstraints>")) {
                bl3 = false;
                bl4 = true;
                continue;
            }
            if (string3.contains("</linearConstraints>")) {
                bl4 = false;
                continue;
            }
            if (bl3.booleanValue() && string3.contains("<variable")) {
                cmplSolution.setVar(this.readSolLine(string3));
            }
            if (!bl4.booleanValue() || !string3.contains("<constraint")) continue;
            cmplSolution.setCon(this.readSolLine(string3));
        }
    }
}

