/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class CmplInfo {
    private String _cmplInfoFile;
    private String _instanceName;
    private String _varProdFileName;
    private String _varProdText;
    private String _statisticsFileName;
    private String _statisticsText;
    private String _matrixFileName;
    private String _matrixText;

    private void setDefaults() {
        this._cmplInfoFile = "";
        this._instanceName = "";
        this._varProdFileName = "";
        this._varProdText = "";
        this._statisticsFileName = "";
        this._statisticsText = "";
        this._matrixFileName = "";
        this._matrixText = "";
    }

    public CmplInfo() {
        this.setDefaults();
    }

    public CmplInfo(String string) {
        this.setDefaults();
        this._cmplInfoFile = string;
    }

    public String varProdFileName() {
        return this._varProdFileName;
    }

    public String varProdText() {
        return this._varProdText;
    }

    public String statisticsFileName() {
        return this._statisticsFileName;
    }

    public String statisticsText() {
        return this._statisticsText;
    }

    public String matrixFileName() {
        return this._matrixFileName;
    }

    public String matrixText() {
        return this._matrixText;
    }

    public void readCmplInfo() throws CmplException {
        this.readCmplInfo("");
    }

    public void readCmplInfo(String string) throws CmplException {
        Object object;
        if (string.isEmpty() && this._cmplInfoFile.isEmpty()) {
            throw new CmplException("Neither cmplInfoFile nor cmplInfoString defined");
        }
        ArrayList<String> arrayList = null;
        if (!this._cmplInfoFile.isEmpty()) {
            String string2 = "";
            try {
                object = new BufferedReader(new FileReader(this._cmplInfoFile));
                arrayList = new ArrayList();
                while ((string2 = ((BufferedReader)object).readLine()) != null) {
                    arrayList.add(string2);
                }
                ((BufferedReader)object).close();
            }
            catch (IOException iOException) {
                throw new CmplException("Cannot read solution file :" + this._cmplInfoFile + " ->" + iOException);
            }
        } else {
            arrayList = new ArrayList<String>(Arrays.asList(string.split("\n")));
        }
        int n = 1;
        object = false;
        Boolean bl = false;
        Boolean bl2 = false;
        Boolean bl3 = false;
        for (String string3 : arrayList) {
            if (n == 1) {
                if (string3.contains("<?xml version")) {
                    ++n;
                    continue;
                }
                throw new CmplException("Cant't read cmplInfo file  - Not a XML file !");
            }
            if (n == 2) {
                if (string3.contains("<CmplInfo")) {
                    ++n;
                    continue;
                }
                throw new CmplException("Cant't read cmplInfo file  - Not a CmplInfo file !");
            }
            if (string3.contains("<general>")) {
                object = true;
                bl = false;
                bl2 = false;
                bl3 = false;
                continue;
            }
            if (string3.contains("</general>")) {
                object = false;
                continue;
            }
            if (string3.contains("<statistics")) {
                this._statisticsFileName = CmplTools.xmlStrToStringList(string3, "\"([^\"]*)\"").get(0);
                object = false;
                bl = false;
                bl2 = true;
                bl3 = false;
                continue;
            }
            if (string3.contains("</statistics")) {
                bl2 = false;
                continue;
            }
            if (string3.contains("<variableProducts")) {
                this._varProdFileName = CmplTools.xmlStrToStringList(string3, "\"([^\"]*)\"").get(0);
                object = false;
                bl = true;
                bl2 = false;
                bl3 = false;
                continue;
            }
            if (string3.contains("</variableProducts")) {
                bl = false;
                continue;
            }
            if (string3.contains("<matrix")) {
                this._matrixFileName = CmplTools.xmlStrToStringList(string3, "\"([^\"]*)\"").get(0);
                object = false;
                bl = false;
                bl2 = false;
                bl3 = true;
                continue;
            }
            if (string3.contains("</matrix")) {
                bl3 = false;
                continue;
            }
            if (((Boolean)object).booleanValue() && string3.contains("<generalStatus")) {
                this._instanceName = CmplTools.xmlStrToString(string3, "<instanceName>([^\"]*)</instanceName>");
                continue;
            }
            if (bl2.booleanValue()) {
                this._statisticsText = this._statisticsText + string3 + "\n";
            }
            if (bl.booleanValue()) {
                this._varProdText = this._varProdText + string3 + "\n";
            }
            if (!bl3.booleanValue()) continue;
            this._matrixText = this._matrixText + string3 + "\n";
        }
    }
}

