/*
 * Decompiled with CFR 0.152.
 */
package jCMPL;

import jCMPL.CmplException;
import jCMPL.CmplInfo;
import jCMPL.CmplInstance;
import jCMPL.CmplMessages;
import jCMPL.CmplMsg;
import jCMPL.CmplParameter;
import jCMPL.CmplSet;
import jCMPL.CmplSolArray;
import jCMPL.CmplSolElement;
import jCMPL.CmplSolution;
import jCMPL.CmplSolutions;
import jCMPL.CmplTools;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class Cmpl
extends Thread {
    public static final int COMPATIBILITY = 2;
    public static final int CMPL_UNKNOWN = 0;
    public static final int CMPL_OK = 1;
    public static final int CMPL_WARNINGS = 2;
    public static final int CMPL_FAILED = 3;
    public static final int SOLVER_OK = 4;
    public static final int SOLVER_FAILED = 5;
    public static final int CMPLSERVER_OK = 6;
    public static final int CMPLSERVER_ERROR = 7;
    public static final int CMPLSERVER_BUSY = 8;
    public static final int CMPLSERVER_CLEANED = 9;
    public static final int CMPLSERVER_WARNING = 10;
    public static final int PROBLEM_RUNNING = 11;
    public static final int PROBLEM_FINISHED = 12;
    public static final int PROBLEM_CANCELED = 13;
    public static final int PROBLEM_NOTRUNNING = 14;
    public static final int CMPLGRID_SCHEDULER_UNKNOWN = 15;
    public static final int CMPLGRID_SCHEDULER_OK = 16;
    public static final int CMPLGRID_SCHEDULER_ERROR = 17;
    public static final int CMPLGRID_SCHEDULER_BUSY = 18;
    public static final int CMPLGRID_SCHEDULER_SOLVER_NOT_AVAILABLE = 19;
    public static final int CMPLGRID_SCHEDULER_WARNING = 20;
    public static final int CMPLGRID_SCHEDULER_PROBLEM_DELETED = 21;
    public static final int CMPL_GRID = 22;
    public static final int STANDALONE_SERVER = 23;
    public static final int SERVER_UNKNOWN = 24;
    private Map<Integer, String> CMPL_STATUS_TXT = new HashMap<Integer, String>();
    private final int _compatibility;
    private String _cmplDataFile;
    private String _cmplMsgFile;
    private String _cmplSolFile;
    private String _problem;
    private StringBuilder _cmplDataStr;
    private ArrayList<CmplSet> _setList;
    private ArrayList<CmplParameter> _parameterList;
    private HashMap<Integer, String> _optionsList;
    private CmplMessages _status;
    private CmplSolutions _solutions;
    private String _solutionString;
    private CmplInfo _cmplInfos;
    private String _cmplInfoString;
    private boolean _remoteMode;
    private int _remoteStatus;
    private String _jobId;
    private String _solver;
    private int _maxCmplServerTries;
    private int _maxCmplServerQueuingTime;
    private XmlRpcClient _cmplServer;
    private String _cmplUrl;
    private boolean _cmplServerRunning;
    private XmlRpcClient _cmplGridScheduler;
    private String _cmplGridSchedulerUrl;
    private int _serverMode;
    private Process _cmplProc;
    private long _refreshTime;
    private boolean _printOutput;
    private String _outputString;
    private int _id;
    private String _outputLeadString;
    private final String _model;
    private boolean _isCleaned;
    private boolean _debug;
    private boolean _runCanceled;

    public Cmpl(String string) throws CmplException {
        this._compatibility = 2;
        this.CMPL_STATUS_TXT.put(0, "CMPL_UNKNOWN");
        this.CMPL_STATUS_TXT.put(1, "CMPL_OK");
        this.CMPL_STATUS_TXT.put(2, "CMPL_WARNINGS");
        this.CMPL_STATUS_TXT.put(3, "CMPL_FAILED");
        this.CMPL_STATUS_TXT.put(4, "SOLVER_OK");
        this.CMPL_STATUS_TXT.put(5, "SOLVER_FAILED");
        this.CMPL_STATUS_TXT.put(6, "CMPLSERVER_OK");
        this.CMPL_STATUS_TXT.put(7, "CMPLSERVER_ERROR");
        this.CMPL_STATUS_TXT.put(8, "CMPLSERVER_BUSY");
        this.CMPL_STATUS_TXT.put(9, "CMPLSERVER_CLEANED");
        this.CMPL_STATUS_TXT.put(10, "CMPLSERVER_WARNING");
        this.CMPL_STATUS_TXT.put(11, "PROBLEM_RUNNING");
        this.CMPL_STATUS_TXT.put(12, "PROBLEM_FINISHED");
        this.CMPL_STATUS_TXT.put(13, "PROBLEM_CANCELED");
        this.CMPL_STATUS_TXT.put(14, "PROBLEM_NOTRUNNING");
        this.CMPL_STATUS_TXT.put(15, "CMPLGRID_SCHEDULER_UNKNOWN");
        this.CMPL_STATUS_TXT.put(16, "CMPLGRID_SCHEDULER_OK");
        this.CMPL_STATUS_TXT.put(17, "CMPLGRID_SCHEDULER_ERROR");
        this.CMPL_STATUS_TXT.put(18, "CMPLGRID_SCHEDULER_BUSY");
        this.CMPL_STATUS_TXT.put(19, "CMPLGRID_SCHEDULER_SOLVER_NOT_AVAILABLE");
        this.CMPL_STATUS_TXT.put(20, "CMPLGRID_SCHEDULER_WARNING");
        this.CMPL_STATUS_TXT.put(21, "CMPLGRID_SCHEDULER_PROBLEM_DELETED");
        this.CMPL_STATUS_TXT.put(22, "CMPL_GRID");
        this.CMPL_STATUS_TXT.put(23, "STANDALONE_SERVER");
        this.CMPL_STATUS_TXT.put(24, "SERVER_UNKNOWN");
        this._problem = "";
        this._cmplDataFile = "";
        this._cmplMsgFile = "";
        this._cmplSolFile = "";
        this._cmplDataStr = new StringBuilder();
        this._setList = new ArrayList();
        this._parameterList = new ArrayList();
        this._optionsList = new HashMap();
        this._status = new CmplMessages();
        this._solutions = new CmplSolutions();
        this._solutionString = "";
        this._cmplInfos = null;
        this._cmplInfoString = "";
        this._remoteMode = false;
        this._remoteStatus = 0;
        this._cmplUrl = "";
        this._cmplGridSchedulerUrl = "";
        this._cmplServerRunning = false;
        this._serverMode = 24;
        this._jobId = "";
        this._solver = "cbc";
        this._maxCmplServerTries = 10;
        this._maxCmplServerQueuingTime = 300;
        this._cmplServer = null;
        this._cmplServerRunning = false;
        this._cmplProc = null;
        this._refreshTime = 400L;
        this._printOutput = false;
        this._outputString = "";
        this._model = string;
        this._isCleaned = false;
        this._debug = false;
        Locale.setDefault(Locale.ENGLISH);
        File file = new File(this._model);
        int n = 100000;
        int n2 = 999999;
        if (!file.exists()) {
            throw new CmplException("Cannot read CMPL file: " + this._model);
        }
        this._id = n + (int)(Math.random() * (double)(n2 - n + 1));
        this._outputLeadString = file.getName().substring(0, file.getName().lastIndexOf(46)) + "> ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            try {
                this.cleanUp();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    public String model() {
        return this._model;
    }

    public String problem() {
        return this._problem;
    }

    public long refreshTime() {
        return this._refreshTime;
    }

    public String output() {
        return this._outputString;
    }

    public ArrayList<CmplMsg> cmplMessages() {
        return this._status.cmplMessageList();
    }

    public ArrayList<CmplSolution> solutionPool() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solutions();
        }
        throw new CmplException("No solution found so far");
    }

    public CmplSolution solution() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solution();
        }
        throw new CmplException("No solution found so far");
    }

    public long nrOfVariables() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.nrOfVariables();
        }
        throw new CmplException("The model isn't generated yet.");
    }

    public long nrOfConstraints() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.nrOfConstraints();
        }
        throw new CmplException("The model isn't generated yet.");
    }

    public String objectiveName() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.objectiveName();
        }
        throw new CmplException("No solution found so far");
    }

    public String objectiveSense() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.objectiveSense();
        }
        throw new CmplException("No solution found so far");
    }

    public int nrOfSolutions() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.nrOfSolutions();
        }
        throw new CmplException("No solution found so far");
    }

    public String solver() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solver();
        }
        throw new CmplException("Since the model isn't solved the solver is not known.");
    }

    public String solverMessage() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.solverMessage();
        }
        throw new CmplException("Since the model isn't solved the solver message is not known.");
    }

    public String varDisplayOptions() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.varDisplayOptions();
        }
        throw new CmplException("Since the model isn't solved this option isn't known.");
    }

    public String conDisplayOptions() throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            return this._solutions.conDisplayOptions();
        }
        throw new CmplException("Since the model isn't solved this option isn't known.");
    }

    public int cmplStatus() {
        if (this._remoteMode && this._remoteStatus != 0) {
            return this._remoteStatus;
        }
        return this._status.cmplStatus();
    }

    public String cmplStatusText() {
        int n = 0;
        n = this._remoteMode && this._remoteStatus != 0 ? this._remoteStatus : this._status.cmplStatus();
        return this.CMPL_STATUS_TXT.get(n);
    }

    public int solverStatus() {
        if (this._solutions.nrOfSolutions() == 0) {
            return 5;
        }
        return 4;
    }

    public String solverStatusText() {
        if (this._solutions.nrOfSolutions() == 0) {
            return "SOLVER_FAILED";
        }
        return "SOLVER_OK";
    }

    public String cmplSolFile() {
        return this._solutions.cmplSolFile();
    }

    public String csvSolFile() {
        return this._solutions.csvSolFile();
    }

    public String asciiSolFile() {
        return this._solutions.asciiSolFile();
    }

    public String jobId() {
        return this._jobId;
    }

    public void setOutput(Boolean bl, String string) {
        this._printOutput = bl;
        if (!string.isEmpty()) {
            this._outputLeadString = string;
        }
    }

    public void setOutput(Boolean bl) {
        this.setOutput(bl, "");
    }

    public void setRefreshTime(long l) {
        this._refreshTime = l;
    }

    private void setSet(CmplSet cmplSet) throws CmplException {
        if (cmplSet.len() <= 0) {
            throw new CmplException("set " + cmplSet.name() + " contains no elements ");
        }
        this._setList.add(cmplSet);
    }

    public void setSets(CmplSet ... cmplSetArray) throws CmplException {
        for (int i = 0; i < cmplSetArray.length; ++i) {
            this.setSet(cmplSetArray[i]);
        }
    }

    private void setParameter(CmplParameter cmplParameter) throws CmplException {
        if (cmplParameter.len() <= 0L) {
            throw new CmplException("set " + cmplParameter.name() + " contains no elements ");
        }
        this._parameterList.add(cmplParameter);
    }

    public void setParameters(CmplParameter ... cmplParameterArray) throws CmplException {
        for (int i = 0; i < cmplParameterArray.length; ++i) {
            this.setParameter(cmplParameterArray[i]);
        }
    }

    public Integer setOption(String string) {
        Integer n = this._optionsList.size();
        this._optionsList.put(n, string);
        return n;
    }

    public void delOption(Integer n) throws CmplException {
        this._optionsList.remove(n);
    }

    public void delOptions() {
        this._optionsList.clear();
    }

    public void setMaxServerQueuingTime(Integer n) {
        this._maxCmplServerQueuingTime = n;
    }

    public int maxServerQueuingTime() {
        return this._maxCmplServerQueuingTime;
    }

    public void setMaxServerTries(Integer n) {
        this._maxCmplServerTries = n;
    }

    public int maxServerTries() {
        return this._maxCmplServerTries;
    }

    public void debug(boolean bl) {
        this._debug = bl;
    }

    public Object getVarByName(String string) throws CmplException {
        return this.getVarByName(string, 0);
    }

    public Object getVarByName(String string, int n) throws CmplException {
        return this.getElementByName(string, this._solutions.solutions().get(n).variables());
    }

    public Object getConByName(String string) throws CmplException {
        return this.getConByName(string, 0);
    }

    public Object getConByName(String string, int n) throws CmplException {
        return this.getElementByName(string, this._solutions.solutions().get(n).constraints());
    }

    public void solve() throws CmplException {
        block36: {
            Object object;
            if (this._remoteMode) {
                if (!this._cmplServerRunning) {
                    throw new CmplException("Model is not connected to a CmplServer");
                }
                this._status = new CmplMessages();
                this._solutions = new CmplSolutions();
                int n = 0;
                long l = 0L;
                while (true) {
                    this._isCleaned = false;
                    try {
                        if (this._remoteStatus == 9) {
                            this.connect(this._cmplUrl);
                        }
                        if (this._serverMode == 22 && this._remoteStatus == 7) {
                            this.connect(this._cmplUrl);
                        }
                        if (this._remoteStatus == 18) {
                            l = System.currentTimeMillis();
                            while (this._remoteStatus != 16) {
                                Thread.sleep(this._refreshTime);
                                this.knockScheduler();
                                if ((System.currentTimeMillis() - l) / 1000L < (long)this._maxCmplServerQueuingTime) continue;
                                this.cleanUp();
                                throw new CmplException("maximum CmplServer queuing time is exceeded.");
                            }
                        }
                        String string = this.send();
                        if (this._debug) {
                            String string2 = this._problem + ".cinst";
                            CmplTools.writeAsciiFile(string2, string);
                        }
                        if (this._remoteStatus == 8) {
                            l = System.currentTimeMillis();
                        }
                        while (this._remoteStatus != 12) {
                            this.knock();
                            Thread.sleep(this._refreshTime);
                            if (this._remoteStatus != 8 || (System.currentTimeMillis() - l) / 1000L < (long)this._maxCmplServerQueuingTime) continue;
                            throw new CmplException("maximum CmplServer queuing time is exceeded.");
                        }
                        this.retrieve();
                        break block36;
                    }
                    catch (CmplException cmplException) {
                        if (this._serverMode == 22 && this._remoteStatus == 7 && !this._cmplGridSchedulerUrl.isEmpty()) {
                            try {
                                this.cmplServerExecute("cmplServerFailed", new Object[]{this._cmplUrl});
                                this.handleOutput("CmplServer failed <" + this._cmplUrl + ">: Problem will be newly connected to CmplGridScheduler and commited to another CmplServer.");
                                this._cmplUrl = this._cmplGridSchedulerUrl;
                                this._cmplGridSchedulerUrl = "";
                                this._cmplGridScheduler = null;
                                this._cmplServer = null;
                                continue;
                            }
                            catch (CmplException cmplException2) {
                                throw new CmplException("CmplGridScheduler failed: " + cmplException2.msg());
                            }
                            if (++n != this._maxCmplServerTries) continue;
                            throw new CmplException(cmplException.msg());
                        }
                        throw new CmplException(cmplException.msg());
                    }
                    catch (InterruptedException interruptedException) {
                        throw new CmplException("Problem has been canceled by user.");
                    }
                    break;
                }
            }
            Properties properties = System.getProperties();
            String string = properties.getProperty("os.name");
            this._problem = this._model.substring(0, this._model.lastIndexOf("."));
            this._cmplDataFile = this._problem + "_" + this._id + ".cdat";
            this._cmplMsgFile = this._problem + "_" + this._id + ".cmsg";
            this._cmplSolFile = this._problem + "_" + this._id + ".csol";
            this.cmplDataElements();
            this._status = new CmplMessages(this._cmplMsgFile);
            this._solutions = new CmplSolutions(this._cmplSolFile);
            File file = new File(this._problem);
            String string3 = file.getName() + "_" + this._id;
            String string4 = System.getenv("CMPLBINARY");
            if (string4 == null) {
                if (string.contains("Mac")) {
                    string4 = "/usr/bin/cmpl";
                } else if (string.contains("Linux")) {
                    string4 = "/usr/share/Cmpl/cmpl";
                } else if (string.contains("Windows")) {
                    string4 = "c:\\program files\\Cmpl\\cmpl.bat";
                    object = properties.getProperty("os.arch");
                    if (((String)object).contains("_64") && !new File(string4).exists()) {
                        string4 = "c:\\program files (x86)\\Cmpl\\cmpl.bat";
                    }
                } else {
                    throw new CmplException("Your operating system is not supported : " + string);
                }
            }
            if (((File)(object = new File(string4))).exists() && ((File)object).canExecute()) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string4);
                arrayList.add(this._model);
                arrayList.add("-solution");
                arrayList.add("-e");
                arrayList.add("-alias");
                arrayList.add(string3);
                if (string.contains("Windows")) {
                    arrayList.add("-cmplJava");
                }
                if (!this._optionsList.isEmpty()) {
                    for (Map.Entry object2 : this._optionsList.entrySet()) {
                        arrayList.add("-headerOpt");
                        arrayList.add(((String)object2.getValue()).replace(" ", "#"));
                    }
                }
                try {
                    String string2;
                    ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
                    processBuilder.redirectErrorStream(true);
                    this._cmplProc = processBuilder.start();
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this._cmplProc.getInputStream()));
                    while ((string2 = bufferedReader.readLine()) != null) {
                        this.handleOutput(string2);
                    }
                    if (!this._runCanceled) {
                        this._cmplProc.waitFor();
                    }
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    throw new CmplException("Can't execute the CMPL binary : " + iOException);
                }
                catch (InterruptedException interruptedException) {
                    throw new CmplException("Internal error : " + interruptedException);
                }
                if (this._cmplProc.exitValue() != 0) {
                    throw new CmplException(this._outputString);
                }
                this._status.readCmplMessages();
                if (this._status.cmplStatus() == 3) {
                    throw new CmplException("Cmpl finished with errors", this._status.cmplMessageList());
                }
                this._solutions.readSolution();
                this.cleanUp();
            } else {
                throw new CmplException("Cant't execute Cmpl binary: " + string4);
            }
        }
    }

    @Override
    public void run() {
        try {
            this.solve();
        }
        catch (CmplException cmplException) {
            System.err.println(cmplException.msg());
        }
    }

    @Override
    public void interrupt() {
        this._runCanceled = true;
        this._cmplProc.destroy();
        try {
            this.cleanUp();
        }
        catch (CmplException cmplException) {
            System.err.println(cmplException.msg());
        }
    }

    public void connect(String string) throws CmplException {
        this._cmplUrl = string;
        this._remoteMode = true;
        File file = new File(this._model);
        Object[] objectArray = null;
        int n = 0;
        if (this._remoteStatus != 0 && this._remoteStatus != 9 && this._serverMode != 22) {
            throw new CmplException("Problem is still connected with CMPLServer: at " + string + " with jobId " + this._jobId);
        }
        while (true) {
            this._remoteMode = true;
            this._remoteStatus = 0;
            this._serverMode = 23;
            this._cmplServer = null;
            this._cmplUrl = string;
            this._cmplGridSchedulerUrl = "";
            this._cmplGridScheduler = null;
            try {
                XmlRpcClientConfigImpl xmlRpcClientConfigImpl = new XmlRpcClientConfigImpl();
                xmlRpcClientConfigImpl.setServerURL(new URL(this._cmplUrl));
                this._cmplServer = new XmlRpcClient();
                this._cmplServer.setConfig((XmlRpcClientConfig)xmlRpcClientConfigImpl);
                this.getSolver();
                objectArray = this.cmplServerExecute("getJobId", new Object[]{file.getName(), this._solver, this._compatibility});
                this._remoteStatus = (Integer)objectArray[0];
                if (this._remoteStatus == 6 || this._remoteStatus == 16 || this._remoteStatus == 18) {
                    this._jobId = (String)objectArray[2];
                }
                if (this._remoteStatus == 6 || this._remoteStatus == 7) {
                    this._serverMode = 23;
                    break;
                }
                if (this._remoteStatus != 16 && this._remoteStatus != 17 && this._remoteStatus != 18) break;
                this._serverMode = 22;
                this.handleOutput("Connected with CmplGridScheduler at " + this._cmplUrl + " with jobId " + this._jobId);
                if (this._remoteStatus != 16) break;
                this.connectServerViaScheduler(objectArray[1].toString());
                this._serverMode = 22;
            }
            catch (Exception exception) {
                ++n;
                this._cmplServer = null;
                if (exception.toString().contains("getJobId()")) {
                    throw new CmplException("Incompatible CmplServer - please install a newer CMPLServer");
                }
                if (this._remoteStatus != 0) {
                    if (n != this._maxCmplServerTries) continue;
                    throw new CmplException("CmplServer error: " + exception.toString());
                }
                throw new CmplException("CmplServer error: " + exception.toString());
            }
            break;
        }
        if (this._remoteStatus == 7 || this._remoteStatus == 17) {
            this.cleanUp();
            throw new CmplException((String)objectArray[1]);
        }
        this._cmplServerRunning = true;
        if (this._serverMode != 22) {
            this.handleOutput("Connected with CmplServer at " + this._cmplUrl + " with jobId " + this._jobId + " >> maxServerTries <" + this._maxCmplServerTries + "> maxQueuingTime <" + this._maxCmplServerQueuingTime + ">");
        }
        if (this._remoteStatus == 18) {
            this.handleOutput((String)objectArray[1]);
        }
    }

    public void disconnect() throws CmplException {
        this.cleanUp();
        this._remoteStatus = 0;
        this._cmplServer = null;
        this._cmplUrl = "";
        this._remoteMode = false;
        this._serverMode = 23;
    }

    public String send() throws CmplException {
        String string;
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplServer");
            }
            if (this._remoteStatus == 9) {
                this.connect(this._cmplUrl);
            }
            this.knock();
            if (this._remoteStatus == 11) {
                throw new CmplException("Don't send the problem again before the CmplServer finished the previous one");
            }
            this._problem = this._model.substring(0, this._model.lastIndexOf(46));
            this.cmplDataElements();
            this._status = new CmplMessages();
            this._solutions = new CmplSolutions();
            this._cmplInfos = new CmplInfo();
            CmplInstance cmplInstance = new CmplInstance();
            string = cmplInstance.cmplInstanceStr(this._model, this._optionsList, this._cmplDataStr.toString(), this._jobId);
            Object[] objectArray = this.cmplServerExecute("send", new Object[]{string});
            this._remoteStatus = (Integer)objectArray[0];
            if (this._remoteStatus == 7) {
                this.cleanUp();
                throw new CmplException((String)objectArray[1]);
            }
        } else {
            throw new CmplException("Cmpl.send can only be used in remote mode");
        }
        return string;
    }

    public void knock() throws CmplException {
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplServer");
            }
            if (this._remoteStatus == 9) {
                throw new CmplException("Model was received and cleaned on the CmplServer");
            }
            if (this._remoteStatus != 13) {
                Object[] objectArray = this.cmplServerExecute("knock", new Object[]{this._jobId});
                this._remoteStatus = (Integer)objectArray[0];
                if (this._remoteStatus == 7 || this._remoteStatus == 3) {
                    this.cleanUp();
                    throw new CmplException((String)objectArray[1]);
                }
                this.handleOutput((String)objectArray[2]);
            }
        } else {
            throw new CmplException("Cmpl.knock can only be used in remote mode");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void retrieve() throws CmplException {
        if (!this._remoteMode) throw new CmplException("Cmpl.retrieve can only be used in remote mode");
        if (!this._cmplServerRunning) {
            throw new CmplException("Model is not connected to a CmplServer");
        }
        if (this._remoteStatus == 9) {
            throw new CmplException("Model was received and cleaned from the CmplServer");
        }
        if (this._remoteStatus == 0) {
            this.knock();
        }
        if (this._remoteStatus == 12) {
            Object[] objectArray = this.cmplServerExecute("getCmplMessages", new Object[]{this._jobId});
            this._remoteStatus = (Integer)objectArray[0];
            if (this._remoteStatus == 7) {
                this.cleanUp();
                throw new CmplException((String)objectArray[1]);
            }
            this._status.readCmplMessages((String)objectArray[2]);
            if (this._status.cmplStatus() == 3) {
                this.cleanUp();
                throw new CmplException("Cmpl finished with errors", this._status.cmplMessageList());
            }
            objectArray = this.cmplServerExecute("getSolutions", new Object[]{this._jobId});
            this._remoteStatus = (Integer)objectArray[0];
            if (this._remoteStatus == 7) {
                this.cleanUp();
                throw new CmplException((String)objectArray[1]);
            }
            this._solutionString = (String)objectArray[2];
            this._solutions.readSolution(this._solutionString);
            this.writeSolFiles();
            objectArray = this.cmplServerExecute("getCmplInfo", new Object[]{this._jobId});
            this._remoteStatus = (Integer)objectArray[0];
            if (this._remoteStatus == 7) {
                this.cleanUp();
                throw new CmplException((String)objectArray[1]);
            }
            this._cmplInfoString = (String)objectArray[2];
            this._cmplInfos.readCmplInfo(this._cmplInfoString);
        } else {
            if (this._remoteStatus != 13) throw new CmplException("Model is still running, cannot retrieve the solutions");
            throw new CmplException("Model has been canceled by user, cannot retrieve the solutions");
        }
        this.writeInfoFiles();
        this.cleanUp();
    }

    public void cancel() throws CmplException {
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplServer");
            }
            if (this._remoteStatus == 9) {
                throw new CmplException("Model has been received and cleaned on the CmplServer");
            }
            if (this._remoteStatus != 13) {
                Object[] objectArray = this.cmplServerExecute("cancel", new Object[]{this._jobId});
                this._remoteStatus = (Integer)objectArray[0];
                if (this._remoteStatus == 7) {
                    this.cleanUp();
                    throw new CmplException((String)objectArray[1]);
                }
                objectArray = this.cmplServerExecute("removeProblem", new Object[]{this._jobId});
                this._remoteStatus = (Integer)objectArray[0];
                if (this._remoteStatus == 7) {
                    this.cleanUp();
                    throw new CmplException((String)objectArray[1]);
                }
                this._remoteStatus = 9;
            }
        } else {
            this.cleanUp();
        }
    }

    public void saveSolution() throws CmplException {
        this.saveSolution("");
    }

    public void saveSolution(String string) throws CmplException {
        String string2;
        if (this._solutions.nrOfSolutions() > 0) {
            string2 = string.isEmpty() ? this._problem + ".csol" : string;
            if (!this._remoteMode) {
                for (String string3 : this._solutions.solFileContent()) {
                    this._solutionString = this._solutionString + string3 + "\n";
                }
            }
        } else {
            throw new CmplException("No solution found so far");
        }
        this._solutions.delSolFileContent();
        CmplTools.writeAsciiFile(string2, this._solutionString);
    }

    public void saveSolutionAscii() throws CmplException {
        this.saveSolutionAscii("");
    }

    public void saveSolutionAscii(String string) throws CmplException {
        if (this._solutions.nrOfSolutions() <= 0) {
            throw new CmplException("No solution found so far");
        }
        String string2 = string.isEmpty() ? this._problem + ".sol" : string;
        this.solutionReport(string2);
    }

    public void solutionReport() throws CmplException {
        this.solutionReport("");
    }

    public void solutionReport(String string) throws CmplException {
        StringBuilder stringBuilder = new StringBuilder();
        File file = new File(this._model);
        if (this._solutions.nrOfSolutions() > 0) {
            stringBuilder.append("---------------------------------------------------------------------------------------------------------\n");
            stringBuilder.append(String.format("%-20s %s%n", "Problem", file.getName()));
            stringBuilder.append(String.format("%-20s %d%n", "Nr. of variables", this._solutions.nrOfVariables()));
            stringBuilder.append(String.format("%-20s %d%n", "Nr. of constraints", this._solutions.nrOfConstraints()));
            stringBuilder.append(String.format("%-20s %s%n", "Objective name", this._solutions.objectiveName()));
            if (this._solutions.nrOfSolutions() > 1) {
                stringBuilder.append(String.format("%-20s %d%n", "Nr. of solutions", this._solutions.nrOfSolutions()));
            }
            stringBuilder.append(String.format("%-20s %s%n", "Solver name", this._solutions.solver()));
            stringBuilder.append(String.format("%-20s %s%n", "Display variables", this._solutions.varDisplayOptions()));
            stringBuilder.append(String.format("%-20s %s%n", "Display vonstraints", this._solutions.conDisplayOptions()));
            stringBuilder.append("---------------------------------------------------------------------------------------------------------\n");
            for (CmplSolution cmplSolution : this._solutions.solutions()) {
                stringBuilder.append("\n");
                if (this._solutions.nrOfSolutions() > 1) {
                    stringBuilder.append(String.format("%-20s %d%n", "Solution nr.", cmplSolution.idx()));
                }
                stringBuilder.append(String.format("%-20s %s%n", "Objective status", cmplSolution.status()));
                stringBuilder.append(String.format("%-20s %-20.2f (%s!)%n", "Objective value", cmplSolution.value(), this._solutions.objectiveSense()));
                stringBuilder.append("\n");
                if (cmplSolution.variables().size() > 0) {
                    stringBuilder.append(String.format("%-20s%n", "Variables"));
                    stringBuilder.append(String.format("%-20s%5s%20s%20s%20s%20s%n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                    stringBuilder.append("---------------------------------------------------------------------------------------------------------\n");
                    for (CmplSolElement cmplSolElement : cmplSolution.variables()) {
                        if (cmplSolElement.type().equals("C")) {
                            stringBuilder.append(String.format("%-20s%5s%20.2f%20.2f%20.2f", cmplSolElement.name(), cmplSolElement.type(), (Double)cmplSolElement.activity(), cmplSolElement.lowerBound(), cmplSolElement.upperBound()));
                        } else {
                            stringBuilder.append(String.format("%-20s%5s%20d%20.2f%20.2f", cmplSolElement.name(), cmplSolElement.type(), (Long)cmplSolElement.activity(), cmplSolElement.lowerBound(), cmplSolElement.upperBound()));
                        }
                        if (this._solutions.isIntegerProgram()) {
                            stringBuilder.append(String.format("%20s%n", "-"));
                            continue;
                        }
                        stringBuilder.append(String.format("%20.2f%n", cmplSolElement.marginal()));
                    }
                    stringBuilder.append("---------------------------------------------------------------------------------------------------------\n");
                }
                if (cmplSolution.constraints().size() <= 0) continue;
                stringBuilder.append("\n");
                stringBuilder.append(String.format("%-20s%n", "Constraints"));
                stringBuilder.append(String.format("%-20s%5s%20s%20s%20s%20s%n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                stringBuilder.append("---------------------------------------------------------------------------------------------------------\n");
                for (CmplSolElement cmplSolElement : cmplSolution.constraints()) {
                    stringBuilder.append(String.format("%-20s%5s%20.2f%20.2f%20.2f", cmplSolElement.name(), cmplSolElement.type(), cmplSolElement.activity(), cmplSolElement.lowerBound(), cmplSolElement.upperBound()));
                    if (this._solutions.isIntegerProgram()) {
                        stringBuilder.append(String.format("%20s%n", "-"));
                        continue;
                    }
                    stringBuilder.append(String.format("%20.2f%n", cmplSolElement.marginal()));
                }
                stringBuilder.append("---------------------------------------------------------------------------------------------------------\n");
            }
            if (string.isEmpty()) {
                System.out.print(stringBuilder);
            } else {
                try {
                    BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
                    bufferedWriter.write(stringBuilder.toString());
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    throw new CmplException("IO error for file " + string + ": " + iOException);
                }
            }
        } else {
            throw new CmplException("No solution found so far");
        }
    }

    public void saveSolutionCsv() throws CmplException {
        this.saveSolutionCsv("");
    }

    public void saveSolutionCsv(String string) throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            String string2 = string.isEmpty() ? this._problem + ".csv" : string;
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
                bufferedWriter.write("CMPL csv export\n");
                bufferedWriter.write("\n");
                bufferedWriter.write(String.format("%s;%s\n", "Problem", this._problem + ".cmpl"));
                bufferedWriter.write(String.format("%s;%d\n", "Nr. of variables", this._solutions.nrOfVariables()));
                bufferedWriter.write(String.format("%s;%d\n", "Nr. of constraints", this._solutions.nrOfConstraints()));
                bufferedWriter.write(String.format("%s;%s\n", "Objective name", this._solutions.objectiveName()));
                if (this._solutions.nrOfSolutions() > 1) {
                    bufferedWriter.write(String.format("%s;%d\n", "Nr. of solutions", this._solutions.nrOfSolutions()));
                }
                bufferedWriter.write(String.format("%s;%s\n", "Solver name", this._solutions.solver()));
                bufferedWriter.write(String.format("%s;%s\n", "Display variables", this._solutions.varDisplayOptions()));
                bufferedWriter.write(String.format("%s;%s\n", "Display constraints", this._solutions.conDisplayOptions()));
                for (CmplSolution cmplSolution : this._solutions.solutions()) {
                    bufferedWriter.write("\n");
                    if (this._solutions.nrOfSolutions() > 1) {
                        bufferedWriter.write(String.format("%s;%d\n", "Solution Nr.", cmplSolution.idx() + 1));
                    }
                    bufferedWriter.write(String.format("%s;%s\n", "Objective status", cmplSolution.status()));
                    bufferedWriter.write(String.format("%s;%f;(%s!)\n", "Objective value", cmplSolution.value(), this._solutions.objectiveSense()));
                    if (cmplSolution.variables().size() > 0) {
                        bufferedWriter.write(String.format("%s\n", "Variables"));
                        bufferedWriter.write(String.format("%s;%s;%s;%s;%s;%s\n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                        for (CmplSolElement cmplSolElement : cmplSolution.variables()) {
                            if (cmplSolElement.type().equals("C")) {
                                bufferedWriter.write(String.format("%s;%s;%f;%f;%f", cmplSolElement.name(), cmplSolElement.type(), (Double)cmplSolElement.activity(), cmplSolElement.lowerBound(), cmplSolElement.upperBound()));
                            } else {
                                bufferedWriter.write(String.format("%s;%s;%d;%f;%f", cmplSolElement.name(), cmplSolElement.type(), (Long)cmplSolElement.activity(), cmplSolElement.lowerBound(), cmplSolElement.upperBound()));
                            }
                            if (this._solutions.isIntegerProgram()) {
                                bufferedWriter.write(";-\n");
                                continue;
                            }
                            bufferedWriter.write(String.format(";%f\n", cmplSolElement.marginal()));
                        }
                    }
                    if (cmplSolution.constraints().size() <= 0) continue;
                    bufferedWriter.write(String.format("%s\n", "Constraints"));
                    bufferedWriter.write(String.format("%s;%s;%s;%s;%s;%s\n", "Name", "Type", "Activity", "LowerBound", "UpperBound", "Marginal"));
                    for (CmplSolElement cmplSolElement : cmplSolution.constraints()) {
                        bufferedWriter.write(String.format("%s;%s;%f;%f;%f", cmplSolElement.name(), cmplSolElement.type(), cmplSolElement.activity(), cmplSolElement.lowerBound(), cmplSolElement.upperBound()));
                        if (this._solutions.isIntegerProgram()) {
                            bufferedWriter.write(";-\n");
                            continue;
                        }
                        bufferedWriter.write(String.format(";%f\n", cmplSolElement.marginal()));
                    }
                }
                bufferedWriter.close();
            }
            catch (Exception exception) {
                throw new CmplException("IO error for file " + string + ": " + exception);
            }
        } else {
            throw new CmplException("No solution found so far");
        }
    }

    private void cleanUp() throws CmplException {
        if (!this._isCleaned) {
            if (this._debug) {
                try {
                    System.out.println("Hit Enter to exit");
                    System.in.read();
                }
                catch (IOException iOException) {
                    throw new CmplException("Internal error: " + iOException);
                }
            }
            if (this._remoteMode) {
                if (this._serverMode != 22 || this._cmplGridSchedulerUrl != "") {
                    if (this._remoteStatus != 12 && this._remoteStatus != 7 && this._remoteStatus != 13 && this._cmplServerRunning) {
                        this.cmplServerExecute("cancel", new Object[]{this._jobId});
                    }
                    if (this._remoteStatus != 9 && this._remoteStatus != 7) {
                        this.cmplServerExecute("removeProblem", new Object[]{this._jobId});
                        this._remoteStatus = 9;
                    }
                }
                if (this._serverMode == 22 && (this._remoteStatus == 18 || this._remoteStatus == 15)) {
                    this.cmplServerExecute("disconnectProblem", new Object[]{this._jobId});
                }
            } else {
                if (this._cmplProc != null) {
                    this._cmplProc.destroy();
                }
                CmplTools.delTmpFile(this._cmplDataFile);
            }
            CmplTools.delTmpFile(this._cmplMsgFile);
            CmplTools.delTmpFile(this._cmplSolFile);
            this._isCleaned = true;
        }
    }

    private void cmplDataElements() throws CmplException {
        try {
            int n;
            for (CmplSet object : this._setList) {
                this._cmplDataStr.append("%");
                this._cmplDataStr.append(object.name());
                if (object.rank() > 1) {
                    this._cmplDataStr.append(" set[");
                    this._cmplDataStr.append(String.valueOf(object.rank()));
                    this._cmplDataStr.append("] < ");
                } else {
                    this._cmplDataStr.append(" set < ");
                }
                if (object.type() == 0) {
                    this._cmplDataStr.append("\n");
                    int n2 = 1;
                    for (n = 0; n < object.len(); ++n) {
                        this._cmplDataStr.append((CharSequence)this.writeElement(object.get(n)));
                        if (n2 == object.rank()) {
                            this._cmplDataStr.append("\n");
                            n2 = 1;
                            continue;
                        }
                        ++n2;
                    }
                }
                if (object.type() == 1) {
                    this._cmplDataStr.append("\n");
                    for (n = 0; n < object.len(); ++n) {
                        for (int i = 0; i < object.rank(); ++i) {
                            this._cmplDataStr.append((CharSequence)this.writeElement(object.get(n, i)));
                        }
                        this._cmplDataStr.append("\n");
                    }
                }
                if (object.type() == 2) {
                    this._cmplDataStr.append(object.get(0));
                    this._cmplDataStr.append("..");
                    this._cmplDataStr.append(object.get(1));
                    this._cmplDataStr.append(" ");
                }
                if (object.type() == 3) {
                    this._cmplDataStr.append(object.get(0));
                    this._cmplDataStr.append("(");
                    this._cmplDataStr.append(object.get(1));
                    this._cmplDataStr.append(")");
                    this._cmplDataStr.append(object.get(2));
                    this._cmplDataStr.append(" ");
                }
                this._cmplDataStr.append(">\n");
            }
            for (CmplParameter cmplParameter : this._parameterList) {
                this._cmplDataStr.append("%");
                this._cmplDataStr.append(cmplParameter.name());
                n = 0;
                if (cmplParameter.rank() > 0) {
                    this._cmplDataStr.append("[");
                    for (CmplSet cmplSet : cmplParameter.setList()) {
                        boolean bl = false;
                        for (CmplSet cmplSet2 : this._setList) {
                            if (!cmplSet.name().equals(cmplSet2.name())) continue;
                            bl = true;
                            break;
                        }
                        if (!bl) {
                            throw new CmplException("The set " + cmplSet.name() + " used for the parameter " + cmplParameter.name() + " doesn't exist.");
                        }
                        this._cmplDataStr.append(cmplSet.name());
                        if (n < cmplParameter.setList().size() - 1) {
                            this._cmplDataStr.append(",");
                        }
                        ++n;
                    }
                    this._cmplDataStr.append("] <\n");
                    this._cmplDataStr.append((CharSequence)this.writeListElements(cmplParameter.values()));
                    this._cmplDataStr.append(">\n");
                    continue;
                }
                this._cmplDataStr.append(" < ");
                this._cmplDataStr.append((CharSequence)this.writeElement(cmplParameter.value()));
                this._cmplDataStr.append(" >\n");
            }
            if (!this._remoteMode) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this._cmplDataFile));
                bufferedWriter.write(this._cmplDataStr.toString());
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            throw new CmplException("Internal error in " + this.getClass().getName() + "\n " + exception);
        }
    }

    private StringBuilder writeElement(Object object) throws CmplException {
        if (object == null) {
            throw new CmplException("Parameter or set w/o value ");
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (object.getClass().toString().contains("String")) {
            stringBuilder.append("\"");
            stringBuilder.append(object);
            stringBuilder.append("\" ");
        } else {
            stringBuilder.append(object.toString());
            stringBuilder.append(" ");
        }
        return stringBuilder;
    }

    private StringBuilder writeListElements(Object object) throws CmplException {
        StringBuilder stringBuilder = new StringBuilder();
        if (object instanceof int[]) {
            for (int i = 0; i < ((int[])object).length; ++i) {
                stringBuilder.append((CharSequence)this.writeElement(((int[])object)[i]));
            }
        } else if (object instanceof long[]) {
            for (int i = 0; i < ((long[])object).length; ++i) {
                stringBuilder.append((CharSequence)this.writeElement(((long[])object)[i]));
            }
        } else if (object instanceof float[]) {
            for (int i = 0; i < ((float[])object).length; ++i) {
                stringBuilder.append((CharSequence)this.writeElement(Float.valueOf(((float[])object)[i])));
            }
        } else if (object instanceof double[]) {
            for (int i = 0; i < ((double[])object).length; ++i) {
                stringBuilder.append((CharSequence)this.writeElement(((double[])object)[i]));
            }
        } else if (object.getClass().toString().contains("List") || object.getClass().isArray()) {
            if (object.getClass().toString().contains("List")) {
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    if (((ArrayList)object).get(i).getClass().toString().contains("List") || ((ArrayList)object).get(i).getClass().isArray()) {
                        stringBuilder.append((CharSequence)this.writeListElements(((ArrayList)object).get(i)));
                        continue;
                    }
                    stringBuilder.append((CharSequence)this.writeElement(((ArrayList)object).get(i)));
                }
            } else if (object.getClass().isArray()) {
                for (int i = 0; i < ((Object[])object).length; ++i) {
                    if (((Object[])object)[i].getClass().toString().contains("List") || ((Object[])object)[i].getClass().isArray()) {
                        stringBuilder.append((CharSequence)this.writeListElements(((Object[])object)[i]));
                        continue;
                    }
                    stringBuilder.append((CharSequence)this.writeElement(((Object[])object)[i]));
                }
            }
        } else {
            stringBuilder.append((CharSequence)this.writeElement(object));
        }
        stringBuilder.append("\n");
        return stringBuilder;
    }

    private void getSolver() throws CmplException {
        boolean bl = false;
        for (String string : this._optionsList.values()) {
            if (!string.contains("-solver")) continue;
            this._solver = string.split("\\s")[2].replace("\"", "");
            bl = true;
            break;
        }
        if (!bl) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(this._model));
                string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.trim().startsWith("%arg") || !string.contains("-solver")) continue;
                    this._solver = string.split("\\s")[2].replace("\"", "");
                }
            }
            catch (IOException iOException) {
                throw new CmplException("Cannot read Cmpl file <" + this._model + "> " + iOException);
            }
        }
    }

    private Object getElementByName(String string, ArrayList<CmplSolElement> arrayList) throws CmplException {
        if (this._solutions.nrOfSolutions() > 0) {
            CmplSolArray cmplSolArray = new CmplSolArray();
            CmplSolElement cmplSolElement = null;
            boolean bl = false;
            for (CmplSolElement cmplSolElement2 : arrayList) {
                if (!cmplSolElement2.name().startsWith(string)) continue;
                if (cmplSolElement2.name().contains("[")) {
                    if (!bl) {
                        bl = true;
                    }
                    cmplSolArray.put(cmplSolElement2.name().substring(cmplSolElement2.name().indexOf("[") + 1, cmplSolElement2.name().indexOf("]")), cmplSolElement2);
                    continue;
                }
                cmplSolElement = cmplSolElement2;
                break;
            }
            if (bl) {
                return cmplSolArray;
            }
            return cmplSolElement;
        }
        throw new CmplException("No solution found so far");
    }

    private void handleOutput(String string) {
        if (!string.isEmpty()) {
            if (this._printOutput) {
                if (!this._outputLeadString.isEmpty()) {
                    System.out.println(this._outputLeadString + string.trim().replace("\n", "\n" + this._outputLeadString));
                } else {
                    System.out.println(string.trim().replace("\n", "\n" + this._outputLeadString));
                }
            }
            this._outputString = this._outputString + string;
        }
    }

    private void connectServerViaScheduler(String string) throws CmplException {
        this._cmplGridSchedulerUrl = this._cmplUrl;
        this._cmplUrl = string;
        this._cmplGridScheduler = this._cmplServer;
        this._serverMode = 22;
        try {
            XmlRpcClientConfigImpl xmlRpcClientConfigImpl = new XmlRpcClientConfigImpl();
            xmlRpcClientConfigImpl.setServerURL(new URL(this._cmplUrl));
            this._cmplServer = new XmlRpcClient();
            this._cmplServer.setConfig((XmlRpcClientConfig)xmlRpcClientConfigImpl);
            this.handleOutput("Connected with CmplServer at " + this._cmplUrl + " with jobId " + this._jobId + " >> maxServerTries <" + this._maxCmplServerTries + "> maxQueuingTime <" + this._maxCmplServerQueuingTime + ">");
        }
        catch (Exception exception) {
            this._remoteStatus = 7;
            throw new CmplException(exception.toString());
        }
    }

    private void knockScheduler() throws CmplException {
        Object[] objectArray = null;
        if (this._remoteMode) {
            if (!this._cmplServerRunning) {
                throw new CmplException("Model is not connected to a CmplScheduler");
            }
            if (this._remoteStatus != 13) {
                objectArray = this.cmplServerExecute("knock", new Object[]{this._jobId});
                this._remoteStatus = (Integer)objectArray[0];
                if (this._remoteStatus == 17) {
                    this.cleanUp();
                    throw new CmplException(objectArray[1].toString());
                }
                if (this._remoteStatus == 16) {
                    this.connectServerViaScheduler((String)objectArray[1]);
                }
            }
        } else {
            throw new CmplException("Cmpl.knock can only be used in remote mode");
        }
    }

    private Object[] cmplServerExecute(String string, Object[] objectArray) throws CmplException {
        Object[] objectArray2 = null;
        int n = 0;
        while (true) {
            try {
                if (string.equals("cmplServerFailed")) {
                    objectArray2 = (Object[])this._cmplGridScheduler.execute(string, objectArray);
                    break;
                }
                objectArray2 = (Object[])this._cmplServer.execute(string, objectArray);
            }
            catch (Exception exception) {
                if (++n != this._maxCmplServerTries) continue;
                this._remoteStatus = 7;
                this.cleanUp();
                throw new CmplException("CmplServer error : " + exception.toString());
            }
            break;
        }
        return objectArray2;
    }

    private void writeSolFiles() throws CmplException {
        String string;
        this.handleOutput("\n");
        if (!this.cmplSolFile().isEmpty()) {
            string = this.cmplSolFile().equals("cmplStandard") ? this._problem + ".csol" : this.cmplSolFile();
            this.saveSolution(string);
        }
        if (!this.asciiSolFile().isEmpty()) {
            string = this.asciiSolFile().equals("cmplStandard") ? this._problem + ".sol" : this.asciiSolFile();
            this.saveSolutionAscii(string);
        }
        if (!this.csvSolFile().isEmpty()) {
            string = this.csvSolFile().equals("cmplStandard") ? this._problem + ".csv" : this.csvSolFile();
            this.saveSolutionCsv(string);
        }
    }

    private void writeInfoFiles() throws CmplException {
        this.handleOutput("\n");
        if (!this._cmplInfos.statisticsFileName().isEmpty()) {
            if (this._cmplInfos.statisticsFileName().equals("stdOut")) {
                this.handleOutput(this._cmplInfos.statisticsText());
                this.handleOutput("\n");
            } else {
                CmplTools.writeAsciiFile(this._cmplInfos.statisticsFileName(), this._cmplInfos.statisticsText());
                this.handleOutput("Statistics written to file: " + this._cmplInfos.statisticsFileName());
            }
        }
        if (!this._cmplInfos.varProdFileName().isEmpty()) {
            if (this._cmplInfos.varProdFileName().equals("stdOut")) {
                this.handleOutput(this._cmplInfos.varProdText());
                this.handleOutput("\n");
            } else {
                CmplTools.writeAsciiFile(this._cmplInfos.varProdFileName(), this._cmplInfos.varProdText());
                this.handleOutput("Variable products statistics written to file: " + this._cmplInfos.varProdFileName());
            }
        }
        if (!this._cmplInfos.matrixFileName().isEmpty()) {
            if (this._cmplInfos.matrixFileName().equals("stdOut")) {
                this.handleOutput(this._cmplInfos.matrixText());
                this.handleOutput("\n");
            } else {
                CmplTools.writeAsciiFile(this._cmplInfos.matrixFileName(), this._cmplInfos.matrixText());
                this.handleOutput("Generated matrix written to file: " + this._cmplInfos.matrixFileName());
            }
        }
    }
}

