/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class DurationFormatUtilsTest
extends TestCase {
    private static final int FOUR_YEARS = 1461;

    public DurationFormatUtilsTest(String s) {
        super(s);
    }

    public void testConstructor() {
        DurationFormatUtilsTest.assertNotNull((Object)new DurationFormatUtils());
        Constructor<?>[] cons = DurationFormatUtils.class.getDeclaredConstructors();
        DurationFormatUtilsTest.assertEquals((int)1, (int)cons.length);
        DurationFormatUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        DurationFormatUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(DurationFormatUtils.class.getModifiers()));
        DurationFormatUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(DurationFormatUtils.class.getModifiers()));
    }

    public void testFormatDurationWords() {
        String text = null;
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)true, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"50 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)true, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"1 minute 5 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)true, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"2 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)true, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"2 minutes 1 second", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)true, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"1 hour 12 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)true, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"1 day 0 hours 0 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)true, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"50 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)true, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"1 minute 5 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)true, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"2 minutes", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)true, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"2 minutes 1 second", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)true, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"1 hour 12 minutes", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)true, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"1 day", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)false, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 0 minutes 50 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)false, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 1 minute 5 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 2 minutes", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)false, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 2 minutes 1 second", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)false, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"0 days 1 hour 12 minutes", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)86400000L, (boolean)false, (boolean)true);
        DurationFormatUtilsTest.assertEquals((String)"1 day", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)50000L, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 0 minutes 50 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)65000L, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 1 minute 5 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)120000L, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 2 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)121000L, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 2 minutes 1 second", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)4320000L, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 1 hour 12 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)90720000L, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"1 day 1 hour 12 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)177120000L, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"2 days 1 hour 12 minutes 0 seconds", (String)text);
        for (int i = 2; i < 31; ++i) {
            text = DurationFormatUtils.formatDurationWords((long)((long)(i * 24 * 60 * 60) * 1000L), (boolean)false, (boolean)false);
        }
    }

    public void testFormatDurationPluralWords() {
        long oneSecond = 1000L;
        long oneMinute = oneSecond * 60L;
        long oneHour = oneMinute * 60L;
        long oneDay = oneHour * 24L;
        String text = null;
        text = DurationFormatUtils.formatDurationWords((long)oneSecond, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 0 minutes 1 second", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneSecond * 2L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 0 minutes 2 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneSecond * 11L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 0 minutes 11 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)oneMinute, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 1 minute 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneMinute * 2L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 2 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneMinute * 11L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 11 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneMinute + oneSecond), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 0 hours 1 minute 1 second", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)oneHour, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 1 hour 0 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneHour * 2L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 2 hours 0 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneHour * 11L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 11 hours 0 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneHour + oneMinute + oneSecond), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"0 days 1 hour 1 minute 1 second", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)oneDay, (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"1 day 0 hours 0 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneDay * 2L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"2 days 0 hours 0 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneDay * 11L), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"11 days 0 hours 0 minutes 0 seconds", (String)text);
        text = DurationFormatUtils.formatDurationWords((long)(oneDay + oneHour + oneMinute + oneSecond), (boolean)false, (boolean)false);
        DurationFormatUtilsTest.assertEquals((String)"1 day 1 hour 1 minute 1 second", (String)text);
    }

    public void testFormatDurationHMS() {
        long time = 0L;
        DurationFormatUtilsTest.assertEquals((String)"0:00:00.000", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1L;
        DurationFormatUtilsTest.assertEquals((String)"0:00:00.001", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 15L;
        DurationFormatUtilsTest.assertEquals((String)"0:00:00.015", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 165L;
        DurationFormatUtilsTest.assertEquals((String)"0:00:00.165", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1675L;
        DurationFormatUtilsTest.assertEquals((String)"0:00:01.675", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 13465L;
        DurationFormatUtilsTest.assertEquals((String)"0:00:13.465", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 72789L;
        DurationFormatUtilsTest.assertEquals((String)"0:01:12.789", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 1932789L;
        DurationFormatUtilsTest.assertEquals((String)"0:32:12.789", (String)DurationFormatUtils.formatDurationHMS((long)time));
        time = 3732789L;
        DurationFormatUtilsTest.assertEquals((String)"1:02:12.789", (String)DurationFormatUtils.formatDurationHMS((long)time));
    }

    public void testFormatDurationISO() {
        DurationFormatUtilsTest.assertEquals((String)"P0Y0M0DT0H0M0.000S", (String)DurationFormatUtils.formatDurationISO((long)0L));
        DurationFormatUtilsTest.assertEquals((String)"P0Y0M0DT0H0M0.001S", (String)DurationFormatUtils.formatDurationISO((long)1L));
        DurationFormatUtilsTest.assertEquals((String)"P0Y0M0DT0H0M0.010S", (String)DurationFormatUtils.formatDurationISO((long)10L));
        DurationFormatUtilsTest.assertEquals((String)"P0Y0M0DT0H0M0.100S", (String)DurationFormatUtils.formatDurationISO((long)100L));
        DurationFormatUtilsTest.assertEquals((String)"P0Y0M0DT0H1M15.321S", (String)DurationFormatUtils.formatDurationISO((long)75321L));
    }

    public void testFormatDuration() {
        long duration = 0L;
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"y"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"M"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"d"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"H"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"m"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"s"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"S"));
        DurationFormatUtilsTest.assertEquals((String)"0000", (String)DurationFormatUtils.formatDuration((long)duration, (String)"SSSS"));
        DurationFormatUtilsTest.assertEquals((String)"0000", (String)DurationFormatUtils.formatDuration((long)duration, (String)"yyyy"));
        DurationFormatUtilsTest.assertEquals((String)"0000", (String)DurationFormatUtils.formatDuration((long)duration, (String)"yyMM"));
        duration = 60000L;
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"y"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"M"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"d"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatDuration((long)duration, (String)"H"));
        DurationFormatUtilsTest.assertEquals((String)"1", (String)DurationFormatUtils.formatDuration((long)duration, (String)"m"));
        DurationFormatUtilsTest.assertEquals((String)"60", (String)DurationFormatUtils.formatDuration((long)duration, (String)"s"));
        DurationFormatUtilsTest.assertEquals((String)"60000", (String)DurationFormatUtils.formatDuration((long)duration, (String)"S"));
        DurationFormatUtilsTest.assertEquals((String)"01:00", (String)DurationFormatUtils.formatDuration((long)duration, (String)"mm:ss"));
        Calendar base = Calendar.getInstance();
        base.set(2000, 0, 1, 0, 0, 0);
        base.set(14, 0);
        Calendar cal = Calendar.getInstance();
        cal.set(2003, 1, 1, 0, 0, 0);
        cal.set(14, 0);
        duration = cal.getTime().getTime() - base.getTime().getTime();
        int days = 1127;
        DurationFormatUtilsTest.assertEquals((String)("0 0 " + days), (String)DurationFormatUtils.formatDuration((long)duration, (String)"y M d"));
    }

    public void testFormatPeriodISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar base = Calendar.getInstance(timeZone);
        base.set(1970, 0, 1, 0, 0, 0);
        base.set(14, 0);
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 9, 11, 12);
        cal.set(14, 1);
        String text = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(cal);
        DurationFormatUtilsTest.assertEquals((String)"2002-02-23T09:11:12-03:00", (String)text);
        text = DurationFormatUtils.formatPeriod((long)base.getTime().getTime(), (long)cal.getTime().getTime(), (String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'", (boolean)false, (TimeZone)timeZone);
        DurationFormatUtilsTest.assertEquals((String)"P32Y1M22DT9H11M12.001S", (String)text);
        cal.set(1971, 1, 3, 10, 30, 0);
        cal.set(14, 0);
        text = DurationFormatUtils.formatPeriod((long)base.getTime().getTime(), (long)cal.getTime().getTime(), (String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'", (boolean)false, (TimeZone)timeZone);
        DurationFormatUtilsTest.assertEquals((String)"P1Y1M2DT10H30M0.000S", (String)text);
    }

    public void testFormatPeriod() {
        Calendar cal1970 = Calendar.getInstance();
        cal1970.set(1970, 0, 1, 0, 0, 0);
        cal1970.set(14, 0);
        long time1970 = cal1970.getTime().getTime();
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"y"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"M"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"d"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"H"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"m"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"s"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"S"));
        DurationFormatUtilsTest.assertEquals((String)"0000", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"SSSS"));
        DurationFormatUtilsTest.assertEquals((String)"0000", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"yyyy"));
        DurationFormatUtilsTest.assertEquals((String)"0000", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time1970, (String)"yyMM"));
        long time = time1970 + 60000L;
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"M"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"d"));
        DurationFormatUtilsTest.assertEquals((String)"0", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"H"));
        DurationFormatUtilsTest.assertEquals((String)"1", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"m"));
        DurationFormatUtilsTest.assertEquals((String)"60", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"s"));
        DurationFormatUtilsTest.assertEquals((String)"60000", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"S"));
        DurationFormatUtilsTest.assertEquals((String)"01:00", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"mm:ss"));
        Calendar cal = Calendar.getInstance();
        cal.set(1973, 6, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        DurationFormatUtilsTest.assertEquals((String)"36", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        DurationFormatUtilsTest.assertEquals((String)"3 years 6 months", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        DurationFormatUtilsTest.assertEquals((String)"03/06", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        cal.set(1973, 10, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        DurationFormatUtilsTest.assertEquals((String)"310", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        DurationFormatUtilsTest.assertEquals((String)"3 years 10 months", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        DurationFormatUtilsTest.assertEquals((String)"03/10", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        cal.set(1974, 0, 1, 0, 0, 0);
        cal.set(14, 0);
        time = cal.getTime().getTime();
        DurationFormatUtilsTest.assertEquals((String)"40", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yM"));
        DurationFormatUtilsTest.assertEquals((String)"4 years 0 months", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"y' years 'M' months'"));
        DurationFormatUtilsTest.assertEquals((String)"04/00", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"yy/MM"));
        DurationFormatUtilsTest.assertEquals((String)"48", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"M"));
        DurationFormatUtilsTest.assertEquals((String)"48", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"MM"));
        DurationFormatUtilsTest.assertEquals((String)"048", (String)DurationFormatUtils.formatPeriod((long)time1970, (long)time, (String)"MMM"));
    }

    public void testLexx() {
        this.assertArrayEquals(new DurationFormatUtils.Token[]{new DurationFormatUtils.Token(DurationFormatUtils.y, 1), new DurationFormatUtils.Token(DurationFormatUtils.M, 1), new DurationFormatUtils.Token(DurationFormatUtils.d, 1), new DurationFormatUtils.Token(DurationFormatUtils.H, 1), new DurationFormatUtils.Token(DurationFormatUtils.m, 1), new DurationFormatUtils.Token(DurationFormatUtils.s, 1), new DurationFormatUtils.Token(DurationFormatUtils.S, 1)}, DurationFormatUtils.lexx((String)"yMdHmsS"));
        this.assertArrayEquals(new DurationFormatUtils.Token[]{new DurationFormatUtils.Token(DurationFormatUtils.H, 1), new DurationFormatUtils.Token((Object)new StringBuffer(":"), 1), new DurationFormatUtils.Token(DurationFormatUtils.m, 2), new DurationFormatUtils.Token((Object)new StringBuffer(":"), 1), new DurationFormatUtils.Token(DurationFormatUtils.s, 2), new DurationFormatUtils.Token((Object)new StringBuffer("."), 1), new DurationFormatUtils.Token(DurationFormatUtils.S, 3)}, DurationFormatUtils.lexx((String)"H:mm:ss.SSS"));
        this.assertArrayEquals(new DurationFormatUtils.Token[]{new DurationFormatUtils.Token((Object)new StringBuffer("P"), 1), new DurationFormatUtils.Token(DurationFormatUtils.y, 4), new DurationFormatUtils.Token((Object)new StringBuffer("Y"), 1), new DurationFormatUtils.Token(DurationFormatUtils.M, 1), new DurationFormatUtils.Token((Object)new StringBuffer("M"), 1), new DurationFormatUtils.Token(DurationFormatUtils.d, 1), new DurationFormatUtils.Token((Object)new StringBuffer("DT"), 1), new DurationFormatUtils.Token(DurationFormatUtils.H, 1), new DurationFormatUtils.Token((Object)new StringBuffer("H"), 1), new DurationFormatUtils.Token(DurationFormatUtils.m, 1), new DurationFormatUtils.Token((Object)new StringBuffer("M"), 1), new DurationFormatUtils.Token(DurationFormatUtils.s, 1), new DurationFormatUtils.Token((Object)new StringBuffer("."), 1), new DurationFormatUtils.Token(DurationFormatUtils.S, 1), new DurationFormatUtils.Token((Object)new StringBuffer("S"), 1)}, DurationFormatUtils.lexx((String)"'P'yyyy'Y'M'M'd'DT'H'H'm'M's.S'S'"));
        DurationFormatUtils.Token token = new DurationFormatUtils.Token(DurationFormatUtils.y, 4);
        DurationFormatUtilsTest.assertFalse((String)"Token equal to non-Token class. ", (boolean)token.equals(new Object()));
        DurationFormatUtilsTest.assertFalse((String)"Token equal to Token with wrong value class. ", (boolean)token.equals((Object)new DurationFormatUtils.Token(new Object())));
        DurationFormatUtilsTest.assertFalse((String)"Token equal to Token with different count. ", (boolean)token.equals((Object)new DurationFormatUtils.Token(DurationFormatUtils.y, 1)));
        DurationFormatUtils.Token numToken = new DurationFormatUtils.Token((Object)1, 4);
        DurationFormatUtilsTest.assertTrue((String)"Token with Number value not equal to itself. ", (boolean)numToken.equals((Object)numToken));
    }

    public void testBugzilla38401() {
        this.assertEqualDuration("0000/00/30 16:00:00 000", new int[]{2006, 0, 26, 18, 47, 34}, new int[]{2006, 1, 26, 10, 47, 34}, "yyyy/MM/dd HH:mm:ss SSS");
    }

    public void testJiraLang281() {
        this.assertEqualDuration("09", new int[]{2005, 11, 31, 0, 0, 0}, new int[]{2006, 9, 6, 0, 0, 0}, "MM");
    }

    public void testLowDurations() {
        for (int hr = 0; hr < 24; ++hr) {
            for (int min = 0; min < 60; ++min) {
                for (int sec = 0; sec < 60; ++sec) {
                    this.assertEqualDuration(hr + ":" + min + ":" + sec, new int[]{2000, 0, 1, 0, 0, 0, 0}, new int[]{2000, 0, 1, hr, min, sec}, "H:m:s");
                }
            }
        }
    }

    public void testEdgeDurations() {
        this.assertEqualDuration("01", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "MM");
        this.assertEqualDuration("12", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 15, 0, 0, 0}, "MM");
        this.assertEqualDuration("12", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 16, 0, 0, 0}, "MM");
        this.assertEqualDuration("11", new int[]{2005, 0, 15, 0, 0, 0}, new int[]{2006, 0, 14, 0, 0, 0}, "MM");
        this.assertEqualDuration("01 26", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("54", new int[]{2006, 0, 15, 0, 0, 0}, new int[]{2006, 2, 10, 0, 0, 0}, "dd");
        this.assertEqualDuration("09 12", new int[]{2006, 1, 20, 0, 0, 0}, new int[]{2006, 11, 4, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("287", new int[]{2006, 1, 20, 0, 0, 0}, new int[]{2006, 11, 4, 0, 0, 0}, "dd");
        this.assertEqualDuration("11 30", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("364", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("12 00", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "MM dd");
        this.assertEqualDuration("365", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2007, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("31", new int[]{2006, 0, 1, 0, 0, 0}, new int[]{2006, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("92", new int[]{2005, 9, 1, 0, 0, 0}, new int[]{2006, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("77", new int[]{2005, 9, 16, 0, 0, 0}, new int[]{2006, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("136", new int[]{2005, 9, 16, 0, 0, 0}, new int[]{2006, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("136", new int[]{2004, 9, 16, 0, 0, 0}, new int[]{2005, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("137", new int[]{2003, 9, 16, 0, 0, 0}, new int[]{2004, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("135", new int[]{2003, 9, 16, 0, 0, 0}, new int[]{2004, 1, 28, 0, 0, 0}, "dd");
        this.assertEqualDuration("364", new int[]{2007, 0, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("729", new int[]{2006, 0, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("365", new int[]{2007, 2, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("333", new int[]{2007, 1, 2, 0, 0, 0}, new int[]{2008, 0, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("28", new int[]{2008, 1, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("393", new int[]{2007, 1, 2, 0, 0, 0}, new int[]{2008, 2, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("369", new int[]{2004, 0, 29, 0, 0, 0}, new int[]{2005, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("338", new int[]{2004, 1, 29, 0, 0, 0}, new int[]{2005, 1, 1, 0, 0, 0}, "dd");
        this.assertEqualDuration("28", new int[]{2004, 2, 8, 0, 0, 0}, new int[]{2004, 3, 5, 0, 0, 0}, "dd");
        this.assertEqualDuration("48", new int[]{1992, 1, 29, 0, 0, 0}, new int[]{1996, 1, 29, 0, 0, 0}, "M");
        this.assertEqualDuration("11", new int[]{1996, 1, 29, 0, 0, 0}, new int[]{1997, 1, 28, 0, 0, 0}, "M");
        this.assertEqualDuration("11 28", new int[]{1996, 1, 29, 0, 0, 0}, new int[]{1997, 1, 28, 0, 0, 0}, "M d");
    }

    public void testDurationsByBruteForce() {
        this.bruteForce(2006, 0, 1, "d", 5);
        this.bruteForce(2006, 0, 2, "d", 5);
        this.bruteForce(2007, 1, 2, "d", 5);
        this.bruteForce(2004, 1, 29, "d", 5);
        this.bruteForce(1996, 1, 29, "d", 5);
        this.bruteForce(1969, 1, 28, "M", 2);
    }

    private void bruteForce(int year, int month, int day, String format, int calendarType) {
        String msg = year + "-" + month + "-" + day + " to ";
        Calendar c = Calendar.getInstance();
        c.set(year, month, day, 0, 0, 0);
        int[] array1 = new int[]{year, month, day, 0, 0, 0};
        int[] array2 = new int[]{year, month, day, 0, 0, 0};
        for (int i = 0; i < 1461; ++i) {
            array2[0] = c.get(1);
            array2[1] = c.get(2);
            array2[2] = c.get(5);
            String tmpMsg = msg + array2[0] + "-" + array2[1] + "-" + array2[2] + " at ";
            this.assertEqualDuration(tmpMsg + i, Integer.toString(i), array1, array2, format);
            c.add(calendarType, 1);
        }
    }

    private void assertEqualDuration(String expected, int[] start, int[] end, String format) {
        this.assertEqualDuration(null, expected, start, end, format);
    }

    private void assertEqualDuration(String message, String expected, int[] start, int[] end, String format) {
        Calendar cal1 = Calendar.getInstance();
        cal1.set(start[0], start[1], start[2], start[3], start[4], start[5]);
        cal1.set(14, 0);
        Calendar cal2 = Calendar.getInstance();
        cal2.set(end[0], end[1], end[2], end[3], end[4], end[5]);
        cal2.set(14, 0);
        long milli1 = cal1.getTime().getTime();
        long milli2 = cal2.getTime().getTime();
        String result = DurationFormatUtils.formatPeriod((long)milli1, (long)milli2, (String)format);
        if (message == null) {
            DurationFormatUtilsTest.assertEquals((String)expected, (String)result);
        } else {
            DurationFormatUtilsTest.assertEquals((String)message, (String)expected, (String)result);
        }
    }

    private void assertArrayEquals(DurationFormatUtils.Token[] obj1, DurationFormatUtils.Token[] obj2) {
        DurationFormatUtilsTest.assertEquals((String)"Arrays are unequal length. ", (int)obj1.length, (int)obj2.length);
        for (int i = 0; i < obj1.length; ++i) {
            DurationFormatUtilsTest.assertTrue((String)("Index " + i + " not equal, " + obj1[i] + " vs " + obj2[i]), (boolean)obj1[i].equals((Object)obj2[i]));
        }
    }
}

