/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.time;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DateFormatUtilsTest
extends TestCase {
    public DateFormatUtilsTest(String s) {
        super(s);
    }

    public void testConstructor() {
        DateFormatUtilsTest.assertNotNull((Object)new DateFormatUtils());
        Constructor<?>[] cons = DateFormatUtils.class.getDeclaredConstructors();
        DateFormatUtilsTest.assertEquals((int)1, (int)cons.length);
        DateFormatUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        DateFormatUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(DateFormatUtils.class.getModifiers()));
        DateFormatUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(DateFormatUtils.class.getModifiers()));
    }

    public void testFormat() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuffer buffer = new StringBuffer();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH"));
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((long)c.getTime().getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    public void testFormatCalendar() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(2005, 0, 1, 12, 0, 0);
        c.setTimeZone(TimeZone.getDefault());
        StringBuffer buffer = new StringBuffer();
        int year = c.get(1);
        int month = c.get(2) + 1;
        int day = c.get(5);
        int hour = c.get(11);
        buffer.append(year);
        buffer.append(month);
        buffer.append(day);
        buffer.append(hour);
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH"));
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH"));
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((Calendar)c, (String)"yyyyMdH", (Locale)Locale.US));
        DateFormatUtilsTest.assertEquals((String)buffer.toString(), (String)DateFormatUtils.format((Date)c.getTime(), (String)"yyyyMdH", (Locale)Locale.US));
    }

    public void testFormatUTC() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.set(2005, 0, 1, 12, 0, 0);
        DateFormatUtilsTest.assertEquals((String)"2005-01-01T12:00:00", (String)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        DateFormatUtilsTest.assertEquals((String)"2005-01-01T12:00:00", (String)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern()));
        DateFormatUtilsTest.assertEquals((String)"2005-01-01T12:00:00", (String)DateFormatUtils.formatUTC((Date)c.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
        DateFormatUtilsTest.assertEquals((String)"2005-01-01T12:00:00", (String)DateFormatUtils.formatUTC((long)c.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (Locale)Locale.US));
    }

    public void testDateTimeISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 9, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23T09:11:12", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23T09:11:12", (String)text);
        text = DateFormatUtils.ISO_DATETIME_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23T09:11:12", (String)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23T09:11:12-03:00", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23T09:11:12-03:00", (String)text);
        text = DateFormatUtils.ISO_DATETIME_TIME_ZONE_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23T09:11:12-03:00", (String)text);
    }

    public void testDateISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23", (String)text);
        text = DateFormatUtils.ISO_DATE_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23", (String)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23-03:00", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23-03:00", (String)text);
        text = DateFormatUtils.ISO_DATE_TIME_ZONE_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"2002-02-23-03:00", (String)text);
    }

    public void testTimeISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"T10:11:12", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"T10:11:12", (String)text);
        text = DateFormatUtils.ISO_TIME_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"T10:11:12", (String)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"T10:11:12-03:00", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"T10:11:12-03:00", (String)text);
        text = DateFormatUtils.ISO_TIME_TIME_ZONE_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"T10:11:12-03:00", (String)text);
    }

    public void testTimeNoTISO() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2002, 1, 23, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"10:11:12", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"10:11:12", (String)text);
        text = DateFormatUtils.ISO_TIME_NO_T_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"10:11:12", (String)text);
        text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"10:11:12-03:00", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.getPattern(), (TimeZone)timeZone);
        DateFormatUtilsTest.assertEquals((String)"10:11:12-03:00", (String)text);
        text = DateFormatUtils.ISO_TIME_NO_T_TIME_ZONE_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"10:11:12-03:00", (String)text);
    }

    public void testSMTP() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT-3");
        Calendar cal = Calendar.getInstance(timeZone);
        cal.set(2003, 5, 8, 10, 11, 12);
        String text = DateFormatUtils.format((Date)cal.getTime(), (String)DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone, (Locale)DateFormatUtils.SMTP_DATETIME_FORMAT.getLocale());
        DateFormatUtilsTest.assertEquals((String)"Sun, 08 Jun 2003 10:11:12 -0300", (String)text);
        text = DateFormatUtils.format((long)cal.getTime().getTime(), (String)DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), (TimeZone)timeZone, (Locale)DateFormatUtils.SMTP_DATETIME_FORMAT.getLocale());
        DateFormatUtilsTest.assertEquals((String)"Sun, 08 Jun 2003 10:11:12 -0300", (String)text);
        text = DateFormatUtils.SMTP_DATETIME_FORMAT.format(cal);
        DateFormatUtilsTest.assertEquals((String)"Sun, 08 Jun 2003 10:11:12 -0300", (String)text);
        text = DateFormatUtils.formatUTC((long)cal.getTime().getTime(), (String)DateFormatUtils.SMTP_DATETIME_FORMAT.getPattern(), (Locale)DateFormatUtils.SMTP_DATETIME_FORMAT.getLocale());
        DateFormatUtilsTest.assertEquals((String)"Sun, 08 Jun 2003 13:11:12 +0000", (String)text);
    }
}

