/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import junit.framework.TestCase;
import org.apache.commons.lang3.text.WordUtils;

public class WordUtilsTest
extends TestCase {
    public WordUtilsTest(String name) {
        super(name);
    }

    public void testConstructor() {
        WordUtilsTest.assertNotNull((Object)new WordUtils());
        Constructor<?>[] cons = WordUtils.class.getDeclaredConstructors();
        WordUtilsTest.assertEquals((int)1, (int)cons.length);
        WordUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(cons[0].getModifiers()));
        WordUtilsTest.assertEquals((boolean)true, (boolean)Modifier.isPublic(WordUtils.class.getModifiers()));
        WordUtilsTest.assertEquals((boolean)false, (boolean)Modifier.isFinal(WordUtils.class.getModifiers()));
    }

    public void testWrap_StringInt() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)20));
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)-1));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)20));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)-1));
        String systemNewLine = System.getProperty("line.separator");
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20));
        input = "Click here to jump to the jakarta website - http://jakarta.apache.org";
        expected = "Click here to jump" + systemNewLine + "to the jakarta" + systemNewLine + "website -" + systemNewLine + "http://jakarta.apache.org";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20));
        input = "Click here, http://jakarta.apache.org, to jump to the jakarta website";
        expected = "Click here," + systemNewLine + "http://jakarta.apache.org," + systemNewLine + "to jump to the" + systemNewLine + "jakarta website";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20));
    }

    public void testWrap_StringIntStringBoolean() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)false));
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)20, (String)"\n", (boolean)true));
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)20, null, (boolean)true));
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)20, null, (boolean)false));
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)-1, null, (boolean)true));
        WordUtilsTest.assertEquals(null, (String)WordUtils.wrap(null, (int)-1, null, (boolean)false));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)false));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)20, (String)"\n", (boolean)true));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)20, null, (boolean)false));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)20, null, (boolean)true));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)-1, null, (boolean)false));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.wrap((String)"", (int)-1, null, (boolean)true));
        String input = "Here is one line of text that is going to be wrapped after 20 columns.";
        String expected = "Here is one line of\ntext that is going\nto be wrapped after\n20 columns.";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of<br />text that is going<br />to be wrapped after<br />20 columns.";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)false));
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"<br />", (boolean)true));
        input = "Here is one line";
        expected = "Here\nis one\nline";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)6, (String)"\n", (boolean)false));
        expected = "Here\nis\none\nline";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)2, (String)"\n", (boolean)false));
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)-1, (String)"\n", (boolean)false));
        String systemNewLine = System.getProperty("line.separator");
        input = "Here is one line of text that is going to be wrapped after 20 columns.";
        expected = "Here is one line of" + systemNewLine + "text that is going" + systemNewLine + "to be wrapped after" + systemNewLine + "20 columns.";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, null, (boolean)false));
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, null, (boolean)true));
        input = " Here:  is  one  line  of  text  that  is  going  to  be  wrapped  after  20  columns.";
        expected = "Here:  is  one  line\nof  text  that  is \ngoing  to  be \nwrapped  after  20 \ncolumns.";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is\tone line of text that is going to be wrapped after 20 columns.";
        expected = "Here is\tone line of\ntext that is going\nto be wrapped after\n20 columns.";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Here is one line of\ttext that is going to be wrapped after 20 columns.";
        expected = "Here is one line\nof\ttext that is\ngoing to be wrapped\nafter 20 columns.";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here to jump to the jakarta website - http://jakarta.apache.org";
        expected = "Click here to jump\nto the jakarta\nwebsite -\nhttp://jakarta.apache.org";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here to jump\nto the jakarta\nwebsite -\nhttp://jakarta.apach\ne.org";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
        input = "Click here, http://jakarta.apache.org, to jump to the jakarta website";
        expected = "Click here,\nhttp://jakarta.apache.org,\nto jump to the\njakarta website";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)false));
        expected = "Click here,\nhttp://jakarta.apach\ne.org, to jump to\nthe jakarta website";
        WordUtilsTest.assertEquals((String)expected, (String)WordUtils.wrap((String)input, (int)20, (String)"\n", (boolean)true));
    }

    public void testCapitalize_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.capitalize(null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.capitalize((String)""));
        WordUtilsTest.assertEquals((String)"  ", (String)WordUtils.capitalize((String)"  "));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalize((String)"I"));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalize((String)"i"));
        WordUtilsTest.assertEquals((String)"I Am Here 123", (String)WordUtils.capitalize((String)"i am here 123"));
        WordUtilsTest.assertEquals((String)"I Am Here 123", (String)WordUtils.capitalize((String)"I Am Here 123"));
        WordUtilsTest.assertEquals((String)"I Am HERE 123", (String)WordUtils.capitalize((String)"i am HERE 123"));
        WordUtilsTest.assertEquals((String)"I AM HERE 123", (String)WordUtils.capitalize((String)"I AM HERE 123"));
    }

    public void testCapitalizeWithDelimiters_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.capitalize(null, null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.capitalize((String)"", (char[])new char[0]));
        WordUtilsTest.assertEquals((String)"  ", (String)WordUtils.capitalize((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalize((String)"I", (char[])chars));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalize((String)"i", (char[])chars));
        WordUtilsTest.assertEquals((String)"I-Am Here+123", (String)WordUtils.capitalize((String)"i-am here+123", (char[])chars));
        WordUtilsTest.assertEquals((String)"I Am+Here-123", (String)WordUtils.capitalize((String)"I Am+Here-123", (char[])chars));
        WordUtilsTest.assertEquals((String)"I+Am-HERE 123", (String)WordUtils.capitalize((String)"i+am-HERE 123", (char[])chars));
        WordUtilsTest.assertEquals((String)"I-AM HERE+123", (String)WordUtils.capitalize((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        WordUtilsTest.assertEquals((String)"I aM.Fine", (String)WordUtils.capitalize((String)"i aM.fine", (char[])chars));
        WordUtilsTest.assertEquals((String)"I Am.fine", (String)WordUtils.capitalize((String)"i am.fine", null));
    }

    public void testCapitalizeFully_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.capitalizeFully(null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.capitalizeFully((String)""));
        WordUtilsTest.assertEquals((String)"  ", (String)WordUtils.capitalizeFully((String)"  "));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalizeFully((String)"I"));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalizeFully((String)"i"));
        WordUtilsTest.assertEquals((String)"I Am Here 123", (String)WordUtils.capitalizeFully((String)"i am here 123"));
        WordUtilsTest.assertEquals((String)"I Am Here 123", (String)WordUtils.capitalizeFully((String)"I Am Here 123"));
        WordUtilsTest.assertEquals((String)"I Am Here 123", (String)WordUtils.capitalizeFully((String)"i am HERE 123"));
        WordUtilsTest.assertEquals((String)"I Am Here 123", (String)WordUtils.capitalizeFully((String)"I AM HERE 123"));
    }

    public void testCapitalizeFullyWithDelimiters_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.capitalizeFully(null, null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.capitalizeFully((String)"", (char[])new char[0]));
        WordUtilsTest.assertEquals((String)"  ", (String)WordUtils.capitalizeFully((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalizeFully((String)"I", (char[])chars));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.capitalizeFully((String)"i", (char[])chars));
        WordUtilsTest.assertEquals((String)"I-Am Here+123", (String)WordUtils.capitalizeFully((String)"i-am here+123", (char[])chars));
        WordUtilsTest.assertEquals((String)"I Am+Here-123", (String)WordUtils.capitalizeFully((String)"I Am+Here-123", (char[])chars));
        WordUtilsTest.assertEquals((String)"I+Am-Here 123", (String)WordUtils.capitalizeFully((String)"i+am-HERE 123", (char[])chars));
        WordUtilsTest.assertEquals((String)"I-Am Here+123", (String)WordUtils.capitalizeFully((String)"I-AM HERE+123", (char[])chars));
        chars = new char[]{'.'};
        WordUtilsTest.assertEquals((String)"I am.Fine", (String)WordUtils.capitalizeFully((String)"i aM.fine", (char[])chars));
        WordUtilsTest.assertEquals((String)"I Am.fine", (String)WordUtils.capitalizeFully((String)"i am.fine", null));
    }

    public void testUncapitalize_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.uncapitalize(null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.uncapitalize((String)""));
        WordUtilsTest.assertEquals((String)"  ", (String)WordUtils.uncapitalize((String)"  "));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.uncapitalize((String)"I"));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.uncapitalize((String)"i"));
        WordUtilsTest.assertEquals((String)"i am here 123", (String)WordUtils.uncapitalize((String)"i am here 123"));
        WordUtilsTest.assertEquals((String)"i am here 123", (String)WordUtils.uncapitalize((String)"I Am Here 123"));
        WordUtilsTest.assertEquals((String)"i am hERE 123", (String)WordUtils.uncapitalize((String)"i am HERE 123"));
        WordUtilsTest.assertEquals((String)"i aM hERE 123", (String)WordUtils.uncapitalize((String)"I AM HERE 123"));
    }

    public void testUncapitalizeWithDelimiters_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.uncapitalize(null, null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.uncapitalize((String)"", (char[])new char[0]));
        WordUtilsTest.assertEquals((String)"  ", (String)WordUtils.uncapitalize((String)"  ", (char[])new char[0]));
        char[] chars = new char[]{'-', '+', ' ', '@'};
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.uncapitalize((String)"I", (char[])chars));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.uncapitalize((String)"i", (char[])chars));
        WordUtilsTest.assertEquals((String)"i am-here+123", (String)WordUtils.uncapitalize((String)"i am-here+123", (char[])chars));
        WordUtilsTest.assertEquals((String)"i+am here-123", (String)WordUtils.uncapitalize((String)"I+Am Here-123", (char[])chars));
        WordUtilsTest.assertEquals((String)"i-am+hERE 123", (String)WordUtils.uncapitalize((String)"i-am+HERE 123", (char[])chars));
        WordUtilsTest.assertEquals((String)"i aM-hERE+123", (String)WordUtils.uncapitalize((String)"I AM-HERE+123", (char[])chars));
        chars = new char[]{'.'};
        WordUtilsTest.assertEquals((String)"i AM.fINE", (String)WordUtils.uncapitalize((String)"I AM.FINE", (char[])chars));
        WordUtilsTest.assertEquals((String)"i aM.FINE", (String)WordUtils.uncapitalize((String)"I AM.FINE", null));
    }

    public void testInitials_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.initials(null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)""));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"  "));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.initials((String)"I"));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.initials((String)"i"));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)"Ben John Lee"));
        WordUtilsTest.assertEquals((String)"BJ", (String)WordUtils.initials((String)"Ben J.Lee"));
        WordUtilsTest.assertEquals((String)"BJ.L", (String)WordUtils.initials((String)" Ben   John  . Lee"));
        WordUtilsTest.assertEquals((String)"iah1", (String)WordUtils.initials((String)"i am here 123"));
    }

    public void testInitials_String_charArray() {
        char[] array = null;
        WordUtilsTest.assertEquals(null, (String)WordUtils.initials(null, array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"", array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"  ", array));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.initials((String)"I", array));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.initials((String)"i", array));
        WordUtilsTest.assertEquals((String)"S", (String)WordUtils.initials((String)"SJC", array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)"Ben John Lee", array));
        WordUtilsTest.assertEquals((String)"BJ", (String)WordUtils.initials((String)"Ben J.Lee", array));
        WordUtilsTest.assertEquals((String)"BJ.L", (String)WordUtils.initials((String)" Ben   John  . Lee", array));
        WordUtilsTest.assertEquals((String)"KO", (String)WordUtils.initials((String)"Kay O'Murphy", array));
        WordUtilsTest.assertEquals((String)"iah1", (String)WordUtils.initials((String)"i am here 123", array));
        array = new char[]{};
        WordUtilsTest.assertEquals(null, (String)WordUtils.initials(null, (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"  ", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"I", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"i", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"SJC", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"Ben John Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " ".toCharArray();
        WordUtilsTest.assertEquals(null, (String)WordUtils.initials(null, (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"  ", (char[])array));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.initials((String)"I", (char[])array));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.initials((String)"i", (char[])array));
        WordUtilsTest.assertEquals((String)"S", (String)WordUtils.initials((String)"SJC", (char[])array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)"Ben John Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"BJ", (String)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"BJ.L", (String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"KO", (String)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        WordUtilsTest.assertEquals((String)"iah1", (String)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .".toCharArray();
        WordUtilsTest.assertEquals(null, (String)WordUtils.initials(null, (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"  ", (char[])array));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.initials((String)"I", (char[])array));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.initials((String)"i", (char[])array));
        WordUtilsTest.assertEquals((String)"S", (String)WordUtils.initials((String)"SJC", (char[])array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)"Ben John Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"KO", (String)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        WordUtilsTest.assertEquals((String)"iah1", (String)WordUtils.initials((String)"i am here 123", (char[])array));
        array = " .'".toCharArray();
        WordUtilsTest.assertEquals(null, (String)WordUtils.initials(null, (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"  ", (char[])array));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.initials((String)"I", (char[])array));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.initials((String)"i", (char[])array));
        WordUtilsTest.assertEquals((String)"S", (String)WordUtils.initials((String)"SJC", (char[])array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)"Ben John Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"BJL", (String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"KOM", (String)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        WordUtilsTest.assertEquals((String)"iah1", (String)WordUtils.initials((String)"i am here 123", (char[])array));
        array = "SIJo1".toCharArray();
        WordUtilsTest.assertEquals(null, (String)WordUtils.initials(null, (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"", (char[])array));
        WordUtilsTest.assertEquals((String)" ", (String)WordUtils.initials((String)"  ", (char[])array));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.initials((String)"I", (char[])array));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.initials((String)"i", (char[])array));
        WordUtilsTest.assertEquals((String)"C", (String)WordUtils.initials((String)"SJC", (char[])array));
        WordUtilsTest.assertEquals((String)"Bh", (String)WordUtils.initials((String)"Ben John Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"B.", (String)WordUtils.initials((String)"Ben J.Lee", (char[])array));
        WordUtilsTest.assertEquals((String)" h", (String)WordUtils.initials((String)" Ben   John  . Lee", (char[])array));
        WordUtilsTest.assertEquals((String)"K", (String)WordUtils.initials((String)"Kay O'Murphy", (char[])array));
        WordUtilsTest.assertEquals((String)"i2", (String)WordUtils.initials((String)"i am here 123", (char[])array));
    }

    public void testSwapCase_String() {
        WordUtilsTest.assertEquals(null, (String)WordUtils.swapCase(null));
        WordUtilsTest.assertEquals((String)"", (String)WordUtils.swapCase((String)""));
        WordUtilsTest.assertEquals((String)"  ", (String)WordUtils.swapCase((String)"  "));
        WordUtilsTest.assertEquals((String)"i", (String)WordUtils.swapCase((String)"I"));
        WordUtilsTest.assertEquals((String)"I", (String)WordUtils.swapCase((String)"i"));
        WordUtilsTest.assertEquals((String)"I AM HERE 123", (String)WordUtils.swapCase((String)"i am here 123"));
        WordUtilsTest.assertEquals((String)"i aM hERE 123", (String)WordUtils.swapCase((String)"I Am Here 123"));
        WordUtilsTest.assertEquals((String)"I AM here 123", (String)WordUtils.swapCase((String)"i am HERE 123"));
        WordUtilsTest.assertEquals((String)"i am here 123", (String)WordUtils.swapCase((String)"I AM HERE 123"));
        String test = "This String contains a TitleCase character: \u01c8";
        String expect = "tHIS sTRING CONTAINS A tITLEcASE CHARACTER: \u01c9";
        WordUtilsTest.assertEquals((String)expect, (String)WordUtils.swapCase((String)test));
    }
}

