/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

public class StrTokenizerTest
extends TestCase {
    private static final String CSV_SIMPLE_FIXTURE = "A,b,c";
    private static final String TSV_SIMPLE_FIXTURE = "A\tb\tc";

    public StrTokenizerTest(String name) {
        super(name);
    }

    private void checkClone(StrTokenizer tokenizer) {
        StrTokenizerTest.assertFalse((StrTokenizer.getCSVInstance() == tokenizer ? 1 : 0) != 0);
        StrTokenizerTest.assertFalse((StrTokenizer.getTSVInstance() == tokenizer ? 1 : 0) != 0);
    }

    public void test1() {
        String input = "a;b;c;\"d;\"\"e\";f; ; ;  ";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", "", "", ""};
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            StrTokenizerTest.assertTrue((String)("token[" + i + "] was '" + tokens[i] + "' but was expected to be '" + expected[i] + "'"), (boolean)ObjectUtils.equals((Object)expected[i], (Object)tokens[i]));
        }
    }

    public void test2() {
        String input = "a;b;c ;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c ", "d;\"e", "f", " ", " ", ""};
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            StrTokenizerTest.assertTrue((String)("token[" + i + "] was '" + tokens[i] + "' but was expected to be '" + expected[i] + "'"), (boolean)ObjectUtils.equals((Object)expected[i], (Object)tokens[i]));
        }
    }

    public void test3() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", " ", " ", ""};
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            StrTokenizerTest.assertTrue((String)("token[" + i + "] was '" + tokens[i] + "' but was expected to be '" + expected[i] + "'"), (boolean)ObjectUtils.equals((Object)expected[i], (Object)tokens[i]));
        }
    }

    public void test4() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(true);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f"};
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            StrTokenizerTest.assertTrue((String)("token[" + i + "] was '" + tokens[i] + "' but was expected to be '" + expected[i] + "'"), (boolean)ObjectUtils.equals((Object)expected[i], (Object)tokens[i]));
        }
    }

    public void test5() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d;\"e", "f", null, null, null};
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            StrTokenizerTest.assertTrue((String)("token[" + i + "] was '" + tokens[i] + "' but was expected to be '" + expected[i] + "'"), (boolean)ObjectUtils.equals((Object)expected[i], (Object)tokens[i]));
        }
    }

    public void test6() {
        String input = "a;b; c;\"d;\"\"e\";f; ; ;";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterChar(';');
        tok.setQuoteChar('\"');
        tok.setIgnoredMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", " c", "d;\"e", "f", null, null, null};
        int nextCount = 0;
        while (tok.hasNext()) {
            tok.next();
            ++nextCount;
        }
        int prevCount = 0;
        while (tok.hasPrevious()) {
            tok.previous();
            ++prevCount;
        }
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        StrTokenizerTest.assertTrue((String)"could not cycle through entire token list using the 'hasNext' and 'next' methods", (nextCount == expected.length ? 1 : 0) != 0);
        StrTokenizerTest.assertTrue((String)"could not cycle through entire token list using the 'hasPrevious' and 'previous' methods", (prevCount == expected.length ? 1 : 0) != 0);
    }

    public void test7() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterMatcher(StrMatcher.spaceMatcher());
        tok.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(false);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "", "", "b", "c", "d e", "f", ""};
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            StrTokenizerTest.assertTrue((String)("token[" + i + "] was '" + tokens[i] + "' but was expected to be '" + expected[i] + "'"), (boolean)ObjectUtils.equals((Object)expected[i], (Object)tokens[i]));
        }
    }

    public void test8() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setDelimiterMatcher(StrMatcher.spaceMatcher());
        tok.setQuoteMatcher(StrMatcher.doubleQuoteMatcher());
        tok.setIgnoredMatcher(StrMatcher.noneMatcher());
        tok.setIgnoreEmptyTokens(true);
        String[] tokens = tok.getTokenArray();
        String[] expected = new String[]{"a", "b", "c", "d e", "f"};
        StrTokenizerTest.assertEquals((String)ArrayUtils.toString((Object)tokens), (int)expected.length, (int)tokens.length);
        for (int i = 0; i < expected.length; ++i) {
            StrTokenizerTest.assertTrue((String)("token[" + i + "] was '" + tokens[i] + "' but was expected to be '" + expected[i] + "'"), (boolean)ObjectUtils.equals((Object)expected[i], (Object)tokens[i]));
        }
    }

    public void testBasic1() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer(input);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasic2() {
        String input = "a \nb\fc";
        StrTokenizer tok = new StrTokenizer(input);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasic3() {
        String input = "a \nb\u0001\fc";
        StrTokenizer tok = new StrTokenizer(input);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b\u0001", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasic4() {
        String input = "a \"b\" c";
        StrTokenizer tok = new StrTokenizer(input);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"\"b\"", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasic5() {
        String input = "a:b':c";
        StrTokenizer tok = new StrTokenizer(input, ':', '\'');
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b'", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicDelim1() {
        String input = "a:b:c";
        StrTokenizer tok = new StrTokenizer(input, ':');
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicDelim2() {
        String input = "a:b:c";
        StrTokenizer tok = new StrTokenizer(input, ',');
        StrTokenizerTest.assertEquals((String)"a:b:c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicEmpty1() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setIgnoreEmptyTokens(false);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicEmpty2() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer(input);
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuoted1() {
        String input = "a 'b' c";
        StrTokenizer tok = new StrTokenizer(input, ' ', '\'');
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuoted2() {
        String input = "a:'b':";
        StrTokenizer tok = new StrTokenizer(input, ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuoted3() {
        String input = "a:'b''c'";
        StrTokenizer tok = new StrTokenizer(input, ':', '\'');
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b'c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuoted4() {
        String input = "a: 'b' 'c' :d";
        StrTokenizer tok = new StrTokenizer(input, ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b c", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"d", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuoted5() {
        String input = "a: 'b'x'c' :d";
        StrTokenizer tok = new StrTokenizer(input, ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"bxc", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"d", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuoted6() {
        String input = "a:'b'\"c':d";
        StrTokenizer tok = new StrTokenizer(input, ':');
        tok.setQuoteMatcher(StrMatcher.quoteMatcher());
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b\"c:d", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuoted7() {
        String input = "a:\"There's a reason here\":b";
        StrTokenizer tok = new StrTokenizer(input, ':');
        tok.setQuoteMatcher(StrMatcher.quoteMatcher());
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"There's a reason here", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicQuotedTrimmed1() {
        String input = "a: 'b' :";
        StrTokenizer tok = new StrTokenizer(input, ':', '\'');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicTrimmed1() {
        String input = "a: b :  ";
        StrTokenizer tok = new StrTokenizer(input, ':');
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicTrimmed2() {
        String input = "a:  b  :";
        StrTokenizer tok = new StrTokenizer(input, ':');
        tok.setTrimmerMatcher(StrMatcher.stringMatcher((String)"  "));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicIgnoreTrimmed1() {
        String input = "a: bIGNOREc : ";
        StrTokenizer tok = new StrTokenizer(input, ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"bc", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicIgnoreTrimmed2() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer(input, ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"bc", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicIgnoreTrimmed3() {
        String input = "IGNOREaIGNORE: IGNORE bIGNOREc IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer(input, ':');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"  bc  ", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"  ", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testBasicIgnoreTrimmed4() {
        String input = "IGNOREaIGNORE: IGNORE 'bIGNOREc'IGNORE'd' IGNORE : IGNORE ";
        StrTokenizer tok = new StrTokenizer(input, ':', '\'');
        tok.setIgnoredMatcher(StrMatcher.stringMatcher((String)"IGNORE"));
        tok.setTrimmerMatcher(StrMatcher.trimMatcher());
        tok.setIgnoreEmptyTokens(false);
        tok.setEmptyTokenAsNull(true);
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"bIGNOREcd", (String)tok.next());
        StrTokenizerTest.assertEquals(null, (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testListArray() {
        String input = "a  b c";
        StrTokenizer tok = new StrTokenizer(input);
        String[] array = tok.getTokenArray();
        List list = tok.getTokenList();
        StrTokenizerTest.assertEquals(Arrays.asList(array), (Object)list);
        StrTokenizerTest.assertEquals((int)3, (int)list.size());
    }

    public void testCSV(String data) {
        this.testXSVAbc(StrTokenizer.getCSVInstance((String)data));
        this.testXSVAbc(StrTokenizer.getCSVInstance((char[])data.toCharArray()));
    }

    public void testCSVEmpty() {
        this.testEmpty(StrTokenizer.getCSVInstance());
        this.testEmpty(StrTokenizer.getCSVInstance((String)""));
    }

    public void testCSVSimple() {
        this.testCSV(CSV_SIMPLE_FIXTURE);
    }

    public void testCSVSimpleNeedsTrim() {
        this.testCSV("   A,b,c");
        this.testCSV("   \n\t  A,b,c");
        this.testCSV("   \n  A,b,c\n\n\r");
    }

    void testEmpty(StrTokenizer tokenizer) {
        this.checkClone(tokenizer);
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tokenizer.hasNext());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tokenizer.hasPrevious());
        StrTokenizerTest.assertEquals(null, (String)tokenizer.nextToken());
        StrTokenizerTest.assertEquals((int)0, (int)tokenizer.size());
        try {
            tokenizer.next();
            StrTokenizerTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testGetContent() {
        String input = "a   b c \"d e\" f ";
        StrTokenizer tok = new StrTokenizer(input);
        StrTokenizerTest.assertEquals((String)input, (String)tok.getContent());
        tok = new StrTokenizer(input.toCharArray());
        StrTokenizerTest.assertEquals((String)input, (String)tok.getContent());
        tok = new StrTokenizer();
        StrTokenizerTest.assertEquals(null, (String)tok.getContent());
    }

    public void testChaining() {
        StrTokenizer tok = new StrTokenizer();
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.reset());
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.reset(""));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.reset(new char[0]));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setDelimiterChar(' '));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setDelimiterString(" "));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setDelimiterMatcher(null));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setQuoteChar(' '));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setQuoteMatcher(null));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setIgnoredChar(' '));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setIgnoredMatcher(null));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setTrimmerMatcher(null));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setEmptyTokenAsNull(false));
        StrTokenizerTest.assertEquals((Object)tok, (Object)tok.setIgnoreEmptyTokens(false));
    }

    public void testCloneNotSupportedException() {
        Object notCloned = new StrTokenizer(){

            Object cloneReset() throws CloneNotSupportedException {
                throw new CloneNotSupportedException("test");
            }
        }.clone();
        StrTokenizerTest.assertNull((Object)notCloned);
    }

    public void testCloneNull() {
        StrTokenizer tokenizer = new StrTokenizer((char[])null);
        StrTokenizerTest.assertEquals(null, (String)tokenizer.nextToken());
        tokenizer.reset();
        StrTokenizerTest.assertEquals(null, (String)tokenizer.nextToken());
        StrTokenizer clonedTokenizer = (StrTokenizer)tokenizer.clone();
        tokenizer.reset();
        StrTokenizerTest.assertEquals(null, (String)tokenizer.nextToken());
        StrTokenizerTest.assertEquals(null, (String)clonedTokenizer.nextToken());
    }

    public void testCloneReset() {
        char[] input = new char[]{'a'};
        StrTokenizer tokenizer = new StrTokenizer(input);
        StrTokenizerTest.assertEquals((String)"a", (String)tokenizer.nextToken());
        tokenizer.reset(input);
        StrTokenizerTest.assertEquals((String)"a", (String)tokenizer.nextToken());
        StrTokenizer clonedTokenizer = (StrTokenizer)tokenizer.clone();
        input[0] = 98;
        tokenizer.reset(input);
        StrTokenizerTest.assertEquals((String)"b", (String)tokenizer.nextToken());
        StrTokenizerTest.assertEquals((String)"a", (String)clonedTokenizer.nextToken());
    }

    public void testConstructor_String() {
        StrTokenizer tok = new StrTokenizer("a b");
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer("");
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer((String)null);
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testConstructor_String_char() {
        StrTokenizer tok = new StrTokenizer("a b", ' ');
        StrTokenizerTest.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer("", ' ');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer((String)null, ' ');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testConstructor_String_char_char() {
        StrTokenizer tok = new StrTokenizer("a b", ' ', '\"');
        StrTokenizerTest.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        StrTokenizerTest.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer("", ' ', '\"');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer((String)null, ' ', '\"');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testConstructor_charArray() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray());
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer(new char[0]);
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null);
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testConstructor_charArray_char() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray(), ' ');
        StrTokenizerTest.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer(new char[0], ' ');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null, ' ');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testConstructor_charArray_char_char() {
        StrTokenizer tok = new StrTokenizer("a b".toCharArray(), ' ', '\"');
        StrTokenizerTest.assertEquals((int)1, (int)tok.getDelimiterMatcher().isMatch(" ".toCharArray(), 0, 0, 1));
        StrTokenizerTest.assertEquals((int)1, (int)tok.getQuoteMatcher().isMatch("\"".toCharArray(), 0, 0, 1));
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer(new char[0], ' ', '\"');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok = new StrTokenizer((char[])null, ' ', '\"');
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testReset() {
        StrTokenizer tok = new StrTokenizer("a b c");
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok.reset();
        StrTokenizerTest.assertEquals((String)"a", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"c", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testReset_String() {
        StrTokenizer tok = new StrTokenizer("x x x");
        tok.reset("d e");
        StrTokenizerTest.assertEquals((String)"d", (String)tok.next());
        StrTokenizerTest.assertEquals((String)"e", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok.reset((String)null);
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testReset_charArray() {
        StrTokenizer tok = new StrTokenizer("x x x");
        char[] array = new char[]{'a', 'b', 'c'};
        tok.reset(array);
        StrTokenizerTest.assertEquals((String)"abc", (String)tok.next());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
        tok.reset((char[])null);
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tok.hasNext());
    }

    public void testTSV() {
        this.testXSVAbc(StrTokenizer.getTSVInstance((String)TSV_SIMPLE_FIXTURE));
        this.testXSVAbc(StrTokenizer.getTSVInstance((char[])TSV_SIMPLE_FIXTURE.toCharArray()));
    }

    public void testTSVEmpty() {
        this.testEmpty(StrTokenizer.getCSVInstance());
        this.testEmpty(StrTokenizer.getCSVInstance((String)""));
    }

    void testXSVAbc(StrTokenizer tokenizer) {
        this.checkClone(tokenizer);
        StrTokenizerTest.assertEquals((int)-1, (int)tokenizer.previousIndex());
        StrTokenizerTest.assertEquals((int)0, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals(null, (String)tokenizer.previousToken());
        StrTokenizerTest.assertEquals((String)"A", (String)tokenizer.nextToken());
        StrTokenizerTest.assertEquals((int)1, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals((String)"b", (String)tokenizer.nextToken());
        StrTokenizerTest.assertEquals((int)2, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals((String)"c", (String)tokenizer.nextToken());
        StrTokenizerTest.assertEquals((int)3, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals(null, (String)tokenizer.nextToken());
        StrTokenizerTest.assertEquals((int)3, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals((String)"c", (String)tokenizer.previousToken());
        StrTokenizerTest.assertEquals((int)2, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals((String)"b", (String)tokenizer.previousToken());
        StrTokenizerTest.assertEquals((int)1, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals((String)"A", (String)tokenizer.previousToken());
        StrTokenizerTest.assertEquals((int)0, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals(null, (String)tokenizer.previousToken());
        StrTokenizerTest.assertEquals((int)0, (int)tokenizer.nextIndex());
        StrTokenizerTest.assertEquals((int)-1, (int)tokenizer.previousIndex());
        StrTokenizerTest.assertEquals((int)3, (int)tokenizer.size());
    }

    public void testIteration() {
        StrTokenizer tkn = new StrTokenizer("a b c");
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tkn.hasPrevious());
        try {
            tkn.previous();
            StrTokenizerTest.fail();
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
        StrTokenizerTest.assertEquals((boolean)true, (boolean)tkn.hasNext());
        StrTokenizerTest.assertEquals((String)"a", (String)tkn.next());
        try {
            tkn.remove();
            StrTokenizerTest.fail();
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        try {
            tkn.set("x");
            StrTokenizerTest.fail();
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        try {
            tkn.add("y");
            StrTokenizerTest.fail();
        }
        catch (UnsupportedOperationException ex) {
            // empty catch block
        }
        StrTokenizerTest.assertEquals((boolean)true, (boolean)tkn.hasPrevious());
        StrTokenizerTest.assertEquals((boolean)true, (boolean)tkn.hasNext());
        StrTokenizerTest.assertEquals((String)"b", (String)tkn.next());
        StrTokenizerTest.assertEquals((boolean)true, (boolean)tkn.hasPrevious());
        StrTokenizerTest.assertEquals((boolean)true, (boolean)tkn.hasNext());
        StrTokenizerTest.assertEquals((String)"c", (String)tkn.next());
        StrTokenizerTest.assertEquals((boolean)true, (boolean)tkn.hasPrevious());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tkn.hasNext());
        try {
            tkn.next();
            StrTokenizerTest.fail();
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        StrTokenizerTest.assertEquals((boolean)true, (boolean)tkn.hasPrevious());
        StrTokenizerTest.assertEquals((boolean)false, (boolean)tkn.hasNext());
    }

    public void testTokenizeSubclassInputChange() {
        StrTokenizer tkn = new StrTokenizer("a b c d e"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                return super.tokenize("w x y z".toCharArray(), 2, 5);
            }
        };
        StrTokenizerTest.assertEquals((String)"x", (String)tkn.next());
        StrTokenizerTest.assertEquals((String)"y", (String)tkn.next());
    }

    public void testTokenizeSubclassOutputChange() {
        StrTokenizer tkn = new StrTokenizer("a b c"){

            protected List<String> tokenize(char[] chars, int offset, int count) {
                List list = super.tokenize(chars, offset, count);
                Collections.reverse(list);
                return list;
            }
        };
        StrTokenizerTest.assertEquals((String)"c", (String)tkn.next());
        StrTokenizerTest.assertEquals((String)"b", (String)tkn.next());
        StrTokenizerTest.assertEquals((String)"a", (String)tkn.next());
    }

    public void testToString() {
        StrTokenizer tkn = new StrTokenizer("a b c d e");
        StrTokenizerTest.assertEquals((String)"StrTokenizer[not tokenized yet]", (String)tkn.toString());
        tkn.next();
        StrTokenizerTest.assertEquals((String)"StrTokenizer[a, b, c, d, e]", (String)tkn.toString());
    }
}

