/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.text;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import junit.framework.TestCase;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.commons.lang3.text.StrMatcher;
import org.apache.commons.lang3.text.StrTokenizer;

public class StrBuilderTest
extends TestCase {
    static final StrMatcher A_NUMBER_MATCHER = new StrMatcher(){

        public int isMatch(char[] buffer, int pos, int bufferStart, int bufferEnd) {
            if (buffer[pos] == 'A' && ++pos < bufferEnd && buffer[pos] >= '0' && buffer[pos] <= '9') {
                return 2;
            }
            return 0;
        }
    };

    public StrBuilderTest(String name) {
        super(name);
    }

    public void testConstructors() {
        StrBuilder sb0 = new StrBuilder();
        StrBuilderTest.assertEquals((int)32, (int)sb0.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb0.length());
        StrBuilderTest.assertEquals((int)0, (int)sb0.size());
        StrBuilder sb1 = new StrBuilder(32);
        StrBuilderTest.assertEquals((int)32, (int)sb1.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb1.length());
        StrBuilderTest.assertEquals((int)0, (int)sb1.size());
        StrBuilder sb2 = new StrBuilder(0);
        StrBuilderTest.assertEquals((int)32, (int)sb2.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb2.length());
        StrBuilderTest.assertEquals((int)0, (int)sb2.size());
        StrBuilder sb3 = new StrBuilder(-1);
        StrBuilderTest.assertEquals((int)32, (int)sb3.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb3.length());
        StrBuilderTest.assertEquals((int)0, (int)sb3.size());
        StrBuilder sb4 = new StrBuilder(1);
        StrBuilderTest.assertEquals((int)1, (int)sb4.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb4.length());
        StrBuilderTest.assertEquals((int)0, (int)sb4.size());
        StrBuilder sb5 = new StrBuilder((String)null);
        StrBuilderTest.assertEquals((int)32, (int)sb5.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb5.length());
        StrBuilderTest.assertEquals((int)0, (int)sb5.size());
        StrBuilder sb6 = new StrBuilder("");
        StrBuilderTest.assertEquals((int)32, (int)sb6.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb6.length());
        StrBuilderTest.assertEquals((int)0, (int)sb6.size());
        StrBuilder sb7 = new StrBuilder("foo");
        StrBuilderTest.assertEquals((int)35, (int)sb7.capacity());
        StrBuilderTest.assertEquals((int)3, (int)sb7.length());
        StrBuilderTest.assertEquals((int)3, (int)sb7.size());
    }

    public void testChaining() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertSame((Object)sb, (Object)sb.setNewLineText(null));
        StrBuilderTest.assertSame((Object)sb, (Object)sb.setNullText(null));
        StrBuilderTest.assertSame((Object)sb, (Object)sb.setLength(1));
        StrBuilderTest.assertSame((Object)sb, (Object)sb.setCharAt(0, 'a'));
        StrBuilderTest.assertSame((Object)sb, (Object)sb.ensureCapacity(0));
        StrBuilderTest.assertSame((Object)sb, (Object)sb.minimizeCapacity());
        StrBuilderTest.assertSame((Object)sb, (Object)sb.clear());
        StrBuilderTest.assertSame((Object)sb, (Object)sb.reverse());
        StrBuilderTest.assertSame((Object)sb, (Object)sb.trim());
    }

    public void testGetSetNewLineText() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals(null, (String)sb.getNewLineText());
        sb.setNewLineText("#");
        StrBuilderTest.assertEquals((String)"#", (String)sb.getNewLineText());
        sb.setNewLineText("");
        StrBuilderTest.assertEquals((String)"", (String)sb.getNewLineText());
        sb.setNewLineText((String)null);
        StrBuilderTest.assertEquals(null, (String)sb.getNewLineText());
    }

    public void testGetSetNullText() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals(null, (String)sb.getNullText());
        sb.setNullText("null");
        StrBuilderTest.assertEquals((String)"null", (String)sb.getNullText());
        sb.setNullText("");
        StrBuilderTest.assertEquals(null, (String)sb.getNullText());
        sb.setNullText("NULL");
        StrBuilderTest.assertEquals((String)"NULL", (String)sb.getNullText());
        sb.setNullText((String)null);
        StrBuilderTest.assertEquals(null, (String)sb.getNullText());
    }

    public void testCapacityAndLength() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)32, (int)sb.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb.length());
        StrBuilderTest.assertEquals((int)0, (int)sb.size());
        StrBuilderTest.assertTrue((boolean)sb.isEmpty());
        sb.minimizeCapacity();
        StrBuilderTest.assertEquals((int)0, (int)sb.capacity());
        StrBuilderTest.assertEquals((int)0, (int)sb.length());
        StrBuilderTest.assertEquals((int)0, (int)sb.size());
        StrBuilderTest.assertTrue((boolean)sb.isEmpty());
        sb.ensureCapacity(32);
        StrBuilderTest.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)0, (int)sb.length());
        StrBuilderTest.assertEquals((int)0, (int)sb.size());
        StrBuilderTest.assertTrue((boolean)sb.isEmpty());
        sb.append("foo");
        StrBuilderTest.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)3, (int)sb.length());
        StrBuilderTest.assertEquals((int)3, (int)sb.size());
        StrBuilderTest.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.clear();
        StrBuilderTest.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)0, (int)sb.length());
        StrBuilderTest.assertEquals((int)0, (int)sb.size());
        StrBuilderTest.assertTrue((boolean)sb.isEmpty());
        sb.append("123456789012345678901234567890123");
        StrBuilderTest.assertTrue((sb.capacity() > 32 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)33, (int)sb.length());
        StrBuilderTest.assertEquals((int)33, (int)sb.size());
        StrBuilderTest.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.ensureCapacity(16);
        StrBuilderTest.assertTrue((sb.capacity() > 16 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)33, (int)sb.length());
        StrBuilderTest.assertEquals((int)33, (int)sb.size());
        StrBuilderTest.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.minimizeCapacity();
        StrBuilderTest.assertEquals((int)33, (int)sb.capacity());
        StrBuilderTest.assertEquals((int)33, (int)sb.length());
        StrBuilderTest.assertEquals((int)33, (int)sb.size());
        StrBuilderTest.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        try {
            sb.setLength(-1);
            StrBuilderTest.fail((String)"setLength(-1) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        sb.setLength(33);
        StrBuilderTest.assertEquals((int)33, (int)sb.capacity());
        StrBuilderTest.assertEquals((int)33, (int)sb.length());
        StrBuilderTest.assertEquals((int)33, (int)sb.size());
        StrBuilderTest.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.setLength(16);
        StrBuilderTest.assertTrue((sb.capacity() >= 16 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)16, (int)sb.length());
        StrBuilderTest.assertEquals((int)16, (int)sb.size());
        StrBuilderTest.assertEquals((String)"1234567890123456", (String)sb.toString());
        StrBuilderTest.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.setLength(32);
        StrBuilderTest.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)32, (int)sb.length());
        StrBuilderTest.assertEquals((int)32, (int)sb.size());
        StrBuilderTest.assertEquals((String)"1234567890123456\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000", (String)sb.toString());
        StrBuilderTest.assertTrue((!sb.isEmpty() ? 1 : 0) != 0);
        sb.setLength(0);
        StrBuilderTest.assertTrue((sb.capacity() >= 32 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)0, (int)sb.length());
        StrBuilderTest.assertEquals((int)0, (int)sb.size());
        StrBuilderTest.assertTrue((boolean)sb.isEmpty());
    }

    public void testLength() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)0, (int)sb.length());
        sb.append("Hello");
        StrBuilderTest.assertEquals((int)5, (int)sb.length());
    }

    public void testSetLength() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hello");
        sb.setLength(2);
        StrBuilderTest.assertEquals((String)"He", (String)sb.toString());
        sb.setLength(2);
        StrBuilderTest.assertEquals((String)"He", (String)sb.toString());
        sb.setLength(3);
        StrBuilderTest.assertEquals((String)"He\u0000", (String)sb.toString());
        try {
            sb.setLength(-1);
            StrBuilderTest.fail((String)"setLength(-1) expected StringIndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testCapacity() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)sb.buffer.length, (int)sb.capacity());
        sb.append("HelloWorldHelloWorldHelloWorldHelloWorld");
        StrBuilderTest.assertEquals((int)sb.buffer.length, (int)sb.capacity());
    }

    public void testEnsureCapacity() {
        StrBuilder sb = new StrBuilder();
        sb.ensureCapacity(2);
        StrBuilderTest.assertEquals((boolean)true, (sb.capacity() >= 2 ? 1 : 0) != 0);
        sb.ensureCapacity(-1);
        StrBuilderTest.assertEquals((boolean)true, (sb.capacity() >= 0 ? 1 : 0) != 0);
        sb.append("HelloWorld");
        sb.ensureCapacity(40);
        StrBuilderTest.assertEquals((boolean)true, (sb.capacity() >= 40 ? 1 : 0) != 0);
    }

    public void testMinimizeCapacity() {
        StrBuilder sb = new StrBuilder();
        sb.minimizeCapacity();
        StrBuilderTest.assertEquals((int)0, (int)sb.capacity());
        sb.append("HelloWorld");
        sb.minimizeCapacity();
        StrBuilderTest.assertEquals((int)10, (int)sb.capacity());
    }

    public void testSize() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)0, (int)sb.size());
        sb.append("Hello");
        StrBuilderTest.assertEquals((int)5, (int)sb.size());
    }

    public void testIsEmpty() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.isEmpty());
        sb.append("Hello");
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb.isEmpty());
        sb.clear();
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.isEmpty());
    }

    public void testClear() {
        StrBuilder sb = new StrBuilder();
        sb.append("Hello");
        sb.clear();
        StrBuilderTest.assertEquals((int)0, (int)sb.length());
        StrBuilderTest.assertEquals((boolean)true, (sb.buffer.length >= 5 ? 1 : 0) != 0);
    }

    public void testCharAt() {
        StrBuilder sb = new StrBuilder();
        try {
            sb.charAt(0);
            StrBuilderTest.fail((String)"charAt(0) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.charAt(-1);
            StrBuilderTest.fail((String)"charAt(-1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.append("foo");
        StrBuilderTest.assertEquals((char)'f', (char)sb.charAt(0));
        StrBuilderTest.assertEquals((char)'o', (char)sb.charAt(1));
        StrBuilderTest.assertEquals((char)'o', (char)sb.charAt(2));
        try {
            sb.charAt(-1);
            StrBuilderTest.fail((String)"charAt(-1) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.charAt(3);
            StrBuilderTest.fail((String)"charAt(3) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSetCharAt() {
        StrBuilder sb = new StrBuilder();
        try {
            sb.setCharAt(0, 'f');
            StrBuilderTest.fail((String)"setCharAt(0,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.setCharAt(-1, 'f');
            StrBuilderTest.fail((String)"setCharAt(-1,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb.append("foo");
        sb.setCharAt(0, 'b');
        sb.setCharAt(1, 'a');
        sb.setCharAt(2, 'r');
        try {
            sb.setCharAt(3, '!');
            StrBuilderTest.fail((String)"setCharAt(3,) expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        StrBuilderTest.assertEquals((String)"bar", (String)sb.toString());
    }

    public void testDeleteCharAt() {
        StrBuilder sb = new StrBuilder("abc");
        sb.deleteCharAt(0);
        StrBuilderTest.assertEquals((String)"bc", (String)sb.toString());
        try {
            sb.deleteCharAt(1000);
            StrBuilderTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testToCharArray() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)sb.toCharArray());
        char[] a = sb.toCharArray();
        StrBuilderTest.assertNotNull((String)"toCharArray() result is null", (Object)a);
        StrBuilderTest.assertEquals((String)"toCharArray() result is too large", (int)0, (int)a.length);
        sb.append("junit");
        a = sb.toCharArray();
        StrBuilderTest.assertEquals((String)"toCharArray() result incorrect length", (int)5, (int)a.length);
        StrBuilderTest.assertTrue((String)"toCharArray() result does not match", (boolean)Arrays.equals("junit".toCharArray(), a));
    }

    public void testToCharArrayIntInt() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((Object)ArrayUtils.EMPTY_CHAR_ARRAY, (Object)sb.toCharArray(0, 0));
        sb.append("junit");
        char[] a = sb.toCharArray(0, 20);
        StrBuilderTest.assertEquals((String)"toCharArray(int,int) result incorrect length", (int)5, (int)a.length);
        StrBuilderTest.assertTrue((String)"toCharArray(int,int) result does not match", (boolean)Arrays.equals("junit".toCharArray(), a));
        a = sb.toCharArray(0, 4);
        StrBuilderTest.assertEquals((String)"toCharArray(int,int) result incorrect length", (int)4, (int)a.length);
        StrBuilderTest.assertTrue((String)"toCharArray(int,int) result does not match", (boolean)Arrays.equals("juni".toCharArray(), a));
        a = sb.toCharArray(0, 4);
        StrBuilderTest.assertEquals((String)"toCharArray(int,int) result incorrect length", (int)4, (int)a.length);
        StrBuilderTest.assertTrue((String)"toCharArray(int,int) result does not match", (boolean)Arrays.equals("juni".toCharArray(), a));
        a = sb.toCharArray(0, 1);
        StrBuilderTest.assertNotNull((String)"toCharArray(int,int) result is null", (Object)a);
        try {
            sb.toCharArray(-1, 5);
            StrBuilderTest.fail((String)"no string index out of bound on -1");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.toCharArray(6, 5);
            StrBuilderTest.fail((String)"no string index out of bound on -1");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetChars() {
        StrBuilder sb = new StrBuilder();
        char[] input = new char[10];
        char[] a = sb.getChars(input);
        StrBuilderTest.assertSame((Object)input, (Object)a);
        StrBuilderTest.assertTrue((boolean)Arrays.equals(new char[10], a));
        sb.append("junit");
        a = sb.getChars(input);
        StrBuilderTest.assertSame((Object)input, (Object)a);
        StrBuilderTest.assertTrue((boolean)Arrays.equals(new char[]{'j', 'u', 'n', 'i', 't', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000'}, a));
        a = sb.getChars(null);
        StrBuilderTest.assertNotSame((Object)input, (Object)a);
        StrBuilderTest.assertEquals((int)5, (int)a.length);
        StrBuilderTest.assertTrue((boolean)Arrays.equals("junit".toCharArray(), a));
        input = new char[5];
        a = sb.getChars(input);
        StrBuilderTest.assertSame((Object)input, (Object)a);
        input = new char[4];
        a = sb.getChars(input);
        StrBuilderTest.assertNotSame((Object)input, (Object)a);
    }

    public void testGetCharsIntIntCharArrayInt() {
        StrBuilder sb = new StrBuilder();
        sb.append("junit");
        char[] a = new char[5];
        sb.getChars(0, 5, a, 0);
        StrBuilderTest.assertTrue((boolean)Arrays.equals(new char[]{'j', 'u', 'n', 'i', 't'}, a));
        a = new char[5];
        sb.getChars(0, 2, a, 3);
        StrBuilderTest.assertTrue((boolean)Arrays.equals(new char[]{'\u0000', '\u0000', '\u0000', 'j', 'u'}, a));
        try {
            sb.getChars(-1, 0, a, 0);
            StrBuilderTest.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.getChars(0, -1, a, 0);
            StrBuilderTest.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.getChars(0, 20, a, 0);
            StrBuilderTest.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.getChars(4, 2, a, 0);
            StrBuilderTest.fail((String)"no exception");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testDeleteIntInt() {
        StrBuilder sb = new StrBuilder("abc");
        sb.delete(0, 1);
        StrBuilderTest.assertEquals((String)"bc", (String)sb.toString());
        sb.delete(1, 2);
        StrBuilderTest.assertEquals((String)"b", (String)sb.toString());
        sb.delete(0, 1);
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
        sb.delete(0, 1000);
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
        try {
            sb.delete(1, 2);
            StrBuilderTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.delete(-1, 1);
            StrBuilderTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb = new StrBuilder("anything");
        try {
            sb.delete(2, 1);
            StrBuilderTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testDeleteAll_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteAll('X');
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.deleteAll('a');
        StrBuilderTest.assertEquals((String)"bcbccb", (String)sb.toString());
        sb.deleteAll('c');
        StrBuilderTest.assertEquals((String)"bbb", (String)sb.toString());
        sb.deleteAll('b');
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll('b');
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
    }

    public void testDeleteFirst_char() {
        StrBuilder sb = new StrBuilder("abcba");
        sb.deleteFirst('X');
        StrBuilderTest.assertEquals((String)"abcba", (String)sb.toString());
        sb.deleteFirst('a');
        StrBuilderTest.assertEquals((String)"bcba", (String)sb.toString());
        sb.deleteFirst('c');
        StrBuilderTest.assertEquals((String)"bba", (String)sb.toString());
        sb.deleteFirst('b');
        StrBuilderTest.assertEquals((String)"ba", (String)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst('b');
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
    }

    public void testDeleteAll_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteAll((String)null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.deleteAll("");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.deleteAll("X");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.deleteAll("a");
        StrBuilderTest.assertEquals((String)"bcbccb", (String)sb.toString());
        sb.deleteAll("c");
        StrBuilderTest.assertEquals((String)"bbb", (String)sb.toString());
        sb.deleteAll("b");
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.deleteAll("bc");
        StrBuilderTest.assertEquals((String)"acba", (String)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll("bc");
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
    }

    public void testDeleteFirst_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.deleteFirst((String)null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.deleteFirst("");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.deleteFirst("X");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.deleteFirst("a");
        StrBuilderTest.assertEquals((String)"bcbccba", (String)sb.toString());
        sb.deleteFirst("c");
        StrBuilderTest.assertEquals((String)"bbccba", (String)sb.toString());
        sb.deleteFirst("b");
        StrBuilderTest.assertEquals((String)"bccba", (String)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.deleteFirst("bc");
        StrBuilderTest.assertEquals((String)"abccba", (String)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst("bc");
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
    }

    public void testDeleteAll_StrMatcher() {
        StrBuilder sb = new StrBuilder("A0xA1A2yA3");
        sb.deleteAll((StrMatcher)null);
        StrBuilderTest.assertEquals((String)"A0xA1A2yA3", (String)sb.toString());
        sb.deleteAll(A_NUMBER_MATCHER);
        StrBuilderTest.assertEquals((String)"xy", (String)sb.toString());
        sb = new StrBuilder("Ax1");
        sb.deleteAll(A_NUMBER_MATCHER);
        StrBuilderTest.assertEquals((String)"Ax1", (String)sb.toString());
        sb = new StrBuilder("");
        sb.deleteAll(A_NUMBER_MATCHER);
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
    }

    public void testDeleteFirst_StrMatcher() {
        StrBuilder sb = new StrBuilder("A0xA1A2yA3");
        sb.deleteFirst((StrMatcher)null);
        StrBuilderTest.assertEquals((String)"A0xA1A2yA3", (String)sb.toString());
        sb.deleteFirst(A_NUMBER_MATCHER);
        StrBuilderTest.assertEquals((String)"xA1A2yA3", (String)sb.toString());
        sb = new StrBuilder("Ax1");
        sb.deleteFirst(A_NUMBER_MATCHER);
        StrBuilderTest.assertEquals((String)"Ax1", (String)sb.toString());
        sb = new StrBuilder("");
        sb.deleteFirst(A_NUMBER_MATCHER);
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
    }

    public void testReplace_int_int_String() {
        StrBuilder sb = new StrBuilder("abc");
        sb.replace(0, 1, "d");
        StrBuilderTest.assertEquals((String)"dbc", (String)sb.toString());
        sb.replace(0, 1, "aaa");
        StrBuilderTest.assertEquals((String)"aaabc", (String)sb.toString());
        sb.replace(0, 3, "");
        StrBuilderTest.assertEquals((String)"bc", (String)sb.toString());
        sb.replace(1, 2, (String)null);
        StrBuilderTest.assertEquals((String)"b", (String)sb.toString());
        sb.replace(1, 1000, "text");
        StrBuilderTest.assertEquals((String)"btext", (String)sb.toString());
        sb.replace(0, 1000, "text");
        StrBuilderTest.assertEquals((String)"text", (String)sb.toString());
        sb = new StrBuilder("atext");
        sb.replace(1, 1, "ny");
        StrBuilderTest.assertEquals((String)"anytext", (String)sb.toString());
        try {
            sb.replace(2, 1, "anything");
            StrBuilderTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        sb = new StrBuilder();
        try {
            sb.replace(1, 2, "anything");
            StrBuilderTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.replace(-1, 1, "anything");
            StrBuilderTest.fail((String)"Expected IndexOutOfBoundsException");
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testReplaceAll_char_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll('x', 'y');
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll('a', 'd');
        StrBuilderTest.assertEquals((String)"dbcbccbd", (String)sb.toString());
        sb.replaceAll('b', 'e');
        StrBuilderTest.assertEquals((String)"dececced", (String)sb.toString());
        sb.replaceAll('c', 'f');
        StrBuilderTest.assertEquals((String)"defeffed", (String)sb.toString());
        sb.replaceAll('d', 'd');
        StrBuilderTest.assertEquals((String)"defeffed", (String)sb.toString());
    }

    public void testReplaceFirst_char_char() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst('x', 'y');
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst('a', 'd');
        StrBuilderTest.assertEquals((String)"dbcbccba", (String)sb.toString());
        sb.replaceFirst('b', 'e');
        StrBuilderTest.assertEquals((String)"decbccba", (String)sb.toString());
        sb.replaceFirst('c', 'f');
        StrBuilderTest.assertEquals((String)"defbccba", (String)sb.toString());
        sb.replaceFirst('d', 'd');
        StrBuilderTest.assertEquals((String)"defbccba", (String)sb.toString());
    }

    public void testReplaceAll_String_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll((String)null, null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll((String)null, "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll("", null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll("", "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll("x", "y");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll("a", "d");
        StrBuilderTest.assertEquals((String)"dbcbccbd", (String)sb.toString());
        sb.replaceAll("d", null);
        StrBuilderTest.assertEquals((String)"bcbccb", (String)sb.toString());
        sb.replaceAll("cb", "-");
        StrBuilderTest.assertEquals((String)"b-c-", (String)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceAll("b", "xbx");
        StrBuilderTest.assertEquals((String)"axbxcxbxa", (String)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceAll("b", "xbx");
        StrBuilderTest.assertEquals((String)"xbxxbx", (String)sb.toString());
    }

    public void testReplaceFirst_String_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst((String)null, null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst((String)null, "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst("", null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst("", "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst("x", "y");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst("a", "d");
        StrBuilderTest.assertEquals((String)"dbcbccba", (String)sb.toString());
        sb.replaceFirst("d", null);
        StrBuilderTest.assertEquals((String)"bcbccba", (String)sb.toString());
        sb.replaceFirst("cb", "-");
        StrBuilderTest.assertEquals((String)"b-ccba", (String)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceFirst("b", "xbx");
        StrBuilderTest.assertEquals((String)"axbxcba", (String)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceFirst("b", "xbx");
        StrBuilderTest.assertEquals((String)"xbxb", (String)sb.toString());
    }

    public void testReplaceAll_StrMatcher_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceAll((StrMatcher)null, null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll((StrMatcher)null, "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll(StrMatcher.noneMatcher(), null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll(StrMatcher.noneMatcher(), "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'x'), "y");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'a'), "d");
        StrBuilderTest.assertEquals((String)"dbcbccbd", (String)sb.toString());
        sb.replaceAll(StrMatcher.charMatcher((char)'d'), null);
        StrBuilderTest.assertEquals((String)"bcbccb", (String)sb.toString());
        sb.replaceAll(StrMatcher.stringMatcher((String)"cb"), "-");
        StrBuilderTest.assertEquals((String)"b-c-", (String)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceAll(StrMatcher.charMatcher((char)'b'), "xbx");
        StrBuilderTest.assertEquals((String)"axbxcxbxa", (String)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceAll(StrMatcher.charMatcher((char)'b'), "xbx");
        StrBuilderTest.assertEquals((String)"xbxxbx", (String)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replaceAll(A_NUMBER_MATCHER, "***");
        StrBuilderTest.assertEquals((String)"***-******-***", (String)sb.toString());
    }

    public void testReplaceFirst_StrMatcher_String() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replaceFirst((StrMatcher)null, null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst((StrMatcher)null, "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst(StrMatcher.noneMatcher(), null);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst(StrMatcher.noneMatcher(), "anything");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'x'), "y");
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'a'), "d");
        StrBuilderTest.assertEquals((String)"dbcbccba", (String)sb.toString());
        sb.replaceFirst(StrMatcher.charMatcher((char)'d'), null);
        StrBuilderTest.assertEquals((String)"bcbccba", (String)sb.toString());
        sb.replaceFirst(StrMatcher.stringMatcher((String)"cb"), "-");
        StrBuilderTest.assertEquals((String)"b-ccba", (String)sb.toString());
        sb = new StrBuilder("abcba");
        sb.replaceFirst(StrMatcher.charMatcher((char)'b'), "xbx");
        StrBuilderTest.assertEquals((String)"axbxcba", (String)sb.toString());
        sb = new StrBuilder("bb");
        sb.replaceFirst(StrMatcher.charMatcher((char)'b'), "xbx");
        StrBuilderTest.assertEquals((String)"xbxb", (String)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replaceFirst(A_NUMBER_MATCHER, "***");
        StrBuilderTest.assertEquals((String)"***-A2A3-A4", (String)sb.toString());
    }

    public void testReplace_StrMatcher_String_int_int_int_VaryMatcher() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replace((StrMatcher)null, "x", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb.replace(StrMatcher.charMatcher((char)'a'), "x", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"xbcbccbx", (String)sb.toString());
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "x", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"xbxcxx", (String)sb.toString());
        sb = new StrBuilder("A1-A2A3-A4");
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"***-******-***", (String)sb.toString());
        sb = new StrBuilder();
        sb.replace(A_NUMBER_MATCHER, "***", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"", (String)sb.toString());
    }

    public void testReplace_StrMatcher_String_int_int_int_VaryReplace() {
        StrBuilder sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "cb", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"abcbccba", (String)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "-", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"ab-c-a", (String)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "+++", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"ab+++c+++a", (String)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), "", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"abca", (String)sb.toString());
        sb = new StrBuilder("abcbccba");
        sb.replace(StrMatcher.stringMatcher((String)"cb"), null, 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"abca", (String)sb.toString());
    }

    public void testReplace_StrMatcher_String_int_int_int_VaryStartIndex() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"-x--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 1, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aax--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 2, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aax--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 3, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aax--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 4, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aaxa-ay-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 5, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aaxaa-y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 6, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aaxaaaay-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 7, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aaxaaaay-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 8, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aaxaaaay-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 9, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aaxaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 10, sb.length(), -1);
        StrBuilderTest.assertEquals((String)"aaxaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 11, sb.length(), -1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        StrBuilderTest.assertEquals((String)"aaxaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", -1, sb.length(), -1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        StrBuilderTest.assertEquals((String)"aaxaaaayaa", (String)sb.toString());
    }

    public void testReplace_StrMatcher_String_int_int_int_VaryEndIndex() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 0, -1);
        StrBuilderTest.assertEquals((String)"aaxaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 2, -1);
        StrBuilderTest.assertEquals((String)"-xaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 3, -1);
        StrBuilderTest.assertEquals((String)"-xaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 4, -1);
        StrBuilderTest.assertEquals((String)"-xaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 5, -1);
        StrBuilderTest.assertEquals((String)"-x-aayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 6, -1);
        StrBuilderTest.assertEquals((String)"-x-aayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 7, -1);
        StrBuilderTest.assertEquals((String)"-x--yaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 8, -1);
        StrBuilderTest.assertEquals((String)"-x--yaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 9, -1);
        StrBuilderTest.assertEquals((String)"-x--yaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, -1);
        StrBuilderTest.assertEquals((String)"-x--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 1000, -1);
        StrBuilderTest.assertEquals((String)"-x--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        try {
            sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 2, 1, -1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        StrBuilderTest.assertEquals((String)"aaxaaaayaa", (String)sb.toString());
    }

    public void testReplace_StrMatcher_String_int_int_int_VaryCount() {
        StrBuilder sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, -1);
        StrBuilderTest.assertEquals((String)"-x--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 0);
        StrBuilderTest.assertEquals((String)"aaxaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 1);
        StrBuilderTest.assertEquals((String)"-xaaaayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 2);
        StrBuilderTest.assertEquals((String)"-x-aayaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 3);
        StrBuilderTest.assertEquals((String)"-x--yaa", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 4);
        StrBuilderTest.assertEquals((String)"-x--y-", (String)sb.toString());
        sb = new StrBuilder("aaxaaaayaa");
        sb.replace(StrMatcher.stringMatcher((String)"aa"), "-", 0, 10, 5);
        StrBuilderTest.assertEquals((String)"-x--y-", (String)sb.toString());
    }

    public void testReverse() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((String)"", (String)sb.reverse().toString());
        sb.clear().append(true);
        StrBuilderTest.assertEquals((String)"eurt", (String)sb.reverse().toString());
        StrBuilderTest.assertEquals((String)"true", (String)sb.reverse().toString());
    }

    public void testTrim() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((String)"", (String)sb.reverse().toString());
        sb.clear().append(" \u0000 ");
        StrBuilderTest.assertEquals((String)"", (String)sb.trim().toString());
        sb.clear().append(" \u0000 a b c");
        StrBuilderTest.assertEquals((String)"a b c", (String)sb.trim().toString());
        sb.clear().append("a b c \u0000 ");
        StrBuilderTest.assertEquals((String)"a b c", (String)sb.trim().toString());
        sb.clear().append(" \u0000 a b c \u0000 ");
        StrBuilderTest.assertEquals((String)"a b c", (String)sb.trim().toString());
        sb.clear().append("a b c");
        StrBuilderTest.assertEquals((String)"a b c", (String)sb.trim().toString());
    }

    public void testStartsWith() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertFalse((boolean)sb.startsWith("a"));
        StrBuilderTest.assertFalse((boolean)sb.startsWith(null));
        StrBuilderTest.assertTrue((boolean)sb.startsWith(""));
        sb.append("abc");
        StrBuilderTest.assertTrue((boolean)sb.startsWith("a"));
        StrBuilderTest.assertTrue((boolean)sb.startsWith("ab"));
        StrBuilderTest.assertTrue((boolean)sb.startsWith("abc"));
        StrBuilderTest.assertFalse((boolean)sb.startsWith("cba"));
    }

    public void testEndsWith() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertFalse((boolean)sb.endsWith("a"));
        StrBuilderTest.assertFalse((boolean)sb.endsWith("c"));
        StrBuilderTest.assertTrue((boolean)sb.endsWith(""));
        StrBuilderTest.assertFalse((boolean)sb.endsWith(null));
        sb.append("abc");
        StrBuilderTest.assertTrue((boolean)sb.endsWith("c"));
        StrBuilderTest.assertTrue((boolean)sb.endsWith("bc"));
        StrBuilderTest.assertTrue((boolean)sb.endsWith("abc"));
        StrBuilderTest.assertFalse((boolean)sb.endsWith("cba"));
        StrBuilderTest.assertFalse((boolean)sb.endsWith("abcd"));
        StrBuilderTest.assertFalse((boolean)sb.endsWith(" abc"));
        StrBuilderTest.assertFalse((boolean)sb.endsWith("abc "));
    }

    public void testSubSequenceIntInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        try {
            sb.subSequence(-1, 5);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.subSequence(2, -1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.subSequence(2, sb.length() + 1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.subSequence(3, 2);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        StrBuilderTest.assertEquals((Object)"hello", (Object)sb.subSequence(0, 5));
        StrBuilderTest.assertEquals((Object)"hello goodbye".subSequence(0, 6), (Object)sb.subSequence(0, 6));
        StrBuilderTest.assertEquals((Object)"goodbye", (Object)sb.subSequence(6, 13));
        StrBuilderTest.assertEquals((Object)"hello goodbye".subSequence(6, 13), (Object)sb.subSequence(6, 13));
    }

    public void testSubstringInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        StrBuilderTest.assertEquals((String)"goodbye", (String)sb.substring(6));
        StrBuilderTest.assertEquals((String)"hello goodbye".substring(6), (String)sb.substring(6));
        StrBuilderTest.assertEquals((String)"hello goodbye", (String)sb.substring(0));
        StrBuilderTest.assertEquals((String)"hello goodbye".substring(0), (String)sb.substring(0));
        try {
            sb.substring(-1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.substring(15);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testSubstringIntInt() {
        StrBuilder sb = new StrBuilder("hello goodbye");
        StrBuilderTest.assertEquals((String)"hello", (String)sb.substring(0, 5));
        StrBuilderTest.assertEquals((String)"hello goodbye".substring(0, 6), (String)sb.substring(0, 6));
        StrBuilderTest.assertEquals((String)"goodbye", (String)sb.substring(6, 13));
        StrBuilderTest.assertEquals((String)"hello goodbye".substring(6, 13), (String)sb.substring(6, 13));
        StrBuilderTest.assertEquals((String)"goodbye", (String)sb.substring(6, 20));
        try {
            sb.substring(-1, 5);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
        try {
            sb.substring(15, 20);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testMidString() {
        StrBuilder sb = new StrBuilder("hello goodbye hello");
        StrBuilderTest.assertEquals((String)"goodbye", (String)sb.midString(6, 7));
        StrBuilderTest.assertEquals((String)"hello", (String)sb.midString(0, 5));
        StrBuilderTest.assertEquals((String)"hello", (String)sb.midString(-5, 5));
        StrBuilderTest.assertEquals((String)"", (String)sb.midString(0, -1));
        StrBuilderTest.assertEquals((String)"", (String)sb.midString(20, 2));
        StrBuilderTest.assertEquals((String)"hello", (String)sb.midString(14, 22));
    }

    public void testRightString() {
        StrBuilder sb = new StrBuilder("left right");
        StrBuilderTest.assertEquals((String)"right", (String)sb.rightString(5));
        StrBuilderTest.assertEquals((String)"", (String)sb.rightString(0));
        StrBuilderTest.assertEquals((String)"", (String)sb.rightString(-5));
        StrBuilderTest.assertEquals((String)"left right", (String)sb.rightString(15));
    }

    public void testLeftString() {
        StrBuilder sb = new StrBuilder("left right");
        StrBuilderTest.assertEquals((String)"left", (String)sb.leftString(4));
        StrBuilderTest.assertEquals((String)"", (String)sb.leftString(0));
        StrBuilderTest.assertEquals((String)"", (String)sb.leftString(-5));
        StrBuilderTest.assertEquals((String)"left right", (String)sb.leftString(15));
    }

    public void testContains_char() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains('a'));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains('o'));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains('z'));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb.contains('1'));
    }

    public void testContains_String() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains("a"));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains("pq"));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains("z"));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb.contains("zyx"));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb.contains((String)null));
    }

    public void testContains_StrMatcher() {
        StrBuilder sb = new StrBuilder("abcdefghijklmnopqrstuvwxyz");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains(StrMatcher.charMatcher((char)'a')));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains(StrMatcher.stringMatcher((String)"pq")));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains(StrMatcher.charMatcher((char)'z')));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb.contains(StrMatcher.stringMatcher((String)"zy")));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb.contains((StrMatcher)null));
        sb = new StrBuilder();
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb.contains(A_NUMBER_MATCHER));
        sb.append("B A1 C");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb.contains(A_NUMBER_MATCHER));
    }

    public void testIndexOf_char() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf('a'));
        StrBuilderTest.assertEquals((int)"abab".indexOf(97), (int)sb.indexOf('a'));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf('b'));
        StrBuilderTest.assertEquals((int)"abab".indexOf(98), (int)sb.indexOf('b'));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf('z'));
    }

    public void testIndexOf_char_int() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf('a', -1));
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf('a', 0));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf('a', 1));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf('a', 4));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf('a', 5));
        StrBuilderTest.assertEquals((int)"abab".indexOf(97, 1), (int)sb.indexOf('a', 1));
        StrBuilderTest.assertEquals((int)3, (int)sb.indexOf('b', 2));
        StrBuilderTest.assertEquals((int)"abab".indexOf(98, 2), (int)sb.indexOf('b', 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf('z', 2));
        sb = new StrBuilder("xyzabc");
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf('z', 0));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf('z', 3));
    }

    public void testLastIndexOf_char() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf('a'));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf(97), (int)sb.lastIndexOf('a'));
        StrBuilderTest.assertEquals((int)3, (int)sb.lastIndexOf('b'));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf(98), (int)sb.lastIndexOf('b'));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf('z'));
    }

    public void testLastIndexOf_char_int() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf('a', -1));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf('a', 0));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf('a', 1));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf(97, 1), (int)sb.lastIndexOf('a', 1));
        StrBuilderTest.assertEquals((int)1, (int)sb.lastIndexOf('b', 2));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf(98, 2), (int)sb.lastIndexOf('b', 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf('z', 2));
        sb = new StrBuilder("xyzabc");
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf('z', sb.length()));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf('z', 1));
    }

    public void testIndexOf_String() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf("a"));
        StrBuilderTest.assertEquals((int)"abab".indexOf("a"), (int)sb.indexOf("a"));
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf("ab"));
        StrBuilderTest.assertEquals((int)"abab".indexOf("ab"), (int)sb.indexOf("ab"));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf("b"));
        StrBuilderTest.assertEquals((int)"abab".indexOf("b"), (int)sb.indexOf("b"));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf("ba"));
        StrBuilderTest.assertEquals((int)"abab".indexOf("ba"), (int)sb.indexOf("ba"));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("z"));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf((String)null));
    }

    public void testIndexOf_String_int() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf("a", -1));
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf("a", 0));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf("a", 1));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf("a", 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("a", 3));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("a", 4));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("a", 5));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("abcdef", 0));
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf("", 0));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf("", 1));
        StrBuilderTest.assertEquals((int)"abab".indexOf("a", 1), (int)sb.indexOf("a", 1));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf("ab", 1));
        StrBuilderTest.assertEquals((int)"abab".indexOf("ab", 1), (int)sb.indexOf("ab", 1));
        StrBuilderTest.assertEquals((int)3, (int)sb.indexOf("b", 2));
        StrBuilderTest.assertEquals((int)"abab".indexOf("b", 2), (int)sb.indexOf("b", 2));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf("ba", 1));
        StrBuilderTest.assertEquals((int)"abab".indexOf("ba", 2), (int)sb.indexOf("ba", 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("z", 2));
        sb = new StrBuilder("xyzabc");
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf("za", 0));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("za", 3));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf((String)null, 2));
    }

    public void testLastIndexOf_String() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf("a"));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("a"), (int)sb.lastIndexOf("a"));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf("ab"));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("ab"), (int)sb.lastIndexOf("ab"));
        StrBuilderTest.assertEquals((int)3, (int)sb.lastIndexOf("b"));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("b"), (int)sb.lastIndexOf("b"));
        StrBuilderTest.assertEquals((int)1, (int)sb.lastIndexOf("ba"));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("ba"), (int)sb.lastIndexOf("ba"));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf("z"));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf((String)null));
    }

    public void testLastIndexOf_String_int() {
        StrBuilder sb = new StrBuilder("abab");
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf("a", -1));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf("a", 0));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf("a", 1));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf("a", 2));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf("a", 3));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf("a", 4));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf("a", 5));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf("abcdef", 3));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("", 3), (int)sb.lastIndexOf("", 3));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("", 1), (int)sb.lastIndexOf("", 1));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("a", 1), (int)sb.lastIndexOf("a", 1));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf("ab", 1));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("ab", 1), (int)sb.lastIndexOf("ab", 1));
        StrBuilderTest.assertEquals((int)1, (int)sb.lastIndexOf("b", 2));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("b", 2), (int)sb.lastIndexOf("b", 2));
        StrBuilderTest.assertEquals((int)1, (int)sb.lastIndexOf("ba", 2));
        StrBuilderTest.assertEquals((int)"abab".lastIndexOf("ba", 2), (int)sb.lastIndexOf("ba", 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf("z", 2));
        sb = new StrBuilder("xyzabc");
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf("za", sb.length()));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf("za", 1));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf((String)null, 2));
    }

    public void testIndexOf_StrMatcher() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a')));
        sb.append("ab bd");
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf(StrMatcher.charMatcher((char)'a')));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b')));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher()));
        StrBuilderTest.assertEquals((int)4, (int)sb.indexOf(StrMatcher.charMatcher((char)'d')));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.noneMatcher()));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null));
        sb.append(" A1 junction");
        StrBuilderTest.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER));
    }

    public void testIndexOf_StrMatcher_int() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null, 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 0));
        sb.append("ab bd");
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), -2));
        StrBuilderTest.assertEquals((int)0, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 0));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'a'), 20));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), -1));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 0));
        StrBuilderTest.assertEquals((int)1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 1));
        StrBuilderTest.assertEquals((int)3, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 2));
        StrBuilderTest.assertEquals((int)3, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 3));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 4));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 5));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.charMatcher((char)'b'), 6));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher(), -2));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher(), 0));
        StrBuilderTest.assertEquals((int)2, (int)sb.indexOf(StrMatcher.spaceMatcher(), 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.spaceMatcher(), 4));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.spaceMatcher(), 20));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(StrMatcher.noneMatcher(), 0));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf((StrMatcher)null, 0));
        sb.append(" A1 junction with A2");
        StrBuilderTest.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER, 5));
        StrBuilderTest.assertEquals((int)6, (int)sb.indexOf(A_NUMBER_MATCHER, 6));
        StrBuilderTest.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 7));
        StrBuilderTest.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 22));
        StrBuilderTest.assertEquals((int)23, (int)sb.indexOf(A_NUMBER_MATCHER, 23));
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf(A_NUMBER_MATCHER, 24));
    }

    public void testLastIndexOf_StrMatcher() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a')));
        sb.append("ab bd");
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a')));
        StrBuilderTest.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b')));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher()));
        StrBuilderTest.assertEquals((int)4, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'d')));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.noneMatcher()));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null));
        sb.append(" A1 junction");
        StrBuilderTest.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER));
    }

    public void testLastIndexOf_StrMatcher_int() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null, 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 0));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), -1));
        sb.append("ab bd");
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), -2));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 0));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 2));
        StrBuilderTest.assertEquals((int)0, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'a'), 20));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), -1));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 0));
        StrBuilderTest.assertEquals((int)1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 1));
        StrBuilderTest.assertEquals((int)1, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 2));
        StrBuilderTest.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 3));
        StrBuilderTest.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 4));
        StrBuilderTest.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 5));
        StrBuilderTest.assertEquals((int)3, (int)sb.lastIndexOf(StrMatcher.charMatcher((char)'b'), 6));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), -2));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 0));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 2));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 4));
        StrBuilderTest.assertEquals((int)2, (int)sb.lastIndexOf(StrMatcher.spaceMatcher(), 20));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(StrMatcher.noneMatcher(), 0));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf((StrMatcher)null, 0));
        sb.append(" A1 junction with A2");
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 5));
        StrBuilderTest.assertEquals((int)-1, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 6));
        StrBuilderTest.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 7));
        StrBuilderTest.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 22));
        StrBuilderTest.assertEquals((int)6, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 23));
        StrBuilderTest.assertEquals((int)23, (int)sb.lastIndexOf(A_NUMBER_MATCHER, 24));
    }

    public void testAsTokenizer() throws Exception {
        StrBuilder b = new StrBuilder();
        b.append("a b ");
        StrTokenizer t = b.asTokenizer();
        String[] tokens1 = t.getTokenArray();
        StrBuilderTest.assertEquals((int)2, (int)tokens1.length);
        StrBuilderTest.assertEquals((String)"a", (String)tokens1[0]);
        StrBuilderTest.assertEquals((String)"b", (String)tokens1[1]);
        StrBuilderTest.assertEquals((int)2, (int)t.size());
        b.append("c d ");
        String[] tokens2 = t.getTokenArray();
        StrBuilderTest.assertEquals((int)2, (int)tokens2.length);
        StrBuilderTest.assertEquals((String)"a", (String)tokens2[0]);
        StrBuilderTest.assertEquals((String)"b", (String)tokens2[1]);
        StrBuilderTest.assertEquals((int)2, (int)t.size());
        StrBuilderTest.assertEquals((String)"a", (String)t.next());
        StrBuilderTest.assertEquals((String)"b", (String)t.next());
        t.reset();
        String[] tokens3 = t.getTokenArray();
        StrBuilderTest.assertEquals((int)4, (int)tokens3.length);
        StrBuilderTest.assertEquals((String)"a", (String)tokens3[0]);
        StrBuilderTest.assertEquals((String)"b", (String)tokens3[1]);
        StrBuilderTest.assertEquals((String)"c", (String)tokens3[2]);
        StrBuilderTest.assertEquals((String)"d", (String)tokens3[3]);
        StrBuilderTest.assertEquals((int)4, (int)t.size());
        StrBuilderTest.assertEquals((String)"a", (String)t.next());
        StrBuilderTest.assertEquals((String)"b", (String)t.next());
        StrBuilderTest.assertEquals((String)"c", (String)t.next());
        StrBuilderTest.assertEquals((String)"d", (String)t.next());
        StrBuilderTest.assertEquals((String)"a b c d ", (String)t.getContent());
    }

    public void testAsReader() throws Exception {
        StrBuilder sb = new StrBuilder("some text");
        Reader reader = sb.asReader();
        StrBuilderTest.assertEquals((boolean)true, (boolean)reader.ready());
        char[] buf = new char[40];
        StrBuilderTest.assertEquals((int)9, (int)reader.read(buf));
        StrBuilderTest.assertEquals((String)"some text", (String)new String(buf, 0, 9));
        StrBuilderTest.assertEquals((int)-1, (int)reader.read());
        StrBuilderTest.assertEquals((boolean)false, (boolean)reader.ready());
        StrBuilderTest.assertEquals((long)0L, (long)reader.skip(2L));
        StrBuilderTest.assertEquals((long)0L, (long)reader.skip(-1L));
        StrBuilderTest.assertEquals((boolean)true, (boolean)reader.markSupported());
        reader = sb.asReader();
        StrBuilderTest.assertEquals((int)115, (int)reader.read());
        reader.mark(-1);
        char[] array = new char[3];
        StrBuilderTest.assertEquals((int)3, (int)reader.read(array, 0, 3));
        StrBuilderTest.assertEquals((char)'o', (char)array[0]);
        StrBuilderTest.assertEquals((char)'m', (char)array[1]);
        StrBuilderTest.assertEquals((char)'e', (char)array[2]);
        reader.reset();
        StrBuilderTest.assertEquals((int)1, (int)reader.read(array, 1, 1));
        StrBuilderTest.assertEquals((char)'o', (char)array[0]);
        StrBuilderTest.assertEquals((char)'o', (char)array[1]);
        StrBuilderTest.assertEquals((char)'e', (char)array[2]);
        StrBuilderTest.assertEquals((long)2L, (long)reader.skip(2L));
        StrBuilderTest.assertEquals((int)32, (int)reader.read());
        StrBuilderTest.assertEquals((boolean)true, (boolean)reader.ready());
        reader.close();
        StrBuilderTest.assertEquals((boolean)true, (boolean)reader.ready());
        reader = sb.asReader();
        array = new char[3];
        try {
            reader.read(array, -1, 0);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            reader.read(array, 0, -1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            reader.read(array, 100, 1);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            reader.read(array, 0, 100);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        try {
            reader.read(array, Integer.MAX_VALUE, Integer.MAX_VALUE);
            StrBuilderTest.fail();
        }
        catch (IndexOutOfBoundsException ex) {
            // empty catch block
        }
        StrBuilderTest.assertEquals((int)0, (int)reader.read(array, 0, 0));
        StrBuilderTest.assertEquals((int)0, (int)array[0]);
        StrBuilderTest.assertEquals((int)0, (int)array[1]);
        StrBuilderTest.assertEquals((int)0, (int)array[2]);
        reader.skip(9L);
        StrBuilderTest.assertEquals((int)-1, (int)reader.read(array, 0, 1));
        reader.reset();
        array = new char[30];
        StrBuilderTest.assertEquals((int)9, (int)reader.read(array, 0, 30));
    }

    public void testAsWriter() throws Exception {
        StrBuilder sb = new StrBuilder("base");
        Writer writer = sb.asWriter();
        writer.write(108);
        StrBuilderTest.assertEquals((String)"basel", (String)sb.toString());
        writer.write(new char[]{'i', 'n'});
        StrBuilderTest.assertEquals((String)"baselin", (String)sb.toString());
        writer.write(new char[]{'n', 'e', 'r'}, 1, 2);
        StrBuilderTest.assertEquals((String)"baseliner", (String)sb.toString());
        writer.write(" rout");
        StrBuilderTest.assertEquals((String)"baseliner rout", (String)sb.toString());
        writer.write("ping that server", 1, 3);
        StrBuilderTest.assertEquals((String)"baseliner routing", (String)sb.toString());
        writer.flush();
        StrBuilderTest.assertEquals((String)"baseliner routing", (String)sb.toString());
        writer.close();
        StrBuilderTest.assertEquals((String)"baseliner routing", (String)sb.toString());
        writer.write(" hi");
        StrBuilderTest.assertEquals((String)"baseliner routing hi", (String)sb.toString());
        sb.setLength(4);
        writer.write(100);
        StrBuilderTest.assertEquals((String)"based", (String)sb.toString());
    }

    public void testEqualsIgnoreCase() {
        StrBuilder sb1 = new StrBuilder();
        StrBuilder sb2 = new StrBuilder();
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equalsIgnoreCase(sb1));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equalsIgnoreCase(sb2));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb2.equalsIgnoreCase(sb2));
        sb1.append("abc");
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb1.equalsIgnoreCase(sb2));
        sb2.append("ABC");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equalsIgnoreCase(sb2));
        sb2.clear().append("abc");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equalsIgnoreCase(sb2));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equalsIgnoreCase(sb1));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb2.equalsIgnoreCase(sb2));
        sb2.clear().append("aBc");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equalsIgnoreCase(sb2));
    }

    public void testEquals() {
        StrBuilder sb1 = new StrBuilder();
        StrBuilder sb2 = new StrBuilder();
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equals(sb2));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equals(sb1));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb2.equals(sb2));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equals((Object)sb2));
        sb1.append("abc");
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb1.equals(sb2));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb1.equals((Object)sb2));
        sb2.append("ABC");
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb1.equals(sb2));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb1.equals((Object)sb2));
        sb2.clear().append("abc");
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equals(sb2));
        StrBuilderTest.assertEquals((boolean)true, (boolean)sb1.equals((Object)sb2));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb1.equals((Object)1));
        StrBuilderTest.assertEquals((boolean)false, (boolean)sb1.equals((Object)"abc"));
    }

    public void testHashCode() {
        StrBuilder sb = new StrBuilder();
        int hc1a = sb.hashCode();
        int hc1b = sb.hashCode();
        StrBuilderTest.assertEquals((int)0, (int)hc1a);
        StrBuilderTest.assertEquals((int)hc1a, (int)hc1b);
        sb.append("abc");
        int hc2a = sb.hashCode();
        int hc2b = sb.hashCode();
        StrBuilderTest.assertEquals((boolean)true, (hc2a != 0 ? 1 : 0) != 0);
        StrBuilderTest.assertEquals((int)hc2a, (int)hc2b);
    }

    public void testToString() {
        StrBuilder sb = new StrBuilder("abc");
        StrBuilderTest.assertEquals((String)"abc", (String)sb.toString());
    }

    public void testToStringBuffer() {
        StrBuilder sb = new StrBuilder();
        StrBuilderTest.assertEquals((String)new StringBuffer().toString(), (String)sb.toStringBuffer().toString());
        sb.append("junit");
        StrBuilderTest.assertEquals((String)new StringBuffer("junit").toString(), (String)sb.toStringBuffer().toString());
    }

    public void testLang294() {
        StrBuilder sb = new StrBuilder("\n%BLAH%\nDo more stuff\neven more stuff\n%BLAH%\n");
        sb.deleteAll("\n%BLAH%");
        StrBuilderTest.assertEquals((String)"\nDo more stuff\neven more stuff\n", (String)sb.toString());
    }

    public void testIndexOfLang294() {
        StrBuilder sb = new StrBuilder("onetwothree");
        sb.deleteFirst("three");
        StrBuilderTest.assertEquals((int)-1, (int)sb.indexOf("three"));
    }

    public void testLang295() {
        StrBuilder sb = new StrBuilder("onetwothree");
        sb.deleteFirst("three");
        StrBuilderTest.assertFalse((String)"The contains(char) method is looking beyond the end of the string", (boolean)sb.contains('h'));
        StrBuilderTest.assertEquals((String)"The indexOf(char) method is looking beyond the end of the string", (int)-1, (int)sb.indexOf('h'));
    }

    public void testLang412Right() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadRight(null, 10, '*');
        StrBuilderTest.assertEquals((String)"Failed to invoke appendFixedWidthPadRight correctly", (String)"**********", (String)sb.toString());
    }

    public void testLang412Left() {
        StrBuilder sb = new StrBuilder();
        sb.appendFixedWidthPadLeft(null, 10, '*');
        StrBuilderTest.assertEquals((String)"Failed to invoke appendFixedWidthPadLeft correctly", (String)"**********", (String)sb.toString());
    }
}

