/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.mutable;

import junit.framework.TestCase;
import org.apache.commons.lang3.mutable.MutableLong;

public class MutableLongTest
extends TestCase {
    public MutableLongTest(String testName) {
        super(testName);
    }

    public void testConstructors() {
        MutableLongTest.assertEquals((long)0L, (long)new MutableLong().longValue());
        MutableLongTest.assertEquals((long)1L, (long)new MutableLong(1L).longValue());
        MutableLongTest.assertEquals((long)2L, (long)new MutableLong((Number)2L).longValue());
        MutableLongTest.assertEquals((long)3L, (long)new MutableLong((Number)new MutableLong(3L)).longValue());
        MutableLongTest.assertEquals((long)2L, (long)new MutableLong("2").longValue());
        try {
            new MutableLong((Number)null);
            MutableLongTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetSet() {
        MutableLong mutNum = new MutableLong(0L);
        MutableLongTest.assertEquals((long)0L, (long)new MutableLong().longValue());
        MutableLongTest.assertEquals((Object)0L, (Object)new MutableLong().getValue());
        mutNum.setValue(1L);
        MutableLongTest.assertEquals((long)1L, (long)mutNum.longValue());
        MutableLongTest.assertEquals((Object)1L, (Object)mutNum.getValue());
        mutNum.setValue((Number)2L);
        MutableLongTest.assertEquals((long)2L, (long)mutNum.longValue());
        MutableLongTest.assertEquals((Object)2L, (Object)mutNum.getValue());
        mutNum.setValue((Number)new MutableLong(3L));
        MutableLongTest.assertEquals((long)3L, (long)mutNum.longValue());
        MutableLongTest.assertEquals((Object)3L, (Object)mutNum.getValue());
        try {
            mutNum.setValue(null);
            MutableLongTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testEquals() {
        MutableLong mutNumA = new MutableLong(0L);
        MutableLong mutNumB = new MutableLong(0L);
        MutableLong mutNumC = new MutableLong(1L);
        MutableLongTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumA));
        MutableLongTest.assertEquals((boolean)true, (boolean)mutNumA.equals((Object)mutNumB));
        MutableLongTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumA));
        MutableLongTest.assertEquals((boolean)true, (boolean)mutNumB.equals((Object)mutNumB));
        MutableLongTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)mutNumC));
        MutableLongTest.assertEquals((boolean)false, (boolean)mutNumB.equals((Object)mutNumC));
        MutableLongTest.assertEquals((boolean)true, (boolean)mutNumC.equals((Object)mutNumC));
        MutableLongTest.assertEquals((boolean)false, (boolean)mutNumA.equals(null));
        MutableLongTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)0L));
        MutableLongTest.assertEquals((boolean)false, (boolean)mutNumA.equals((Object)"0"));
    }

    public void testHashCode() {
        MutableLong mutNumA = new MutableLong(0L);
        MutableLong mutNumB = new MutableLong(0L);
        MutableLong mutNumC = new MutableLong(1L);
        MutableLongTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumA.hashCode() ? 1 : 0) != 0);
        MutableLongTest.assertEquals((boolean)true, (mutNumA.hashCode() == mutNumB.hashCode() ? 1 : 0) != 0);
        MutableLongTest.assertEquals((boolean)false, (mutNumA.hashCode() == mutNumC.hashCode() ? 1 : 0) != 0);
        MutableLongTest.assertEquals((boolean)true, (mutNumA.hashCode() == Long.valueOf(0L).hashCode() ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        MutableLong mutNum = new MutableLong(0L);
        MutableLongTest.assertEquals((int)0, (int)mutNum.compareTo(new MutableLong(0L)));
        MutableLongTest.assertEquals((int)1, (int)mutNum.compareTo(new MutableLong(-1L)));
        MutableLongTest.assertEquals((int)-1, (int)mutNum.compareTo(new MutableLong(1L)));
        try {
            mutNum.compareTo(null);
            MutableLongTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testPrimitiveValues() {
        MutableLong mutNum = new MutableLong(1L);
        MutableLongTest.assertEquals((float)1.0f, (float)mutNum.floatValue(), (float)0.0f);
        MutableLongTest.assertEquals((double)1.0, (double)mutNum.doubleValue(), (double)0.0);
        MutableLongTest.assertEquals((byte)1, (byte)mutNum.byteValue());
        MutableLongTest.assertEquals((short)1, (short)mutNum.shortValue());
        MutableLongTest.assertEquals((int)1, (int)mutNum.intValue());
        MutableLongTest.assertEquals((long)1L, (long)mutNum.longValue());
    }

    public void testToLong() {
        MutableLongTest.assertEquals((Object)0L, (Object)new MutableLong(0L).toLong());
        MutableLongTest.assertEquals((Object)123L, (Object)new MutableLong(123L).toLong());
    }

    public void testIncrement() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.increment();
        MutableLongTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableLongTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testDecrement() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.decrement();
        MutableLongTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableLongTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testAddValuePrimitive() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.add(1L);
        MutableLongTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableLongTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testAddValueObject() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.add((Number)1L);
        MutableLongTest.assertEquals((int)2, (int)mutNum.intValue());
        MutableLongTest.assertEquals((long)2L, (long)mutNum.longValue());
    }

    public void testSubtractValuePrimitive() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.subtract(1L);
        MutableLongTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableLongTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testSubtractValueObject() {
        MutableLong mutNum = new MutableLong(1L);
        mutNum.subtract((Number)1L);
        MutableLongTest.assertEquals((int)0, (int)mutNum.intValue());
        MutableLongTest.assertEquals((long)0L, (long)mutNum.longValue());
    }

    public void testToString() {
        MutableLongTest.assertEquals((String)"0", (String)new MutableLong(0L).toString());
        MutableLongTest.assertEquals((String)"10", (String)new MutableLong(10L).toString());
        MutableLongTest.assertEquals((String)"-123", (String)new MutableLong(-123L).toString());
    }
}

